package io.qt.datavis;

import io.qt.*;


/**
 * <p>Representation of a camera in 3D space</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/q3dcamera.html">QtDataVisualization::Q3DCamera</a></code></p>
 */
public class Q3DCamera extends io.qt.datavis.Q3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DCamera.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::Q3DCamera::CameraPreset</a></code></p>
     */
    @QtUnlistedEnum
    public enum CameraPreset implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetNone</a></code></p>
         */
        CameraPresetNone(-1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetFrontLow</a></code></p>
         */
        CameraPresetFrontLow(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetFront</a></code></p>
         */
        CameraPresetFront(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetFrontHigh</a></code></p>
         */
        CameraPresetFrontHigh(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetLeftLow</a></code></p>
         */
        CameraPresetLeftLow(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetLeft</a></code></p>
         */
        CameraPresetLeft(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetLeftHigh</a></code></p>
         */
        CameraPresetLeftHigh(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetRightLow</a></code></p>
         */
        CameraPresetRightLow(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetRight</a></code></p>
         */
        CameraPresetRight(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetRightHigh</a></code></p>
         */
        CameraPresetRightHigh(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetBehindLow</a></code></p>
         */
        CameraPresetBehindLow(9),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetBehind</a></code></p>
         */
        CameraPresetBehind(10),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetBehindHigh</a></code></p>
         */
        CameraPresetBehindHigh(11),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetIsometricLeft</a></code></p>
         */
        CameraPresetIsometricLeft(12),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetIsometricLeftHigh</a></code></p>
         */
        CameraPresetIsometricLeftHigh(13),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetIsometricRight</a></code></p>
         */
        CameraPresetIsometricRight(14),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetIsometricRightHigh</a></code></p>
         */
        CameraPresetIsometricRightHigh(15),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetDirectlyAbove</a></code></p>
         */
        CameraPresetDirectlyAbove(16),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetDirectlyAboveCW45</a></code></p>
         */
        CameraPresetDirectlyAboveCW45(17),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetDirectlyAboveCCW45</a></code></p>
         */
        CameraPresetDirectlyAboveCCW45(18),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetFrontBelow</a></code></p>
         */
        CameraPresetFrontBelow(19),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetLeftBelow</a></code></p>
         */
        CameraPresetLeftBelow(20),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetRightBelow</a></code></p>
         */
        CameraPresetRightBelow(21),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetBehindBelow</a></code></p>
         */
        CameraPresetBehindBelow(22),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#CameraPreset-enum">QtDataVisualization::<wbr>Q3DCamera::<wbr>CameraPresetDirectlyBelow</a></code></p>
         */
        CameraPresetDirectlyBelow(23);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CameraPreset(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CameraPreset resolve(int value) {
            switch (value) {
            case -1: return CameraPresetNone;
            case 0: return CameraPresetFrontLow;
            case 1: return CameraPresetFront;
            case 2: return CameraPresetFrontHigh;
            case 3: return CameraPresetLeftLow;
            case 4: return CameraPresetLeft;
            case 5: return CameraPresetLeftHigh;
            case 6: return CameraPresetRightLow;
            case 7: return CameraPresetRight;
            case 8: return CameraPresetRightHigh;
            case 9: return CameraPresetBehindLow;
            case 10: return CameraPresetBehind;
            case 11: return CameraPresetBehindHigh;
            case 12: return CameraPresetIsometricLeft;
            case 13: return CameraPresetIsometricLeftHigh;
            case 14: return CameraPresetIsometricRight;
            case 15: return CameraPresetIsometricRightHigh;
            case 16: return CameraPresetDirectlyAbove;
            case 17: return CameraPresetDirectlyAboveCW45;
            case 18: return CameraPresetDirectlyAboveCCW45;
            case 19: return CameraPresetFrontBelow;
            case 20: return CameraPresetLeftBelow;
            case 21: return CameraPresetRightBelow;
            case 22: return CameraPresetBehindBelow;
            case 23: return CameraPresetDirectlyBelow;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#cameraPreset-prop">QtDataVisualization::Q3DCamera::<wbr>cameraPresetChanged(QtDataVisualization::Q3DCamera::CameraPreset)</a></code></p>
     */
    @QtPropertyNotify(name="cameraPreset")
    public final @NonNull Signal1<io.qt.datavis.Q3DCamera.@NonNull CameraPreset> cameraPresetChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#maxZoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>maxZoomLevelChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="maxZoomLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maxZoomLevelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#minZoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>minZoomLevelChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="minZoomLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minZoomLevelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#target-prop">QtDataVisualization::Q3DCamera::<wbr>targetChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="target")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> targetChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#wrapXRotation-prop">QtDataVisualization::Q3DCamera::<wbr>wrapXRotationChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="wrapXRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> wrapXRotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#wrapYRotation-prop">QtDataVisualization::Q3DCamera::<wbr>wrapYRotationChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="wrapYRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> wrapYRotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#xRotation-prop">QtDataVisualization::Q3DCamera::<wbr>xRotationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="xRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> xRotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#yRotation-prop">QtDataVisualization::Q3DCamera::<wbr>yRotationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="yRotation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> yRotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#zoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>zoomLevelChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="zoomLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> zoomLevelChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#Q3DCamera">QtDataVisualization::Q3DCamera::<wbr>Q3DCamera(QObject*)</a></code></p>
     */
    public Q3DCamera(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DCamera instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#cameraPreset-prop">QtDataVisualization::Q3DCamera::<wbr>cameraPreset()const</a></code></p>
     */
    @QtPropertyReader(name="cameraPreset")
    @QtUninvokable
    public final io.qt.datavis.Q3DCamera.@NonNull CameraPreset cameraPreset(){
        return io.qt.datavis.Q3DCamera.CameraPreset.resolve(cameraPreset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int cameraPreset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#maxZoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>maxZoomLevel()const</a></code></p>
     */
    @QtPropertyReader(name="maxZoomLevel")
    @QtUninvokable
    public final float maxZoomLevel(){
        return maxZoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxZoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#minZoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>minZoomLevel()const</a></code></p>
     */
    @QtPropertyReader(name="minZoomLevel")
    @QtUninvokable
    public final float minZoomLevel(){
        return minZoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minZoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#setCameraPosition">QtDataVisualization::Q3DCamera::<wbr>setCameraPosition(float,<wbr>float,<wbr>float)</a></code></p>
     */
    @QtUninvokable
    public final void setCameraPosition(float horizontal, float vertical, float zoom){
        setCameraPosition_native_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), horizontal, vertical, zoom);
    }
    
    @QtUninvokable
    private native void setCameraPosition_native_float_float_float(long __this__nativeId, float horizontal, float vertical, float zoom);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#cameraPreset-prop">QtDataVisualization::Q3DCamera::<wbr>setCameraPreset(QtDataVisualization::Q3DCamera::CameraPreset)</a></code></p>
     */
    @QtPropertyWriter(name="cameraPreset")
    @QtUninvokable
    public final void setCameraPreset(io.qt.datavis.Q3DCamera.@NonNull CameraPreset preset){
        setCameraPreset_native_QtDataVisualization_Q3DCamera_CameraPreset(QtJambi_LibraryUtilities.internal.nativeId(this), preset.value());
    }
    
    @QtUninvokable
    private native void setCameraPreset_native_QtDataVisualization_Q3DCamera_CameraPreset(long __this__nativeId, int preset);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#maxZoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>setMaxZoomLevel(float)</a></code></p>
     */
    @QtPropertyWriter(name="maxZoomLevel")
    @QtUninvokable
    public final void setMaxZoomLevel(float zoomLevel){
        setMaxZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @QtUninvokable
    private native void setMaxZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#minZoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>setMinZoomLevel(float)</a></code></p>
     */
    @QtPropertyWriter(name="minZoomLevel")
    @QtUninvokable
    public final void setMinZoomLevel(float zoomLevel){
        setMinZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @QtUninvokable
    private native void setMinZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#target-prop">QtDataVisualization::Q3DCamera::<wbr>setTarget(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="target")
    @QtUninvokable
    public final void setTarget(io.qt.gui.@NonNull QVector3D target){
        setTarget_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
    }
    
    @QtUninvokable
    private native void setTarget_native_cref_QVector3D(long __this__nativeId, long target);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#wrapXRotation-prop">QtDataVisualization::Q3DCamera::<wbr>setWrapXRotation(bool)</a></code></p>
     */
    @QtPropertyWriter(name="wrapXRotation")
    @QtUninvokable
    public final void setWrapXRotation(boolean isEnabled){
        setWrapXRotation_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    @QtUninvokable
    private native void setWrapXRotation_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#wrapYRotation-prop">QtDataVisualization::Q3DCamera::<wbr>setWrapYRotation(bool)</a></code></p>
     */
    @QtPropertyWriter(name="wrapYRotation")
    @QtUninvokable
    public final void setWrapYRotation(boolean isEnabled){
        setWrapYRotation_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isEnabled);
    }
    
    @QtUninvokable
    private native void setWrapYRotation_native_bool(long __this__nativeId, boolean isEnabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#xRotation-prop">QtDataVisualization::Q3DCamera::<wbr>setXRotation(float)</a></code></p>
     */
    @QtPropertyWriter(name="xRotation")
    @QtUninvokable
    public final void setXRotation(float rotation){
        setXRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotation);
    }
    
    @QtUninvokable
    private native void setXRotation_native_float(long __this__nativeId, float rotation);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#yRotation-prop">QtDataVisualization::Q3DCamera::<wbr>setYRotation(float)</a></code></p>
     */
    @QtPropertyWriter(name="yRotation")
    @QtUninvokable
    public final void setYRotation(float rotation){
        setYRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), rotation);
    }
    
    @QtUninvokable
    private native void setYRotation_native_float(long __this__nativeId, float rotation);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#zoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>setZoomLevel(float)</a></code></p>
     */
    @QtPropertyWriter(name="zoomLevel")
    @QtUninvokable
    public final void setZoomLevel(float zoomLevel){
        setZoomLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoomLevel);
    }
    
    @QtUninvokable
    private native void setZoomLevel_native_float(long __this__nativeId, float zoomLevel);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#target-prop">QtDataVisualization::Q3DCamera::<wbr>target()const</a></code></p>
     */
    @QtPropertyReader(name="target")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D target(){
        return target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#wrapXRotation-prop">QtDataVisualization::Q3DCamera::<wbr>wrapXRotation()const</a></code></p>
     */
    @QtPropertyReader(name="wrapXRotation")
    @QtUninvokable
    public final boolean wrapXRotation(){
        return wrapXRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean wrapXRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#wrapYRotation-prop">QtDataVisualization::Q3DCamera::<wbr>wrapYRotation()const</a></code></p>
     */
    @QtPropertyReader(name="wrapYRotation")
    @QtUninvokable
    public final boolean wrapYRotation(){
        return wrapYRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean wrapYRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#xRotation-prop">QtDataVisualization::Q3DCamera::<wbr>xRotation()const</a></code></p>
     */
    @QtPropertyReader(name="xRotation")
    @QtUninvokable
    public final float xRotation(){
        return xRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float xRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#yRotation-prop">QtDataVisualization::Q3DCamera::<wbr>yRotation()const</a></code></p>
     */
    @QtPropertyReader(name="yRotation")
    @QtUninvokable
    public final float yRotation(){
        return yRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float yRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dcamera.html#zoomLevel-prop">QtDataVisualization::Q3DCamera::<wbr>zoomLevel()const</a></code></p>
     */
    @QtPropertyReader(name="zoomLevel")
    @QtUninvokable
    public final float zoomLevel(){
        return zoomLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float zoomLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#copyValuesFrom">QtDataVisualization::Q3DObject::<wbr>copyValuesFrom(QtDataVisualization::Q3DObject)</a></code></p>
     */
    @QtUninvokable
    public void copyValuesFrom(io.qt.datavis.@StrictNonNull Q3DObject source){
        java.util.Objects.requireNonNull(source, "Argument 'source': null not expected.");
        copyValuesFrom_native_cref_QtDataVisualization_Q3DObject(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_cref_QtDataVisualization_Q3DObject(long __this__nativeId, long source);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected Q3DCamera(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DCamera(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DCamera instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #Q3DCamera(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DCamera() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #cameraPreset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.Q3DCamera.@NonNull CameraPreset getCameraPreset() {
        return cameraPreset();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxZoomLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxZoomLevel() {
        return maxZoomLevel();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minZoomLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinZoomLevel() {
        return minZoomLevel();
    }
    
    /**
     * <p>Overloaded function for {@link #setCameraPosition(float, float, float)}
     *  with <code>zoom = 100.0f</code>.</p>
     */
    @QtUninvokable
    public final void setCameraPosition(float horizontal, float vertical) {
        setCameraPosition(horizontal, vertical, (float)100.0f);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #target()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getTarget() {
        return target();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #wrapXRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getWrapXRotation() {
        return wrapXRotation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #wrapYRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getWrapYRotation() {
        return wrapYRotation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getXRotation() {
        return xRotation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yRotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getYRotation() {
        return yRotation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zoomLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getZoomLevel() {
        return zoomLevel();
    }
}
