package io.qt.datavis;

import io.qt.*;
import static io.qt.QtUtilities.*;

final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 5;

    final static int qtMinorVersion = 15;

    final static int qtJambiPatch = 16;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.core");
            loadQtLibrary("DBus", LibraryRequirementMode.ProvideOnly, "macos", "linux");
            loadQtLibrary("Network", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("OpenGL", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("PrintSupport", LibraryRequirementMode.ProvideOnly, "macos");
            loadQtLibrary("Qml", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("QmlModels", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Quick", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Svg", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("VirtualKeyboard", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WaylandClient", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WaylandEglClientHwIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Widgets", LibraryRequirementMode.ProvideOnly, "linux", "macos");
            loadQtLibrary("WlShellIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadUtilityLibrary("libGLESv2", LibraryRequirementMode.Optional, "windows");
            loadUtilityLibrary("libEGL", LibraryRequirementMode.Optional, "windows");
            loadQtLibrary("Gui", LibraryRequirementMode.Mandatory);
            loadQtLibrary("DataVisualization", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("DataVisualization");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

