package io.qt.datavis;

import io.qt.*;


/**
 * <p>Container for resolved data to be added to scatter graphs</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html">QtDataVisualization::QScatterDataItem</a></code></p>
 */
public class QScatterDataItem extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#QScatterDataItem">QtDataVisualization::QScatterDataItem::<wbr>QScatterDataItem()</a></code></p>
     */
    public QScatterDataItem(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScatterDataItem instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#QScatterDataItem-1">QtDataVisualization::QScatterDataItem::<wbr>QScatterDataItem(QVector3D)</a></code></p>
     */
    public QScatterDataItem(io.qt.gui.@NonNull QVector3D position){
        super((QPrivateConstructor)null);
        initialize_native(this, position);
    }
    
    private native static void initialize_native(QScatterDataItem instance, io.qt.gui.QVector3D position);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#QScatterDataItem-2">QtDataVisualization::QScatterDataItem::<wbr>QScatterDataItem(QVector3D,<wbr>QQuaternion)</a></code></p>
     */
    public QScatterDataItem(io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QQuaternion rotation){
        super((QPrivateConstructor)null);
        initialize_native(this, position, rotation);
    }
    
    private native static void initialize_native(QScatterDataItem instance, io.qt.gui.QVector3D position, io.qt.gui.QQuaternion rotation);
    
    /**
     * <p>See <code>QtDataVisualization::QScatterDataItem::<wbr>QScatterDataItem(QtDataVisualization::QScatterDataItem)</code></p>
     */
    public QScatterDataItem(io.qt.datavis.@NonNull QScatterDataItem other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScatterDataItem instance, io.qt.datavis.QScatterDataItem other);
    
    /**
     * <p>See <code>QtDataVisualization::QScatterDataItem::<wbr>createExtraData()</code></p>
     */
    @QtUninvokable
    protected final void createExtraData(){
        createExtraData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void createExtraData_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#operator-eq">QtDataVisualization::QScatterDataItem::<wbr>operator=(QtDataVisualization::QScatterDataItem)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.datavis.@NonNull QScatterDataItem other){
        assign_native_cref_QtDataVisualization_QScatterDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QtDataVisualization_QScatterDataItem(long __this__nativeId, long other);
    
    /**
     * <p>See <code>operator==(QtDataVisualization::QScatterDataItem,<wbr>QtDataVisualization::QScatterDataItem)</code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.datavis.@NonNull QScatterDataItem b){
        return operator_equal_native_cref_QtDataVisualization_QScatterDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QtDataVisualization_QScatterDataItem(long __this__nativeId, long b);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#position">QtDataVisualization::QScatterDataItem::<wbr>position()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#rotation">QtDataVisualization::QScatterDataItem::<wbr>rotation()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#setPosition">QtDataVisualization::QScatterDataItem::<wbr>setPosition(QVector3D)</a></code></p>
     */
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D pos){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos));
    }
    
    @QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long pos);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#setRotation">QtDataVisualization::QScatterDataItem::<wbr>setRotation(QQuaternion)</a></code></p>
     */
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion rot){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rot));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rot);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#setX">QtDataVisualization::QScatterDataItem::<wbr>setX(float)</a></code></p>
     */
    @QtUninvokable
    public final void setX(float value){
        setX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setX_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#setY">QtDataVisualization::QScatterDataItem::<wbr>setY(float)</a></code></p>
     */
    @QtUninvokable
    public final void setY(float value){
        setY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setY_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#setZ">QtDataVisualization::QScatterDataItem::<wbr>setZ(float)</a></code></p>
     */
    @QtUninvokable
    public final void setZ(float value){
        setZ_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setZ_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#x">QtDataVisualization::QScatterDataItem::<wbr>x()const</a></code></p>
     */
    @QtUninvokable
    public final float x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#y">QtDataVisualization::QScatterDataItem::<wbr>y()const</a></code></p>
     */
    @QtUninvokable
    public final float y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qscatterdataitem.html#z">QtDataVisualization::QScatterDataItem::<wbr>z()const</a></code></p>
     */
    @QtUninvokable
    public final float z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float z_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScatterDataItem(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator==(QtDataVisualization::QScatterDataItem,<wbr>QtDataVisualization::QScatterDataItem)</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.datavis.QScatterDataItem) {
            return operator_equal((io.qt.datavis.QScatterDataItem) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QtDataVisualization::QScatterDataItem)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QScatterDataItem clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QScatterDataItem clone_native(long __this_nativeId);
}
