package io.qt.datavis;

import io.qt.*;


/**
 * <p>Proxy class for presenting data in item models with Q3DScatter</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html">QtDataVisualization::QItemModelScatterDataProxy</a></code></p>
 */
public class QItemModelScatterDataProxy extends io.qt.datavis.QScatterDataProxy
{
    @QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelScatterDataProxy.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#itemModel-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>itemModelChanged(const QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyNotify(name="itemModel")
    public final @NonNull Signal1<io.qt.core.@Nullable QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>rotationRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>rotationRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> rotationRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>rotationRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>xPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>xPosRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> xPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>xPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="xPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> xPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>yPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>yPosRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> yPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>yPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="yPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> yPosRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>zPosRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRole")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>zPosRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> zPosRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>zPosRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="zPosRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> zPosRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy-1">QtDataVisualization::QItemModelScatterDataProxy::<wbr>QItemModelScatterDataProxy(QAbstractItemModel*,<wbr>QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole) {
        this(itemModel, xPosRole, yPosRole, zPosRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy-2">QtDataVisualization::QItemModelScatterDataProxy::<wbr>QItemModelScatterDataProxy(QAbstractItemModel*,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, xPosRole, yPosRole, zPosRole, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.lang.@NonNull String rotationRole) {
        this(itemModel, xPosRole, yPosRole, zPosRole, rotationRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy-3">QtDataVisualization::QItemModelScatterDataProxy::<wbr>QItemModelScatterDataProxy(QAbstractItemModel*,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.lang.@NonNull String rotationRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, xPosRole, yPosRole, zPosRole, rotationRole, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.lang.String rotationRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelScatterDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelScatterDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#QItemModelScatterDataProxy">QtDataVisualization::QItemModelScatterDataProxy::<wbr>QItemModelScatterDataProxy(QObject*)</a></code></p>
     */
    public QItemModelScatterDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelScatterDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel getItemModel() {
        return itemModel();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#itemModel-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>itemModel()const</a></code></p>
     */
    @QtPropertyReader(name="itemModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#remap">QtDataVisualization::QItemModelScatterDataProxy::<wbr>remap(QString,<wbr>QString,<wbr>QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final void remap(java.lang.@NonNull String xPosRole, java.lang.@NonNull String yPosRole, java.lang.@NonNull String zPosRole, java.lang.@NonNull String rotationRole){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), xPosRole, yPosRole, zPosRole, rotationRole);
    }
    
    @QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String xPosRole, java.lang.String yPosRole, java.lang.String zPosRole, java.lang.String rotationRole);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRole() {
        return rotationRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>rotationRole()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRole")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRole(){
        return rotationRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getRotationRolePattern() {
        return rotationRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>rotationRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp rotationRolePattern(){
        return rotationRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp rotationRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRoleReplace() {
        return rotationRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>rotationRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRoleReplace(){
        return rotationRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#setItemModel">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setItemModel(QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyWriter(name="itemModel")
    @QtUninvokable
    public final void setItemModel(io.qt.core.@Nullable QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setRotationRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRole")
    @QtUninvokable
    public final void setRotationRole(java.lang.@NonNull String role){
        setRotationRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRotationRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setRotationRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRolePattern")
    @QtUninvokable
    public final void setRotationRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setRotationRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRotationRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setRotationRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRoleReplace")
    @QtUninvokable
    public final void setRotationRoleReplace(java.lang.@NonNull String replace){
        setRotationRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRotationRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setXPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRole")
    @QtUninvokable
    public final void setXPosRole(java.lang.@NonNull String role){
        setXPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setXPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setXPosRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRolePattern")
    @QtUninvokable
    public final void setXPosRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setXPosRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setXPosRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setXPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="xPosRoleReplace")
    @QtUninvokable
    public final void setXPosRoleReplace(java.lang.@NonNull String replace){
        setXPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setXPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setYPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRole")
    @QtUninvokable
    public final void setYPosRole(java.lang.@NonNull String role){
        setYPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setYPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setYPosRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRolePattern")
    @QtUninvokable
    public final void setYPosRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setYPosRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setYPosRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setYPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="yPosRoleReplace")
    @QtUninvokable
    public final void setYPosRoleReplace(java.lang.@NonNull String replace){
        setYPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setYPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setZPosRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRole")
    @QtUninvokable
    public final void setZPosRole(java.lang.@NonNull String role){
        setZPosRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setZPosRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setZPosRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRolePattern")
    @QtUninvokable
    public final void setZPosRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setZPosRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setZPosRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>setZPosRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="zPosRoleReplace")
    @QtUninvokable
    public final void setZPosRoleReplace(java.lang.@NonNull String replace){
        setZPosRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setZPosRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRole() {
        return xPosRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>xPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRole(){
        return xPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getXPosRolePattern() {
        return xPosRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>xPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp xPosRolePattern(){
        return xPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp xPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #xPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getXPosRoleReplace() {
        return xPosRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#xPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>xPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="xPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String xPosRoleReplace(){
        return xPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String xPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRole() {
        return yPosRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>yPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRole(){
        return yPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getYPosRolePattern() {
        return yPosRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>yPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp yPosRolePattern(){
        return yPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp yPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #yPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getYPosRoleReplace() {
        return yPosRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#yPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>yPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="yPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String yPosRoleReplace(){
        return yPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String yPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zPosRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRole() {
        return zPosRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRole-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>zPosRole()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRole")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRole(){
        return zPosRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zPosRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getZPosRolePattern() {
        return zPosRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRolePattern-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>zPosRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp zPosRolePattern(){
        return zPosRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp zPosRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zPosRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getZPosRoleReplace() {
        return zPosRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelscatterdataproxy.html#zPosRoleReplace-prop">QtDataVisualization::QItemModelScatterDataProxy::<wbr>zPosRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="zPosRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String zPosRoleReplace(){
        return zPosRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String zPosRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QItemModelScatterDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QItemModelScatterDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QItemModelScatterDataProxy instance, QDeclarativeConstructor constructor);
    
}
