package io.qt.datavis;

import io.qt.*;


/**
 * <p>Proxy class for presenting data in item models with Q3DBars</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html">QtDataVisualization::QItemModelBarDataProxy</a></code></p>
 */
public class QItemModelBarDataProxy extends io.qt.datavis.QBarDataProxy
{
    @QtPropertyMember(enabled=false)
    private Object __rcItemModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QItemModelBarDataProxy.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior</a></code></p>
     */
    @QtUnlistedEnum
    public enum MultiMatchBehavior implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QtDataVisualization::<wbr>QItemModelBarDataProxy::<wbr>MMBFirst</a></code></p>
         */
        MMBFirst(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QtDataVisualization::<wbr>QItemModelBarDataProxy::<wbr>MMBLast</a></code></p>
         */
        MMBLast(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QtDataVisualization::<wbr>QItemModelBarDataProxy::<wbr>MMBAverage</a></code></p>
         */
        MMBAverage(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#MultiMatchBehavior-enum">QtDataVisualization::<wbr>QItemModelBarDataProxy::<wbr>MMBCumulative</a></code></p>
         */
        MMBCumulative(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MultiMatchBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MultiMatchBehavior resolve(int value) {
            switch (value) {
            case 0: return MMBFirst;
            case 1: return MMBLast;
            case 2: return MMBAverage;
            case 3: return MMBCumulative;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>autoColumnCategoriesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="autoColumnCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoColumnCategoriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>autoRowCategoriesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="autoRowCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoRowCategoriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnCategoriesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="columnCategories")
    public final @NonNull Signal0 columnCategoriesChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="columnRole")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="columnRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> columnRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="columnRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> columnRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#itemModel-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>itemModelChanged(const QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyNotify(name="itemModel")
    public final @NonNull Signal1<io.qt.core.@Nullable QAbstractItemModel> itemModelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>multiMatchBehaviorChanged(QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior)</a></code></p>
     */
    @QtPropertyNotify(name="multiMatchBehavior")
    public final @NonNull Signal1<io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior> multiMatchBehaviorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rotationRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rotationRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> rotationRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rotationRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rotationRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rotationRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowCategoriesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="rowCategories")
    public final @NonNull Signal0 rowCategoriesChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rowRole")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="rowRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> rowRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="rowRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> rowRoleReplaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>useModelCategoriesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="useModelCategories")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> useModelCategoriesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>valueRoleChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="valueRole")
    public final @NonNull Signal1<java.lang.@NonNull String> valueRoleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>valueRolePatternChanged(QRegExp)</a></code></p>
     */
    @QtPropertyNotify(name="valueRolePattern")
    public final @NonNull Signal1<io.qt.core.@NonNull QRegExp> valueRolePatternChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>valueRoleReplaceChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="valueRoleReplace")
    public final @NonNull Signal1<java.lang.@NonNull String> valueRoleReplaceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel) {
        this(itemModel, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-1">QtDataVisualization::QItemModelBarDataProxy::<wbr>QItemModelBarDataProxy(QAbstractItemModel*,<wbr>QObject*)</a></code></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole) {
        this(itemModel, rowRole, columnRole, valueRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-3">QtDataVisualization::QItemModelBarDataProxy::<wbr>QItemModelBarDataProxy(QAbstractItemModel*,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QObject*)</a></code></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole) {
        this(itemModel, rowRole, columnRole, valueRole, rotationRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-4">QtDataVisualization::QItemModelBarDataProxy::<wbr>QItemModelBarDataProxy(QAbstractItemModel*,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QObject*)</a></code></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rotationRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-6">QtDataVisualization::QItemModelBarDataProxy::<wbr>QItemModelBarDataProxy(QAbstractItemModel*,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QStringList,<wbr>QStringList,<wbr>QObject*)</a></code></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, java.lang.String, java.lang.String, java.util.Collection, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories) {
        this(itemModel, rowRole, columnRole, valueRole, rowCategories, columnCategories, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-5">QtDataVisualization::QItemModelBarDataProxy::<wbr>QItemModelBarDataProxy(QAbstractItemModel*,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QStringList,<wbr>QStringList,<wbr>QObject*)</a></code></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, rowRole, columnRole, valueRole, rowCategories, columnCategories, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QAbstractItemModel, java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String valueRole) {
        this(itemModel, valueRole, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy-2">QtDataVisualization::QItemModelBarDataProxy::<wbr>QItemModelBarDataProxy(QAbstractItemModel*,<wbr>QString,<wbr>QObject*)</a></code></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QAbstractItemModel itemModel, java.lang.@NonNull String valueRole, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, itemModel, valueRole, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QAbstractItemModel itemModel, java.lang.String valueRole, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QItemModelBarDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QItemModelBarDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#QItemModelBarDataProxy">QtDataVisualization::QItemModelBarDataProxy::<wbr>QItemModelBarDataProxy(QObject*)</a></code></p>
     */
    public QItemModelBarDataProxy(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QItemModelBarDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoColumnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoColumnCategories() {
        return autoColumnCategories();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>autoColumnCategories()const</a></code></p>
     */
    @QtPropertyReader(name="autoColumnCategories")
    @QtUninvokable
    public final boolean autoColumnCategories(){
        return autoColumnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoColumnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #autoRowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoRowCategories() {
        return autoRowCategories();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>autoRowCategories()const</a></code></p>
     */
    @QtPropertyReader(name="autoRowCategories")
    @QtUninvokable
    public final boolean autoRowCategories(){
        return autoRowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean autoRowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getColumnCategories() {
        return columnCategories();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnCategories()const</a></code></p>
     */
    @QtPropertyReader(name="columnCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList columnCategories(){
        return columnCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList columnCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategoryIndex">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnCategoryIndex(QString)</a></code></p>
     */
    public final int columnCategoryIndex(java.lang.@NonNull String category){
        return columnCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int columnCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRole() {
        return columnRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnRole()const</a></code></p>
     */
    @QtPropertyReader(name="columnRole")
    @QtUninvokable
    public final java.lang.@NonNull String columnRole(){
        return columnRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getColumnRolePattern() {
        return columnRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="columnRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp columnRolePattern(){
        return columnRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp columnRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #columnRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getColumnRoleReplace() {
        return columnRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>columnRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="columnRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String columnRoleReplace(){
        return columnRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String columnRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #itemModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel getItemModel() {
        return itemModel();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#itemModel-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>itemModel()const</a></code></p>
     */
    @QtPropertyReader(name="itemModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractItemModel itemModel(){
        return itemModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractItemModel itemModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #multiMatchBehavior()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior getMultiMatchBehavior() {
        return multiMatchBehavior();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>multiMatchBehavior()const</a></code></p>
     */
    @QtPropertyReader(name="multiMatchBehavior")
    @QtUninvokable
    public final io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior multiMatchBehavior(){
        return io.qt.datavis.QItemModelBarDataProxy.MultiMatchBehavior.resolve(multiMatchBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int multiMatchBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#remap">QtDataVisualization::QItemModelBarDataProxy::<wbr>remap(QString,<wbr>QString,<wbr>QString,<wbr>QString,<wbr>QStringList,<wbr>QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void remap(java.lang.@NonNull String rowRole, java.lang.@NonNull String columnRole, java.lang.@NonNull String valueRole, java.lang.@NonNull String rotationRole, java.util.@NonNull Collection<java.lang.@NonNull String> rowCategories, java.util.@NonNull Collection<java.lang.@NonNull String> columnCategories){
        remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), rowRole, columnRole, valueRole, rotationRole, rowCategories, columnCategories);
    }
    
    @QtUninvokable
    private native void remap_native_cref_QString_cref_QString_cref_QString_cref_QString_cref_QStringList_cref_QStringList(long __this__nativeId, java.lang.String rowRole, java.lang.String columnRole, java.lang.String valueRole, java.lang.String rotationRole, java.util.Collection<java.lang.String> rowCategories, java.util.Collection<java.lang.String> columnCategories);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRole() {
        return rotationRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rotationRole()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRole")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRole(){
        return rotationRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getRotationRolePattern() {
        return rotationRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rotationRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp rotationRolePattern(){
        return rotationRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp rotationRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotationRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRotationRoleReplace() {
        return rotationRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rotationRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="rotationRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rotationRoleReplace(){
        return rotationRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rotationRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getRowCategories() {
        return rowCategories();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowCategories()const</a></code></p>
     */
    @QtPropertyReader(name="rowCategories")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList rowCategories(){
        return rowCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList rowCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategoryIndex">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowCategoryIndex(QString)</a></code></p>
     */
    public final int rowCategoryIndex(java.lang.@NonNull String category){
        return rowCategoryIndex_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), category);
    }
    
    private native int rowCategoryIndex_native_cref_QString(long __this__nativeId, java.lang.String category);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRole() {
        return rowRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowRole()const</a></code></p>
     */
    @QtPropertyReader(name="rowRole")
    @QtUninvokable
    public final java.lang.@NonNull String rowRole(){
        return rowRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getRowRolePattern() {
        return rowRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="rowRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp rowRolePattern(){
        return rowRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp rowRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rowRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRowRoleReplace() {
        return rowRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>rowRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="rowRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String rowRoleReplace(){
        return rowRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String rowRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoColumnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setAutoColumnCategories(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoColumnCategories")
    @QtUninvokable
    public final void setAutoColumnCategories(boolean enable){
        setAutoColumnCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoColumnCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#autoRowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setAutoRowCategories(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoRowCategories")
    @QtUninvokable
    public final void setAutoRowCategories(boolean enable){
        setAutoRowCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setAutoRowCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setColumnCategories(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="columnCategories")
    @QtUninvokable
    public final void setColumnCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setColumnCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setColumnCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setColumnRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="columnRole")
    @QtUninvokable
    public final void setColumnRole(java.lang.@NonNull String role){
        setColumnRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setColumnRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setColumnRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="columnRolePattern")
    @QtUninvokable
    public final void setColumnRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setColumnRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setColumnRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#columnRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setColumnRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="columnRoleReplace")
    @QtUninvokable
    public final void setColumnRoleReplace(java.lang.@NonNull String replace){
        setColumnRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setColumnRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#setItemModel">QtDataVisualization::QItemModelBarDataProxy::<wbr>setItemModel(QAbstractItemModel*)</a></code></p>
     */
    @QtPropertyWriter(name="itemModel")
    @QtUninvokable
    public final void setItemModel(io.qt.core.@Nullable QAbstractItemModel itemModel){
        setItemModel_native_QAbstractItemModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(itemModel));
        __rcItemModel = itemModel;
    }
    
    @QtUninvokable
    private native void setItemModel_native_QAbstractItemModel_ptr(long __this__nativeId, long itemModel);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#multiMatchBehavior-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setMultiMatchBehavior(QtDataVisualization::QItemModelBarDataProxy::MultiMatchBehavior)</a></code></p>
     */
    @QtPropertyWriter(name="multiMatchBehavior")
    @QtUninvokable
    public final void setMultiMatchBehavior(io.qt.datavis.QItemModelBarDataProxy.@NonNull MultiMatchBehavior behavior){
        setMultiMatchBehavior_native_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), behavior.value());
    }
    
    @QtUninvokable
    private native void setMultiMatchBehavior_native_QtDataVisualization_QItemModelBarDataProxy_MultiMatchBehavior(long __this__nativeId, int behavior);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setRotationRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRole")
    @QtUninvokable
    public final void setRotationRole(java.lang.@NonNull String role){
        setRotationRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRotationRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setRotationRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRolePattern")
    @QtUninvokable
    public final void setRotationRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setRotationRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRotationRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rotationRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setRotationRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rotationRoleReplace")
    @QtUninvokable
    public final void setRotationRoleReplace(java.lang.@NonNull String replace){
        setRotationRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRotationRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setRowCategories(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="rowCategories")
    @QtUninvokable
    public final void setRowCategories(java.util.@NonNull Collection<java.lang.@NonNull String> categories){
        setRowCategories_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), categories);
    }
    
    @QtUninvokable
    private native void setRowCategories_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> categories);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setRowRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rowRole")
    @QtUninvokable
    public final void setRowRole(java.lang.@NonNull String role){
        setRowRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setRowRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setRowRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="rowRolePattern")
    @QtUninvokable
    public final void setRowRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setRowRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setRowRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#rowRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setRowRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="rowRoleReplace")
    @QtUninvokable
    public final void setRowRoleReplace(java.lang.@NonNull String replace){
        setRowRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setRowRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setUseModelCategories(bool)</a></code></p>
     */
    @QtPropertyWriter(name="useModelCategories")
    @QtUninvokable
    public final void setUseModelCategories(boolean enable){
        setUseModelCategories_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setUseModelCategories_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setValueRole(QString)</a></code></p>
     */
    @QtPropertyWriter(name="valueRole")
    @QtUninvokable
    public final void setValueRole(java.lang.@NonNull String role){
        setValueRole_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), role);
    }
    
    @QtUninvokable
    private native void setValueRole_native_cref_QString(long __this__nativeId, java.lang.String role);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setValueRolePattern(QRegExp)</a></code></p>
     */
    @QtPropertyWriter(name="valueRolePattern")
    @QtUninvokable
    public final void setValueRolePattern(io.qt.core.@NonNull QRegExp pattern){
        setValueRolePattern_native_cref_QRegExp(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pattern));
    }
    
    @QtUninvokable
    private native void setValueRolePattern_native_cref_QRegExp(long __this__nativeId, long pattern);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>setValueRoleReplace(QString)</a></code></p>
     */
    @QtPropertyWriter(name="valueRoleReplace")
    @QtUninvokable
    public final void setValueRoleReplace(java.lang.@NonNull String replace){
        setValueRoleReplace_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replace);
    }
    
    @QtUninvokable
    private native void setValueRoleReplace_native_cref_QString(long __this__nativeId, java.lang.String replace);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #useModelCategories()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUseModelCategories() {
        return useModelCategories();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#useModelCategories-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>useModelCategories()const</a></code></p>
     */
    @QtPropertyReader(name="useModelCategories")
    @QtUninvokable
    public final boolean useModelCategories(){
        return useModelCategories_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean useModelCategories_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #valueRole()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getValueRole() {
        return valueRole();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRole-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>valueRole()const</a></code></p>
     */
    @QtPropertyReader(name="valueRole")
    @QtUninvokable
    public final java.lang.@NonNull String valueRole(){
        return valueRole_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String valueRole_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #valueRolePattern()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp getValueRolePattern() {
        return valueRolePattern();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRolePattern-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>valueRolePattern()const</a></code></p>
     */
    @QtPropertyReader(name="valueRolePattern")
    @QtUninvokable
    public final io.qt.core.@NonNull QRegExp valueRolePattern(){
        return valueRolePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRegExp valueRolePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #valueRoleReplace()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getValueRoleReplace() {
        return valueRoleReplace();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qitemmodelbardataproxy.html#valueRoleReplace-prop">QtDataVisualization::QItemModelBarDataProxy::<wbr>valueRoleReplace()const</a></code></p>
     */
    @QtPropertyReader(name="valueRoleReplace")
    @QtUninvokable
    public final java.lang.@NonNull String valueRoleReplace(){
        return valueRoleReplace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String valueRoleReplace_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QItemModelBarDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QItemModelBarDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QItemModelBarDataProxy instance, QDeclarativeConstructor constructor);
    
}
