package io.qt.datavis;

import io.qt.*;


/**
 * <p>Adds a volume rendered object to a graph</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html">QtDataVisualization::QCustom3DVolume</a></code></p>
 */
public class QCustom3DVolume extends io.qt.datavis.QCustom3DItem
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCustom3DVolume.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#alphaMultiplier-prop">QtDataVisualization::QCustom3DVolume::<wbr>alphaMultiplierChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="alphaMultiplier")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> alphaMultiplierChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#colorTable-prop">QtDataVisualization::QCustom3DVolume::<wbr>colorTableChanged()</a></code></p>
     */
    @QtPropertyNotify(name="colorTable")
    public final @NonNull Signal0 colorTableChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSliceFrames-prop">QtDataVisualization::QCustom3DVolume::<wbr>drawSliceFramesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="drawSliceFrames")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> drawSliceFramesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSlices-prop">QtDataVisualization::QCustom3DVolume::<wbr>drawSlicesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="drawSlices")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> drawSlicesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#preserveOpacity-prop">QtDataVisualization::QCustom3DVolume::<wbr>preserveOpacityChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="preserveOpacity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> preserveOpacityChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameColor-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="sliceFrameColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> sliceFrameColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameGaps-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameGapsChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="sliceFrameGaps")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> sliceFrameGapsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameThicknesses-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameThicknessesChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="sliceFrameThicknesses")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> sliceFrameThicknessesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameWidths-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameWidthsChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="sliceFrameWidths")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> sliceFrameWidthsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexX-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceIndexXChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="sliceIndexX")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> sliceIndexXChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexY-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceIndexYChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="sliceIndexY")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> sliceIndexYChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexZ-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceIndexZChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="sliceIndexZ")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> sliceIndexZChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureData-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureDataChanged(QVector&lt;uchar&gt;*)</a></code></p>
     */
    @QtPropertyNotify(name="textureData")
    public final @NonNull Signal1<java.util.@Nullable List<java.lang.@QtPrimitiveType@NonNull Byte>> textureDataChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDepth-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureDepthChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="textureDepth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> textureDepthChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureFormatChanged">QtDataVisualization::QCustom3DVolume::<wbr>textureFormatChanged(QImage::Format)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.gui.QImage.@NonNull Format> textureFormatChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureHeight-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureHeightChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="textureHeight")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> textureHeightChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureWidth-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureWidthChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="textureWidth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> textureWidthChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#useHighDefShader-prop">QtDataVisualization::QCustom3DVolume::<wbr>useHighDefShaderChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="useHighDefShader")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> useHighDefShaderChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DVolume(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DVolume() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#QCustom3DVolume">QtDataVisualization::QCustom3DVolume::<wbr>QCustom3DVolume(QObject*)</a></code></p>
     */
    public QCustom3DVolume(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCustom3DVolume instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DVolume(io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, int, int, int, java.util.Collection, io.qt.gui.QImage.Format, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DVolume(io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.@Nullable Collection<java.lang.@QtPrimitiveType@NonNull Byte> textureData, io.qt.gui.QImage.@NonNull Format textureFormat, java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> colorTable) {
        this(position, scaling, rotation, textureWidth, textureHeight, textureDepth, textureData, textureFormat, colorTable, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code>QtDataVisualization::QCustom3DVolume::<wbr>QCustom3DVolume(QVector3D,<wbr>QVector3D,<wbr>QQuaternion,<wbr>int,<wbr>int,<wbr>int,<wbr>QVector&lt;uchar&gt;*,<wbr>QImage::Format,<wbr>QVector&lt;QRgb&gt;,<wbr>QObject*)</code></p>
     */
    public QCustom3DVolume(io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.@Nullable Collection<java.lang.@QtPrimitiveType@NonNull Byte> textureData, io.qt.gui.QImage.@NonNull Format textureFormat, java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> colorTable, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, position, scaling, rotation, textureWidth, textureHeight, textureDepth, textureData, textureFormat, colorTable, parent);
    }
    
    private native static void initialize_native(QCustom3DVolume instance, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.Collection<java.lang.@QtPrimitiveType Byte> textureData, io.qt.gui.QImage.Format textureFormat, java.util.Collection<java.lang.@QtPrimitiveType Integer> colorTable, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #alphaMultiplier()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getAlphaMultiplier() {
        return alphaMultiplier();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#alphaMultiplier-prop">QtDataVisualization::QCustom3DVolume::<wbr>alphaMultiplier()const</a></code></p>
     */
    @QtPropertyReader(name="alphaMultiplier")
    @QtUninvokable
    public final float alphaMultiplier(){
        return alphaMultiplier_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float alphaMultiplier_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #colorTable()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QVector<java.lang.@QtPrimitiveType@NonNull Integer> getColorTable() {
        return colorTable();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#colorTable-prop">QtDataVisualization::QCustom3DVolume::<wbr>colorTable()const</a></code></p>
     */
    @QtPropertyReader(name="colorTable")
    @QtUninvokable
    public final io.qt.core.@NonNull QVector<java.lang.@QtPrimitiveType@NonNull Integer> colorTable(){
        return colorTable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QVector<java.lang.@QtPrimitiveType Integer> colorTable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#createTextureData">QtDataVisualization::QCustom3DVolume::<wbr>createTextureData(QVector&lt;QImage*&gt;)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QVector<java.lang.@QtPrimitiveType@NonNull Byte> createTextureData(java.util.@NonNull Collection<? extends io.qt.gui.@Nullable QImage> images){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcTextureData);
        io.qt.core.@Nullable QVector<java.lang.@QtPrimitiveType@NonNull Byte> __qt_return_value = createTextureData_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), images);
        __rcTextureData = __qt_return_value;
        QtJambi_LibraryUtilities.internal.registerDependentObject(__rcTextureData, this);
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.core.QVector<java.lang.@QtPrimitiveType Byte> createTextureData_native_cref_QVector(long __this__nativeId, java.util.Collection<? extends io.qt.gui.QImage> images);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #drawSliceFrames()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getDrawSliceFrames() {
        return drawSliceFrames();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSliceFrames-prop">QtDataVisualization::QCustom3DVolume::<wbr>drawSliceFrames()const</a></code></p>
     */
    @QtPropertyReader(name="drawSliceFrames")
    @QtUninvokable
    public final boolean drawSliceFrames(){
        return drawSliceFrames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean drawSliceFrames_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #drawSlices()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getDrawSlices() {
        return drawSlices();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSlices-prop">QtDataVisualization::QCustom3DVolume::<wbr>drawSlices()const</a></code></p>
     */
    @QtPropertyReader(name="drawSlices")
    @QtUninvokable
    public final boolean drawSlices(){
        return drawSlices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean drawSlices_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #preserveOpacity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPreserveOpacity() {
        return preserveOpacity();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#preserveOpacity-prop">QtDataVisualization::QCustom3DVolume::<wbr>preserveOpacity()const</a></code></p>
     */
    @QtPropertyReader(name="preserveOpacity")
    @QtUninvokable
    public final boolean preserveOpacity(){
        return preserveOpacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean preserveOpacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#renderSlice">QtDataVisualization::QCustom3DVolume::<wbr>renderSlice(Qt::Axis,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage renderSlice(io.qt.core.Qt.@NonNull Axis axis, int index){
        return renderSlice_native_Qt_Axis_int(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index);
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage renderSlice_native_Qt_Axis_int(long __this__nativeId, int axis, int index);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#alphaMultiplier-prop">QtDataVisualization::QCustom3DVolume::<wbr>setAlphaMultiplier(float)</a></code></p>
     */
    @QtPropertyWriter(name="alphaMultiplier")
    @QtUninvokable
    public final void setAlphaMultiplier(float mult){
        setAlphaMultiplier_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), mult);
    }
    
    @QtUninvokable
    private native void setAlphaMultiplier_native_float(long __this__nativeId, float mult);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#colorTable-prop">QtDataVisualization::QCustom3DVolume::<wbr>setColorTable(QVector&lt;QRgb&gt;)</a></code></p>
     */
    @QtPropertyWriter(name="colorTable")
    @QtUninvokable
    public final void setColorTable(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> colors){
        setColorTable_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), colors);
    }
    
    @QtUninvokable
    private native void setColorTable_native_cref_QVector(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Integer> colors);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSliceFrames-prop">QtDataVisualization::QCustom3DVolume::<wbr>setDrawSliceFrames(bool)</a></code></p>
     */
    @QtPropertyWriter(name="drawSliceFrames")
    @QtUninvokable
    public final void setDrawSliceFrames(boolean enable){
        setDrawSliceFrames_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setDrawSliceFrames_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSlices-prop">QtDataVisualization::QCustom3DVolume::<wbr>setDrawSlices(bool)</a></code></p>
     */
    @QtPropertyWriter(name="drawSlices")
    @QtUninvokable
    public final void setDrawSlices(boolean enable){
        setDrawSlices_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setDrawSlices_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#preserveOpacity-prop">QtDataVisualization::QCustom3DVolume::<wbr>setPreserveOpacity(bool)</a></code></p>
     */
    @QtPropertyWriter(name="preserveOpacity")
    @QtUninvokable
    public final void setPreserveOpacity(boolean enable){
        setPreserveOpacity_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setPreserveOpacity_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameColor-prop">QtDataVisualization::QCustom3DVolume::<wbr>setSliceFrameColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="sliceFrameColor")
    @QtUninvokable
    public final void setSliceFrameColor(io.qt.gui.@NonNull QColor color){
        setSliceFrameColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setSliceFrameColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameGaps-prop">QtDataVisualization::QCustom3DVolume::<wbr>setSliceFrameGaps(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="sliceFrameGaps")
    @QtUninvokable
    public final void setSliceFrameGaps(io.qt.gui.@NonNull QVector3D values){
        setSliceFrameGaps_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native void setSliceFrameGaps_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameThicknesses-prop">QtDataVisualization::QCustom3DVolume::<wbr>setSliceFrameThicknesses(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="sliceFrameThicknesses")
    @QtUninvokable
    public final void setSliceFrameThicknesses(io.qt.gui.@NonNull QVector3D values){
        setSliceFrameThicknesses_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native void setSliceFrameThicknesses_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameWidths-prop">QtDataVisualization::QCustom3DVolume::<wbr>setSliceFrameWidths(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="sliceFrameWidths")
    @QtUninvokable
    public final void setSliceFrameWidths(io.qt.gui.@NonNull QVector3D values){
        setSliceFrameWidths_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native void setSliceFrameWidths_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexX-prop">QtDataVisualization::QCustom3DVolume::<wbr>setSliceIndexX(int)</a></code></p>
     */
    @QtPropertyWriter(name="sliceIndexX")
    @QtUninvokable
    public final void setSliceIndexX(int value){
        setSliceIndexX_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setSliceIndexX_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexY-prop">QtDataVisualization::QCustom3DVolume::<wbr>setSliceIndexY(int)</a></code></p>
     */
    @QtPropertyWriter(name="sliceIndexY")
    @QtUninvokable
    public final void setSliceIndexY(int value){
        setSliceIndexY_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setSliceIndexY_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexZ-prop">QtDataVisualization::QCustom3DVolume::<wbr>setSliceIndexZ(int)</a></code></p>
     */
    @QtPropertyWriter(name="sliceIndexZ")
    @QtUninvokable
    public final void setSliceIndexZ(int value){
        setSliceIndexZ_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setSliceIndexZ_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setSliceIndices">QtDataVisualization::QCustom3DVolume::<wbr>setSliceIndices(int,<wbr>int,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void setSliceIndices(int x, int y, int z){
        setSliceIndices_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void setSliceIndices_native_int_int_int(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setSubTextureData-1">QtDataVisualization::QCustom3DVolume::<wbr>setSubTextureData(Qt::Axis,<wbr>int,<wbr>QImage)</a></code></p>
     */
    @QtUninvokable
    public final void setSubTextureData(io.qt.core.Qt.@NonNull Axis axis, int index, io.qt.gui.@NonNull QImage image){
        setSubTextureData_native_Qt_Axis_int_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index, QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    @QtUninvokable
    private native void setSubTextureData_native_Qt_Axis_int_cref_QImage(long __this__nativeId, int axis, int index, long image);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setSubTextureData">QtDataVisualization::QCustom3DVolume::<wbr>setSubTextureData(Qt::Axis,<wbr>int,<wbr>const uchar*)</a></code></p>
     */
    @QtUninvokable
    public final void setSubTextureData(io.qt.core.Qt.@NonNull Axis axis, int index, java.nio.ByteBuffer data){
        setSubTextureData_native_Qt_Axis_int_const_uchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index, data);
    }
    
    @QtUninvokable
    private native void setSubTextureData_native_Qt_Axis_int_const_uchar_ptr(long __this__nativeId, int axis, int index, java.nio.ByteBuffer data);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureData-prop">QtDataVisualization::QCustom3DVolume::<wbr>setTextureData(QVector&lt;uchar&gt;*)</a></code></p>
     */
    @QtPropertyWriter(name="textureData")
    @QtUninvokable
    public final void setTextureData(java.util.@Nullable Collection<java.lang.@QtPrimitiveType@NonNull Byte> data){
        setTextureData_native_QVector_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native void setTextureData_native_QVector_ptr(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Byte> data);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDepth-prop">QtDataVisualization::QCustom3DVolume::<wbr>setTextureDepth(int)</a></code></p>
     */
    @QtPropertyWriter(name="textureDepth")
    @QtUninvokable
    public final void setTextureDepth(int value){
        setTextureDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setTextureDepth_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setTextureDimensions">QtDataVisualization::QCustom3DVolume::<wbr>setTextureDimensions(int,<wbr>int,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void setTextureDimensions(int width, int height, int depth){
        setTextureDimensions_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, depth);
    }
    
    @QtUninvokable
    private native void setTextureDimensions_native_int_int_int(long __this__nativeId, int width, int height, int depth);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setTextureFormat">QtDataVisualization::QCustom3DVolume::<wbr>setTextureFormat(QImage::Format)</a></code></p>
     */
    @QtUninvokable
    public final void setTextureFormat(io.qt.gui.QImage.@NonNull Format format){
        setTextureFormat_native_QImage_Format(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setTextureFormat_native_QImage_Format(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureHeight-prop">QtDataVisualization::QCustom3DVolume::<wbr>setTextureHeight(int)</a></code></p>
     */
    @QtPropertyWriter(name="textureHeight")
    @QtUninvokable
    public final void setTextureHeight(int value){
        setTextureHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setTextureHeight_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureWidth-prop">QtDataVisualization::QCustom3DVolume::<wbr>setTextureWidth(int)</a></code></p>
     */
    @QtPropertyWriter(name="textureWidth")
    @QtUninvokable
    public final void setTextureWidth(int value){
        setTextureWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setTextureWidth_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#useHighDefShader-prop">QtDataVisualization::QCustom3DVolume::<wbr>setUseHighDefShader(bool)</a></code></p>
     */
    @QtPropertyWriter(name="useHighDefShader")
    @QtUninvokable
    public final void setUseHighDefShader(boolean enable){
        setUseHighDefShader_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setUseHighDefShader_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getSliceFrameColor() {
        return sliceFrameColor();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameColor-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameColor()const</a></code></p>
     */
    @QtPropertyReader(name="sliceFrameColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor sliceFrameColor(){
        return sliceFrameColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor sliceFrameColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameGaps()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getSliceFrameGaps() {
        return sliceFrameGaps();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameGaps-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameGaps()const</a></code></p>
     */
    @QtPropertyReader(name="sliceFrameGaps")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D sliceFrameGaps(){
        return sliceFrameGaps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameGaps_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameThicknesses()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getSliceFrameThicknesses() {
        return sliceFrameThicknesses();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameThicknesses-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameThicknesses()const</a></code></p>
     */
    @QtPropertyReader(name="sliceFrameThicknesses")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D sliceFrameThicknesses(){
        return sliceFrameThicknesses_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameThicknesses_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceFrameWidths()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getSliceFrameWidths() {
        return sliceFrameWidths();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameWidths-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceFrameWidths()const</a></code></p>
     */
    @QtPropertyReader(name="sliceFrameWidths")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D sliceFrameWidths(){
        return sliceFrameWidths_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameWidths_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceIndexX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSliceIndexX() {
        return sliceIndexX();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexX-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceIndexX()const</a></code></p>
     */
    @QtPropertyReader(name="sliceIndexX")
    @QtUninvokable
    public final int sliceIndexX(){
        return sliceIndexX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sliceIndexX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceIndexY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSliceIndexY() {
        return sliceIndexY();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexY-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceIndexY()const</a></code></p>
     */
    @QtPropertyReader(name="sliceIndexY")
    @QtUninvokable
    public final int sliceIndexY(){
        return sliceIndexY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sliceIndexY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sliceIndexZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSliceIndexZ() {
        return sliceIndexZ();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexZ-prop">QtDataVisualization::QCustom3DVolume::<wbr>sliceIndexZ()const</a></code></p>
     */
    @QtPropertyReader(name="sliceIndexZ")
    @QtUninvokable
    public final int sliceIndexZ(){
        return sliceIndexZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sliceIndexZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureData()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QVector<java.lang.@QtPrimitiveType@NonNull Byte> getTextureData() {
        return textureData();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureData-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureData()const</a></code></p>
     */
    @QtPropertyReader(name="textureData")
    @QtUninvokable
    public final io.qt.core.@Nullable QVector<java.lang.@QtPrimitiveType@NonNull Byte> textureData(){
        return textureData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QVector<java.lang.@QtPrimitiveType Byte> textureData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDataWidth">QtDataVisualization::QCustom3DVolume::<wbr>textureDataWidth()const</a></code></p>
     */
    @QtUninvokable
    public final int textureDataWidth(){
        return textureDataWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureDataWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureDepth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTextureDepth() {
        return textureDepth();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDepth-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureDepth()const</a></code></p>
     */
    @QtPropertyReader(name="textureDepth")
    @QtUninvokable
    public final int textureDepth(){
        return textureDepth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureDepth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureFormat">QtDataVisualization::QCustom3DVolume::<wbr>textureFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.QImage.@NonNull Format textureFormat(){
        return io.qt.gui.QImage.Format.resolve(textureFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int textureFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureHeight()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTextureHeight() {
        return textureHeight();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureHeight-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureHeight()const</a></code></p>
     */
    @QtPropertyReader(name="textureHeight")
    @QtUninvokable
    public final int textureHeight(){
        return textureHeight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureHeight_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureWidth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTextureWidth() {
        return textureWidth();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureWidth-prop">QtDataVisualization::QCustom3DVolume::<wbr>textureWidth()const</a></code></p>
     */
    @QtPropertyReader(name="textureWidth")
    @QtUninvokable
    public final int textureWidth(){
        return textureWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #useHighDefShader()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUseHighDefShader() {
        return useHighDefShader();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#useHighDefShader-prop">QtDataVisualization::QCustom3DVolume::<wbr>useHighDefShader()const</a></code></p>
     */
    @QtPropertyReader(name="useHighDefShader")
    @QtUninvokable
    public final boolean useHighDefShader(){
        return useHighDefShader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean useHighDefShader_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QCustom3DVolume(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCustom3DVolume(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCustom3DVolume instance, QDeclarativeConstructor constructor);
    
    private QtObject __rcTextureData;
}
