package io.qt.datavis;

import io.qt.*;


/**
 * <p>Adds a custom item to a graph</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html">QtDataVisualization::QCustom3DItem</a></code></p>
 */
public class QCustom3DItem extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCustom3DItem.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#meshFile-prop">QtDataVisualization::QCustom3DItem::<wbr>meshFileChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="meshFile")
    public final @NonNull Signal1<java.lang.@NonNull String> meshFileChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#positionAbsolute-prop">QtDataVisualization::QCustom3DItem::<wbr>positionAbsoluteChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="positionAbsolute")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> positionAbsoluteChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#position-prop">QtDataVisualization::QCustom3DItem::<wbr>positionChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> positionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#rotation-prop">QtDataVisualization::QCustom3DItem::<wbr>rotationChanged(QQuaternion)</a></code></p>
     */
    @QtPropertyNotify(name="rotation")
    public final @NonNull Signal1<io.qt.gui.@NonNull QQuaternion> rotationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#scalingAbsolute-prop">QtDataVisualization::QCustom3DItem::<wbr>scalingAbsoluteChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="scalingAbsolute")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> scalingAbsoluteChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#scaling-prop">QtDataVisualization::QCustom3DItem::<wbr>scalingChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="scaling")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> scalingChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#shadowCasting-prop">QtDataVisualization::QCustom3DItem::<wbr>shadowCastingChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="shadowCasting")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> shadowCastingChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#textureFile-prop">QtDataVisualization::QCustom3DItem::<wbr>textureFileChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="textureFile")
    public final @NonNull Signal1<java.lang.@NonNull String> textureFileChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#visible-prop">QtDataVisualization::QCustom3DItem::<wbr>visibleChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="visible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> visibleChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DItem(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DItem() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#QCustom3DItem">QtDataVisualization::QCustom3DItem::<wbr>QCustom3DItem(QObject*)</a></code></p>
     */
    public QCustom3DItem(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCustom3DItem instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DItem(java.lang.String, io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, io.qt.gui.QImage, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DItem(java.lang.@NonNull String meshFile, io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, io.qt.gui.@NonNull QImage texture) {
        this(meshFile, position, scaling, rotation, texture, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#QCustom3DItem-1">QtDataVisualization::QCustom3DItem::<wbr>QCustom3DItem(QString,<wbr>QVector3D,<wbr>QVector3D,<wbr>QQuaternion,<wbr>QImage,<wbr>QObject*)</a></code></p>
     */
    public QCustom3DItem(java.lang.@NonNull String meshFile, io.qt.gui.@NonNull QVector3D position, io.qt.gui.@NonNull QVector3D scaling, io.qt.gui.@NonNull QQuaternion rotation, io.qt.gui.@NonNull QImage texture, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, meshFile, position, scaling, rotation, texture, parent);
    }
    
    private native static void initialize_native(QCustom3DItem instance, java.lang.String meshFile, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, io.qt.gui.QImage texture, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isPositionAbsolute()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPositionAbsolute() {
        return isPositionAbsolute();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#positionAbsolute-prop">QtDataVisualization::QCustom3DItem::<wbr>isPositionAbsolute()const</a></code></p>
     */
    @QtPropertyReader(name="positionAbsolute")
    @QtUninvokable
    public final boolean isPositionAbsolute(){
        return isPositionAbsolute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPositionAbsolute_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isScalingAbsolute()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getScalingAbsolute() {
        return isScalingAbsolute();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#scalingAbsolute-prop">QtDataVisualization::QCustom3DItem::<wbr>isScalingAbsolute()const</a></code></p>
     */
    @QtPropertyReader(name="scalingAbsolute")
    @QtUninvokable
    public final boolean isScalingAbsolute(){
        return isScalingAbsolute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isScalingAbsolute_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isShadowCasting()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getShadowCasting() {
        return isShadowCasting();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#shadowCasting-prop">QtDataVisualization::QCustom3DItem::<wbr>isShadowCasting()const</a></code></p>
     */
    @QtPropertyReader(name="shadowCasting")
    @QtUninvokable
    public final boolean isShadowCasting(){
        return isShadowCasting_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isShadowCasting_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getVisible() {
        return isVisible();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#visible-prop">QtDataVisualization::QCustom3DItem::<wbr>isVisible()const</a></code></p>
     */
    @QtPropertyReader(name="visible")
    @QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #meshFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getMeshFile() {
        return meshFile();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#meshFile-prop">QtDataVisualization::QCustom3DItem::<wbr>meshFile()const</a></code></p>
     */
    @QtPropertyReader(name="meshFile")
    @QtUninvokable
    public final java.lang.@NonNull String meshFile(){
        return meshFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String meshFile_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#position-prop">QtDataVisualization::QCustom3DItem::<wbr>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rotation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion getRotation() {
        return rotation();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#rotation-prop">QtDataVisualization::QCustom3DItem::<wbr>rotation()</a></code></p>
     */
    @QtPropertyReader(name="rotation")
    @QtUninvokable
    public final io.qt.gui.@NonNull QQuaternion rotation(){
        return rotation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QQuaternion rotation_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #scaling()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getScaling() {
        return scaling();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#scaling-prop">QtDataVisualization::QCustom3DItem::<wbr>scaling()const</a></code></p>
     */
    @QtPropertyReader(name="scaling")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D scaling(){
        return scaling_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D scaling_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#meshFile-prop">QtDataVisualization::QCustom3DItem::<wbr>setMeshFile(QString)</a></code></p>
     */
    @QtPropertyWriter(name="meshFile")
    @QtUninvokable
    public final void setMeshFile(java.lang.@NonNull String meshFile){
        setMeshFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), meshFile);
    }
    
    @QtUninvokable
    private native void setMeshFile_native_cref_QString(long __this__nativeId, java.lang.String meshFile);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#position-prop">QtDataVisualization::QCustom3DItem::<wbr>setPosition(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="position")
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D position){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#positionAbsolute-prop">QtDataVisualization::QCustom3DItem::<wbr>setPositionAbsolute(bool)</a></code></p>
     */
    @QtPropertyWriter(name="positionAbsolute")
    @QtUninvokable
    public final void setPositionAbsolute(boolean positionAbsolute){
        setPositionAbsolute_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), positionAbsolute);
    }
    
    @QtUninvokable
    private native void setPositionAbsolute_native_bool(long __this__nativeId, boolean positionAbsolute);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#rotation-prop">QtDataVisualization::QCustom3DItem::<wbr>setRotation(QQuaternion)</a></code></p>
     */
    @QtPropertyWriter(name="rotation")
    @QtUninvokable
    public final void setRotation(io.qt.gui.@NonNull QQuaternion rotation){
        setRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    @QtUninvokable
    private native void setRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#setRotationAxisAndAngle">QtDataVisualization::QCustom3DItem::<wbr>setRotationAxisAndAngle(QVector3D,<wbr>float)</a></code></p>
     */
    public final void setRotationAxisAndAngle(io.qt.gui.@NonNull QVector3D axis, float angle){
        setRotationAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native void setRotationAxisAndAngle_native_cref_QVector3D_float(long __this__nativeId, long axis, float angle);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#scaling-prop">QtDataVisualization::QCustom3DItem::<wbr>setScaling(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="scaling")
    @QtUninvokable
    public final void setScaling(io.qt.gui.@NonNull QVector3D scaling){
        setScaling_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scaling));
    }
    
    @QtUninvokable
    private native void setScaling_native_cref_QVector3D(long __this__nativeId, long scaling);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#scalingAbsolute-prop">QtDataVisualization::QCustom3DItem::<wbr>setScalingAbsolute(bool)</a></code></p>
     */
    @QtPropertyWriter(name="scalingAbsolute")
    @QtUninvokable
    public final void setScalingAbsolute(boolean scalingAbsolute){
        setScalingAbsolute_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), scalingAbsolute);
    }
    
    @QtUninvokable
    private native void setScalingAbsolute_native_bool(long __this__nativeId, boolean scalingAbsolute);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#shadowCasting-prop">QtDataVisualization::QCustom3DItem::<wbr>setShadowCasting(bool)</a></code></p>
     */
    @QtPropertyWriter(name="shadowCasting")
    @QtUninvokable
    public final void setShadowCasting(boolean enabled){
        setShadowCasting_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setShadowCasting_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#textureFile-prop">QtDataVisualization::QCustom3DItem::<wbr>setTextureFile(QString)</a></code></p>
     */
    @QtPropertyWriter(name="textureFile")
    @QtUninvokable
    public final void setTextureFile(java.lang.@NonNull String textureFile){
        setTextureFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), textureFile);
    }
    
    @QtUninvokable
    private native void setTextureFile_native_cref_QString(long __this__nativeId, java.lang.String textureFile);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#setTextureImage">QtDataVisualization::QCustom3DItem::<wbr>setTextureImage(QImage)</a></code></p>
     */
    @QtUninvokable
    public final void setTextureImage(io.qt.gui.@NonNull QImage textureImage){
        setTextureImage_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @QtUninvokable
    private native void setTextureImage_native_cref_QImage(long __this__nativeId, long textureImage);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#visible-prop">QtDataVisualization::QCustom3DItem::<wbr>setVisible(bool)</a></code></p>
     */
    @QtPropertyWriter(name="visible")
    @QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureFile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTextureFile() {
        return textureFile();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qcustom3ditem.html#textureFile-prop">QtDataVisualization::QCustom3DItem::<wbr>textureFile()const</a></code></p>
     */
    @QtPropertyReader(name="textureFile")
    @QtUninvokable
    public final java.lang.@NonNull String textureFile(){
        return textureFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String textureFile_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QCustom3DItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCustom3DItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCustom3DItem instance, QDeclarativeConstructor constructor);
    
}
