package io.qt.datavis;

import io.qt.*;


/**
 * <p>Description of the 3D scene being visualized</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/q3dscene.html">QtDataVisualization::Q3DScene</a></code></p>
 */
public class Q3DScene extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DScene.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#activeCamera-prop">QtDataVisualization::Q3DScene::<wbr>activeCameraChanged(QtDataVisualization::Q3DCamera*)</a></code></p>
     */
    @QtPropertyNotify(name="activeCamera")
    public final @NonNull Signal1<io.qt.datavis.@Nullable Q3DCamera> activeCameraChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#activeLight-prop">QtDataVisualization::Q3DScene::<wbr>activeLightChanged(QtDataVisualization::Q3DLight*)</a></code></p>
     */
    @QtPropertyNotify(name="activeLight")
    public final @NonNull Signal1<io.qt.datavis.@Nullable Q3DLight> activeLightChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#devicePixelRatio-prop">QtDataVisualization::Q3DScene::<wbr>devicePixelRatioChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="devicePixelRatio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> devicePixelRatioChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#graphPositionQuery-prop">QtDataVisualization::Q3DScene::<wbr>graphPositionQueryChanged(QPoint)</a></code></p>
     */
    @QtPropertyNotify(name="graphPositionQuery")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> graphPositionQueryChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#primarySubViewport-prop">QtDataVisualization::Q3DScene::<wbr>primarySubViewportChanged(QRect)</a></code></p>
     */
    @QtPropertyNotify(name="primarySubViewport")
    public final @NonNull Signal1<io.qt.core.@NonNull QRect> primarySubViewportChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#secondarySubViewport-prop">QtDataVisualization::Q3DScene::<wbr>secondarySubViewportChanged(QRect)</a></code></p>
     */
    @QtPropertyNotify(name="secondarySubViewport")
    public final @NonNull Signal1<io.qt.core.@NonNull QRect> secondarySubViewportChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#secondarySubviewOnTop-prop">QtDataVisualization::Q3DScene::<wbr>secondarySubviewOnTopChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="secondarySubviewOnTop")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> secondarySubviewOnTopChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#selectionQueryPosition-prop">QtDataVisualization::Q3DScene::<wbr>selectionQueryPositionChanged(QPoint)</a></code></p>
     */
    @QtPropertyNotify(name="selectionQueryPosition")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> selectionQueryPositionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#slicingActive-prop">QtDataVisualization::Q3DScene::<wbr>slicingActiveChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="slicingActive")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> slicingActiveChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#viewport-prop">QtDataVisualization::Q3DScene::<wbr>viewportChanged(QRect)</a></code></p>
     */
    @QtPropertyNotify(name="viewport")
    public final @NonNull Signal1<io.qt.core.@NonNull QRect> viewportChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DScene(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DScene() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#Q3DScene">QtDataVisualization::Q3DScene::<wbr>Q3DScene(QObject*)</a></code></p>
     */
    public Q3DScene(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DScene instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activeCamera()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DCamera getActiveCamera() {
        return activeCamera();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#activeCamera-prop">QtDataVisualization::Q3DScene::<wbr>activeCamera()const</a></code></p>
     */
    @QtPropertyReader(name="activeCamera")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DCamera activeCamera(){
        return activeCamera_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DCamera activeCamera_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activeLight()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DLight getActiveLight() {
        return activeLight();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#activeLight-prop">QtDataVisualization::Q3DScene::<wbr>activeLight()const</a></code></p>
     */
    @QtPropertyReader(name="activeLight")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DLight activeLight(){
        return activeLight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DLight activeLight_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #devicePixelRatio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDevicePixelRatio() {
        return devicePixelRatio();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#devicePixelRatio-prop">QtDataVisualization::Q3DScene::<wbr>devicePixelRatio()const</a></code></p>
     */
    @QtPropertyReader(name="devicePixelRatio")
    @QtUninvokable
    public final float devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #graphPositionQuery()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getGraphPositionQuery() {
        return graphPositionQuery();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#graphPositionQuery-prop">QtDataVisualization::Q3DScene::<wbr>graphPositionQuery()const</a></code></p>
     */
    @QtPropertyReader(name="graphPositionQuery")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint graphPositionQuery(){
        return graphPositionQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint graphPositionQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#isPointInPrimarySubView">QtDataVisualization::Q3DScene::<wbr>isPointInPrimarySubView(QPoint)</a></code></p>
     */
    @QtUninvokable
    public final boolean isPointInPrimarySubView(io.qt.core.@NonNull QPoint point){
        return isPointInPrimarySubView_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native boolean isPointInPrimarySubView_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#isPointInSecondarySubView">QtDataVisualization::Q3DScene::<wbr>isPointInSecondarySubView(QPoint)</a></code></p>
     */
    @QtUninvokable
    public final boolean isPointInSecondarySubView(io.qt.core.@NonNull QPoint point){
        return isPointInSecondarySubView_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native boolean isPointInSecondarySubView_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isSecondarySubviewOnTop()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSecondarySubviewOnTop() {
        return isSecondarySubviewOnTop();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#secondarySubviewOnTop-prop">QtDataVisualization::Q3DScene::<wbr>isSecondarySubviewOnTop()const</a></code></p>
     */
    @QtPropertyReader(name="secondarySubviewOnTop")
    @QtUninvokable
    public final boolean isSecondarySubviewOnTop(){
        return isSecondarySubviewOnTop_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSecondarySubviewOnTop_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isSlicingActive()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSlicingActive() {
        return isSlicingActive();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#slicingActive-prop">QtDataVisualization::Q3DScene::<wbr>isSlicingActive()const</a></code></p>
     */
    @QtPropertyReader(name="slicingActive")
    @QtUninvokable
    public final boolean isSlicingActive(){
        return isSlicingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSlicingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #primarySubViewport()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRect getPrimarySubViewport() {
        return primarySubViewport();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#primarySubViewport-prop">QtDataVisualization::Q3DScene::<wbr>primarySubViewport()const</a></code></p>
     */
    @QtPropertyReader(name="primarySubViewport")
    @QtUninvokable
    public final io.qt.core.@NonNull QRect primarySubViewport(){
        return primarySubViewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect primarySubViewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #secondarySubViewport()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRect getSecondarySubViewport() {
        return secondarySubViewport();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#secondarySubViewport-prop">QtDataVisualization::Q3DScene::<wbr>secondarySubViewport()const</a></code></p>
     */
    @QtPropertyReader(name="secondarySubViewport")
    @QtUninvokable
    public final io.qt.core.@NonNull QRect secondarySubViewport(){
        return secondarySubViewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect secondarySubViewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectionQueryPosition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getSelectionQueryPosition() {
        return selectionQueryPosition();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#selectionQueryPosition-prop">QtDataVisualization::Q3DScene::<wbr>selectionQueryPosition()const</a></code></p>
     */
    @QtPropertyReader(name="selectionQueryPosition")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint selectionQueryPosition(){
        return selectionQueryPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint selectionQueryPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#activeCamera-prop">QtDataVisualization::Q3DScene::<wbr>setActiveCamera(QtDataVisualization::Q3DCamera*)</a></code></p>
     */
    @QtPropertyWriter(name="activeCamera")
    @QtUninvokable
    public final void setActiveCamera(io.qt.datavis.@Nullable Q3DCamera camera){
        setActiveCamera_native_QtDataVisualization_Q3DCamera_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(camera));
    }
    
    @QtUninvokable
    private native void setActiveCamera_native_QtDataVisualization_Q3DCamera_ptr(long __this__nativeId, long camera);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#activeLight-prop">QtDataVisualization::Q3DScene::<wbr>setActiveLight(QtDataVisualization::Q3DLight*)</a></code></p>
     */
    @QtPropertyWriter(name="activeLight")
    @QtUninvokable
    public final void setActiveLight(io.qt.datavis.@Nullable Q3DLight light){
        setActiveLight_native_QtDataVisualization_Q3DLight_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(light));
    }
    
    @QtUninvokable
    private native void setActiveLight_native_QtDataVisualization_Q3DLight_ptr(long __this__nativeId, long light);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#devicePixelRatio-prop">QtDataVisualization::Q3DScene::<wbr>setDevicePixelRatio(float)</a></code></p>
     */
    @QtPropertyWriter(name="devicePixelRatio")
    @QtUninvokable
    public final void setDevicePixelRatio(float pixelRatio){
        setDevicePixelRatio_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), pixelRatio);
    }
    
    @QtUninvokable
    private native void setDevicePixelRatio_native_float(long __this__nativeId, float pixelRatio);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#graphPositionQuery-prop">QtDataVisualization::Q3DScene::<wbr>setGraphPositionQuery(QPoint)</a></code></p>
     */
    @QtPropertyWriter(name="graphPositionQuery")
    @QtUninvokable
    public final void setGraphPositionQuery(io.qt.core.@NonNull QPoint point){
        setGraphPositionQuery_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setGraphPositionQuery_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#primarySubViewport-prop">QtDataVisualization::Q3DScene::<wbr>setPrimarySubViewport(QRect)</a></code></p>
     */
    @QtPropertyWriter(name="primarySubViewport")
    @QtUninvokable
    public final void setPrimarySubViewport(io.qt.core.@NonNull QRect primarySubViewport){
        setPrimarySubViewport_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(primarySubViewport));
    }
    
    @QtUninvokable
    private native void setPrimarySubViewport_native_cref_QRect(long __this__nativeId, long primarySubViewport);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#secondarySubViewport-prop">QtDataVisualization::Q3DScene::<wbr>setSecondarySubViewport(QRect)</a></code></p>
     */
    @QtPropertyWriter(name="secondarySubViewport")
    @QtUninvokable
    public final void setSecondarySubViewport(io.qt.core.@NonNull QRect secondarySubViewport){
        setSecondarySubViewport_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(secondarySubViewport));
    }
    
    @QtUninvokable
    private native void setSecondarySubViewport_native_cref_QRect(long __this__nativeId, long secondarySubViewport);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#secondarySubviewOnTop-prop">QtDataVisualization::Q3DScene::<wbr>setSecondarySubviewOnTop(bool)</a></code></p>
     */
    @QtPropertyWriter(name="secondarySubviewOnTop")
    @QtUninvokable
    public final void setSecondarySubviewOnTop(boolean isSecondaryOnTop){
        setSecondarySubviewOnTop_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isSecondaryOnTop);
    }
    
    @QtUninvokable
    private native void setSecondarySubviewOnTop_native_bool(long __this__nativeId, boolean isSecondaryOnTop);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#selectionQueryPosition-prop">QtDataVisualization::Q3DScene::<wbr>setSelectionQueryPosition(QPoint)</a></code></p>
     */
    @QtPropertyWriter(name="selectionQueryPosition")
    @QtUninvokable
    public final void setSelectionQueryPosition(io.qt.core.@NonNull QPoint point){
        setSelectionQueryPosition_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setSelectionQueryPosition_native_cref_QPoint(long __this__nativeId, long point);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#slicingActive-prop">QtDataVisualization::Q3DScene::<wbr>setSlicingActive(bool)</a></code></p>
     */
    @QtPropertyWriter(name="slicingActive")
    @QtUninvokable
    public final void setSlicingActive(boolean isSlicing){
        setSlicingActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isSlicing);
    }
    
    @QtUninvokable
    private native void setSlicingActive_native_bool(long __this__nativeId, boolean isSlicing);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewport()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRect getViewport() {
        return viewport();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#viewport-prop">QtDataVisualization::Q3DScene::<wbr>viewport()const</a></code></p>
     */
    @QtPropertyReader(name="viewport")
    @QtUninvokable
    public final io.qt.core.@NonNull QRect viewport(){
        return viewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect viewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dscene.html#invalidSelectionPoint">QtDataVisualization::Q3DScene::<wbr>invalidSelectionPoint()</a></code></p>
     */
    public native static io.qt.core.@NonNull QPoint invalidSelectionPoint();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected Q3DScene(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DScene(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DScene instance, QDeclarativeConstructor constructor);
    
}
