package io.qt.datavis;

import io.qt.*;


/**
 * <p>Simple base class for all the objects in a 3D scene</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/q3dobject.html">QtDataVisualization::Q3DObject</a></code></p>
 */
public class Q3DObject extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DObject.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#position-prop">QtDataVisualization::Q3DObject::<wbr>positionChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> positionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DObject(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DObject() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#Q3DObject">QtDataVisualization::Q3DObject::<wbr>Q3DObject(QObject*)</a></code></p>
     */
    public Q3DObject(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DObject instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#isDirty">QtDataVisualization::Q3DObject::<wbr>isDirty()const</a></code></p>
     */
    @QtUninvokable
    protected final boolean isDirty(){
        return isDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDirty_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #parentScene()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DScene getParentScene() {
        return parentScene();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#parentScene-prop">QtDataVisualization::Q3DObject::<wbr>parentScene()</a></code></p>
     */
    @QtPropertyReader(name="parentScene")
    @QtUninvokable
    public final io.qt.datavis.@Nullable Q3DScene parentScene(){
        return parentScene_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.datavis.Q3DScene parentScene_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#position-prop">QtDataVisualization::Q3DObject::<wbr>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#setDirty">QtDataVisualization::Q3DObject::<wbr>setDirty(bool)</a></code></p>
     */
    @QtUninvokable
    protected final void setDirty(boolean dirty){
        setDirty_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), dirty);
    }
    
    @QtUninvokable
    private native void setDirty_native_bool(long __this__nativeId, boolean dirty);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#position-prop">QtDataVisualization::Q3DObject::<wbr>setPosition(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="position")
    @QtUninvokable
    public final void setPosition(io.qt.gui.@NonNull QVector3D position){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dobject.html#copyValuesFrom">QtDataVisualization::Q3DObject::<wbr>copyValuesFrom(QtDataVisualization::Q3DObject)</a></code></p>
     */
    @QtUninvokable
    public void copyValuesFrom(io.qt.datavis.@StrictNonNull Q3DObject source){
        java.util.Objects.requireNonNull(source, "Argument 'source': null not expected.");
        copyValuesFrom_native_cref_QtDataVisualization_Q3DObject(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native void copyValuesFrom_native_cref_QtDataVisualization_Q3DObject(long __this__nativeId, long source);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected Q3DObject(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DObject(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DObject instance, QDeclarativeConstructor constructor);
    
}
