package io.qt.datavis;

import io.qt.*;


/**
 * <p>Representation of a light source in 3D space</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/q3dlight.html">QtDataVisualization::Q3DLight</a></code></p>
 */
public class Q3DLight extends io.qt.datavis.Q3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DLight.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dlight.html#autoPosition-prop">QtDataVisualization::Q3DLight::<wbr>autoPositionChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="autoPosition")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> autoPositionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DLight(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DLight() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dlight.html#Q3DLight">QtDataVisualization::Q3DLight::<wbr>Q3DLight(QObject*)</a></code></p>
     */
    public Q3DLight(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DLight instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAutoPosition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAutoPosition() {
        return isAutoPosition();
    }
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dlight.html#autoPosition-prop">QtDataVisualization::Q3DLight::<wbr>isAutoPosition()</a></code></p>
     */
    @QtPropertyReader(name="autoPosition")
    @QtUninvokable
    public final boolean isAutoPosition(){
        return isAutoPosition_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAutoPosition_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/q3dlight.html#autoPosition-prop">QtDataVisualization::Q3DLight::<wbr>setAutoPosition(bool)</a></code></p>
     */
    @QtPropertyWriter(name="autoPosition")
    @QtUninvokable
    public final void setAutoPosition(boolean enabled){
        setAutoPosition_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setAutoPosition_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected Q3DLight(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected Q3DLight(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(Q3DLight instance, QDeclarativeConstructor constructor);
    
}
