package io.qt.datavis;


/**
 * <p>Adds a volume rendered object to a graph</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html">QtDataVisualization::QCustom3DVolume</a></p>
 */
public class QCustom3DVolume extends io.qt.datavis.QCustom3DItem
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCustom3DVolume.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#alphaMultiplier-prop">QtDataVisualization::QCustom3DVolume::alphaMultiplierChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="alphaMultiplier")
    public final Signal1<@io.qt.QtPrimitiveType Float> alphaMultiplierChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#colorTable-prop">QtDataVisualization::QCustom3DVolume::colorTableChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="colorTable")
    public final Signal0 colorTableChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSliceFrames-prop">QtDataVisualization::QCustom3DVolume::drawSliceFramesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="drawSliceFrames")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> drawSliceFramesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSlices-prop">QtDataVisualization::QCustom3DVolume::drawSlicesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="drawSlices")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> drawSlicesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#preserveOpacity-prop">QtDataVisualization::QCustom3DVolume::preserveOpacityChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="preserveOpacity")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> preserveOpacityChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameColor-prop">QtDataVisualization::QCustom3DVolume::sliceFrameColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sliceFrameColor")
    public final Signal1<io.qt.gui.QColor> sliceFrameColorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameGaps-prop">QtDataVisualization::QCustom3DVolume::sliceFrameGapsChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sliceFrameGaps")
    public final Signal1<io.qt.gui.QVector3D> sliceFrameGapsChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameThicknesses-prop">QtDataVisualization::QCustom3DVolume::sliceFrameThicknessesChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sliceFrameThicknesses")
    public final Signal1<io.qt.gui.QVector3D> sliceFrameThicknessesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameWidths-prop">QtDataVisualization::QCustom3DVolume::sliceFrameWidthsChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sliceFrameWidths")
    public final Signal1<io.qt.gui.QVector3D> sliceFrameWidthsChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexX-prop">QtDataVisualization::QCustom3DVolume::sliceIndexXChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sliceIndexX")
    public final Signal1<@io.qt.QtPrimitiveType Integer> sliceIndexXChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexY-prop">QtDataVisualization::QCustom3DVolume::sliceIndexYChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sliceIndexY")
    public final Signal1<@io.qt.QtPrimitiveType Integer> sliceIndexYChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexZ-prop">QtDataVisualization::QCustom3DVolume::sliceIndexZChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sliceIndexZ")
    public final Signal1<@io.qt.QtPrimitiveType Integer> sliceIndexZChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureData-prop">QtDataVisualization::QCustom3DVolume::textureDataChanged(QVector&lt;uchar&gt;*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureData")
    public final Signal1<java.util.List<java.lang.Byte>> textureDataChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDepth-prop">QtDataVisualization::QCustom3DVolume::textureDepthChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureDepth")
    public final Signal1<@io.qt.QtPrimitiveType Integer> textureDepthChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureFormatChanged">QtDataVisualization::QCustom3DVolume::textureFormatChanged(QImage::Format)</a></p>
     */
    public final Signal1<io.qt.gui.QImage.Format> textureFormatChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureHeight-prop">QtDataVisualization::QCustom3DVolume::textureHeightChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureHeight")
    public final Signal1<@io.qt.QtPrimitiveType Integer> textureHeightChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureWidth-prop">QtDataVisualization::QCustom3DVolume::textureWidthChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureWidth")
    public final Signal1<@io.qt.QtPrimitiveType Integer> textureWidthChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#useHighDefShader-prop">QtDataVisualization::QCustom3DVolume::useHighDefShaderChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="useHighDefShader")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> useHighDefShaderChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DVolume(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DVolume() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#QCustom3DVolume">QtDataVisualization::QCustom3DVolume::QCustom3DVolume(QObject*)</a></p>
     */
    public QCustom3DVolume(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCustom3DVolume instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QCustom3DVolume(io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, int, int, int, java.util.Collection, io.qt.gui.QImage.Format, java.util.Collection, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCustom3DVolume(io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.Collection<java.lang.Byte> textureData, io.qt.gui.QImage.Format textureFormat, java.util.Collection<java.lang.Integer> colorTable) {
        this(position, scaling, rotation, textureWidth, textureHeight, textureDepth, textureData, textureFormat, colorTable, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#QCustom3DVolume-1">QtDataVisualization::QCustom3DVolume::QCustom3DVolume(QVector3D,QVector3D,QQuaternion,int,int,int,QVector&lt;uchar&gt;*,QImage::Format,QVector&lt;QRgb&gt;,QObject*)</a></p>
     */
    public QCustom3DVolume(io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.Collection<java.lang.Byte> textureData, io.qt.gui.QImage.Format textureFormat, java.util.Collection<java.lang.Integer> colorTable, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, position, scaling, rotation, textureWidth, textureHeight, textureDepth, textureData, textureFormat, colorTable, parent);
    }
    
    private native static void initialize_native(QCustom3DVolume instance, io.qt.gui.QVector3D position, io.qt.gui.QVector3D scaling, io.qt.gui.QQuaternion rotation, int textureWidth, int textureHeight, int textureDepth, java.util.Collection<java.lang.Byte> textureData, io.qt.gui.QImage.Format textureFormat, java.util.Collection<java.lang.Integer> colorTable, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#alphaMultiplier-prop">QtDataVisualization::QCustom3DVolume::alphaMultiplier()const</a></p>
     */
    @io.qt.QtPropertyReader(name="alphaMultiplier")
    @io.qt.QtUninvokable
    public final float alphaMultiplier(){
        return alphaMultiplier_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float alphaMultiplier_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#colorTable-prop">QtDataVisualization::QCustom3DVolume::colorTable()const</a></p>
     */
    @io.qt.QtPropertyReader(name="colorTable")
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<java.lang.Integer> colorTable(){
        return colorTable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<java.lang.Integer> colorTable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#createTextureData">QtDataVisualization::QCustom3DVolume::createTextureData(QVector&lt;QImage*&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<java.lang.Byte> createTextureData(java.util.Collection<io.qt.gui.QImage> images){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcTextureData);
        io.qt.core.QVector<java.lang.Byte> __qt_return_value = createTextureData_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), images);
        __rcTextureData = __qt_return_value;
        QtJambi_LibraryUtilities.internal.registerDependentObject(__rcTextureData, this);
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<java.lang.Byte> createTextureData_native_cref_QVector(long __this__nativeId, java.util.Collection<io.qt.gui.QImage> images);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSliceFrames-prop">QtDataVisualization::QCustom3DVolume::drawSliceFrames()const</a></p>
     */
    @io.qt.QtPropertyReader(name="drawSliceFrames")
    @io.qt.QtUninvokable
    public final boolean drawSliceFrames(){
        return drawSliceFrames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean drawSliceFrames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSlices-prop">QtDataVisualization::QCustom3DVolume::drawSlices()const</a></p>
     */
    @io.qt.QtPropertyReader(name="drawSlices")
    @io.qt.QtUninvokable
    public final boolean drawSlices(){
        return drawSlices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean drawSlices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#preserveOpacity-prop">QtDataVisualization::QCustom3DVolume::preserveOpacity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="preserveOpacity")
    @io.qt.QtUninvokable
    public final boolean preserveOpacity(){
        return preserveOpacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean preserveOpacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#renderSlice">QtDataVisualization::QCustom3DVolume::renderSlice(Qt::Axis,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage renderSlice(io.qt.core.Qt.Axis axis, int index){
        return renderSlice_native_Qt_Axis_int(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage renderSlice_native_Qt_Axis_int(long __this__nativeId, int axis, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#alphaMultiplier-prop">QtDataVisualization::QCustom3DVolume::setAlphaMultiplier(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="alphaMultiplier")
    @io.qt.QtUninvokable
    public final void setAlphaMultiplier(float mult){
        setAlphaMultiplier_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), mult);
    }
    
    @io.qt.QtUninvokable
    private native void setAlphaMultiplier_native_float(long __this__nativeId, float mult);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#colorTable-prop">QtDataVisualization::QCustom3DVolume::setColorTable(QVector&lt;QRgb&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="colorTable")
    @io.qt.QtUninvokable
    public final void setColorTable(java.util.Collection<java.lang.Integer> colors){
        setColorTable_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), colors);
    }
    
    @io.qt.QtUninvokable
    private native void setColorTable_native_cref_QVector(long __this__nativeId, java.util.Collection<java.lang.Integer> colors);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSliceFrames-prop">QtDataVisualization::QCustom3DVolume::setDrawSliceFrames(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="drawSliceFrames")
    @io.qt.QtUninvokable
    public final void setDrawSliceFrames(boolean enable){
        setDrawSliceFrames_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setDrawSliceFrames_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#drawSlices-prop">QtDataVisualization::QCustom3DVolume::setDrawSlices(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="drawSlices")
    @io.qt.QtUninvokable
    public final void setDrawSlices(boolean enable){
        setDrawSlices_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setDrawSlices_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#preserveOpacity-prop">QtDataVisualization::QCustom3DVolume::setPreserveOpacity(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="preserveOpacity")
    @io.qt.QtUninvokable
    public final void setPreserveOpacity(boolean enable){
        setPreserveOpacity_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setPreserveOpacity_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameColor-prop">QtDataVisualization::QCustom3DVolume::setSliceFrameColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sliceFrameColor")
    @io.qt.QtUninvokable
    public final void setSliceFrameColor(io.qt.gui.QColor color){
        setSliceFrameColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setSliceFrameColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameGaps-prop">QtDataVisualization::QCustom3DVolume::setSliceFrameGaps(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sliceFrameGaps")
    @io.qt.QtUninvokable
    public final void setSliceFrameGaps(io.qt.gui.QVector3D values){
        setSliceFrameGaps_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @io.qt.QtUninvokable
    private native void setSliceFrameGaps_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameThicknesses-prop">QtDataVisualization::QCustom3DVolume::setSliceFrameThicknesses(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sliceFrameThicknesses")
    @io.qt.QtUninvokable
    public final void setSliceFrameThicknesses(io.qt.gui.QVector3D values){
        setSliceFrameThicknesses_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @io.qt.QtUninvokable
    private native void setSliceFrameThicknesses_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameWidths-prop">QtDataVisualization::QCustom3DVolume::setSliceFrameWidths(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sliceFrameWidths")
    @io.qt.QtUninvokable
    public final void setSliceFrameWidths(io.qt.gui.QVector3D values){
        setSliceFrameWidths_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @io.qt.QtUninvokable
    private native void setSliceFrameWidths_native_cref_QVector3D(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexX-prop">QtDataVisualization::QCustom3DVolume::setSliceIndexX(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sliceIndexX")
    @io.qt.QtUninvokable
    public final void setSliceIndexX(int value){
        setSliceIndexX_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setSliceIndexX_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexY-prop">QtDataVisualization::QCustom3DVolume::setSliceIndexY(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sliceIndexY")
    @io.qt.QtUninvokable
    public final void setSliceIndexY(int value){
        setSliceIndexY_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setSliceIndexY_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexZ-prop">QtDataVisualization::QCustom3DVolume::setSliceIndexZ(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sliceIndexZ")
    @io.qt.QtUninvokable
    public final void setSliceIndexZ(int value){
        setSliceIndexZ_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setSliceIndexZ_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setSliceIndices">QtDataVisualization::QCustom3DVolume::setSliceIndices(int,int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSliceIndices(int x, int y, int z){
        setSliceIndices_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void setSliceIndices_native_int_int_int(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setSubTextureData-1">QtDataVisualization::QCustom3DVolume::setSubTextureData(Qt::Axis,int,QImage)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSubTextureData(io.qt.core.Qt.Axis axis, int index, io.qt.gui.QImage image){
        setSubTextureData_native_Qt_Axis_int_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index, QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    @io.qt.QtUninvokable
    private native void setSubTextureData_native_Qt_Axis_int_cref_QImage(long __this__nativeId, int axis, int index, long image);
    
    @io.qt.QtUninvokable
    public final void setSubTextureData(io.qt.core.Qt.Axis axis, int index, java.nio.ByteBuffer data){
        setSubTextureData_native_Qt_Axis_int_const_unsigned_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), index, data);
    }
    
    @io.qt.QtUninvokable
    private native void setSubTextureData_native_Qt_Axis_int_const_unsigned_char_ptr(long __this__nativeId, int axis, int index, java.nio.ByteBuffer data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureData-prop">QtDataVisualization::QCustom3DVolume::setTextureData(QVector&lt;uchar&gt;*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureData")
    @io.qt.QtUninvokable
    public final void setTextureData(java.util.Collection<java.lang.Byte> data){
        setTextureData_native_QVector_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureData_native_QVector_ptr(long __this__nativeId, java.util.Collection<java.lang.Byte> data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDepth-prop">QtDataVisualization::QCustom3DVolume::setTextureDepth(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureDepth")
    @io.qt.QtUninvokable
    public final void setTextureDepth(int value){
        setTextureDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureDepth_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setTextureDimensions">QtDataVisualization::QCustom3DVolume::setTextureDimensions(int,int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTextureDimensions(int width, int height, int depth){
        setTextureDimensions_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, depth);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureDimensions_native_int_int_int(long __this__nativeId, int width, int height, int depth);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#setTextureFormat">QtDataVisualization::QCustom3DVolume::setTextureFormat(QImage::Format)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTextureFormat(io.qt.gui.QImage.Format format){
        setTextureFormat_native_QImage_Format(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @io.qt.QtUninvokable
    private native void setTextureFormat_native_QImage_Format(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureHeight-prop">QtDataVisualization::QCustom3DVolume::setTextureHeight(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureHeight")
    @io.qt.QtUninvokable
    public final void setTextureHeight(int value){
        setTextureHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureHeight_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureWidth-prop">QtDataVisualization::QCustom3DVolume::setTextureWidth(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureWidth")
    @io.qt.QtUninvokable
    public final void setTextureWidth(int value){
        setTextureWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureWidth_native_int(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#useHighDefShader-prop">QtDataVisualization::QCustom3DVolume::setUseHighDefShader(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="useHighDefShader")
    @io.qt.QtUninvokable
    public final void setUseHighDefShader(boolean enable){
        setUseHighDefShader_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setUseHighDefShader_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameColor-prop">QtDataVisualization::QCustom3DVolume::sliceFrameColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sliceFrameColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor sliceFrameColor(){
        return sliceFrameColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor sliceFrameColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameGaps-prop">QtDataVisualization::QCustom3DVolume::sliceFrameGaps()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sliceFrameGaps")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D sliceFrameGaps(){
        return sliceFrameGaps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameGaps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameThicknesses-prop">QtDataVisualization::QCustom3DVolume::sliceFrameThicknesses()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sliceFrameThicknesses")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D sliceFrameThicknesses(){
        return sliceFrameThicknesses_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameThicknesses_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceFrameWidths-prop">QtDataVisualization::QCustom3DVolume::sliceFrameWidths()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sliceFrameWidths")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D sliceFrameWidths(){
        return sliceFrameWidths_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D sliceFrameWidths_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexX-prop">QtDataVisualization::QCustom3DVolume::sliceIndexX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sliceIndexX")
    @io.qt.QtUninvokable
    public final int sliceIndexX(){
        return sliceIndexX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int sliceIndexX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexY-prop">QtDataVisualization::QCustom3DVolume::sliceIndexY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sliceIndexY")
    @io.qt.QtUninvokable
    public final int sliceIndexY(){
        return sliceIndexY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int sliceIndexY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#sliceIndexZ-prop">QtDataVisualization::QCustom3DVolume::sliceIndexZ()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sliceIndexZ")
    @io.qt.QtUninvokable
    public final int sliceIndexZ(){
        return sliceIndexZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int sliceIndexZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureData-prop">QtDataVisualization::QCustom3DVolume::textureData()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureData")
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<java.lang.Byte> textureData(){
        return textureData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<java.lang.Byte> textureData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDataWidth">QtDataVisualization::QCustom3DVolume::textureDataWidth()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int textureDataWidth(){
        return textureDataWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int textureDataWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureDepth-prop">QtDataVisualization::QCustom3DVolume::textureDepth()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureDepth")
    @io.qt.QtUninvokable
    public final int textureDepth(){
        return textureDepth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int textureDepth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureFormat">QtDataVisualization::QCustom3DVolume::textureFormat()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage.Format textureFormat(){
        return io.qt.gui.QImage.Format.resolve(textureFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int textureFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureHeight-prop">QtDataVisualization::QCustom3DVolume::textureHeight()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureHeight")
    @io.qt.QtUninvokable
    public final int textureHeight(){
        return textureHeight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int textureHeight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#textureWidth-prop">QtDataVisualization::QCustom3DVolume::textureWidth()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureWidth")
    @io.qt.QtUninvokable
    public final int textureWidth(){
        return textureWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int textureWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qcustom3dvolume.html#useHighDefShader-prop">QtDataVisualization::QCustom3DVolume::useHighDefShader()const</a></p>
     */
    @io.qt.QtPropertyReader(name="useHighDefShader")
    @io.qt.QtUninvokable
    public final boolean useHighDefShader(){
        return useHighDefShader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean useHighDefShader_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QCustom3DVolume(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QCustom3DVolume(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QCustom3DVolume instance, QDeclarativeConstructor constructor);
    
    private io.qt.QtObject __rcTextureData;
}
