package io.qt.datavis;


/**
 * <p>Base class for all data series</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qabstract3dseries.html">QtDataVisualization::QAbstract3DSeries</a></p>
 */
public class QAbstract3DSeries extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DSeries.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#Mesh-enum">QtDataVisualization::QAbstract3DSeries::Mesh</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum Mesh implements io.qt.QtEnumerator {
        MeshUserDefined(0),
        MeshBar(1),
        MeshCube(2),
        MeshPyramid(3),
        MeshCone(4),
        MeshCylinder(5),
        MeshBevelBar(6),
        MeshBevelCube(7),
        MeshSphere(8),
        MeshMinimal(9),
        MeshArrow(10),
        MeshPoint(11);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mesh(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Mesh resolve(int value) {
            switch (value) {
            case 0: return MeshUserDefined;
            case 1: return MeshBar;
            case 2: return MeshCube;
            case 3: return MeshPyramid;
            case 4: return MeshCone;
            case 5: return MeshCylinder;
            case 6: return MeshBevelBar;
            case 7: return MeshBevelCube;
            case 8: return MeshSphere;
            case 9: return MeshMinimal;
            case 10: return MeshArrow;
            case 11: return MeshPoint;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#SeriesType-enum">QtDataVisualization::QAbstract3DSeries::SeriesType</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum SeriesType implements io.qt.QtEnumerator {
        SeriesTypeNone(0),
        SeriesTypeBar(1),
        SeriesTypeScatter(2),
        SeriesTypeSurface(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SeriesType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SeriesType resolve(int value) {
            switch (value) {
            case 0: return SeriesTypeNone;
            case 1: return SeriesTypeBar;
            case 2: return SeriesTypeScatter;
            case 4: return SeriesTypeSurface;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseColor-prop">QtDataVisualization::QAbstract3DSeries::baseColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="baseColor")
    public final Signal1<io.qt.gui.QColor> baseColorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseGradient-prop">QtDataVisualization::QAbstract3DSeries::baseGradientChanged(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyNotify(name="baseGradient")
    public final Signal1<io.qt.gui.QLinearGradient> baseGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#colorStyle-prop">QtDataVisualization::QAbstract3DSeries::colorStyleChanged(QtDataVisualization::Q3DTheme::ColorStyle)</a></p>
     */
    @io.qt.QtPropertyNotify(name="colorStyle")
    public final Signal1<io.qt.datavis.Q3DTheme.ColorStyle> colorStyleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabel-prop">QtDataVisualization::QAbstract3DSeries::itemLabelChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="itemLabel")
    public final Signal1<java.lang.String> itemLabelChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelFormat-prop">QtDataVisualization::QAbstract3DSeries::itemLabelFormatChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="itemLabelFormat")
    public final Signal1<java.lang.String> itemLabelFormatChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelVisible-prop">QtDataVisualization::QAbstract3DSeries::itemLabelVisibilityChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="itemLabelVisible")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> itemLabelVisibilityChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#mesh-prop">QtDataVisualization::QAbstract3DSeries::meshChanged(QtDataVisualization::QAbstract3DSeries::Mesh)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mesh")
    public final Signal1<io.qt.datavis.QAbstract3DSeries.Mesh> meshChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshRotation-prop">QtDataVisualization::QAbstract3DSeries::meshRotationChanged(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyNotify(name="meshRotation")
    public final Signal1<io.qt.gui.QQuaternion> meshRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshSmooth-prop">QtDataVisualization::QAbstract3DSeries::meshSmoothChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="meshSmooth")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> meshSmoothChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::multiHighlightColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="multiHighlightColor")
    public final Signal1<io.qt.gui.QColor> multiHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::multiHighlightGradientChanged(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyNotify(name="multiHighlightGradient")
    public final Signal1<io.qt.gui.QLinearGradient> multiHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#name-prop">QtDataVisualization::QAbstract3DSeries::nameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="name")
    public final Signal1<java.lang.String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::singleHighlightColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="singleHighlightColor")
    public final Signal1<io.qt.gui.QColor> singleHighlightColorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::singleHighlightGradientChanged(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyNotify(name="singleHighlightGradient")
    public final Signal1<io.qt.gui.QLinearGradient> singleHighlightGradientChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#userDefinedMesh-prop">QtDataVisualization::QAbstract3DSeries::userDefinedMeshChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="userDefinedMesh")
    public final Signal1<java.lang.String> userDefinedMeshChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#visible-prop">QtDataVisualization::QAbstract3DSeries::visibilityChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="visible")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> visibilityChanged = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseColor-prop">QtDataVisualization::QAbstract3DSeries::baseColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="baseColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor baseColor(){
        return baseColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor baseColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseGradient-prop">QtDataVisualization::QAbstract3DSeries::baseGradient()const</a></p>
     */
    @io.qt.QtPropertyReader(name="baseGradient")
    @io.qt.QtUninvokable
    public final io.qt.gui.QLinearGradient baseGradient(){
        return baseGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QLinearGradient baseGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#colorStyle-prop">QtDataVisualization::QAbstract3DSeries::colorStyle()const</a></p>
     */
    @io.qt.QtPropertyReader(name="colorStyle")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DTheme.ColorStyle colorStyle(){
        return io.qt.datavis.Q3DTheme.ColorStyle.resolve(colorStyle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int colorStyle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelVisible-prop">QtDataVisualization::QAbstract3DSeries::isItemLabelVisible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="itemLabelVisible")
    @io.qt.QtUninvokable
    public final boolean isItemLabelVisible(){
        return isItemLabelVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isItemLabelVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshSmooth-prop">QtDataVisualization::QAbstract3DSeries::isMeshSmooth()const</a></p>
     */
    @io.qt.QtPropertyReader(name="meshSmooth")
    @io.qt.QtUninvokable
    public final boolean isMeshSmooth(){
        return isMeshSmooth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isMeshSmooth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#visible-prop">QtDataVisualization::QAbstract3DSeries::isVisible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="visible")
    @io.qt.QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabel-prop">QtDataVisualization::QAbstract3DSeries::itemLabel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="itemLabel")
    @io.qt.QtUninvokable
    public final java.lang.String itemLabel(){
        return itemLabel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String itemLabel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelFormat-prop">QtDataVisualization::QAbstract3DSeries::itemLabelFormat()const</a></p>
     */
    @io.qt.QtPropertyReader(name="itemLabelFormat")
    @io.qt.QtUninvokable
    public final java.lang.String itemLabelFormat(){
        return itemLabelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String itemLabelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#mesh-prop">QtDataVisualization::QAbstract3DSeries::mesh()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mesh")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.Mesh mesh(){
        return io.qt.datavis.QAbstract3DSeries.Mesh.resolve(mesh_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int mesh_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshRotation-prop">QtDataVisualization::QAbstract3DSeries::meshRotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="meshRotation")
    @io.qt.QtUninvokable
    public final io.qt.gui.QQuaternion meshRotation(){
        return meshRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QQuaternion meshRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::multiHighlightColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="multiHighlightColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor multiHighlightColor(){
        return multiHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor multiHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::multiHighlightGradient()const</a></p>
     */
    @io.qt.QtPropertyReader(name="multiHighlightGradient")
    @io.qt.QtUninvokable
    public final io.qt.gui.QLinearGradient multiHighlightGradient(){
        return multiHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QLinearGradient multiHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#name-prop">QtDataVisualization::QAbstract3DSeries::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseColor-prop">QtDataVisualization::QAbstract3DSeries::setBaseColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="baseColor")
    @io.qt.QtUninvokable
    public final void setBaseColor(io.qt.gui.QColor color){
        setBaseColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setBaseColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#baseGradient-prop">QtDataVisualization::QAbstract3DSeries::setBaseGradient(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyWriter(name="baseGradient")
    @io.qt.QtUninvokable
    public final void setBaseGradient(io.qt.gui.QLinearGradient gradient){
        setBaseGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @io.qt.QtUninvokable
    private native void setBaseGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#colorStyle-prop">QtDataVisualization::QAbstract3DSeries::setColorStyle(QtDataVisualization::Q3DTheme::ColorStyle)</a></p>
     */
    @io.qt.QtPropertyWriter(name="colorStyle")
    @io.qt.QtUninvokable
    public final void setColorStyle(io.qt.datavis.Q3DTheme.ColorStyle style){
        setColorStyle_native_QtDataVisualization_Q3DTheme_ColorStyle(QtJambi_LibraryUtilities.internal.nativeId(this), style.value());
    }
    
    @io.qt.QtUninvokable
    private native void setColorStyle_native_QtDataVisualization_Q3DTheme_ColorStyle(long __this__nativeId, int style);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelFormat-prop">QtDataVisualization::QAbstract3DSeries::setItemLabelFormat(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="itemLabelFormat")
    @io.qt.QtUninvokable
    public final void setItemLabelFormat(java.lang.String format){
        setItemLabelFormat_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), format);
    }
    
    @io.qt.QtUninvokable
    private native void setItemLabelFormat_native_cref_QString(long __this__nativeId, java.lang.String format);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#itemLabelVisible-prop">QtDataVisualization::QAbstract3DSeries::setItemLabelVisible(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="itemLabelVisible")
    @io.qt.QtUninvokable
    public final void setItemLabelVisible(boolean visible){
        setItemLabelVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @io.qt.QtUninvokable
    private native void setItemLabelVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#mesh-prop">QtDataVisualization::QAbstract3DSeries::setMesh(QtDataVisualization::QAbstract3DSeries::Mesh)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mesh")
    @io.qt.QtUninvokable
    public final void setMesh(io.qt.datavis.QAbstract3DSeries.Mesh mesh){
        setMesh_native_QtDataVisualization_QAbstract3DSeries_Mesh(QtJambi_LibraryUtilities.internal.nativeId(this), mesh.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMesh_native_QtDataVisualization_QAbstract3DSeries_Mesh(long __this__nativeId, int mesh);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#setMeshAxisAndAngle">QtDataVisualization::QAbstract3DSeries::setMeshAxisAndAngle(QVector3D,float)</a></p>
     */
    public final void setMeshAxisAndAngle(io.qt.gui.QVector3D axis, float angle){
        setMeshAxisAndAngle_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis), angle);
    }
    
    private native void setMeshAxisAndAngle_native_cref_QVector3D_float(long __this__nativeId, long axis, float angle);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshRotation-prop">QtDataVisualization::QAbstract3DSeries::setMeshRotation(QQuaternion)</a></p>
     */
    @io.qt.QtPropertyWriter(name="meshRotation")
    @io.qt.QtUninvokable
    public final void setMeshRotation(io.qt.gui.QQuaternion rotation){
        setMeshRotation_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation));
    }
    
    @io.qt.QtUninvokable
    private native void setMeshRotation_native_cref_QQuaternion(long __this__nativeId, long rotation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#meshSmooth-prop">QtDataVisualization::QAbstract3DSeries::setMeshSmooth(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="meshSmooth")
    @io.qt.QtUninvokable
    public final void setMeshSmooth(boolean enable){
        setMeshSmooth_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setMeshSmooth_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::setMultiHighlightColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="multiHighlightColor")
    @io.qt.QtUninvokable
    public final void setMultiHighlightColor(io.qt.gui.QColor color){
        setMultiHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setMultiHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#multiHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::setMultiHighlightGradient(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyWriter(name="multiHighlightGradient")
    @io.qt.QtUninvokable
    public final void setMultiHighlightGradient(io.qt.gui.QLinearGradient gradient){
        setMultiHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @io.qt.QtUninvokable
    private native void setMultiHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#name-prop">QtDataVisualization::QAbstract3DSeries::setName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="name")
    @io.qt.QtUninvokable
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::setSingleHighlightColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="singleHighlightColor")
    @io.qt.QtUninvokable
    public final void setSingleHighlightColor(io.qt.gui.QColor color){
        setSingleHighlightColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setSingleHighlightColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::setSingleHighlightGradient(QLinearGradient)</a></p>
     */
    @io.qt.QtPropertyWriter(name="singleHighlightGradient")
    @io.qt.QtUninvokable
    public final void setSingleHighlightGradient(io.qt.gui.QLinearGradient gradient){
        setSingleHighlightGradient_native_cref_QLinearGradient(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(gradient));
    }
    
    @io.qt.QtUninvokable
    private native void setSingleHighlightGradient_native_cref_QLinearGradient(long __this__nativeId, long gradient);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#userDefinedMesh-prop">QtDataVisualization::QAbstract3DSeries::setUserDefinedMesh(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="userDefinedMesh")
    @io.qt.QtUninvokable
    public final void setUserDefinedMesh(java.lang.String fileName){
        setUserDefinedMesh_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native void setUserDefinedMesh_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#visible-prop">QtDataVisualization::QAbstract3DSeries::setVisible(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="visible")
    @io.qt.QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @io.qt.QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightColor-prop">QtDataVisualization::QAbstract3DSeries::singleHighlightColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="singleHighlightColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor singleHighlightColor(){
        return singleHighlightColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor singleHighlightColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#singleHighlightGradient-prop">QtDataVisualization::QAbstract3DSeries::singleHighlightGradient()const</a></p>
     */
    @io.qt.QtPropertyReader(name="singleHighlightGradient")
    @io.qt.QtUninvokable
    public final io.qt.gui.QLinearGradient singleHighlightGradient(){
        return singleHighlightGradient_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QLinearGradient singleHighlightGradient_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#type-prop">QtDataVisualization::QAbstract3DSeries::type()const</a></p>
     */
    @io.qt.QtPropertyReader(name="type")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DSeries.SeriesType type(){
        return io.qt.datavis.QAbstract3DSeries.SeriesType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3dseries.html#userDefinedMesh-prop">QtDataVisualization::QAbstract3DSeries::userDefinedMesh()const</a></p>
     */
    @io.qt.QtPropertyReader(name="userDefinedMesh")
    @io.qt.QtUninvokable
    public final java.lang.String userDefinedMesh(){
        return userDefinedMesh_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String userDefinedMesh_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstract3DSeries(QPrivateConstructor p) { super(p); } 
    
}
