package io.qt.datavis;


/**
 * <p>Simple base class for all the objects in a 3D scene</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/q3dobject.html">QtDataVisualization::Q3DObject</a></p>
 */
public class Q3DObject extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DObject.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#position-prop">QtDataVisualization::Q3DObject::positionChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="position")
    public final Signal1<io.qt.gui.QVector3D> positionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DObject(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DObject() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#Q3DObject">QtDataVisualization::Q3DObject::Q3DObject(QObject*)</a></p>
     */
    public Q3DObject(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(Q3DObject instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#isDirty">QtDataVisualization::Q3DObject::isDirty()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean isDirty(){
        return isDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDirty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#parentScene-prop">QtDataVisualization::Q3DObject::parentScene()</a></p>
     */
    @io.qt.QtPropertyReader(name="parentScene")
    @io.qt.QtUninvokable
    public final io.qt.datavis.Q3DScene parentScene(){
        return parentScene_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.Q3DScene parentScene_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#position-prop">QtDataVisualization::Q3DObject::position()const</a></p>
     */
    @io.qt.QtPropertyReader(name="position")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#setDirty">QtDataVisualization::Q3DObject::setDirty(bool)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setDirty(boolean dirty){
        setDirty_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), dirty);
    }
    
    @io.qt.QtUninvokable
    private native void setDirty_native_bool(long __this__nativeId, boolean dirty);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#position-prop">QtDataVisualization::Q3DObject::setPosition(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="position")
    @io.qt.QtUninvokable
    public final void setPosition(io.qt.gui.QVector3D position){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @io.qt.QtUninvokable
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dobject.html#copyValuesFrom">QtDataVisualization::Q3DObject::copyValuesFrom(QtDataVisualization::Q3DObject)</a></p>
     */
    @io.qt.QtUninvokable
    public void copyValuesFrom(io.qt.datavis.Q3DObject source){
        copyValuesFrom_native_cref_QtDataVisualization_Q3DObject(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @io.qt.QtUninvokable
    private native void copyValuesFrom_native_cref_QtDataVisualization_Q3DObject(long __this__nativeId, long source);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DObject(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DObject(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DObject instance, QDeclarativeConstructor constructor);
    
}
