package io.qt.datavis;


/**
 * <p>The data proxy for a 3D surface graph</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html">QtDataVisualization::QSurfaceDataProxy</a></p>
 */
public class QSurfaceDataProxy extends io.qt.datavis.QAbstractDataProxy
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSurfaceDataProxy.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#arrayReset">QtDataVisualization::QSurfaceDataProxy::arrayReset()</a></p>
     */
    public final Signal0 arrayReset = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#columnCount-prop">QtDataVisualization::QSurfaceDataProxy::columnCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnCount")
    public final Signal1<@io.qt.QtPrimitiveType Integer> columnCountChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#itemChanged">QtDataVisualization::QSurfaceDataProxy::itemChanged(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> itemChanged = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#rowCount-prop">QtDataVisualization::QSurfaceDataProxy::rowCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowCount")
    public final Signal1<@io.qt.QtPrimitiveType Integer> rowCountChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#rowsAdded">QtDataVisualization::QSurfaceDataProxy::rowsAdded(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsAdded = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#rowsChanged">QtDataVisualization::QSurfaceDataProxy::rowsChanged(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsChanged = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#rowsInserted">QtDataVisualization::QSurfaceDataProxy::rowsInserted(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsInserted = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#rowsRemoved">QtDataVisualization::QSurfaceDataProxy::rowsRemoved(int,int)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Integer, @io.qt.QtPrimitiveType Integer> rowsRemoved = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#series-prop">QtDataVisualization::QSurfaceDataProxy::seriesChanged(QtDataVisualization::QSurface3DSeries*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="series")
    public final Signal1<io.qt.datavis.QSurface3DSeries> seriesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSurfaceDataProxy(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSurfaceDataProxy() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#QSurfaceDataProxy">QtDataVisualization::QSurfaceDataProxy::QSurfaceDataProxy(QObject*)</a></p>
     */
    public QSurfaceDataProxy(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSurfaceDataProxy instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#addRow">QtDataVisualization::QSurfaceDataProxy::addRow(QtDataVisualization::QSurfaceDataRow*)</a></p>
     */
    @io.qt.QtUninvokable
    public final int addRow(io.qt.datavis.QSurfaceDataRow row){
        return addRow_native_QtDataVisualization_QSurfaceDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @io.qt.QtUninvokable
    private native int addRow_native_QtDataVisualization_QSurfaceDataRow_ptr(long __this__nativeId, long row);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#addRows">QtDataVisualization::QSurfaceDataProxy::addRows(QtDataVisualization::QSurfaceDataArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final int addRows(io.qt.datavis.QSurfaceDataArray rows){
        return addRows_native_cref_QtDataVisualization_QSurfaceDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @io.qt.QtUninvokable
    private native int addRows_native_cref_QtDataVisualization_QSurfaceDataArray(long __this__nativeId, long rows);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#array">QtDataVisualization::QSurfaceDataProxy::array()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QSurfaceDataArray array(){
        return array_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QSurfaceDataArray array_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#columnCount-prop">QtDataVisualization::QSurfaceDataProxy::columnCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnCount")
    @io.qt.QtUninvokable
    public final int columnCount(){
        return columnCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int columnCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#insertRow">QtDataVisualization::QSurfaceDataProxy::insertRow(int,QtDataVisualization::QSurfaceDataRow*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertRow(int rowIndex, io.qt.datavis.QSurfaceDataRow row){
        insertRow_native_int_QtDataVisualization_QSurfaceDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @io.qt.QtUninvokable
    private native void insertRow_native_int_QtDataVisualization_QSurfaceDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#insertRows">QtDataVisualization::QSurfaceDataProxy::insertRows(int,QtDataVisualization::QSurfaceDataArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertRows(int rowIndex, io.qt.datavis.QSurfaceDataArray rows){
        insertRows_native_int_cref_QtDataVisualization_QSurfaceDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @io.qt.QtUninvokable
    private native void insertRows_native_int_cref_QtDataVisualization_QSurfaceDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#itemAt-1">QtDataVisualization::QSurfaceDataProxy::itemAt(QPoint)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QSurfaceDataItem itemAt(io.qt.core.QPoint position){
        return itemAt_native_cref_QPoint_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QSurfaceDataItem itemAt_native_cref_QPoint_constfct(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#itemAt">QtDataVisualization::QSurfaceDataProxy::itemAt(int,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.datavis.QSurfaceDataItem itemAt(int rowIndex, int columnIndex){
        return itemAt_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QSurfaceDataItem itemAt_native_int_int_constfct(long __this__nativeId, int rowIndex, int columnIndex);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#removeRows">QtDataVisualization::QSurfaceDataProxy::removeRows(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeRows(int rowIndex, int removeCount){
        removeRows_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, removeCount);
    }
    
    @io.qt.QtUninvokable
    private native void removeRows_native_int_int(long __this__nativeId, int rowIndex, int removeCount);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#resetArray">QtDataVisualization::QSurfaceDataProxy::resetArray(QtDataVisualization::QSurfaceDataArray*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void resetArray(io.qt.datavis.QSurfaceDataArray newArray){
        QtJambi_LibraryUtilities.internal.invalidateObject(__rcArray);
        resetArray_native_QtDataVisualization_QSurfaceDataArray_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), newArray);
        QtJambi_LibraryUtilities.internal.setCppOwnership(newArray);
        __rcArray = newArray;
                    QtJambi_LibraryUtilities.internal.registerDependentObject(__rcArray, this);
    }
    
    @io.qt.QtUninvokable
    private native void resetArray_native_QtDataVisualization_QSurfaceDataArray_ptr(long __this__nativeId, io.qt.datavis.QSurfaceDataArray newArray);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#rowCount-prop">QtDataVisualization::QSurfaceDataProxy::rowCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowCount")
    @io.qt.QtUninvokable
    public final int rowCount(){
        return rowCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int rowCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#series-prop">QtDataVisualization::QSurfaceDataProxy::series()const</a></p>
     */
    @io.qt.QtPropertyReader(name="series")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QSurface3DSeries series(){
        return series_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QSurface3DSeries series_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void setItem(io.qt.core.QPoint position, io.qt.datavis.QSurfaceDataItem item){
        setItem_native_cref_QPoint_cref_QtDataVisualization_QSurfaceDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native void setItem_native_cref_QPoint_cref_QtDataVisualization_QSurfaceDataItem(long __this__nativeId, long position, long item);
    
    @io.qt.QtUninvokable
    public final void setItem(int rowIndex, int columnIndex, io.qt.datavis.QSurfaceDataItem item){
        setItem_native_int_int_cref_QtDataVisualization_QSurfaceDataItem(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, columnIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native void setItem_native_int_int_cref_QtDataVisualization_QSurfaceDataItem(long __this__nativeId, int rowIndex, int columnIndex, long item);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#setRow">QtDataVisualization::QSurfaceDataProxy::setRow(int,QtDataVisualization::QSurfaceDataRow*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRow(int rowIndex, io.qt.datavis.QSurfaceDataRow row){
        setRow_native_int_QtDataVisualization_QSurfaceDataRow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(row));
    }
    
    @io.qt.QtUninvokable
    private native void setRow_native_int_QtDataVisualization_QSurfaceDataRow_ptr(long __this__nativeId, int rowIndex, long row);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsurfacedataproxy.html#setRows">QtDataVisualization::QSurfaceDataProxy::setRows(int,QtDataVisualization::QSurfaceDataArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRows(int rowIndex, io.qt.datavis.QSurfaceDataArray rows){
        setRows_native_int_cref_QtDataVisualization_QSurfaceDataArray(QtJambi_LibraryUtilities.internal.nativeId(this), rowIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(rows));
    }
    
    @io.qt.QtUninvokable
    private native void setRows_native_int_cref_QtDataVisualization_QSurfaceDataArray(long __this__nativeId, int rowIndex, long rows);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSurfaceDataProxy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSurfaceDataProxy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSurfaceDataProxy instance, QDeclarativeConstructor constructor);
    
    private QSurfaceDataArray __rcArray;
}
