package io.qt.datavis;


/**
 * <p>Represents a data series in a 3D scatter graph</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscatter3dseries.html">QtDataVisualization::QScatter3DSeries</a></p>
 */
public class QScatter3DSeries extends io.qt.datavis.QAbstract3DSeries
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScatter3DSeries.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#dataProxy-prop">QtDataVisualization::QScatter3DSeries::dataProxyChanged(QtDataVisualization::QScatterDataProxy*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="dataProxy")
    public final Signal1<io.qt.datavis.QScatterDataProxy> dataProxyChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#itemSize-prop">QtDataVisualization::QScatter3DSeries::itemSizeChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="itemSize")
    public final Signal1<@io.qt.QtPrimitiveType Float> itemSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#selectedItem-prop">QtDataVisualization::QScatter3DSeries::selectedItemChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedItem")
    public final Signal1<@io.qt.QtPrimitiveType Integer> selectedItemChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QScatter3DSeries(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScatter3DSeries() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#QScatter3DSeries">QtDataVisualization::QScatter3DSeries::QScatter3DSeries(QObject*)</a></p>
     */
    public QScatter3DSeries(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScatter3DSeries instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QScatter3DSeries(io.qt.datavis.QScatterDataProxy, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScatter3DSeries(io.qt.datavis.QScatterDataProxy dataProxy) {
        this(dataProxy, (io.qt.core.QObject)null);
    }
    
    public QScatter3DSeries(io.qt.datavis.QScatterDataProxy dataProxy, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, dataProxy, parent);
    }
    
    private native static void initialize_native(QScatter3DSeries instance, io.qt.datavis.QScatterDataProxy dataProxy, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#dataProxy-prop">QtDataVisualization::QScatter3DSeries::dataProxy()const</a></p>
     */
    @io.qt.QtPropertyReader(name="dataProxy")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QScatterDataProxy dataProxy(){
        return dataProxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QScatterDataProxy dataProxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#itemSize-prop">QtDataVisualization::QScatter3DSeries::itemSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="itemSize")
    @io.qt.QtUninvokable
    public final float itemSize(){
        return itemSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float itemSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#selectedItem-prop">QtDataVisualization::QScatter3DSeries::selectedItem()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedItem")
    @io.qt.QtUninvokable
    public final int selectedItem(){
        return selectedItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int selectedItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#setDataProxy">QtDataVisualization::QScatter3DSeries::setDataProxy(QtDataVisualization::QScatterDataProxy*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="dataProxy")
    @io.qt.QtUninvokable
    public final void setDataProxy(io.qt.datavis.QScatterDataProxy proxy){
        if(proxy!=null){
                        if(proxy==dataProxy()){
                            throw new IllegalArgumentException("Proxy is already assigned to this series.");
                        }else if(proxy.series()!=null){
                            throw new IllegalArgumentException("Proxy is already assigned to another series.");
                        }
                    }
        java.util.Objects.requireNonNull(proxy, "Argument 'proxy': null not expected.");
        setDataProxy_native_QtDataVisualization_QScatterDataProxy_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(proxy));
    }
    
    @io.qt.QtUninvokable
    private native void setDataProxy_native_QtDataVisualization_QScatterDataProxy_ptr(long __this__nativeId, long proxy);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#itemSize-prop">QtDataVisualization::QScatter3DSeries::setItemSize(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="itemSize")
    @io.qt.QtUninvokable
    public final void setItemSize(float size){
        setItemSize_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @io.qt.QtUninvokable
    private native void setItemSize_native_float(long __this__nativeId, float size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#setSelectedItem">QtDataVisualization::QScatter3DSeries::setSelectedItem(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="selectedItem")
    @io.qt.QtUninvokable
    public final void setSelectedItem(int index){
        setSelectedItem_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void setSelectedItem_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscatter3dseries.html#invalidSelectionIndex">QtDataVisualization::QScatter3DSeries::invalidSelectionIndex()</a></p>
     */
    public native static int invalidSelectionIndex();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScatter3DSeries(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QScatter3DSeries(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QScatter3DSeries instance, QDeclarativeConstructor constructor);
    
}
