package io.qt.datavis;


/**
 * <p>Represents a data series in a 3D bar graph</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qbar3dseries.html">QtDataVisualization::QBar3DSeries</a></p>
 */
public class QBar3DSeries extends io.qt.datavis.QAbstract3DSeries
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBar3DSeries.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#dataProxy-prop">QtDataVisualization::QBar3DSeries::dataProxyChanged(QtDataVisualization::QBarDataProxy*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="dataProxy")
    public final Signal1<io.qt.datavis.QBarDataProxy> dataProxyChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#meshAngle-prop">QtDataVisualization::QBar3DSeries::meshAngleChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="meshAngle")
    public final Signal1<@io.qt.QtPrimitiveType Float> meshAngleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#selectedBar-prop">QtDataVisualization::QBar3DSeries::selectedBarChanged(QPoint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedBar")
    public final Signal1<io.qt.core.QPoint> selectedBarChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBar3DSeries(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBar3DSeries() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#QBar3DSeries">QtDataVisualization::QBar3DSeries::QBar3DSeries(QObject*)</a></p>
     */
    public QBar3DSeries(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBar3DSeries instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QBar3DSeries(io.qt.datavis.QBarDataProxy, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QBar3DSeries(io.qt.datavis.QBarDataProxy dataProxy) {
        this(dataProxy, (io.qt.core.QObject)null);
    }
    
    public QBar3DSeries(io.qt.datavis.QBarDataProxy dataProxy, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, dataProxy, parent);
    }
    
    private native static void initialize_native(QBar3DSeries instance, io.qt.datavis.QBarDataProxy dataProxy, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#dataProxy-prop">QtDataVisualization::QBar3DSeries::dataProxy()const</a></p>
     */
    @io.qt.QtPropertyReader(name="dataProxy")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBarDataProxy dataProxy(){
        return dataProxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBarDataProxy dataProxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#meshAngle-prop">QtDataVisualization::QBar3DSeries::meshAngle()const</a></p>
     */
    @io.qt.QtPropertyReader(name="meshAngle")
    @io.qt.QtUninvokable
    public final float meshAngle(){
        return meshAngle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float meshAngle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#selectedBar-prop">QtDataVisualization::QBar3DSeries::selectedBar()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedBar")
    @io.qt.QtUninvokable
    public final io.qt.core.QPoint selectedBar(){
        return selectedBar_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPoint selectedBar_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#dataProxy-prop">QtDataVisualization::QBar3DSeries::setDataProxy(QtDataVisualization::QBarDataProxy*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="dataProxy")
    @io.qt.QtUninvokable
    public final void setDataProxy(io.qt.datavis.QBarDataProxy proxy){
        if(proxy!=null){
                        if(proxy==dataProxy()){
                            throw new IllegalArgumentException("Proxy is already assigned to this series.");
                        }else if(proxy.series()!=null){
                            throw new IllegalArgumentException("Proxy is already assigned to another series.");
                        }
                    }
        java.util.Objects.requireNonNull(proxy, "Argument 'proxy': null not expected.");
        setDataProxy_native_QtDataVisualization_QBarDataProxy_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(proxy));
    }
    
    @io.qt.QtUninvokable
    private native void setDataProxy_native_QtDataVisualization_QBarDataProxy_ptr(long __this__nativeId, long proxy);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#meshAngle-prop">QtDataVisualization::QBar3DSeries::setMeshAngle(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="meshAngle")
    @io.qt.QtUninvokable
    public final void setMeshAngle(float angle){
        setMeshAngle_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    @io.qt.QtUninvokable
    private native void setMeshAngle_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#setSelectedBar">QtDataVisualization::QBar3DSeries::setSelectedBar(QPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="selectedBar")
    @io.qt.QtUninvokable
    public final void setSelectedBar(io.qt.core.QPoint position){
        setSelectedBar_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    @io.qt.QtUninvokable
    private native void setSelectedBar_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qbar3dseries.html#invalidSelectionPosition">QtDataVisualization::QBar3DSeries::invalidSelectionPosition()</a></p>
     */
    public native static io.qt.core.QPoint invalidSelectionPosition();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBar3DSeries(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QBar3DSeries(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QBar3DSeries instance, QDeclarativeConstructor constructor);
    
}
