package io.qt.datavis;


/**
 * <p>Base class for the axes of a graph</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qabstract3daxis.html">QtDataVisualization::QAbstract3DAxis</a></p>
 */
public class QAbstract3DAxis extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstract3DAxis.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#AxisOrientation-enum">QtDataVisualization::QAbstract3DAxis::AxisOrientation</a></p>
     */
    public enum AxisOrientation implements io.qt.QtEnumerator {
        AxisOrientationNone(0),
        AxisOrientationX(1),
        AxisOrientationY(2),
        AxisOrientationZ(4);

        private AxisOrientation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AxisOrientation resolve(int value) {
            switch (value) {
            case 0: return AxisOrientationNone;
            case 1: return AxisOrientationX;
            case 2: return AxisOrientationY;
            case 4: return AxisOrientationZ;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#AxisType-enum">QtDataVisualization::QAbstract3DAxis::AxisType</a></p>
     */
    public enum AxisType implements io.qt.QtEnumerator {
        AxisTypeNone(0),
        AxisTypeCategory(1),
        AxisTypeValue(2);

        private AxisType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AxisType resolve(int value) {
            switch (value) {
            case 0: return AxisTypeNone;
            case 1: return AxisTypeCategory;
            case 2: return AxisTypeValue;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#autoAdjustRange-prop">QtDataVisualization::QAbstract3DAxis::autoAdjustRangeChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="autoAdjustRange")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> autoAdjustRangeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#labelAutoRotation-prop">QtDataVisualization::QAbstract3DAxis::labelAutoRotationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="labelAutoRotation")
    public final Signal1<@io.qt.QtPrimitiveType Float> labelAutoRotationChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#labels-prop">QtDataVisualization::QAbstract3DAxis::labelsChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="labels")
    public final Signal0 labelsChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#max-prop">QtDataVisualization::QAbstract3DAxis::maxChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="max")
    public final Signal1<@io.qt.QtPrimitiveType Float> maxChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#min-prop">QtDataVisualization::QAbstract3DAxis::minChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="min")
    public final Signal1<@io.qt.QtPrimitiveType Float> minChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#orientation-prop">QtDataVisualization::QAbstract3DAxis::orientationChanged(QtDataVisualization::QAbstract3DAxis::AxisOrientation)</a></p>
     */
    @io.qt.QtPropertyNotify(name="orientation")
    public final Signal1<io.qt.datavis.QAbstract3DAxis.AxisOrientation> orientationChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#rangeChanged">QtDataVisualization::QAbstract3DAxis::rangeChanged(float,float)</a></p>
     */
    public final Signal2<@io.qt.QtPrimitiveType Float, @io.qt.QtPrimitiveType Float> rangeChanged = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#title-prop">QtDataVisualization::QAbstract3DAxis::titleChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="title")
    public final Signal1<java.lang.String> titleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#titleFixed-prop">QtDataVisualization::QAbstract3DAxis::titleFixedChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="titleFixed")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> titleFixedChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#titleVisible-prop">QtDataVisualization::QAbstract3DAxis::titleVisibilityChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="titleVisible")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> titleVisibilityChanged = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#autoAdjustRange-prop">QtDataVisualization::QAbstract3DAxis::isAutoAdjustRange()const</a></p>
     */
    @io.qt.QtPropertyReader(name="autoAdjustRange")
    @io.qt.QtUninvokable
    public final boolean isAutoAdjustRange(){
        return isAutoAdjustRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAutoAdjustRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#titleFixed-prop">QtDataVisualization::QAbstract3DAxis::isTitleFixed()const</a></p>
     */
    @io.qt.QtPropertyReader(name="titleFixed")
    @io.qt.QtUninvokable
    public final boolean isTitleFixed(){
        return isTitleFixed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isTitleFixed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#titleVisible-prop">QtDataVisualization::QAbstract3DAxis::isTitleVisible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="titleVisible")
    @io.qt.QtUninvokable
    public final boolean isTitleVisible(){
        return isTitleVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isTitleVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#labelAutoRotation-prop">QtDataVisualization::QAbstract3DAxis::labelAutoRotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="labelAutoRotation")
    @io.qt.QtUninvokable
    public final float labelAutoRotation(){
        return labelAutoRotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float labelAutoRotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#labels-prop">QtDataVisualization::QAbstract3DAxis::labels()const</a></p>
     */
    @io.qt.QtPropertyReader(name="labels")
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public io.qt.core.QStringList labels(){
        return labels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList labels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#max-prop">QtDataVisualization::QAbstract3DAxis::max()const</a></p>
     */
    @io.qt.QtPropertyReader(name="max")
    @io.qt.QtUninvokable
    public final float max(){
        return max_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float max_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#min-prop">QtDataVisualization::QAbstract3DAxis::min()const</a></p>
     */
    @io.qt.QtPropertyReader(name="min")
    @io.qt.QtUninvokable
    public final float min(){
        return min_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float min_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#orientation-prop">QtDataVisualization::QAbstract3DAxis::orientation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="orientation")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DAxis.AxisOrientation orientation(){
        return io.qt.datavis.QAbstract3DAxis.AxisOrientation.resolve(orientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int orientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#autoAdjustRange-prop">QtDataVisualization::QAbstract3DAxis::setAutoAdjustRange(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="autoAdjustRange")
    @io.qt.QtUninvokable
    public final void setAutoAdjustRange(boolean autoAdjust){
        setAutoAdjustRange_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoAdjust);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoAdjustRange_native_bool(long __this__nativeId, boolean autoAdjust);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#labelAutoRotation-prop">QtDataVisualization::QAbstract3DAxis::setLabelAutoRotation(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="labelAutoRotation")
    @io.qt.QtUninvokable
    public final void setLabelAutoRotation(float angle){
        setLabelAutoRotation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    @io.qt.QtUninvokable
    private native void setLabelAutoRotation_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#labels-prop">QtDataVisualization::QAbstract3DAxis::setLabels(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="labels")
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public void setLabels(java.util.Collection<java.lang.String> labels){
        setLabels_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), labels);
    }
    
    @io.qt.QtUninvokable
    private native void setLabels_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> labels);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#max-prop">QtDataVisualization::QAbstract3DAxis::setMax(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="max")
    @io.qt.QtUninvokable
    public final void setMax(float max){
        setMax_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), max);
    }
    
    @io.qt.QtUninvokable
    private native void setMax_native_float(long __this__nativeId, float max);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#min-prop">QtDataVisualization::QAbstract3DAxis::setMin(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="min")
    @io.qt.QtUninvokable
    public final void setMin(float min){
        setMin_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), min);
    }
    
    @io.qt.QtUninvokable
    private native void setMin_native_float(long __this__nativeId, float min);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#setRange">QtDataVisualization::QAbstract3DAxis::setRange(float,float)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRange(float min, float max){
        setRange_native_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), min, max);
    }
    
    @io.qt.QtUninvokable
    private native void setRange_native_float_float(long __this__nativeId, float min, float max);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#title-prop">QtDataVisualization::QAbstract3DAxis::setTitle(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="title")
    @io.qt.QtUninvokable
    public final void setTitle(java.lang.String title){
        setTitle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), title);
    }
    
    @io.qt.QtUninvokable
    private native void setTitle_native_cref_QString(long __this__nativeId, java.lang.String title);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#titleFixed-prop">QtDataVisualization::QAbstract3DAxis::setTitleFixed(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="titleFixed")
    @io.qt.QtUninvokable
    public final void setTitleFixed(boolean fixed){
        setTitleFixed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), fixed);
    }
    
    @io.qt.QtUninvokable
    private native void setTitleFixed_native_bool(long __this__nativeId, boolean fixed);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#titleVisible-prop">QtDataVisualization::QAbstract3DAxis::setTitleVisible(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="titleVisible")
    @io.qt.QtUninvokable
    public final void setTitleVisible(boolean visible){
        setTitleVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @io.qt.QtUninvokable
    private native void setTitleVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#title-prop">QtDataVisualization::QAbstract3DAxis::title()const</a></p>
     */
    @io.qt.QtPropertyReader(name="title")
    @io.qt.QtUninvokable
    public final java.lang.String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstract3daxis.html#type-prop">QtDataVisualization::QAbstract3DAxis::type()const</a></p>
     */
    @io.qt.QtPropertyReader(name="type")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.datavis.QAbstract3DAxis.AxisType type(){
        return io.qt.datavis.QAbstract3DAxis.AxisType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstract3DAxis(QPrivateConstructor p) { super(p); } 
    
}
