package io.qt.datavis;


/**
 * <p>Methods for rendering 3D surface plots</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/q3dsurface.html">QtDataVisualization::Q3DSurface</a></p>
 */
public class Q3DSurface extends io.qt.datavis.QAbstract3DGraph
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DSurface.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#axisX-prop">QtDataVisualization::Q3DSurface::axisXChanged(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisX")
    public final Signal1<io.qt.datavis.QValue3DAxis> axisXChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#axisY-prop">QtDataVisualization::Q3DSurface::axisYChanged(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisY")
    public final Signal1<io.qt.datavis.QValue3DAxis> axisYChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#axisZ-prop">QtDataVisualization::Q3DSurface::axisZChanged(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="axisZ")
    public final Signal1<io.qt.datavis.QValue3DAxis> axisZChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#flipHorizontalGrid-prop">QtDataVisualization::Q3DSurface::flipHorizontalGridChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="flipHorizontalGrid")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> flipHorizontalGridChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#selectedSeries-prop">QtDataVisualization::Q3DSurface::selectedSeriesChanged(QtDataVisualization::QSurface3DSeries*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedSeries")
    public final Signal1<io.qt.datavis.QSurface3DSeries> selectedSeriesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DSurface(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DSurface(io.qt.gui.QSurfaceFormat format) {
        this(format, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #Q3DSurface(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>format = null</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public Q3DSurface() {
        this((io.qt.gui.QSurfaceFormat)null, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#Q3DSurface">QtDataVisualization::Q3DSurface::Q3DSurface(const QSurfaceFormat*,QWindow*)</a></p>
     */
    public Q3DSurface(io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, format, parent);
    }
    
    private native static void initialize_native(Q3DSurface instance, io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#addAxis">QtDataVisualization::Q3DSurface::addAxis(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addAxis(io.qt.datavis.QValue3DAxis axis){
        addAxis_native_QtDataVisualization_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void addAxis_native_QtDataVisualization_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#addSeries">QtDataVisualization::Q3DSurface::addSeries(QtDataVisualization::QSurface3DSeries*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addSeries(io.qt.datavis.QSurface3DSeries series){
        addSeries_native_QtDataVisualization_QSurface3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void addSeries_native_QtDataVisualization_QSurface3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#axes">QtDataVisualization::Q3DSurface::axes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QValue3DAxis> axes(){
        return axes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QValue3DAxis> axes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#axisX-prop">QtDataVisualization::Q3DSurface::axisX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisX")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QValue3DAxis axisX(){
        return axisX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#axisY-prop">QtDataVisualization::Q3DSurface::axisY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisY")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QValue3DAxis axisY(){
        return axisY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#axisZ-prop">QtDataVisualization::Q3DSurface::axisZ()const</a></p>
     */
    @io.qt.QtPropertyReader(name="axisZ")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QValue3DAxis axisZ(){
        return axisZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QValue3DAxis axisZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#flipHorizontalGrid-prop">QtDataVisualization::Q3DSurface::flipHorizontalGrid()const</a></p>
     */
    @io.qt.QtPropertyReader(name="flipHorizontalGrid")
    @io.qt.QtUninvokable
    public final boolean flipHorizontalGrid(){
        return flipHorizontalGrid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean flipHorizontalGrid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#releaseAxis">QtDataVisualization::Q3DSurface::releaseAxis(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void releaseAxis(io.qt.datavis.QValue3DAxis axis){
        releaseAxis_native_QtDataVisualization_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void releaseAxis_native_QtDataVisualization_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#removeSeries">QtDataVisualization::Q3DSurface::removeSeries(QtDataVisualization::QSurface3DSeries*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeSeries(io.qt.datavis.QSurface3DSeries series){
        removeSeries_native_QtDataVisualization_QSurface3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void removeSeries_native_QtDataVisualization_QSurface3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#selectedSeries-prop">QtDataVisualization::Q3DSurface::selectedSeries()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedSeries")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QSurface3DSeries selectedSeries(){
        return selectedSeries_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QSurface3DSeries selectedSeries_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#seriesList">QtDataVisualization::Q3DSurface::seriesList()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QSurface3DSeries> seriesList(){
        return seriesList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QSurface3DSeries> seriesList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#setAxisX">QtDataVisualization::Q3DSurface::setAxisX(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axisX")
    @io.qt.QtUninvokable
    public final void setAxisX(io.qt.datavis.QValue3DAxis axis){
        setAxisX_native_QtDataVisualization_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setAxisX_native_QtDataVisualization_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#setAxisY">QtDataVisualization::Q3DSurface::setAxisY(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axisY")
    @io.qt.QtUninvokable
    public final void setAxisY(io.qt.datavis.QValue3DAxis axis){
        setAxisY_native_QtDataVisualization_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setAxisY_native_QtDataVisualization_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#setAxisZ">QtDataVisualization::Q3DSurface::setAxisZ(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="axisZ")
    @io.qt.QtUninvokable
    public final void setAxisZ(io.qt.datavis.QValue3DAxis axis){
        setAxisZ_native_QtDataVisualization_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setAxisZ_native_QtDataVisualization_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dsurface.html#flipHorizontalGrid-prop">QtDataVisualization::Q3DSurface::setFlipHorizontalGrid(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="flipHorizontalGrid")
    @io.qt.QtUninvokable
    public final void setFlipHorizontalGrid(boolean flip){
        setFlipHorizontalGrid_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), flip);
    }
    
    @io.qt.QtUninvokable
    private native void setFlipHorizontalGrid_native_bool(long __this__nativeId, boolean flip);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DSurface(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DSurface(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DSurface instance, QDeclarativeConstructor constructor);
    
}
