package io.qt.datavis;


/**
 * <p>Methods for rendering 3D bar graphs</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/q3dbars.html">QtDataVisualization::Q3DBars</a></p>
 */
public class Q3DBars extends io.qt.datavis.QAbstract3DGraph
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(Q3DBars.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barSpacing-prop">QtDataVisualization::Q3DBars::barSpacingChanged(QSizeF)</a></p>
     */
    @io.qt.QtPropertyNotify(name="barSpacing")
    public final Signal1<io.qt.core.QSizeF> barSpacingChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barSpacingRelative-prop">QtDataVisualization::Q3DBars::barSpacingRelativeChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="barSpacingRelative")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> barSpacingRelativeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barThickness-prop">QtDataVisualization::Q3DBars::barThicknessChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="barThickness")
    public final Signal1<@io.qt.QtPrimitiveType Float> barThicknessChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#columnAxis-prop">QtDataVisualization::Q3DBars::columnAxisChanged(QtDataVisualization::QCategory3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="columnAxis")
    public final Signal1<io.qt.datavis.QCategory3DAxis> columnAxisChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#floorLevel-prop">QtDataVisualization::Q3DBars::floorLevelChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="floorLevel")
    public final Signal1<@io.qt.QtPrimitiveType Float> floorLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#multiSeriesUniform-prop">QtDataVisualization::Q3DBars::multiSeriesUniformChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="multiSeriesUniform")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> multiSeriesUniformChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#primarySeries-prop">QtDataVisualization::Q3DBars::primarySeriesChanged(QtDataVisualization::QBar3DSeries*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="primarySeries")
    public final Signal1<io.qt.datavis.QBar3DSeries> primarySeriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#rowAxis-prop">QtDataVisualization::Q3DBars::rowAxisChanged(QtDataVisualization::QCategory3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rowAxis")
    public final Signal1<io.qt.datavis.QCategory3DAxis> rowAxisChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#selectedSeries-prop">QtDataVisualization::Q3DBars::selectedSeriesChanged(QtDataVisualization::QBar3DSeries*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedSeries")
    public final Signal1<io.qt.datavis.QBar3DSeries> selectedSeriesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#valueAxis-prop">QtDataVisualization::Q3DBars::valueAxisChanged(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="valueAxis")
    public final Signal1<io.qt.datavis.QValue3DAxis> valueAxisChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #Q3DBars(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public Q3DBars(io.qt.gui.QSurfaceFormat format) {
        this(format, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #Q3DBars(io.qt.gui.QSurfaceFormat, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>format = null</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public Q3DBars() {
        this((io.qt.gui.QSurfaceFormat)null, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#Q3DBars">QtDataVisualization::Q3DBars::Q3DBars(const QSurfaceFormat*,QWindow*)</a></p>
     */
    public Q3DBars(io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, format, parent);
    }
    
    private native static void initialize_native(Q3DBars instance, io.qt.gui.QSurfaceFormat format, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#addAxis">QtDataVisualization::Q3DBars::addAxis(QtDataVisualization::QAbstract3DAxis*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addAxis(io.qt.datavis.QAbstract3DAxis axis){
        addAxis_native_QtDataVisualization_QAbstract3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void addAxis_native_QtDataVisualization_QAbstract3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#addSeries">QtDataVisualization::Q3DBars::addSeries(QtDataVisualization::QBar3DSeries*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addSeries(io.qt.datavis.QBar3DSeries series){
        addSeries_native_QtDataVisualization_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void addSeries_native_QtDataVisualization_QBar3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#axes">QtDataVisualization::Q3DBars::axes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QAbstract3DAxis> axes(){
        return axes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QAbstract3DAxis> axes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barSpacing-prop">QtDataVisualization::Q3DBars::barSpacing()const</a></p>
     */
    @io.qt.QtPropertyReader(name="barSpacing")
    @io.qt.QtUninvokable
    public final io.qt.core.QSizeF barSpacing(){
        return barSpacing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSizeF barSpacing_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barThickness-prop">QtDataVisualization::Q3DBars::barThickness()const</a></p>
     */
    @io.qt.QtPropertyReader(name="barThickness")
    @io.qt.QtUninvokable
    public final float barThickness(){
        return barThickness_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float barThickness_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#columnAxis-prop">QtDataVisualization::Q3DBars::columnAxis()const</a></p>
     */
    @io.qt.QtPropertyReader(name="columnAxis")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QCategory3DAxis columnAxis(){
        return columnAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QCategory3DAxis columnAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#floorLevel-prop">QtDataVisualization::Q3DBars::floorLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="floorLevel")
    @io.qt.QtUninvokable
    public final float floorLevel(){
        return floorLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float floorLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#insertSeries">QtDataVisualization::Q3DBars::insertSeries(int,QtDataVisualization::QBar3DSeries*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertSeries(int index, io.qt.datavis.QBar3DSeries series){
        insertSeries_native_int_QtDataVisualization_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void insertSeries_native_int_QtDataVisualization_QBar3DSeries_ptr(long __this__nativeId, int index, long series);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barSpacingRelative-prop">QtDataVisualization::Q3DBars::isBarSpacingRelative()const</a></p>
     */
    @io.qt.QtPropertyReader(name="barSpacingRelative")
    @io.qt.QtUninvokable
    public final boolean isBarSpacingRelative(){
        return isBarSpacingRelative_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isBarSpacingRelative_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#multiSeriesUniform-prop">QtDataVisualization::Q3DBars::isMultiSeriesUniform()const</a></p>
     */
    @io.qt.QtPropertyReader(name="multiSeriesUniform")
    @io.qt.QtUninvokable
    public final boolean isMultiSeriesUniform(){
        return isMultiSeriesUniform_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isMultiSeriesUniform_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#primarySeries-prop">QtDataVisualization::Q3DBars::primarySeries()const</a></p>
     */
    @io.qt.QtPropertyReader(name="primarySeries")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBar3DSeries primarySeries(){
        return primarySeries_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBar3DSeries primarySeries_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#releaseAxis">QtDataVisualization::Q3DBars::releaseAxis(QtDataVisualization::QAbstract3DAxis*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void releaseAxis(io.qt.datavis.QAbstract3DAxis axis){
        releaseAxis_native_QtDataVisualization_QAbstract3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void releaseAxis_native_QtDataVisualization_QAbstract3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#removeSeries">QtDataVisualization::Q3DBars::removeSeries(QtDataVisualization::QBar3DSeries*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeSeries(io.qt.datavis.QBar3DSeries series){
        removeSeries_native_QtDataVisualization_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void removeSeries_native_QtDataVisualization_QBar3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#rowAxis-prop">QtDataVisualization::Q3DBars::rowAxis()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rowAxis")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QCategory3DAxis rowAxis(){
        return rowAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QCategory3DAxis rowAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#selectedSeries-prop">QtDataVisualization::Q3DBars::selectedSeries()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedSeries")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QBar3DSeries selectedSeries(){
        return selectedSeries_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QBar3DSeries selectedSeries_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#seriesList">QtDataVisualization::Q3DBars::seriesList()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.datavis.QBar3DSeries> seriesList(){
        return seriesList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.datavis.QBar3DSeries> seriesList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barSpacing-prop">QtDataVisualization::Q3DBars::setBarSpacing(QSizeF)</a></p>
     */
    @io.qt.QtPropertyWriter(name="barSpacing")
    @io.qt.QtUninvokable
    public final void setBarSpacing(io.qt.core.QSizeF spacing){
        setBarSpacing_native_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(spacing));
    }
    
    @io.qt.QtUninvokable
    private native void setBarSpacing_native_cref_QSizeF(long __this__nativeId, long spacing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barSpacingRelative-prop">QtDataVisualization::Q3DBars::setBarSpacingRelative(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="barSpacingRelative")
    @io.qt.QtUninvokable
    public final void setBarSpacingRelative(boolean relative){
        setBarSpacingRelative_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), relative);
    }
    
    @io.qt.QtUninvokable
    private native void setBarSpacingRelative_native_bool(long __this__nativeId, boolean relative);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#barThickness-prop">QtDataVisualization::Q3DBars::setBarThickness(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="barThickness")
    @io.qt.QtUninvokable
    public final void setBarThickness(float thicknessRatio){
        setBarThickness_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), thicknessRatio);
    }
    
    @io.qt.QtUninvokable
    private native void setBarThickness_native_float(long __this__nativeId, float thicknessRatio);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#setColumnAxis">QtDataVisualization::Q3DBars::setColumnAxis(QtDataVisualization::QCategory3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="columnAxis")
    @io.qt.QtUninvokable
    public final void setColumnAxis(io.qt.datavis.QCategory3DAxis axis){
        setColumnAxis_native_QtDataVisualization_QCategory3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setColumnAxis_native_QtDataVisualization_QCategory3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#floorLevel-prop">QtDataVisualization::Q3DBars::setFloorLevel(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="floorLevel")
    @io.qt.QtUninvokable
    public final void setFloorLevel(float level){
        setFloorLevel_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), level);
    }
    
    @io.qt.QtUninvokable
    private native void setFloorLevel_native_float(long __this__nativeId, float level);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#multiSeriesUniform-prop">QtDataVisualization::Q3DBars::setMultiSeriesUniform(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="multiSeriesUniform")
    @io.qt.QtUninvokable
    public final void setMultiSeriesUniform(boolean uniform){
        setMultiSeriesUniform_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), uniform);
    }
    
    @io.qt.QtUninvokable
    private native void setMultiSeriesUniform_native_bool(long __this__nativeId, boolean uniform);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#setPrimarySeries">QtDataVisualization::Q3DBars::setPrimarySeries(QtDataVisualization::QBar3DSeries*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="primarySeries")
    @io.qt.QtUninvokable
    public final void setPrimarySeries(io.qt.datavis.QBar3DSeries series){
        setPrimarySeries_native_QtDataVisualization_QBar3DSeries_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(series));
    }
    
    @io.qt.QtUninvokable
    private native void setPrimarySeries_native_QtDataVisualization_QBar3DSeries_ptr(long __this__nativeId, long series);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#setRowAxis">QtDataVisualization::Q3DBars::setRowAxis(QtDataVisualization::QCategory3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rowAxis")
    @io.qt.QtUninvokable
    public final void setRowAxis(io.qt.datavis.QCategory3DAxis axis){
        setRowAxis_native_QtDataVisualization_QCategory3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setRowAxis_native_QtDataVisualization_QCategory3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#valueAxis-prop">QtDataVisualization::Q3DBars::setValueAxis(QtDataVisualization::QValue3DAxis*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="valueAxis")
    @io.qt.QtUninvokable
    public final void setValueAxis(io.qt.datavis.QValue3DAxis axis){
        setValueAxis_native_QtDataVisualization_QValue3DAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    @io.qt.QtUninvokable
    private native void setValueAxis_native_QtDataVisualization_QValue3DAxis_ptr(long __this__nativeId, long axis);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/q3dbars.html#valueAxis-prop">QtDataVisualization::Q3DBars::valueAxis()const</a></p>
     */
    @io.qt.QtPropertyReader(name="valueAxis")
    @io.qt.QtUninvokable
    public final io.qt.datavis.QValue3DAxis valueAxis(){
        return valueAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.datavis.QValue3DAxis valueAxis_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected Q3DBars(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected Q3DBars(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(Q3DBars instance, QDeclarativeConstructor constructor);
    
}
