#include <QtCore/QtGlobal>
#include <QtDataVisualization/qbardataproxy.h>
#include <QtCore/QVariant>
#include "hashes.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QBarDataArray(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QBarDataArray")
    QBarDataArray *_ptr = reinterpret_cast<QBarDataArray *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QBarDataArray()
void __qt_construct_QBarDataArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBarDataArray()")
    Q_UNUSED(__java_arguments)
    QList<QBarDataRow*> *__qt_this = new(__qtjambi_ptr) QList<QBarDataRow*>();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QList<QBarDataRow*>::QBarDataArray()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_datavis_QBarDataArray_initialize_1native__Lio_qt_datavis_QBarDataArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QList<QBarDataRow*>::QBarDataArray()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBarDataArray, sizeof(QBarDataArray), typeid(QBarDataArray), false, QtJambiPrivate::QListAccess<QBarDataRow*>::newInstance(), &deleter_QBarDataArray, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBarDataArray(QBarDataArray)
void __qt_construct_QBarDataArray_cref_QBarDataArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBarDataArray(QBarDataArray)")
    jobject other0 = __java_arguments[0].l;
    const QBarDataArray& __qt_other0 = qtjambi_cast<const QBarDataArray& >(__jni_env, other0);
    QList<QBarDataRow*> *__qt_this = new(__qtjambi_ptr) QList<QBarDataRow*>(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QList<QBarDataRow*>::QBarDataArray(QBarDataArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_datavis_QBarDataArray_initialize_1native__Lio_qt_datavis_QBarDataArray_2Lio_qt_datavis_QBarDataArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QList<QBarDataRow*>::QBarDataArray(QBarDataArray)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBarDataArray_cref_QBarDataArray, sizeof(QBarDataArray), typeid(QBarDataArray), false, QtJambiPrivate::QListAccess<QBarDataRow*>::newInstance(), &deleter_QBarDataArray, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QList<QBarDataRow*>
void __qt_destruct_QBarDataArray(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QList<QBarDataRow*>")
    reinterpret_cast<QList<QBarDataRow*>*>(ptr)->~QList();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_datavis_QBarDataArray_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QBarDataArray *__qt_this = QtJambiAPI::objectFromNativeId<QBarDataArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_datavis_QBarDataArray_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QBarDataArray *__qt_this = QtJambiAPI::objectFromNativeId<QBarDataArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QBarDataArray(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QBarDataArray>("QBarDataArray", "io/qt/datavis/QBarDataArray");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QBarDataArray, {
        ConstructorInfo(&__qt_construct_QBarDataArray, nullptr)
       ,ConstructorInfo(&__qt_construct_QBarDataArray_cref_QBarDataArray, "Lio/qt/datavis/QBarDataArray;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QBarDataArray);
    registerMetaType<QBarDataArray>("QBarDataArray");
    registerContainerAccessFactory(typeId, NewContainerAccessFunction(&QtJambiPrivate::QListAccess<QBarDataRow*>::newInstance));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
