/*
 * Decompiled with CFR 0.152.
 */
package io.qt.concurrent;

import io.qt.NonNull;
import io.qt.Nullable;
import io.qt.QFlags;
import io.qt.QNoSuchEnumValueException;
import io.qt.QtAbstractFlagEnumerator;
import io.qt.QtEnumerator;
import io.qt.QtFlagEnumerator;
import io.qt.QtObject;
import io.qt.QtPrimitiveType;
import io.qt.QtUninvokable;
import io.qt.StrictNonNull;
import io.qt.concurrent.QtJambi_LibraryUtilities;
import io.qt.core.QFuture;
import io.qt.core.QList;
import io.qt.core.QMetaType;
import io.qt.core.QPromise;
import io.qt.core.QThreadPool;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;

public final class QtConcurrent {
    private QtConcurrent() throws InstantiationError {
        throw new InstantiationError("Cannot instantiate namespace QtConcurrent.");
    }

    @QtUninvokable
    private static <U> U computeDefaultResult(ReduceFunctor<U, ?> functor) {
        int[] types = QtJambi_LibraryUtilities.internal.lambdaMetaTypes(ReduceFunctor.class, functor);
        if (types != null && types.length > 0) {
            return (U)new QMetaType(types[0]).create();
        }
        return null;
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<@QtPrimitiveType Void> map(@StrictNonNull Collection<T> sequence, MapFunctor<T> functor) {
        return QtConcurrent.startMap(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }

    @QtUninvokable
    public static <T> void blockingMap(@StrictNonNull Collection<T> sequence, MapFunctor<T> functor) {
        QFuture<@QtPrimitiveType Void> future = QtConcurrent.map(sequence, functor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> mapped(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        return QtConcurrent.startMapped(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> @NonNull QList<U> blockingMapped(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        QFuture<U> future = QtConcurrent.mapped(sequence, functor);
        return future.results();
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, new ReduceOption[]{ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce});
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        QFuture<ReduceOption[]> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        QFuture<ReduceOptions> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<@QtPrimitiveType Void> filter(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.filter(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }

    @QtUninvokable
    public static <T> void blockingFilter(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        QFuture<@QtPrimitiveType Void> future = QtConcurrent.filter(sequence, filteredFunctor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<T> filtered(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.startFiltered(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor)).startAsynchronously();
    }

    @QtUninvokable
    public static <T> @NonNull QList<T> blockingFiltered(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        QFuture<T> future = QtConcurrent.filtered(sequence, filteredFunctor);
        return future.results();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOption[]{ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce});
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor) {
        QFuture<U> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        QFuture<ReduceOption[]> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        QFuture<ReduceOptions> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    private static native <T> @NonNull QFuture<@QtPrimitiveType Void> filter(long var0, Collection<T> var2, @StrictNonNull FilteredFunctor<T> var3);

    @QtUninvokable
    private static native <T> @NonNull ThreadEngineStarter<@QtPrimitiveType Void> startMap(long var0, Collection<T> var2, MapFunctor<T> var3);

    @QtUninvokable
    private static native <U, T> @NonNull ThreadEngineStarter<U> startMapped(long var0, Collection<T> var2, @StrictNonNull MappedFunctor<U, T> var3);

    @QtUninvokable
    private static native <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(long var0, Collection<T> var2, @StrictNonNull MappedFunctor<V, T> var3, @StrictNonNull ReduceFunctor<U, V> var4, U var5, int var6);

    @QtUninvokable
    private static native <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(long var0, Collection<T> var2, @StrictNonNull FilteredFunctor<T> var3, @StrictNonNull ReduceFunctor<U, T> var4, U var5, int var6);

    @QtUninvokable
    private static native <T> @NonNull ThreadEngineStarter<T> startFiltered(long var0, Collection<T> var2, @StrictNonNull FilteredFunctor<T> var3);

    @QtUninvokable
    public static <T> @NonNull QFuture<T> run(Callable<T> callable) {
        return QtConcurrent.run0(null, Objects.requireNonNull(callable));
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, Callable<T> callable) {
        return QtConcurrent.run0(threadPool, Objects.requireNonNull(callable));
    }

    @QtUninvokable
    private static native <T> @NonNull QFuture<T> run0(@Nullable QThreadPool var0, Callable<T> var1);

    @QtUninvokable
    public static @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable runnable) {
        return QtConcurrent.runVoid0(null, Objects.requireNonNull(runnable));
    }

    @QtUninvokable
    public static @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable runnable) {
        return QtConcurrent.runVoid0(threadPool, Objects.requireNonNull(runnable));
    }

    @QtUninvokable
    private static native @NonNull QFuture<@QtPrimitiveType Void> runVoid0(@Nullable QThreadPool var0, @StrictNonNull Runnable var1);

    public static <A> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable1<A> runnable, A a) {
        return QtConcurrent.runVoid1(null, runnable, a);
    }

    public static <A> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable1<A> runnable, A a) {
        return QtConcurrent.runVoid1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <A> @NonNull QFuture<@QtPrimitiveType Void> runVoid1(@Nullable QThreadPool var0, @StrictNonNull Runnable1<A> var1, A var2);

    public static <A, B> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable2<A, B> runnable, A a, B b) {
        return QtConcurrent.runVoid2(null, Objects.requireNonNull(runnable), a, b);
    }

    public static <A, B> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable2<A, B> runnable, A a, B b) {
        return QtConcurrent.runVoid2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <A, B> @NonNull QFuture<@QtPrimitiveType Void> runVoid2(@Nullable QThreadPool var0, @StrictNonNull Runnable2<A, B> var1, A var2, B var3);

    public static <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runVoid3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    public static <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runVoid3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> runVoid3(@Nullable QThreadPool var0, @StrictNonNull Runnable3<A, B, C> var1, A var2, B var3, C var4);

    public static <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runVoid4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    public static <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runVoid4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> runVoid4(@Nullable QThreadPool var0, @StrictNonNull Runnable4<A, B, C, D> var1, A var2, B var3, C var4, D var5);

    public static <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runVoid5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    public static <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runVoid5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> runVoid5(@Nullable QThreadPool var0, @StrictNonNull Runnable5<A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    public static <T, A> @NonNull QFuture<T> run(@StrictNonNull Callable1<T, A> runnable, A a) {
        return QtConcurrent.run1(null, Objects.requireNonNull(runnable), a);
    }

    public static <T, A> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable1<T, A> runnable, A a) {
        return QtConcurrent.run1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <T, A> @NonNull QFuture<T> run1(@Nullable QThreadPool var0, Callable1<T, A> var1, A var2);

    public static <T, A, B> @NonNull QFuture<T> run(@StrictNonNull Callable2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.run2(null, Objects.requireNonNull(runnable), a, b);
    }

    public static <T, A, B> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.run2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <T, A, B> @NonNull QFuture<T> run2(@Nullable QThreadPool var0, Callable2<T, A, B> var1, A var2, B var3);

    public static <T, A, B, C> @NonNull QFuture<T> run(@StrictNonNull Callable3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.run3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    public static <T, A, B, C> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.run3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <T, A, B, C> @NonNull QFuture<T> run3(@Nullable QThreadPool var0, Callable3<T, A, B, C> var1, A var2, B var3, C var4);

    public static <T, A, B, C, D> @NonNull QFuture<T> run(@StrictNonNull Callable4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.run4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    public static <T, A, B, C, D> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.run4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <T, A, B, C, D> @NonNull QFuture<T> run4(@Nullable QThreadPool var0, Callable4<T, A, B, C, D> var1, A var2, B var3, C var4, D var5);

    public static <T, A, B, C, D, E> @NonNull QFuture<T> run(@StrictNonNull Callable5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.run5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    public static <T, A, B, C, D, E> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.run5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <T, A, B, C, D, E> @NonNull QFuture<T> run5(@Nullable QThreadPool var0, Callable5<T, A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    public static <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.runVoid6(null, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    public static <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.runVoid6(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    private static native <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> runVoid6(@Nullable QThreadPool var0, @StrictNonNull Runnable6<A, B, C, D, E, F> var1, A var2, B var3, C var4, D var5, E var6, F var7);

    public static <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.runVoid7(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    public static <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.runVoid7(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    private static native <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> runVoid7(@Nullable QThreadPool var0, @StrictNonNull Runnable7<A, B, C, D, E, F, G> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8);

    public static <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.runVoid8(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    public static <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.runVoid8(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    private static native <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> runVoid8(@Nullable QThreadPool var0, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9);

    public static <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.runVoid9(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    public static <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.runVoid9(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    private static native <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> runVoid9(@Nullable QThreadPool var0, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9, I var10);

    public static <T, A, B, C, D, E, F> @NonNull QFuture<T> run(Callable6<T, A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.run6(null, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    public static <T, A, B, C, D, E, F> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.run6(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    private static native <T, A, B, C, D, E, F> @NonNull QFuture<T> run6(@Nullable QThreadPool var0, Callable6<T, A, B, C, D, E, F> var1, A var2, B var3, C var4, D var5, E var6, F var7);

    public static <T, A, B, C, D, E, F, G> @NonNull QFuture<T> run(Callable7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.run7(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    public static <T, A, B, C, D, E, F, G> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.run7(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    private static native <T, A, B, C, D, E, F, G> @NonNull QFuture<T> run7(@Nullable QThreadPool var0, Callable7<T, A, B, C, D, E, F, G> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8);

    public static <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> run(Callable8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.run8(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    public static <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.run8(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    private static native <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> run8(@Nullable QThreadPool var0, Callable8<T, A, B, C, D, E, F, G, H> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9);

    public static <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> run(Callable9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.run9(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    public static <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.run9(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    private static native <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> run9(@Nullable QThreadPool var0, Callable9<T, A, B, C, D, E, F, G, H, I> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9, I var10);

    @QtUninvokable
    public static <T> @NonNull QFuture<@QtPrimitiveType Void> map(@Nullable QThreadPool threadPool, Collection<T> sequence, MapFunctor<T> functor) {
        return QtConcurrent.startMap(threadPool, sequence, functor).startAsynchronously();
    }

    @QtUninvokable
    public static <T> void blockingMap(@Nullable QThreadPool threadPool, Collection<T> sequence, MapFunctor<T> functor) {
        QFuture<@QtPrimitiveType Void> future = QtConcurrent.map(threadPool, sequence, functor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> mapped(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        return QtConcurrent.startMapped(threadPool, sequence, functor).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> QList<U> blockingMapped(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        QFuture<U> future = QtConcurrent.mapped(threadPool, sequence, functor);
        return future.results();
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor) {
        return QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, new ReduceOption[]{ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce});
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(threadPool, sequence, functor, reduceFunctor, options).startAsynchronously();
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue) {
        return QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, ReduceOption ... options) {
        return QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue, options).startAsynchronously();
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, initialValue, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, ReduceOption ... options) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, initialValue, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor) {
        QFuture<U> future = QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        QFuture<ReduceOption[]> future = QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        QFuture<ReduceOptions> future = QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue) {
        QFuture<U> future = QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, ReduceOption ... options) {
        QFuture<U> future = QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        QFuture<U> future = QtConcurrent.mappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, initialValue);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, ReduceOption ... options) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, initialValue, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, initialValue, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<@QtPrimitiveType Void> filter(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.filter(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), filteredFunctor);
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<T> filtered(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.startFiltered(threadPool, sequence, filteredFunctor).startAsynchronously();
    }

    @QtUninvokable
    public static <T> QList<T> blockingFiltered(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        QFuture<T> future = QtConcurrent.filtered(threadPool, sequence, filteredFunctor);
        return future.results();
    }

    @QtUninvokable
    public static <T> void blockingFilter(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        QFuture<@QtPrimitiveType Void> future = QtConcurrent.filter(threadPool, sequence, filteredFunctor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor) {
        return QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, new ReduceOption[]{ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce});
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, options).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue) {
        return QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, ReduceOption ... options) {
        return QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue, options).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, initialValue, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, ReduceOption ... options) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, initialValue, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), initialValue, options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor) {
        return (U)QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return (U)QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, options).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        return (U)QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, options).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue) {
        return (U)QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, ReduceOption ... options) {
        return (U)QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue, options).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return (U)QtConcurrent.filteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue, options).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue) {
        return (U)QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, initialValue).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, ReduceOption ... options) {
        return (U)QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, initialValue, options).result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return (U)QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, initialValue, options).result();
    }

    @QtUninvokable
    public static <T> @NonNull ThreadEngineStarter<@QtPrimitiveType Void> startMap(@Nullable QThreadPool threadPool, Collection<T> sequence, MapFunctor<T> functor) {
        return QtConcurrent.startMap(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startMapped(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        return QtConcurrent.startMapped(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor) {
        return QtConcurrent.startMappedReduced(threadPool, sequence, functor, reduceFunctor, QtConcurrent.computeDefaultResult(reduceFunctor), ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value());
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.startMappedReduced(threadPool, sequence, functor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue) {
        return QtConcurrent.startMappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), initialValue, options.value());
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, U initialValue, ReduceOption ... options) {
        return QtConcurrent.startMappedReduced(threadPool, sequence, functor, reduceFunctor, initialValue, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor) {
        return QtConcurrent.startFilteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, new ReduceOption[]{ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce});
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.startFilteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value());
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue) {
        return QtConcurrent.startFilteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, ReduceOption ... options) {
        return QtConcurrent.startFilteredReduced(threadPool, sequence, filteredFunctor, reduceFunctor, initialValue, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, U initialValue, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), initialValue, options.value());
    }

    @QtUninvokable
    public static <T> @NonNull ThreadEngineStarter<T> startFiltered(@Nullable QThreadPool threadPool, Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.startFiltered(QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)Objects.requireNonNull(threadPool)), Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }

    public static <T> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise<T> runnable) {
        return QtConcurrent.runWithPromise0(null, runnable);
    }

    public static <T> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithPromise<T> runnable) {
        return QtConcurrent.runWithPromise0(threadPool, runnable);
    }

    private static native <T> @NonNull QFuture<T> runWithPromise0(@Nullable QThreadPool var0, @StrictNonNull RunnableWithPromise<T> var1);

    public static <T, A> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise1<T, A> runnable, A a) {
        return QtConcurrent.runWithPromise1(null, Objects.requireNonNull(runnable), a);
    }

    public static <T, A> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithPromise1<T, A> runnable, A a) {
        return QtConcurrent.runWithPromise1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <T, A> @NonNull QFuture<T> runWithPromise1(@Nullable QThreadPool var0, @StrictNonNull RunnableWithPromise1<T, A> var1, A var2);

    public static <T, A, B> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.runWithPromise2(null, Objects.requireNonNull(runnable), a, b);
    }

    public static <T, A, B> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithPromise2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.runWithPromise2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <T, A, B> @NonNull QFuture<T> runWithPromise2(@Nullable QThreadPool var0, @StrictNonNull RunnableWithPromise2<T, A, B> var1, A var2, B var3);

    public static <T, A, B, C> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runWithPromise3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    public static <T, A, B, C> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithPromise3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runWithPromise3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <T, A, B, C> @NonNull QFuture<T> runWithPromise3(@Nullable QThreadPool var0, @StrictNonNull RunnableWithPromise3<T, A, B, C> var1, A var2, B var3, C var4);

    public static <T, A, B, C, D> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runWithPromise4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    public static <T, A, B, C, D> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runWithPromise4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <T, A, B, C, D> @NonNull QFuture<T> runWithPromise4(@Nullable QThreadPool var0, @StrictNonNull RunnableWithPromise4<T, A, B, C, D> var1, A var2, B var3, C var4, D var5);

    public static <T, A, B, C, D, E> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runWithPromise5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    public static <T, A, B, C, D, E> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runWithPromise5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <T, A, B, C, D, E> @NonNull QFuture<T> runWithPromise5(@Nullable QThreadPool var0, RunnableWithPromise5<T, A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    public static <T, A, B, C, D, E, F> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.runWithPromise6(null, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    public static <T, A, B, C, D, E, F> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.runWithPromise6(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    private static native <T, A, B, C, D, E, F> @NonNull QFuture<T> runWithPromise6(@Nullable QThreadPool var0, RunnableWithPromise6<T, A, B, C, D, E, F> var1, A var2, B var3, C var4, D var5, E var6, F var7);

    public static <T, A, B, C, D, E, F, G> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.runWithPromise7(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    public static <T, A, B, C, D, E, F, G> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.runWithPromise7(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    private static native <T, A, B, C, D, E, F, G> @NonNull QFuture<T> runWithPromise7(@Nullable QThreadPool var0, RunnableWithPromise7<T, A, B, C, D, E, F, G> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8);

    public static <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.runWithPromise8(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    public static <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.runWithPromise8(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    private static native <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> runWithPromise8(@Nullable QThreadPool var0, RunnableWithPromise8<T, A, B, C, D, E, F, G, H> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9);

    public static <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> run(@StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.runWithPromise9(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    public static <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.runWithPromise9(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    private static native <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> runWithPromise9(@Nullable QThreadPool var0, RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9, I var10);

    public static @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise runnable) {
        return QtConcurrent.runWithPromiseVoid0(null, runnable);
    }

    public static @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise runnable) {
        return QtConcurrent.runWithPromiseVoid0(threadPool, runnable);
    }

    private static native @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid0(@Nullable QThreadPool var0, @StrictNonNull RunnableWithVoidPromise var1);

    public static <A> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise1<A> runnable, A a) {
        return QtConcurrent.runWithPromiseVoid1(null, Objects.requireNonNull(runnable), a);
    }

    public static <A> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise1<A> runnable, A a) {
        return QtConcurrent.runWithPromiseVoid1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <A> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid1(@Nullable QThreadPool var0, @StrictNonNull RunnableWithVoidPromise1<A> var1, A var2);

    public static <A, B> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise2<A, B> runnable, A a, B b) {
        return QtConcurrent.runWithPromiseVoid2(null, Objects.requireNonNull(runnable), a, b);
    }

    public static <A, B> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise2<A, B> runnable, A a, B b) {
        return QtConcurrent.runWithPromiseVoid2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <A, B> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid2(@Nullable QThreadPool var0, @StrictNonNull RunnableWithVoidPromise2<A, B> var1, A var2, B var3);

    public static <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runWithPromiseVoid3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    public static <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runWithPromiseVoid3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid3(@Nullable QThreadPool var0, @StrictNonNull RunnableWithVoidPromise3<A, B, C> var1, A var2, B var3, C var4);

    public static <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runWithPromiseVoid4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    public static <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runWithPromiseVoid4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid4(@Nullable QThreadPool var0, @StrictNonNull RunnableWithVoidPromise4<A, B, C, D> var1, A var2, B var3, C var4, D var5);

    public static <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runWithPromiseVoid5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    public static <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runWithPromiseVoid5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid5(@Nullable QThreadPool var0, RunnableWithVoidPromise5<A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    public static <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.runWithPromiseVoid6(null, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    public static <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
        return QtConcurrent.runWithPromiseVoid6(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f);
    }

    private static native <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid6(@Nullable QThreadPool var0, RunnableWithVoidPromise6<A, B, C, D, E, F> var1, A var2, B var3, C var4, D var5, E var6, F var7);

    public static <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.runWithPromiseVoid7(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    public static <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
        return QtConcurrent.runWithPromiseVoid7(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g);
    }

    private static native <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid7(@Nullable QThreadPool var0, RunnableWithVoidPromise7<A, B, C, D, E, F, G> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8);

    public static <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.runWithPromiseVoid8(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    public static <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
        return QtConcurrent.runWithPromiseVoid8(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h);
    }

    private static native <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid8(@Nullable QThreadPool var0, RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9);

    public static <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.runWithPromiseVoid9(null, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    public static <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return QtConcurrent.runWithPromiseVoid9(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e, f, g, h, i);
    }

    private static native <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> runWithPromiseVoid9(@Nullable QThreadPool var0, RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9, I var10);

    public static QTaskBuilderVoid0Arg0 task(@StrictNonNull Runnable runnable) {
        return new QTaskBuilderVoid0Arg0(0, null, runnable);
    }

    public static <A> QTaskBuilderVoid1Arg0<A> task(@StrictNonNull Runnable1<A> runnable) {
        return new QTaskBuilderVoid1Arg0<A>(0, null, runnable);
    }

    public static <A, B> QTaskBuilderVoid2Arg0<A, B> task(@StrictNonNull Runnable2<A, B> runnable) {
        return new QTaskBuilderVoid2Arg0<A, B>(0, null, runnable);
    }

    public static <A, B, C> QTaskBuilderVoid3Arg0<A, B, C> task(@StrictNonNull Runnable3<A, B, C> runnable) {
        return new QTaskBuilderVoid3Arg0<A, B, C>(0, null, runnable);
    }

    public static <A, B, C, D> QTaskBuilderVoid4Arg0<A, B, C, D> task(@StrictNonNull Runnable4<A, B, C, D> runnable) {
        return new QTaskBuilderVoid4Arg0<A, B, C, D>(0, null, runnable);
    }

    public static <A, B, C, D, E> QTaskBuilderVoid5Arg0<A, B, C, D, E> task(@StrictNonNull Runnable5<A, B, C, D, E> runnable) {
        return new QTaskBuilderVoid5Arg0<A, B, C, D, E>(0, null, runnable);
    }

    public static <A, B, C, D, E, F> QTaskBuilderVoid6Arg0<A, B, C, D, E, F> task(@StrictNonNull Runnable6<A, B, C, D, E, F> runnable) {
        return new QTaskBuilderVoid6Arg0<A, B, C, D, E, F>(0, null, runnable);
    }

    public static <A, B, C, D, E, F, G> QTaskBuilderVoid7Arg0<A, B, C, D, E, F, G> task(@StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable) {
        return new QTaskBuilderVoid7Arg0<A, B, C, D, E, F, G>(0, null, runnable);
    }

    public static <A, B, C, D, E, F, G, H> QTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H> task(@StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable) {
        return new QTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H>(0, null, runnable);
    }

    public static <A, B, C, D, E, F, G, H, I> QTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I> task(@StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable) {
        return new QTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I>(0, null, runnable);
    }

    public static <T> @NonNull QTypedTaskBuilder0Arg0<T> task(@StrictNonNull Callable<T> callable) {
        return new QTypedTaskBuilder0Arg0<T>(0, null, callable);
    }

    public static <T, A> @NonNull QTypedTaskBuilder1Arg0<T, A> task(@StrictNonNull Callable1<T, A> callable) {
        return new QTypedTaskBuilder1Arg0<T, A>(0, null, callable);
    }

    public static <T, A, B> @NonNull QTypedTaskBuilder2Arg0<T, A, B> task(@StrictNonNull Callable2<T, A, B> callable) {
        return new QTypedTaskBuilder2Arg0<T, A, B>(0, null, callable);
    }

    public static <T, A, B, C> @NonNull QTypedTaskBuilder3Arg0<T, A, B, C> task(@StrictNonNull Callable3<T, A, B, C> callable) {
        return new QTypedTaskBuilder3Arg0<T, A, B, C>(0, null, callable);
    }

    public static <T, A, B, C, D> @NonNull QTypedTaskBuilder4Arg0<T, A, B, C, D> task(@StrictNonNull Callable4<T, A, B, C, D> callable) {
        return new QTypedTaskBuilder4Arg0<T, A, B, C, D>(0, null, callable);
    }

    public static <T, A, B, C, D, E> @NonNull QTypedTaskBuilder5Arg0<T, A, B, C, D, E> task(@StrictNonNull Callable5<T, A, B, C, D, E> callable) {
        return new QTypedTaskBuilder5Arg0<T, A, B, C, D, E>(0, null, callable);
    }

    public static <T, A, B, C, D, E, F> @NonNull QTypedTaskBuilder6Arg0<T, A, B, C, D, E, F> task(@StrictNonNull Callable6<T, A, B, C, D, E, F> callable) {
        return new QTypedTaskBuilder6Arg0<T, A, B, C, D, E, F>(0, null, callable);
    }

    public static <T, A, B, C, D, E, F, G> @NonNull QTypedTaskBuilder7Arg0<T, A, B, C, D, E, F, G> task(@StrictNonNull Callable7<T, A, B, C, D, E, F, G> callable) {
        return new QTypedTaskBuilder7Arg0<T, A, B, C, D, E, F, G>(0, null, callable);
    }

    public static <T, A, B, C, D, E, F, G, H> @NonNull QTypedTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H> task(@StrictNonNull Callable8<T, A, B, C, D, E, F, G, H> callable) {
        return new QTypedTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H>(0, null, callable);
    }

    public static <T, A, B, C, D, E, F, G, H, I> @NonNull QTypedTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I> task(@StrictNonNull Callable9<T, A, B, C, D, E, F, G, H, I> callable) {
        return new QTypedTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I>(0, null, callable);
    }

    public static QPromiseTaskBuilderVoid0Arg0 task(@StrictNonNull RunnableWithVoidPromise runnable) {
        return new QPromiseTaskBuilderVoid0Arg0(0, null, runnable);
    }

    public static <A> QPromiseTaskBuilderVoid1Arg0<A> task(@StrictNonNull RunnableWithVoidPromise1<A> runnable) {
        return new QPromiseTaskBuilderVoid1Arg0<A>(0, null, runnable);
    }

    public static <A, B> QPromiseTaskBuilderVoid2Arg0<A, B> task(@StrictNonNull RunnableWithVoidPromise2<A, B> runnable) {
        return new QPromiseTaskBuilderVoid2Arg0<A, B>(0, null, runnable);
    }

    public static <A, B, C> QPromiseTaskBuilderVoid3Arg0<A, B, C> task(@StrictNonNull RunnableWithVoidPromise3<A, B, C> runnable) {
        return new QPromiseTaskBuilderVoid3Arg0<A, B, C>(0, null, runnable);
    }

    public static <A, B, C, D> QPromiseTaskBuilderVoid4Arg0<A, B, C, D> task(@StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable) {
        return new QPromiseTaskBuilderVoid4Arg0<A, B, C, D>(0, null, runnable);
    }

    public static <A, B, C, D, E> QPromiseTaskBuilderVoid5Arg0<A, B, C, D, E> task(@StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable) {
        return new QPromiseTaskBuilderVoid5Arg0<A, B, C, D, E>(0, null, runnable);
    }

    public static <A, B, C, D, E, F> QPromiseTaskBuilderVoid6Arg0<A, B, C, D, E, F> task(@StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable) {
        return new QPromiseTaskBuilderVoid6Arg0<A, B, C, D, E, F>(0, null, runnable);
    }

    public static <A, B, C, D, E, F, G> QPromiseTaskBuilderVoid7Arg0<A, B, C, D, E, F, G> task(@StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable) {
        return new QPromiseTaskBuilderVoid7Arg0<A, B, C, D, E, F, G>(0, null, runnable);
    }

    public static <A, B, C, D, E, F, G, H> QPromiseTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H> task(@StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable) {
        return new QPromiseTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H>(0, null, runnable);
    }

    public static <A, B, C, D, E, F, G, H, I> QPromiseTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I> task(@StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable) {
        return new QPromiseTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I>(0, null, runnable);
    }

    public static <T> QTypedPromiseTaskBuilder0Arg0<T> task(@StrictNonNull RunnableWithPromise<T> callable) {
        return new QTypedPromiseTaskBuilder0Arg0<T>(0, null, callable);
    }

    public static <T, A> QTypedPromiseTaskBuilder1Arg0<T, A> task(@StrictNonNull RunnableWithPromise1<T, A> runnable) {
        return new QTypedPromiseTaskBuilder1Arg0<T, A>(0, null, runnable);
    }

    public static <T, A, B> QTypedPromiseTaskBuilder2Arg0<T, A, B> task(@StrictNonNull RunnableWithPromise2<T, A, B> runnable) {
        return new QTypedPromiseTaskBuilder2Arg0<T, A, B>(0, null, runnable);
    }

    public static <T, A, B, C> QTypedPromiseTaskBuilder3Arg0<T, A, B, C> task(@StrictNonNull RunnableWithPromise3<T, A, B, C> runnable) {
        return new QTypedPromiseTaskBuilder3Arg0<T, A, B, C>(0, null, runnable);
    }

    public static <T, A, B, C, D> QTypedPromiseTaskBuilder4Arg0<T, A, B, C, D> task(@StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable) {
        return new QTypedPromiseTaskBuilder4Arg0<T, A, B, C, D>(0, null, runnable);
    }

    public static <T, A, B, C, D, E> QTypedPromiseTaskBuilder5Arg0<T, A, B, C, D, E> task(@StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable) {
        return new QTypedPromiseTaskBuilder5Arg0<T, A, B, C, D, E>(0, null, runnable);
    }

    public static <T, A, B, C, D, E, F> QTypedPromiseTaskBuilder6Arg0<T, A, B, C, D, E, F> task(@StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable) {
        return new QTypedPromiseTaskBuilder6Arg0<T, A, B, C, D, E, F>(0, null, runnable);
    }

    public static <T, A, B, C, D, E, F, G> QTypedPromiseTaskBuilder7Arg0<T, A, B, C, D, E, F, G> task(@StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable) {
        return new QTypedPromiseTaskBuilder7Arg0<T, A, B, C, D, E, F, G>(0, null, runnable);
    }

    public static <T, A, B, C, D, E, F, G, H> QTypedPromiseTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H> task(@StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable) {
        return new QTypedPromiseTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H>(0, null, runnable);
    }

    public static <T, A, B, C, D, E, F, G, H, I> QTypedPromiseTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I> task(@StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable) {
        return new QTypedPromiseTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I>(0, null, runnable);
    }

    static {
        QtJambi_LibraryUtilities.initialize();
    }

    @FunctionalInterface
    public static interface ReduceFunctor<U, T>
    extends Serializable {
        public U reduce(U var1, T var2);
    }

    @FunctionalInterface
    public static interface MapFunctor<T> {
        public void map(T var1);
    }

    public static final class ThreadEngineStarter<T>
    extends QtObject {
        private ThreadEngineStarter(QtObject.QPrivateConstructor p) {
            super(p);
        }

        public final @NonNull QFuture<T> startAsynchronously() {
            QFuture<T> result = ThreadEngineStarter.startAsynchronously(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
            this.dispose();
            return result;
        }

        @QtUninvokable
        private static final native <T> @NonNull QFuture<T> startAsynchronously(long var0);
    }

    @FunctionalInterface
    public static interface MappedFunctor<U, T> {
        public U map(T var1);
    }

    public static enum ReduceOption implements QtFlagEnumerator
    {
        UnorderedReduce(1),
        OrderedReduce(2),
        SequentialReduce(4);

        private final int value;

        private ReduceOption(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public ReduceOptions asFlags() {
            return new ReduceOptions(this.value);
        }

        public ReduceOptions combined(ReduceOption e) {
            return new ReduceOptions(this, e);
        }

        public static ReduceOptions flags(ReduceOption ... values) {
            return new ReduceOptions(values);
        }

        public static ReduceOption resolve(int value) {
            switch (value) {
                case 1: {
                    return UnorderedReduce;
                }
                case 2: {
                    return OrderedReduce;
                }
                case 4: {
                    return SequentialReduce;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static final class ReduceOptions
    extends QFlags<ReduceOption>
    implements Comparable<ReduceOptions> {
        private static final long serialVersionUID = -4989003295974641378L;

        public ReduceOptions(ReduceOption ... args) {
            super((QtAbstractFlagEnumerator[])args);
        }

        public ReduceOptions(int value) {
            super(value);
        }

        public final ReduceOptions combined(ReduceOption e) {
            return new ReduceOptions(this.value() | e.value());
        }

        public final ReduceOptions setFlag(ReduceOption e) {
            super.setFlag((QtAbstractFlagEnumerator)e);
            return this;
        }

        public final ReduceOptions setFlag(ReduceOption e, boolean on) {
            super.setFlag((QtAbstractFlagEnumerator)e, on);
            return this;
        }

        public final ReduceOption[] flags() {
            return (ReduceOption[])super.flags((QtAbstractFlagEnumerator[])ReduceOption.values());
        }

        public final ReduceOptions clone() {
            return new ReduceOptions(this.value());
        }

        @Override
        public final int compareTo(ReduceOptions other) {
            return Integer.compare(this.value(), other.value());
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static interface FilteredFunctor<T> {
        public boolean filter(T var1);
    }

    @FunctionalInterface
    public static interface Runnable1<A> {
        public void run(A var1);
    }

    @FunctionalInterface
    public static interface Runnable2<A, B> {
        public void run(A var1, B var2);
    }

    @FunctionalInterface
    public static interface Runnable3<A, B, C> {
        public void run(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface Runnable4<A, B, C, D> {
        public void run(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface Runnable5<A, B, C, D, E> {
        public void run(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface Callable1<T, A> {
        public T call(A var1);
    }

    @FunctionalInterface
    public static interface Callable2<T, A, B> {
        public T call(A var1, B var2);
    }

    @FunctionalInterface
    public static interface Callable3<T, A, B, C> {
        public T call(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface Callable4<T, A, B, C, D> {
        public T call(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface Callable5<T, A, B, C, D, E> {
        public T call(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface Runnable6<A, B, C, D, E, F> {
        public void run(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    @FunctionalInterface
    public static interface Runnable7<A, B, C, D, E, F, G> {
        public void run(A var1, B var2, C var3, D var4, E var5, F var6, G var7);
    }

    @FunctionalInterface
    public static interface Runnable8<A, B, C, D, E, F, G, H> {
        public void run(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8);
    }

    @FunctionalInterface
    public static interface Runnable9<A, B, C, D, E, F, G, H, I> {
        public void run(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8, I var9);
    }

    @FunctionalInterface
    public static interface Callable6<T, A, B, C, D, E, F> {
        public T call(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    @FunctionalInterface
    public static interface Callable7<T, A, B, C, D, E, F, G> {
        public T call(A var1, B var2, C var3, D var4, E var5, F var6, G var7);
    }

    @FunctionalInterface
    public static interface Callable8<T, A, B, C, D, E, F, G, H> {
        public T call(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8);
    }

    @FunctionalInterface
    public static interface Callable9<T, A, B, C, D, E, F, G, H, I> {
        public T call(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8, I var9);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise<T> {
        public void run(@StrictNonNull QPromise<T> var1);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise1<T, A> {
        public void run(@StrictNonNull QPromise<T> var1, A var2);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise2<T, A, B> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise3<T, A, B, C> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3, C var4);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise4<T, A, B, C, D> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3, C var4, D var5);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise5<T, A, B, C, D, E> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3, C var4, D var5, E var6);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise6<T, A, B, C, D, E, F> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3, C var4, D var5, E var6, F var7);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise7<T, A, B, C, D, E, F, G> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise8<T, A, B, C, D, E, F, G, H> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9);
    }

    @FunctionalInterface
    public static interface RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> {
        public void run(@StrictNonNull QPromise<T> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9, I var10);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise1<A> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise2<A, B> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise3<A, B, C> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3, C var4);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise4<A, B, C, D> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3, C var4, D var5);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise5<A, B, C, D, E> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3, C var4, D var5, E var6);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise6<A, B, C, D, E, F> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3, C var4, D var5, E var6, F var7);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise7<A, B, C, D, E, F, G> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9);
    }

    @FunctionalInterface
    public static interface RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> {
        public void run(@StrictNonNull QPromise<@QtPrimitiveType Void> var1, A var2, B var3, C var4, D var5, E var6, F var7, G var8, H var9, I var10);
    }

    public static class QTaskBuilderVoid0Arg0
    extends QTaskBuilder<Void> {
        private final Runnable runnable;

        QTaskBuilderVoid0Arg0(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable runnable) {
            super(newPriority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid0Arg0 withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid0Arg0 onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid0Arg0.spawn(this.threadPool(), this.priority(), this.runnable);
        }

        private static native @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, @StrictNonNull Runnable var2);
    }

    public static final class QTaskBuilderVoid1Arg0<A>
    extends QTaskBuilder<Void> {
        private final Runnable1<A> runnable;

        QTaskBuilderVoid1Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable1<A> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid1Arg1<A> withArguments(A a) {
            return new QTaskBuilderVoid1Arg1<A>(this.priority(), this.threadPool(), this.runnable, a);
        }

        @Override
        public @NonNull QTaskBuilderVoid1Arg0<A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        @Override
        public @NonNull QTaskBuilderVoid1Arg0<A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid2Arg0<A, B>
    extends QTaskBuilder<Void> {
        private final Runnable2<A, B> runnable;

        QTaskBuilderVoid2Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable2<A, B> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid2Arg1<A, B> withArguments(A a) {
            return new QTaskBuilderVoid2Arg1<A, B>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid2Arg2<A, B> withArguments(A a, B b) {
            return new QTaskBuilderVoid2Arg2<A, B>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid2Arg0<A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid2Arg0<A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid3Arg0<A, B, C>
    extends QTaskBuilder<Void> {
        private final Runnable3<A, B, C> runnable;

        QTaskBuilderVoid3Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable3<A, B, C> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid3Arg1<A, B, C> withArguments(A a) {
            return new QTaskBuilderVoid3Arg1<A, B, C>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid3Arg2<A, B, C> withArguments(A a, B b) {
            return new QTaskBuilderVoid3Arg2<A, B, C>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid3Arg3<A, B, C> withArguments(A a, B b, C c) {
            return new QTaskBuilderVoid3Arg3<A, B, C>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public @NonNull QTaskBuilderVoid3Arg0<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid3Arg0<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid4Arg0<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final Runnable4<A, B, C, D> runnable;

        QTaskBuilderVoid4Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable4<A, B, C, D> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid4Arg1<A, B, C, D> withArguments(A a) {
            return new QTaskBuilderVoid4Arg1<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid4Arg2<A, B, C, D> withArguments(A a, B b) {
            return new QTaskBuilderVoid4Arg2<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid4Arg3<A, B, C, D> withArguments(A a, B b, C c) {
            return new QTaskBuilderVoid4Arg3<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public @NonNull QTaskBuilderVoid4Arg4<A, B, C, D> withArguments(A a, B b, C c, D d) {
            return new QTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid4Arg0<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid4Arg0<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid5Arg0<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final Runnable5<A, B, C, D, E> runnable;

        QTaskBuilderVoid5Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid5Arg1<A, B, C, D, E> withArguments(A a) {
            return new QTaskBuilderVoid5Arg1<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid5Arg2<A, B, C, D, E> withArguments(A a, B b) {
            return new QTaskBuilderVoid5Arg2<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid5Arg3<A, B, C, D, E> withArguments(A a, B b, C c) {
            return new QTaskBuilderVoid5Arg3<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public @NonNull QTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(A a, B b, C c, D d) {
            return new QTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(A a, B b, C c, D d, E e) {
            return new QTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid5Arg0<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid5Arg0<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid6Arg0<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final Runnable6<A, B, C, D, E, F> runnable;

        QTaskBuilderVoid6Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid6Arg1<A, B, C, D, E, F> withArguments(A a) {
            return new QTaskBuilderVoid6Arg1<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid6Arg2<A, B, C, D, E, F> withArguments(A a, B b) {
            return new QTaskBuilderVoid6Arg2<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid6Arg3<A, B, C, D, E, F> withArguments(A a, B b, C c) {
            return new QTaskBuilderVoid6Arg3<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public @NonNull QTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(A a, B b, C c, D d) {
            return new QTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e) {
            return new QTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid6Arg0<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid6Arg0<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid7Arg0<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;

        QTaskBuilderVoid7Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid7Arg1<A, B, C, D, E, F, G> withArguments(A a) {
            return new QTaskBuilderVoid7Arg1<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> withArguments(A a, B b) {
            return new QTaskBuilderVoid7Arg2<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withArguments(A a, B b, C c) {
            return new QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public @NonNull QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d) {
            return new QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e) {
            return new QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid7Arg0<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg0<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;

        QTaskBuilderVoid8Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H> withArguments(A a) {
            return new QTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> withArguments(A a, B b) {
            return new QTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c) {
            return new QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public @NonNull QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d) {
            return new QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e) {
            return new QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;

        QTaskBuilderVoid9Arg0(int priority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public @NonNull QTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I> withArguments(A a) {
            return new QTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public @NonNull QTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> withArguments(A a, B b) {
            return new QTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public @NonNull QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c) {
            return new QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public @NonNull QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d) {
            return new QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e) {
            return new QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder0Arg0<T>
    extends QTaskBuilder<T> {
        private final Callable<T> callable;

        QTypedTaskBuilder0Arg0(int newPriority, QThreadPool threadPool, Callable<T> callable) {
            super(newPriority, threadPool);
            this.callable = callable;
        }

        @Override
        public @NonNull QTypedTaskBuilder0Arg0<T> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        @Override
        public @NonNull QTypedTaskBuilder0Arg0<T> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder0Arg0.spawn(this.threadPool(), this.priority(), this.callable);
        }

        private static native <T> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable<T> var2);
    }

    public static final class QTypedTaskBuilder1Arg0<T, A>
    extends QTaskBuilder<T> {
        private final Callable1<T, A> callable;

        QTypedTaskBuilder1Arg0(int priority, QThreadPool threadPool, Callable1<T, A> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder1Arg1<T, A> withArguments(A a) {
            return new QTypedTaskBuilder1Arg1<T, A>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder1Arg0<T, A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder1Arg0<T, A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder2Arg0<T, A, B>
    extends QTaskBuilder<T> {
        private final Callable2<T, A, B> callable;

        QTypedTaskBuilder2Arg0(int priority, QThreadPool threadPool, Callable2<T, A, B> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder2Arg1<T, A, B> withArguments(A a) {
            return new QTypedTaskBuilder2Arg1<T, A, B>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder2Arg2<T, A, B> withArguments(A a, B b) {
            return new QTypedTaskBuilder2Arg2<T, A, B>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder2Arg0<T, A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder2Arg0<T, A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder3Arg0<T, A, B, C>
    extends QTaskBuilder<T> {
        private final Callable3<T, A, B, C> callable;

        QTypedTaskBuilder3Arg0(int priority, QThreadPool threadPool, Callable3<T, A, B, C> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder3Arg1<T, A, B, C> withArguments(A a) {
            return new QTypedTaskBuilder3Arg1<T, A, B, C>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder3Arg2<T, A, B, C> withArguments(A a, B b) {
            return new QTypedTaskBuilder3Arg2<T, A, B, C>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder3Arg3<T, A, B, C> withArguments(A a, B b, C c) {
            return new QTypedTaskBuilder3Arg3<T, A, B, C>(this.priority(), this.threadPool(), this.callable, a, b, c);
        }

        public @NonNull QTypedTaskBuilder3Arg0<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder3Arg0<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder4Arg0<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final Callable4<T, A, B, C, D> callable;

        QTypedTaskBuilder4Arg0(int priority, QThreadPool threadPool, Callable4<T, A, B, C, D> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder4Arg1<T, A, B, C, D> withArguments(A a) {
            return new QTypedTaskBuilder4Arg1<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder4Arg2<T, A, B, C, D> withArguments(A a, B b) {
            return new QTypedTaskBuilder4Arg2<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder4Arg3<T, A, B, C, D> withArguments(A a, B b, C c) {
            return new QTypedTaskBuilder4Arg3<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, a, b, c);
        }

        public @NonNull QTypedTaskBuilder4Arg4<T, A, B, C, D> withArguments(A a, B b, C c, D d) {
            return new QTypedTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder4Arg0<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder4Arg0<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder5Arg0<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final Callable5<T, A, B, C, D, E> callable;

        QTypedTaskBuilder5Arg0(int priority, QThreadPool threadPool, Callable5<T, A, B, C, D, E> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder5Arg1<T, A, B, C, D, E> withArguments(A a) {
            return new QTypedTaskBuilder5Arg1<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder5Arg2<T, A, B, C, D, E> withArguments(A a, B b) {
            return new QTypedTaskBuilder5Arg2<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder5Arg3<T, A, B, C, D, E> withArguments(A a, B b, C c) {
            return new QTypedTaskBuilder5Arg3<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, a, b, c);
        }

        public @NonNull QTypedTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(A a, B b, C c, D d) {
            return new QTypedTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder5Arg0<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder5Arg0<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder6Arg0<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final Callable6<T, A, B, C, D, E, F> callable;

        QTypedTaskBuilder6Arg0(int priority, QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder6Arg1<T, A, B, C, D, E, F> withArguments(A a) {
            return new QTypedTaskBuilder6Arg1<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder6Arg2<T, A, B, C, D, E, F> withArguments(A a, B b) {
            return new QTypedTaskBuilder6Arg2<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F> withArguments(A a, B b, C c) {
            return new QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, a, b, c);
        }

        public @NonNull QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(A a, B b, C c, D d) {
            return new QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder6Arg0<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder6Arg0<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder7Arg0<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;

        QTypedTaskBuilder7Arg0(int priority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder7Arg1<T, A, B, C, D, E, F, G> withArguments(A a) {
            return new QTypedTaskBuilder7Arg1<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder7Arg2<T, A, B, C, D, E, F, G> withArguments(A a, B b) {
            return new QTypedTaskBuilder7Arg2<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c) {
            return new QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, a, b, c);
        }

        public @NonNull QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d) {
            return new QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder7Arg0<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg0<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;

        QTypedTaskBuilder8Arg0(int priority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H> withArguments(A a) {
            return new QTypedTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> withArguments(A a, B b) {
            return new QTypedTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c) {
            return new QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a, b, c);
        }

        public @NonNull QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d) {
            return new QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;

        QTypedTaskBuilder9Arg0(int priority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable) {
            super(priority, threadPool);
            this.callable = callable;
        }

        public @NonNull QTypedTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I> withArguments(A a) {
            return new QTypedTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a);
        }

        public @NonNull QTypedTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b) {
            return new QTypedTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b);
        }

        public @NonNull QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c) {
            return new QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b, c);
        }

        public @NonNull QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d) {
            return new QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, a, b, c, d, e, f, g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid0Arg0
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise runnable;

        QPromiseTaskBuilderVoid0Arg0(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise runnable) {
            super(newPriority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid0Arg0 withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid0Arg0 onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid0Arg0.spawn(this.threadPool(), this.priority(), this.runnable);
        }

        private static native @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, @StrictNonNull RunnableWithVoidPromise var2);
    }

    public static final class QPromiseTaskBuilderVoid1Arg0<A>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise1<A> runnable;

        QPromiseTaskBuilderVoid1Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise1<A> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid1Arg1<A> withArguments(A a) {
            return new QPromiseTaskBuilderVoid1Arg1<A>(this.priority(), this.threadPool(), this.runnable, a);
        }

        @Override
        public QPromiseTaskBuilderVoid1Arg0<A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        @Override
        public QPromiseTaskBuilderVoid1Arg0<A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid2Arg0<A, B>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise2<A, B> runnable;

        QPromiseTaskBuilderVoid2Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise2<A, B> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid2Arg1<A, B> withArguments(A a) {
            return new QPromiseTaskBuilderVoid2Arg1<A, B>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid2Arg2<A, B> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid2Arg2<A, B>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid2Arg0<A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid2Arg0<A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid3Arg0<A, B, C>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise3<A, B, C> runnable;

        QPromiseTaskBuilderVoid3Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise3<A, B, C> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid3Arg1<A, B, C> withArguments(A a) {
            return new QPromiseTaskBuilderVoid3Arg1<A, B, C>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid3Arg2<A, B, C> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid3Arg2<A, B, C>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid3Arg3<A, B, C> withArguments(A a, B b, C c) {
            return new QPromiseTaskBuilderVoid3Arg3<A, B, C>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QPromiseTaskBuilderVoid3Arg0<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid3Arg0<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid4Arg0<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise4<A, B, C, D> runnable;

        QPromiseTaskBuilderVoid4Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid4Arg1<A, B, C, D> withArguments(A a) {
            return new QPromiseTaskBuilderVoid4Arg1<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid4Arg2<A, B, C, D> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid4Arg2<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid4Arg3<A, B, C, D> withArguments(A a, B b, C c) {
            return new QPromiseTaskBuilderVoid4Arg3<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QPromiseTaskBuilderVoid4Arg4<A, B, C, D> withArguments(A a, B b, C c, D d) {
            return new QPromiseTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QPromiseTaskBuilderVoid4Arg0<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid4Arg0<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid5Arg0<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise5<A, B, C, D, E> runnable;

        QPromiseTaskBuilderVoid5Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid5Arg1<A, B, C, D, E> withArguments(A a) {
            return new QPromiseTaskBuilderVoid5Arg1<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid5Arg2<A, B, C, D, E> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid5Arg2<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E> withArguments(A a, B b, C c) {
            return new QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(A a, B b, C c, D d) {
            return new QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(A a, B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid5Arg0<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid5Arg0<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid6Arg0<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise6<A, B, C, D, E, F> runnable;

        QPromiseTaskBuilderVoid6Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid6Arg1<A, B, C, D, E, F> withArguments(A a) {
            return new QPromiseTaskBuilderVoid6Arg1<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid6Arg2<A, B, C, D, E, F> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid6Arg2<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F> withArguments(A a, B b, C c) {
            return new QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(A a, B b, C c, D d) {
            return new QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid6Arg0<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid6Arg0<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid7Arg0<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;

        QPromiseTaskBuilderVoid7Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid7Arg1<A, B, C, D, E, F, G> withArguments(A a) {
            return new QPromiseTaskBuilderVoid7Arg1<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid7Arg2<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withArguments(A a, B b, C c) {
            return new QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d) {
            return new QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid7Arg0<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg0<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;

        QPromiseTaskBuilderVoid8Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H> withArguments(A a) {
            return new QPromiseTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c) {
            return new QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d) {
            return new QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg0<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;

        QPromiseTaskBuilderVoid9Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QPromiseTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I> withArguments(A a) {
            return new QPromiseTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QPromiseTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> withArguments(A a, B b) {
            return new QPromiseTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c) {
            return new QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d) {
            return new QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg0<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder0Arg0<T>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise<T> runnable;

        QTypedPromiseTaskBuilder0Arg0(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise<T> runnable) {
            super(newPriority, threadPool);
            this.runnable = runnable;
        }

        @Override
        public QTypedPromiseTaskBuilder0Arg0<T> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        @Override
        public QTypedPromiseTaskBuilder0Arg0<T> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder0Arg0.spawn(this.threadPool(), this.priority(), this.runnable);
        }

        private static native <T> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, @StrictNonNull RunnableWithPromise<T> var2);
    }

    public static final class QTypedPromiseTaskBuilder1Arg0<T, A>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise1<T, A> runnable;

        QTypedPromiseTaskBuilder1Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise1<T, A> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder1Arg1<T, A> withArguments(A a) {
            return new QTypedPromiseTaskBuilder1Arg1<T, A>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder1Arg0<T, A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder1Arg0<T, A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder2Arg0<T, A, B>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise2<T, A, B> runnable;

        QTypedPromiseTaskBuilder2Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise2<T, A, B> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder2Arg1<T, A, B> withArguments(A a) {
            return new QTypedPromiseTaskBuilder2Arg1<T, A, B>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder2Arg2<T, A, B> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder2Arg2<T, A, B>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder2Arg0<T, A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder2Arg0<T, A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder3Arg0<T, A, B, C>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise3<T, A, B, C> runnable;

        QTypedPromiseTaskBuilder3Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise3<T, A, B, C> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder3Arg1<T, A, B, C> withArguments(A a) {
            return new QTypedPromiseTaskBuilder3Arg1<T, A, B, C>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder3Arg2<T, A, B, C> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder3Arg2<T, A, B, C>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder3Arg3<T, A, B, C> withArguments(A a, B b, C c) {
            return new QTypedPromiseTaskBuilder3Arg3<T, A, B, C>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QTypedPromiseTaskBuilder3Arg0<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder3Arg0<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder4Arg0<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise4<T, A, B, C, D> runnable;

        QTypedPromiseTaskBuilder4Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder4Arg1<T, A, B, C, D> withArguments(A a) {
            return new QTypedPromiseTaskBuilder4Arg1<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder4Arg2<T, A, B, C, D> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder4Arg2<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D> withArguments(A a, B b, C c) {
            return new QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D> withArguments(A a, B b, C c, D d) {
            return new QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QTypedPromiseTaskBuilder4Arg0<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder4Arg0<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder5Arg0<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise5<T, A, B, C, D, E> runnable;

        QTypedPromiseTaskBuilder5Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder5Arg1<T, A, B, C, D, E> withArguments(A a) {
            return new QTypedPromiseTaskBuilder5Arg1<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder5Arg2<T, A, B, C, D, E> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder5Arg2<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E> withArguments(A a, B b, C c) {
            return new QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(A a, B b, C c, D d) {
            return new QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder5Arg0<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder5Arg0<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder6Arg0<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise6<T, A, B, C, D, E, F> runnable;

        QTypedPromiseTaskBuilder6Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder6Arg1<T, A, B, C, D, E, F> withArguments(A a) {
            return new QTypedPromiseTaskBuilder6Arg1<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder6Arg2<T, A, B, C, D, E, F> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder6Arg2<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F> withArguments(A a, B b, C c) {
            return new QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(A a, B b, C c, D d) {
            return new QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder6Arg0<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder6Arg0<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder7Arg0<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;

        QTypedPromiseTaskBuilder7Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder7Arg1<T, A, B, C, D, E, F, G> withArguments(A a) {
            return new QTypedPromiseTaskBuilder7Arg1<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder7Arg2<T, A, B, C, D, E, F, G> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder7Arg2<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c) {
            return new QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d) {
            return new QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder7Arg0<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg0<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;

        QTypedPromiseTaskBuilder8Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H> withArguments(A a) {
            return new QTypedPromiseTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c) {
            return new QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d) {
            return new QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg0<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;

        QTypedPromiseTaskBuilder9Arg0(int priority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable) {
            super(priority, threadPool);
            this.runnable = runnable;
        }

        public QTypedPromiseTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I> withArguments(A a) {
            return new QTypedPromiseTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a);
        }

        public QTypedPromiseTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b) {
            return new QTypedPromiseTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b);
        }

        public QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c) {
            return new QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c);
        }

        public QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d) {
            return new QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d);
        }

        public QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, a, b, c, d, e, f, g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg0<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;
        private final I i;

        QTypedPromiseTaskBuilder9Arg9(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
            this.i = i;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder9Arg9.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        private static native <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10, I var11);
    }

    public static final class QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QTypedPromiseTaskBuilder9Arg8(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, i);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTypedPromiseTaskBuilder9Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedPromiseTaskBuilder9Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(G g) {
            return new QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(G g, H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(G g, H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedPromiseTaskBuilder9Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(F f) {
            return new QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(F f, G g) {
            return new QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedPromiseTaskBuilder9Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(E e) {
            return new QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f) {
            return new QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g) {
            return new QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTypedPromiseTaskBuilder9Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(D d) {
            return new QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e) {
            return new QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f) {
            return new QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder9Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withArguments(C c) {
            return new QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d) {
            return new QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e) {
            return new QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable;
        private final A a;

        QTypedPromiseTaskBuilder9Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise9<T, A, B, C, D, E, F, G, H, I> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> withArguments(B b) {
            return new QTypedPromiseTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c) {
            return new QTypedPromiseTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d) {
            return new QTypedPromiseTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QTypedPromiseTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h, i);
        }

        public QTypedPromiseTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QTypedPromiseTaskBuilder8Arg8(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder8Arg8.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }

        private static native <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise8<T, A, B, C, D, E, F, G, H> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10);
    }

    public static final class QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTypedPromiseTaskBuilder8Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedPromiseTaskBuilder8Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(G g) {
            return new QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(G g, H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedPromiseTaskBuilder8Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(F f) {
            return new QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(F f, G g) {
            return new QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(F f, G g, H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedPromiseTaskBuilder8Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(E e) {
            return new QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(E e, F f) {
            return new QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(E e, F f, G g) {
            return new QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTypedPromiseTaskBuilder8Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(D d) {
            return new QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(D d, E e) {
            return new QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(D d, E e, F f) {
            return new QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder8Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withArguments(C c) {
            return new QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(C c, D d) {
            return new QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e) {
            return new QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable;
        private final A a;

        QTypedPromiseTaskBuilder8Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise8<T, A, B, C, D, E, F, G, H> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> withArguments(B b) {
            return new QTypedPromiseTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withArguments(B b, C c) {
            return new QTypedPromiseTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d) {
            return new QTypedPromiseTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedPromiseTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h);
        }

        public QTypedPromiseTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTypedPromiseTaskBuilder7Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder7Arg7.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        private static native <T, A, B, C, D, E, F, G> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise7<T, A, B, C, D, E, F, G> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9);
    }

    public static final class QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedPromiseTaskBuilder7Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(G g) {
            return new QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedPromiseTaskBuilder7Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(F f) {
            return new QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(F f, G g) {
            return new QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedPromiseTaskBuilder7Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(E e) {
            return new QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(E e, F f) {
            return new QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(E e, F f, G g) {
            return new QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTypedPromiseTaskBuilder7Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(D d) {
            return new QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(D d, E e) {
            return new QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(D d, E e, F f) {
            return new QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder7Arg2<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder7Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withArguments(C c) {
            return new QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(C c, D d) {
            return new QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(C c, D d, E e) {
            return new QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder7Arg2<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg2<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder7Arg1<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable;
        private final A a;

        QTypedPromiseTaskBuilder7Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise7<T, A, B, C, D, E, F, G> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder7Arg2<T, A, B, C, D, E, F, G> withArguments(B b) {
            return new QTypedPromiseTaskBuilder7Arg2<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withArguments(B b, C c) {
            return new QTypedPromiseTaskBuilder7Arg3<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d) {
            return new QTypedPromiseTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTypedPromiseTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public QTypedPromiseTaskBuilder7Arg1<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder7Arg1<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise6<T, A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedPromiseTaskBuilder6Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder6Arg6.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f);
        }

        private static native <T, A, B, C, D, E, F> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise6<T, A, B, C, D, E, F> var2, A var3, B var4, C var5, D var6, E var7, F var8);
    }

    public static final class QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise6<T, A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedPromiseTaskBuilder6Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(F f) {
            return new QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise6<T, A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedPromiseTaskBuilder6Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(E e) {
            return new QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(E e, F f) {
            return new QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise6<T, A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTypedPromiseTaskBuilder6Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(D d) {
            return new QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(D d, E e) {
            return new QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(D d, E e, F f) {
            return new QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder6Arg2<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise6<T, A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder6Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F> withArguments(C c) {
            return new QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(C c, D d) {
            return new QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(C c, D d, E e) {
            return new QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder6Arg2<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder6Arg2<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder6Arg1<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise6<T, A, B, C, D, E, F> runnable;
        private final A a;

        QTypedPromiseTaskBuilder6Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise6<T, A, B, C, D, E, F> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder6Arg2<T, A, B, C, D, E, F> withArguments(B b) {
            return new QTypedPromiseTaskBuilder6Arg2<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F> withArguments(B b, C c) {
            return new QTypedPromiseTaskBuilder6Arg3<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(B b, C c, D d) {
            return new QTypedPromiseTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedPromiseTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QTypedPromiseTaskBuilder6Arg1<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder6Arg1<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise5<T, A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedPromiseTaskBuilder5Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder5Arg5.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e);
        }

        private static native <T, A, B, C, D, E> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise5<T, A, B, C, D, E> var2, A var3, B var4, C var5, D var6, E var7);
    }

    public static final class QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise5<T, A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedPromiseTaskBuilder5Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(E e) {
            return new QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise5<T, A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTypedPromiseTaskBuilder5Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(D d) {
            return new QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(D d, E e) {
            return new QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder5Arg2<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise5<T, A, B, C, D, E> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder5Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E> withArguments(C c) {
            return new QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(C c, D d) {
            return new QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(C c, D d, E e) {
            return new QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QTypedPromiseTaskBuilder5Arg2<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder5Arg2<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder5Arg1<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise5<T, A, B, C, D, E> runnable;
        private final A a;

        QTypedPromiseTaskBuilder5Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise5<T, A, B, C, D, E> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder5Arg2<T, A, B, C, D, E> withArguments(B b) {
            return new QTypedPromiseTaskBuilder5Arg2<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E> withArguments(B b, C c) {
            return new QTypedPromiseTaskBuilder5Arg3<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(B b, C c, D d) {
            return new QTypedPromiseTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(B b, C c, D d, E e) {
            return new QTypedPromiseTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QTypedPromiseTaskBuilder5Arg1<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder5Arg1<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise4<T, A, B, C, D> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedPromiseTaskBuilder4Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder4Arg4.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d);
        }

        private static native <T, A, B, C, D> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise4<T, A, B, C, D> var2, A var3, B var4, C var5, D var6);
    }

    public static final class QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise4<T, A, B, C, D> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTypedPromiseTaskBuilder4Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D> withArguments(D d) {
            return new QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder4Arg2<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise4<T, A, B, C, D> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder4Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D> withArguments(C c) {
            return new QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D> withArguments(C c, D d) {
            return new QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QTypedPromiseTaskBuilder4Arg2<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder4Arg2<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder4Arg1<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise4<T, A, B, C, D> runnable;
        private final A a;

        QTypedPromiseTaskBuilder4Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise4<T, A, B, C, D> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder4Arg2<T, A, B, C, D> withArguments(B b) {
            return new QTypedPromiseTaskBuilder4Arg2<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D> withArguments(B b, C c) {
            return new QTypedPromiseTaskBuilder4Arg3<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D> withArguments(B b, C c, D d) {
            return new QTypedPromiseTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QTypedPromiseTaskBuilder4Arg1<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder4Arg1<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder3Arg3<T, A, B, C>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise3<T, A, B, C> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTypedPromiseTaskBuilder3Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise3<T, A, B, C> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QTypedPromiseTaskBuilder3Arg3<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder3Arg3<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder3Arg3.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c);
        }

        private static native <T, A, B, C> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise3<T, A, B, C> var2, A var3, B var4, C var5);
    }

    public static final class QTypedPromiseTaskBuilder3Arg2<T, A, B, C>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise3<T, A, B, C> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder3Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise3<T, A, B, C> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder3Arg3<T, A, B, C> withArguments(C c) {
            return new QTypedPromiseTaskBuilder3Arg3<T, A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QTypedPromiseTaskBuilder3Arg2<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder3Arg2<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder3Arg1<T, A, B, C>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise3<T, A, B, C> runnable;
        private final A a;

        QTypedPromiseTaskBuilder3Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise3<T, A, B, C> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder3Arg2<T, A, B, C> withArguments(B b) {
            return new QTypedPromiseTaskBuilder3Arg2<T, A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder3Arg3<T, A, B, C> withArguments(B b, C c) {
            return new QTypedPromiseTaskBuilder3Arg3<T, A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QTypedPromiseTaskBuilder3Arg1<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder3Arg1<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder2Arg2<T, A, B>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise2<T, A, B> runnable;
        private final A a;
        private final B b;

        QTypedPromiseTaskBuilder2Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise2<T, A, B> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QTypedPromiseTaskBuilder2Arg2<T, A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder2Arg2<T, A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder2Arg2.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b);
        }

        private static native <T, A, B> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise2<T, A, B> var2, A var3, B var4);
    }

    public static final class QTypedPromiseTaskBuilder2Arg1<T, A, B>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise2<T, A, B> runnable;
        private final A a;

        QTypedPromiseTaskBuilder2Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise2<T, A, B> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder2Arg2<T, A, B> withArguments(B b) {
            return new QTypedPromiseTaskBuilder2Arg2<T, A, B>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QTypedPromiseTaskBuilder2Arg1<T, A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder2Arg1<T, A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedPromiseTaskBuilder1Arg1<T, A>
    extends QTaskBuilder<T> {
        private final RunnableWithPromise1<T, A> runnable;
        private final A a;

        QTypedPromiseTaskBuilder1Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithPromise1<T, A> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QTypedPromiseTaskBuilder1Arg1<T, A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QTypedPromiseTaskBuilder1Arg1<T, A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedPromiseTaskBuilder1Arg1.spawn(this.threadPool(), this.priority(), this.runnable, this.a);
        }

        private static native <T, A> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, RunnableWithPromise1<T, A> var2, A var3);
    }

    public static final class QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;
        private final I i;

        QPromiseTaskBuilderVoid9Arg9(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
            this.i = i;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid9Arg9.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        private static native <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10, I var11);
    }

    public static final class QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QPromiseTaskBuilderVoid9Arg8(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, i);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QPromiseTaskBuilderVoid9Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QPromiseTaskBuilderVoid9Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(G g) {
            return new QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(G g, H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(G g, H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QPromiseTaskBuilderVoid9Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(F f) {
            return new QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(F f, G g) {
            return new QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QPromiseTaskBuilderVoid9Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(E e) {
            return new QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(E e, F f) {
            return new QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g) {
            return new QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;

        QPromiseTaskBuilderVoid9Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(D d) {
            return new QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(D d, E e) {
            return new QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f) {
            return new QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid9Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withArguments(C c) {
            return new QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(C c, D d) {
            return new QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e) {
            return new QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;

        QPromiseTaskBuilderVoid9Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise9<A, B, C, D, E, F, G, H, I> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> withArguments(B b) {
            return new QPromiseTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withArguments(B b, C c) {
            return new QPromiseTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d) {
            return new QPromiseTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QPromiseTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h, i);
        }

        public QPromiseTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QPromiseTaskBuilderVoid8Arg8(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid8Arg8.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }

        private static native <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10);
    }

    public static final class QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QPromiseTaskBuilderVoid8Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QPromiseTaskBuilderVoid8Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(G g) {
            return new QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(G g, H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QPromiseTaskBuilderVoid8Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(F f) {
            return new QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(F f, G g) {
            return new QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(F f, G g, H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QPromiseTaskBuilderVoid8Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(E e) {
            return new QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(E e, F f) {
            return new QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(E e, F f, G g) {
            return new QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;

        QPromiseTaskBuilderVoid8Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(D d) {
            return new QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(D d, E e) {
            return new QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(D d, E e, F f) {
            return new QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid8Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withArguments(C c) {
            return new QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(C c, D d) {
            return new QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e) {
            return new QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable;
        private final A a;

        QPromiseTaskBuilderVoid8Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise8<A, B, C, D, E, F, G, H> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> withArguments(B b) {
            return new QPromiseTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withArguments(B b, C c) {
            return new QPromiseTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d) {
            return new QPromiseTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QPromiseTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h);
        }

        public QPromiseTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QPromiseTaskBuilderVoid7Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid7Arg7.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        private static native <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise7<A, B, C, D, E, F, G> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9);
    }

    public static final class QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QPromiseTaskBuilderVoid7Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(G g) {
            return new QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QPromiseTaskBuilderVoid7Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(F f) {
            return new QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(F f, G g) {
            return new QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QPromiseTaskBuilderVoid7Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(E e) {
            return new QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(E e, F f) {
            return new QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(E e, F f, G g) {
            return new QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;

        QPromiseTaskBuilderVoid7Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(D d) {
            return new QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(D d, E e) {
            return new QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(D d, E e, F f) {
            return new QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid7Arg2<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid7Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withArguments(C c) {
            return new QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(C c, D d) {
            return new QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(C c, D d, E e) {
            return new QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid7Arg1<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable;
        private final A a;

        QPromiseTaskBuilderVoid7Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise7<A, B, C, D, E, F, G> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> withArguments(B b) {
            return new QPromiseTaskBuilderVoid7Arg2<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withArguments(B b, C c) {
            return new QPromiseTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(B b, C c, D d) {
            return new QPromiseTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QPromiseTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public QPromiseTaskBuilderVoid7Arg1<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid7Arg1<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QPromiseTaskBuilderVoid6Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid6Arg6.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f);
        }

        private static native <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise6<A, B, C, D, E, F> var2, A var3, B var4, C var5, D var6, E var7, F var8);
    }

    public static final class QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QPromiseTaskBuilderVoid6Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(F f) {
            return new QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QPromiseTaskBuilderVoid6Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(E e) {
            return new QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(E e, F f) {
            return new QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;

        QPromiseTaskBuilderVoid6Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(D d) {
            return new QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(D d, E e) {
            return new QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(D d, E e, F f) {
            return new QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid6Arg2<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid6Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F> withArguments(C c) {
            return new QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(C c, D d) {
            return new QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(C c, D d, E e) {
            return new QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid6Arg2<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid6Arg2<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid6Arg1<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise6<A, B, C, D, E, F> runnable;
        private final A a;

        QPromiseTaskBuilderVoid6Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise6<A, B, C, D, E, F> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid6Arg2<A, B, C, D, E, F> withArguments(B b) {
            return new QPromiseTaskBuilderVoid6Arg2<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F> withArguments(B b, C c) {
            return new QPromiseTaskBuilderVoid6Arg3<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(B b, C c, D d) {
            return new QPromiseTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(B b, C c, D d, E e, F f) {
            return new QPromiseTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public QPromiseTaskBuilderVoid6Arg1<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid6Arg1<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QPromiseTaskBuilderVoid5Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid5Arg5.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e);
        }

        private static native <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise5<A, B, C, D, E> var2, A var3, B var4, C var5, D var6, E var7);
    }

    public static final class QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QPromiseTaskBuilderVoid5Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(E e) {
            return new QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;

        QPromiseTaskBuilderVoid5Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(D d) {
            return new QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(D d, E e) {
            return new QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid5Arg2<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid5Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E> withArguments(C c) {
            return new QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(C c, D d) {
            return new QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(C c, D d, E e) {
            return new QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public QPromiseTaskBuilderVoid5Arg2<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid5Arg2<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid5Arg1<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise5<A, B, C, D, E> runnable;
        private final A a;

        QPromiseTaskBuilderVoid5Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise5<A, B, C, D, E> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid5Arg2<A, B, C, D, E> withArguments(B b) {
            return new QPromiseTaskBuilderVoid5Arg2<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E> withArguments(B b, C c) {
            return new QPromiseTaskBuilderVoid5Arg3<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(B b, C c, D d) {
            return new QPromiseTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(B b, C c, D d, E e) {
            return new QPromiseTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public QPromiseTaskBuilderVoid5Arg1<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid5Arg1<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid4Arg4<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise4<A, B, C, D> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QPromiseTaskBuilderVoid4Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public QPromiseTaskBuilderVoid4Arg4<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid4Arg4<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid4Arg4.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d);
        }

        private static native <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise4<A, B, C, D> var2, A var3, B var4, C var5, D var6);
    }

    public static final class QPromiseTaskBuilderVoid4Arg3<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise4<A, B, C, D> runnable;
        private final A a;
        private final B b;
        private final C c;

        QPromiseTaskBuilderVoid4Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QPromiseTaskBuilderVoid4Arg4<A, B, C, D> withArguments(D d) {
            return new QPromiseTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public QPromiseTaskBuilderVoid4Arg3<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid4Arg3<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid4Arg2<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise4<A, B, C, D> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid4Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid4Arg3<A, B, C, D> withArguments(C c) {
            return new QPromiseTaskBuilderVoid4Arg3<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QPromiseTaskBuilderVoid4Arg4<A, B, C, D> withArguments(C c, D d) {
            return new QPromiseTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public QPromiseTaskBuilderVoid4Arg2<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid4Arg2<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid4Arg1<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise4<A, B, C, D> runnable;
        private final A a;

        QPromiseTaskBuilderVoid4Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise4<A, B, C, D> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid4Arg2<A, B, C, D> withArguments(B b) {
            return new QPromiseTaskBuilderVoid4Arg2<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid4Arg3<A, B, C, D> withArguments(B b, C c) {
            return new QPromiseTaskBuilderVoid4Arg3<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QPromiseTaskBuilderVoid4Arg4<A, B, C, D> withArguments(B b, C c, D d) {
            return new QPromiseTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public QPromiseTaskBuilderVoid4Arg1<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid4Arg1<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid3Arg3<A, B, C>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise3<A, B, C> runnable;
        private final A a;
        private final B b;
        private final C c;

        QPromiseTaskBuilderVoid3Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise3<A, B, C> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public QPromiseTaskBuilderVoid3Arg3<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid3Arg3<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid3Arg3.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c);
        }

        private static native <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise3<A, B, C> var2, A var3, B var4, C var5);
    }

    public static final class QPromiseTaskBuilderVoid3Arg2<A, B, C>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise3<A, B, C> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid3Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise3<A, B, C> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid3Arg3<A, B, C> withArguments(C c) {
            return new QPromiseTaskBuilderVoid3Arg3<A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public QPromiseTaskBuilderVoid3Arg2<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid3Arg2<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QPromiseTaskBuilderVoid3Arg1<A, B, C>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise3<A, B, C> runnable;
        private final A a;

        QPromiseTaskBuilderVoid3Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise3<A, B, C> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid3Arg2<A, B, C> withArguments(B b) {
            return new QPromiseTaskBuilderVoid3Arg2<A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid3Arg3<A, B, C> withArguments(B b, C c) {
            return new QPromiseTaskBuilderVoid3Arg3<A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public QPromiseTaskBuilderVoid3Arg1<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid3Arg1<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid2Arg2<A, B>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise2<A, B> runnable;
        private final A a;
        private final B b;

        QPromiseTaskBuilderVoid2Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise2<A, B> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public QPromiseTaskBuilderVoid2Arg2<A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid2Arg2<A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid2Arg2.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b);
        }

        private static native <A, B> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise2<A, B> var2, A var3, B var4);
    }

    public static class QPromiseTaskBuilderVoid2Arg1<A, B>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise2<A, B> runnable;
        private final A a;

        QPromiseTaskBuilderVoid2Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise2<A, B> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public QPromiseTaskBuilderVoid2Arg2<A, B> withArguments(B b) {
            return new QPromiseTaskBuilderVoid2Arg2<A, B>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public QPromiseTaskBuilderVoid2Arg1<A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public QPromiseTaskBuilderVoid2Arg1<A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QPromiseTaskBuilderVoid1Arg1<A>
    extends QTaskBuilder<Void> {
        private final RunnableWithVoidPromise1<A> runnable;
        private final A a;

        QPromiseTaskBuilderVoid1Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull RunnableWithVoidPromise1<A> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        @Override
        public QPromiseTaskBuilderVoid1Arg1<A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        @Override
        public QPromiseTaskBuilderVoid1Arg1<A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QPromiseTaskBuilderVoid1Arg1.spawn(this.threadPool(), this.priority(), this.runnable, this.a);
        }

        private static native <A> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, RunnableWithVoidPromise1<A> var2, A var3);
    }

    public static final class QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;
        private final I i;

        QTypedTaskBuilder9Arg9(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
            this.i = i;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder9Arg9.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        private static native <T, A, B, C, D, E, F, G, H, I> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable9<T, A, B, C, D, E, F, G, H, I> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10, I var11);
    }

    public static final class QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QTypedTaskBuilder9Arg8(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTypedTaskBuilder9Arg7(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedTaskBuilder9Arg6(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(G g) {
            return new QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(G g, H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(G g, H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedTaskBuilder9Arg5(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(F f) {
            return new QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(F f, G g) {
            return new QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f, g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedTaskBuilder9Arg4(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(E e) {
            return new QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f) {
            return new QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g) {
            return new QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f, g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;
        private final C c;

        QTypedTaskBuilder9Arg3(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(D d) {
            return new QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d);
        }

        public @NonNull QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e) {
            return new QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f) {
            return new QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g) {
            return new QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f, g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder9Arg2(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withArguments(C c) {
            return new QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c);
        }

        public @NonNull QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d) {
            return new QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d);
        }

        public @NonNull QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e) {
            return new QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f) {
            return new QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f, g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<T> {
        private final Callable9<T, A, B, C, D, E, F, G, H, I> callable;
        private final A a;

        QTypedTaskBuilder9Arg1(int newPriority, QThreadPool threadPool, Callable9<T, A, B, C, D, E, F, G, H, I> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I> withArguments(B b) {
            return new QTypedTaskBuilder9Arg2<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c) {
            return new QTypedTaskBuilder9Arg3<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b, c);
        }

        public @NonNull QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d) {
            return new QTypedTaskBuilder9Arg4<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e) {
            return new QTypedTaskBuilder9Arg5<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder9Arg6<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder9Arg7<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder9Arg8<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QTypedTaskBuilder9Arg9<T, A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f, g, h, i);
        }

        public @NonNull QTypedTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder9Arg1<T, A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QTypedTaskBuilder8Arg8(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder8Arg8.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }

        private static native <T, A, B, C, D, E, F, G, H> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable8<T, A, B, C, D, E, F, G, H> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10);
    }

    public static final class QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTypedTaskBuilder8Arg7(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedTaskBuilder8Arg6(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(G g) {
            return new QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(G g, H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedTaskBuilder8Arg5(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(F f) {
            return new QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(F f, G g) {
            return new QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(F f, G g, H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedTaskBuilder8Arg4(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(E e) {
            return new QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(E e, F f) {
            return new QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(E e, F f, G g) {
            return new QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(E e, F f, G g, H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;
        private final B b;
        private final C c;

        QTypedTaskBuilder8Arg3(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(D d) {
            return new QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d);
        }

        public @NonNull QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(D d, E e) {
            return new QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(D d, E e, F f) {
            return new QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g) {
            return new QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder8Arg2(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withArguments(C c) {
            return new QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c);
        }

        public @NonNull QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(C c, D d) {
            return new QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d);
        }

        public @NonNull QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e) {
            return new QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f) {
            return new QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H>
    extends QTaskBuilder<T> {
        private final Callable8<T, A, B, C, D, E, F, G, H> callable;
        private final A a;

        QTypedTaskBuilder8Arg1(int newPriority, QThreadPool threadPool, Callable8<T, A, B, C, D, E, F, G, H> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H> withArguments(B b) {
            return new QTypedTaskBuilder8Arg2<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H> withArguments(B b, C c) {
            return new QTypedTaskBuilder8Arg3<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, b, c);
        }

        public @NonNull QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d) {
            return new QTypedTaskBuilder8Arg4<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e) {
            return new QTypedTaskBuilder8Arg5<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder8Arg6<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder8Arg7<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QTypedTaskBuilder8Arg8<T, A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f, g, h);
        }

        public @NonNull QTypedTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder8Arg1<T, A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTypedTaskBuilder7Arg7(int newPriority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder7Arg7.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        private static native <T, A, B, C, D, E, F, G> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable7<T, A, B, C, D, E, F, G> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9);
    }

    public static final class QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedTaskBuilder7Arg6(int newPriority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(G g) {
            return new QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedTaskBuilder7Arg5(int newPriority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(F f) {
            return new QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(F f, G g) {
            return new QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public @NonNull QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedTaskBuilder7Arg4(int newPriority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(E e) {
            return new QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(E e, F f) {
            return new QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(E e, F f, G g) {
            return new QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;
        private final A a;
        private final B b;
        private final C c;

        QTypedTaskBuilder7Arg3(int newPriority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(D d) {
            return new QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d);
        }

        public @NonNull QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(D d, E e) {
            return new QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(D d, E e, F f) {
            return new QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(D d, E e, F f, G g) {
            return new QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder7Arg2<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder7Arg2(int newPriority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withArguments(C c) {
            return new QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c);
        }

        public @NonNull QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(C c, D d) {
            return new QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d);
        }

        public @NonNull QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(C c, D d, E e) {
            return new QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f) {
            return new QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder7Arg2<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg2<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder7Arg1<T, A, B, C, D, E, F, G>
    extends QTaskBuilder<T> {
        private final Callable7<T, A, B, C, D, E, F, G> callable;
        private final A a;

        QTypedTaskBuilder7Arg1(int newPriority, QThreadPool threadPool, Callable7<T, A, B, C, D, E, F, G> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder7Arg2<T, A, B, C, D, E, F, G> withArguments(B b) {
            return new QTypedTaskBuilder7Arg2<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G> withArguments(B b, C c) {
            return new QTypedTaskBuilder7Arg3<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, b, c);
        }

        public @NonNull QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d) {
            return new QTypedTaskBuilder7Arg4<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e) {
            return new QTypedTaskBuilder7Arg5<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder7Arg6<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTypedTaskBuilder7Arg7<T, A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f, g);
        }

        public @NonNull QTypedTaskBuilder7Arg1<T, A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder7Arg1<T, A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final Callable6<T, A, B, C, D, E, F> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTypedTaskBuilder6Arg6(int newPriority, QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> callable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder6Arg6.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b, this.c, this.d, this.e, this.f);
        }

        private static native <T, A, B, C, D, E, F> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable6<T, A, B, C, D, E, F> var2, A var3, B var4, C var5, D var6, E var7, F var8);
    }

    public static final class QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final Callable6<T, A, B, C, D, E, F> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedTaskBuilder6Arg5(int newPriority, QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> callable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(F f) {
            return new QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final Callable6<T, A, B, C, D, E, F> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedTaskBuilder6Arg4(int newPriority, QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> callable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(E e) {
            return new QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(E e, F f) {
            return new QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final Callable6<T, A, B, C, D, E, F> callable;
        private final A a;
        private final B b;
        private final C c;

        QTypedTaskBuilder6Arg3(int newPriority, QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> callable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(D d) {
            return new QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d);
        }

        public @NonNull QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(D d, E e) {
            return new QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(D d, E e, F f) {
            return new QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder6Arg2<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final Callable6<T, A, B, C, D, E, F> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder6Arg2(int newPriority, QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F> withArguments(C c) {
            return new QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c);
        }

        public @NonNull QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(C c, D d) {
            return new QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d);
        }

        public @NonNull QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(C c, D d, E e) {
            return new QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(C c, D d, E e, F f) {
            return new QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder6Arg2<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder6Arg2<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder6Arg1<T, A, B, C, D, E, F>
    extends QTaskBuilder<T> {
        private final Callable6<T, A, B, C, D, E, F> callable;
        private final A a;

        QTypedTaskBuilder6Arg1(int newPriority, QThreadPool threadPool, Callable6<T, A, B, C, D, E, F> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder6Arg2<T, A, B, C, D, E, F> withArguments(B b) {
            return new QTypedTaskBuilder6Arg2<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F> withArguments(B b, C c) {
            return new QTypedTaskBuilder6Arg3<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, b, c);
        }

        public @NonNull QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F> withArguments(B b, C c, D d) {
            return new QTypedTaskBuilder6Arg4<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F> withArguments(B b, C c, D d, E e) {
            return new QTypedTaskBuilder6Arg5<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F> withArguments(B b, C c, D d, E e, F f) {
            return new QTypedTaskBuilder6Arg6<T, A, B, C, D, E, F>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e, f);
        }

        public @NonNull QTypedTaskBuilder6Arg1<T, A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder6Arg1<T, A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder5Arg5<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final Callable5<T, A, B, C, D, E> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTypedTaskBuilder5Arg5(int newPriority, QThreadPool threadPool, Callable5<T, A, B, C, D, E> callable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTypedTaskBuilder5Arg5<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder5Arg5<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder5Arg5.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b, this.c, this.d, this.e);
        }

        private static native <T, A, B, C, D, E> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable5<T, A, B, C, D, E> var2, A var3, B var4, C var5, D var6, E var7);
    }

    public static final class QTypedTaskBuilder5Arg4<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final Callable5<T, A, B, C, D, E> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedTaskBuilder5Arg4(int newPriority, QThreadPool threadPool, Callable5<T, A, B, C, D, E> callable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTypedTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(E e) {
            return new QTypedTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTypedTaskBuilder5Arg4<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder5Arg4<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder5Arg3<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final Callable5<T, A, B, C, D, E> callable;
        private final A a;
        private final B b;
        private final C c;

        QTypedTaskBuilder5Arg3(int newPriority, QThreadPool threadPool, Callable5<T, A, B, C, D, E> callable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTypedTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(D d) {
            return new QTypedTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d);
        }

        public @NonNull QTypedTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(D d, E e) {
            return new QTypedTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTypedTaskBuilder5Arg3<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder5Arg3<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder5Arg2<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final Callable5<T, A, B, C, D, E> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder5Arg2(int newPriority, QThreadPool threadPool, Callable5<T, A, B, C, D, E> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder5Arg3<T, A, B, C, D, E> withArguments(C c) {
            return new QTypedTaskBuilder5Arg3<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c);
        }

        public @NonNull QTypedTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(C c, D d) {
            return new QTypedTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d);
        }

        public @NonNull QTypedTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(C c, D d, E e) {
            return new QTypedTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder5Arg2<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder5Arg2<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder5Arg1<T, A, B, C, D, E>
    extends QTaskBuilder<T> {
        private final Callable5<T, A, B, C, D, E> callable;
        private final A a;

        QTypedTaskBuilder5Arg1(int newPriority, QThreadPool threadPool, Callable5<T, A, B, C, D, E> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder5Arg2<T, A, B, C, D, E> withArguments(B b) {
            return new QTypedTaskBuilder5Arg2<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder5Arg3<T, A, B, C, D, E> withArguments(B b, C c) {
            return new QTypedTaskBuilder5Arg3<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, b, c);
        }

        public @NonNull QTypedTaskBuilder5Arg4<T, A, B, C, D, E> withArguments(B b, C c, D d) {
            return new QTypedTaskBuilder5Arg4<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder5Arg5<T, A, B, C, D, E> withArguments(B b, C c, D d, E e) {
            return new QTypedTaskBuilder5Arg5<T, A, B, C, D, E>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d, e);
        }

        public @NonNull QTypedTaskBuilder5Arg1<T, A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder5Arg1<T, A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder4Arg4<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final Callable4<T, A, B, C, D> callable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTypedTaskBuilder4Arg4(int newPriority, QThreadPool threadPool, Callable4<T, A, B, C, D> callable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTypedTaskBuilder4Arg4<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder4Arg4<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder4Arg4.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b, this.c, this.d);
        }

        private static native <T, A, B, C, D> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable4<T, A, B, C, D> var2, A var3, B var4, C var5, D var6);
    }

    public static final class QTypedTaskBuilder4Arg3<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final Callable4<T, A, B, C, D> callable;
        private final A a;
        private final B b;
        private final C c;

        QTypedTaskBuilder4Arg3(int newPriority, QThreadPool threadPool, Callable4<T, A, B, C, D> callable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTypedTaskBuilder4Arg4<T, A, B, C, D> withArguments(D d) {
            return new QTypedTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, this.a, this.b, this.c, d);
        }

        public @NonNull QTypedTaskBuilder4Arg3<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder4Arg3<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder4Arg2<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final Callable4<T, A, B, C, D> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder4Arg2(int newPriority, QThreadPool threadPool, Callable4<T, A, B, C, D> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder4Arg3<T, A, B, C, D> withArguments(C c) {
            return new QTypedTaskBuilder4Arg3<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c);
        }

        public @NonNull QTypedTaskBuilder4Arg4<T, A, B, C, D> withArguments(C c, D d) {
            return new QTypedTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c, d);
        }

        public @NonNull QTypedTaskBuilder4Arg2<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder4Arg2<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder4Arg1<T, A, B, C, D>
    extends QTaskBuilder<T> {
        private final Callable4<T, A, B, C, D> callable;
        private final A a;

        QTypedTaskBuilder4Arg1(int newPriority, QThreadPool threadPool, Callable4<T, A, B, C, D> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder4Arg2<T, A, B, C, D> withArguments(B b) {
            return new QTypedTaskBuilder4Arg2<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder4Arg3<T, A, B, C, D> withArguments(B b, C c) {
            return new QTypedTaskBuilder4Arg3<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, this.a, b, c);
        }

        public @NonNull QTypedTaskBuilder4Arg4<T, A, B, C, D> withArguments(B b, C c, D d) {
            return new QTypedTaskBuilder4Arg4<T, A, B, C, D>(this.priority(), this.threadPool(), this.callable, this.a, b, c, d);
        }

        public @NonNull QTypedTaskBuilder4Arg1<T, A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder4Arg1<T, A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder3Arg3<T, A, B, C>
    extends QTaskBuilder<T> {
        private final Callable3<T, A, B, C> callable;
        private final A a;
        private final B b;
        private final C c;

        QTypedTaskBuilder3Arg3(int newPriority, QThreadPool threadPool, Callable3<T, A, B, C> callable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTypedTaskBuilder3Arg3<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder3Arg3<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder3Arg3.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b, this.c);
        }

        private static native <T, A, B, C> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable3<T, A, B, C> var2, A var3, B var4, C var5);
    }

    public static final class QTypedTaskBuilder3Arg2<T, A, B, C>
    extends QTaskBuilder<T> {
        private final Callable3<T, A, B, C> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder3Arg2(int newPriority, QThreadPool threadPool, Callable3<T, A, B, C> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder3Arg3<T, A, B, C> withArguments(C c) {
            return new QTypedTaskBuilder3Arg3<T, A, B, C>(this.priority(), this.threadPool(), this.callable, this.a, this.b, c);
        }

        public @NonNull QTypedTaskBuilder3Arg2<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder3Arg2<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder3Arg1<T, A, B, C>
    extends QTaskBuilder<T> {
        private final Callable3<T, A, B, C> callable;
        private final A a;

        QTypedTaskBuilder3Arg1(int newPriority, QThreadPool threadPool, Callable3<T, A, B, C> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder3Arg2<T, A, B, C> withArguments(B b) {
            return new QTypedTaskBuilder3Arg2<T, A, B, C>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder3Arg3<T, A, B, C> withArguments(B b, C c) {
            return new QTypedTaskBuilder3Arg3<T, A, B, C>(this.priority(), this.threadPool(), this.callable, this.a, b, c);
        }

        public @NonNull QTypedTaskBuilder3Arg1<T, A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder3Arg1<T, A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTypedTaskBuilder2Arg2<T, A, B>
    extends QTaskBuilder<T> {
        private final Callable2<T, A, B> callable;
        private final A a;
        private final B b;

        QTypedTaskBuilder2Arg2(int newPriority, QThreadPool threadPool, Callable2<T, A, B> callable, A a, B b) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTypedTaskBuilder2Arg2<T, A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder2Arg2<T, A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder2Arg2.spawn(this.threadPool(), this.priority(), this.callable, this.a, this.b);
        }

        private static native <T, A, B> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable2<T, A, B> var2, A var3, B var4);
    }

    public static class QTypedTaskBuilder2Arg1<T, A, B>
    extends QTaskBuilder<T> {
        private final Callable2<T, A, B> callable;
        private final A a;

        QTypedTaskBuilder2Arg1(int newPriority, QThreadPool threadPool, Callable2<T, A, B> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder2Arg2<T, A, B> withArguments(B b) {
            return new QTypedTaskBuilder2Arg2<T, A, B>(this.priority(), this.threadPool(), this.callable, this.a, b);
        }

        public @NonNull QTypedTaskBuilder2Arg1<T, A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder2Arg1<T, A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTypedTaskBuilder1Arg1<T, A>
    extends QTaskBuilder<T> {
        private final Callable1<T, A> callable;
        private final A a;

        QTypedTaskBuilder1Arg1(int newPriority, QThreadPool threadPool, Callable1<T, A> callable, A a) {
            super(newPriority, threadPool);
            this.callable = callable;
            this.a = a;
        }

        public @NonNull QTypedTaskBuilder1Arg1<T, A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTypedTaskBuilder1Arg1<T, A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<T> spawn() {
            return QTypedTaskBuilder1Arg1.spawn(this.threadPool(), this.priority(), this.callable, this.a);
        }

        private static native <T, A> @NonNull QFuture<T> spawn(@Nullable QThreadPool var0, int var1, Callable1<T, A> var2, A var3);
    }

    public static final class QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;
        private final I i;

        QTaskBuilderVoid9Arg9(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
            this.i = i;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid9Arg9.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        private static native <A, B, C, D, E, F, G, H, I> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable9<A, B, C, D, E, F, G, H, I> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10, I var11);
    }

    public static final class QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QTaskBuilderVoid9Arg8(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTaskBuilderVoid9Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTaskBuilderVoid9Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(G g) {
            return new QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(G g, H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(G g, H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTaskBuilderVoid9Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(F f) {
            return new QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(F f, G g) {
            return new QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(F f, G g, H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTaskBuilderVoid9Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(E e) {
            return new QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(E e, F f) {
            return new QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g) {
            return new QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(E e, F f, G g, H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTaskBuilderVoid9Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(D d) {
            return new QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public @NonNull QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(D d, E e) {
            return new QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f) {
            return new QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g) {
            return new QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(D d, E e, F f, G g, H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid9Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withArguments(C c) {
            return new QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public @NonNull QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(C c, D d) {
            return new QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public @NonNull QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e) {
            return new QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f) {
            return new QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(C c, D d, E e, F f, G g, H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I>
    extends QTaskBuilder<Void> {
        private final Runnable9<A, B, C, D, E, F, G, H, I> runnable;
        private final A a;

        QTaskBuilderVoid9Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable9<A, B, C, D, E, F, G, H, I> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I> withArguments(B b) {
            return new QTaskBuilderVoid9Arg2<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I> withArguments(B b, C c) {
            return new QTaskBuilderVoid9Arg3<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public @NonNull QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d) {
            return new QTaskBuilderVoid9Arg4<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e) {
            return new QTaskBuilderVoid9Arg5<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid9Arg6<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid9Arg7<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid9Arg8<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I> withArguments(B b, C c, D d, E e, F f, G g, H h, I i) {
            return new QTaskBuilderVoid9Arg9<A, B, C, D, E, F, G, H, I>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h, i);
        }

        public @NonNull QTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid9Arg1<A, B, C, D, E, F, G, H, I> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;
        private final H h;

        QTaskBuilderVoid8Arg8(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g, H h) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
            this.h = h;
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid8Arg8.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }

        private static native <A, B, C, D, E, F, G, H> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable8<A, B, C, D, E, F, G, H> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9, H var10);
    }

    public static final class QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTaskBuilderVoid8Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTaskBuilderVoid8Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(G g) {
            return new QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(G g, H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTaskBuilderVoid8Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(F f) {
            return new QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(F f, G g) {
            return new QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(F f, G g, H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTaskBuilderVoid8Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(E e) {
            return new QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(E e, F f) {
            return new QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(E e, F f, G g) {
            return new QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(E e, F f, G g, H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTaskBuilderVoid8Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(D d) {
            return new QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public @NonNull QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(D d, E e) {
            return new QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(D d, E e, F f) {
            return new QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g) {
            return new QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid8Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withArguments(C c) {
            return new QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public @NonNull QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(C c, D d) {
            return new QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public @NonNull QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e) {
            return new QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f) {
            return new QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(C c, D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H>
    extends QTaskBuilder<Void> {
        private final Runnable8<A, B, C, D, E, F, G, H> runnable;
        private final A a;

        QTaskBuilderVoid8Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable8<A, B, C, D, E, F, G, H> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H> withArguments(B b) {
            return new QTaskBuilderVoid8Arg2<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H> withArguments(B b, C c) {
            return new QTaskBuilderVoid8Arg3<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public @NonNull QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d) {
            return new QTaskBuilderVoid8Arg4<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e) {
            return new QTaskBuilderVoid8Arg5<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid8Arg6<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid8Arg7<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H> withArguments(B b, C c, D d, E e, F f, G g, H h) {
            return new QTaskBuilderVoid8Arg8<A, B, C, D, E, F, G, H>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g, h);
        }

        public @NonNull QTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid8Arg1<A, B, C, D, E, F, G, H> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;
        private final G g;

        QTaskBuilderVoid7Arg7(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f, G g) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid7Arg7.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        private static native <A, B, C, D, E, F, G> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable7<A, B, C, D, E, F, G> var2, A var3, B var4, C var5, D var6, E var7, F var8, G var9);
    }

    public static final class QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTaskBuilderVoid7Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(G g) {
            return new QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f, g);
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTaskBuilderVoid7Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(F f) {
            return new QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(F f, G g) {
            return new QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f, g);
        }

        public @NonNull QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTaskBuilderVoid7Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(E e) {
            return new QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(E e, F f) {
            return new QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(E e, F f, G g) {
            return new QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTaskBuilderVoid7Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(D d) {
            return new QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public @NonNull QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(D d, E e) {
            return new QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(D d, E e, F f) {
            return new QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(D d, E e, F f, G g) {
            return new QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid7Arg2<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid7Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withArguments(C c) {
            return new QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public @NonNull QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(C c, D d) {
            return new QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public @NonNull QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(C c, D d, E e) {
            return new QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f) {
            return new QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid7Arg1<A, B, C, D, E, F, G>
    extends QTaskBuilder<Void> {
        private final Runnable7<A, B, C, D, E, F, G> runnable;
        private final A a;

        QTaskBuilderVoid7Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable7<A, B, C, D, E, F, G> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid7Arg2<A, B, C, D, E, F, G> withArguments(B b) {
            return new QTaskBuilderVoid7Arg2<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G> withArguments(B b, C c) {
            return new QTaskBuilderVoid7Arg3<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public @NonNull QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G> withArguments(B b, C c, D d) {
            return new QTaskBuilderVoid7Arg4<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e) {
            return new QTaskBuilderVoid7Arg5<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid7Arg6<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G> withArguments(B b, C c, D d, E e, F f, G g) {
            return new QTaskBuilderVoid7Arg7<A, B, C, D, E, F, G>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f, g);
        }

        public @NonNull QTaskBuilderVoid7Arg1<A, B, C, D, E, F, G> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid7Arg1<A, B, C, D, E, F, G> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid6Arg6<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final Runnable6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;
        private final F f;

        QTaskBuilderVoid6Arg6(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e, F f) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid6Arg6.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e, this.f);
        }

        private static native <A, B, C, D, E, F> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable6<A, B, C, D, E, F> var2, A var3, B var4, C var5, D var6, E var7, F var8);
    }

    public static final class QTaskBuilderVoid6Arg5<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final Runnable6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTaskBuilderVoid6Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(F f) {
            return new QTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, this.e, f);
        }

        public @NonNull QTaskBuilderVoid6Arg5<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid6Arg5<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid6Arg4<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final Runnable6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTaskBuilderVoid6Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(E e) {
            return new QTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(E e, F f) {
            return new QTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e, f);
        }

        public @NonNull QTaskBuilderVoid6Arg4<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid6Arg4<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid6Arg3<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final Runnable6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTaskBuilderVoid6Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(D d) {
            return new QTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public @NonNull QTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(D d, E e) {
            return new QTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(D d, E e, F f) {
            return new QTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid6Arg3<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid6Arg3<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid6Arg2<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final Runnable6<A, B, C, D, E, F> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid6Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid6Arg3<A, B, C, D, E, F> withArguments(C c) {
            return new QTaskBuilderVoid6Arg3<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public @NonNull QTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(C c, D d) {
            return new QTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public @NonNull QTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(C c, D d, E e) {
            return new QTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(C c, D d, E e, F f) {
            return new QTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid6Arg2<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid6Arg2<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid6Arg1<A, B, C, D, E, F>
    extends QTaskBuilder<Void> {
        private final Runnable6<A, B, C, D, E, F> runnable;
        private final A a;

        QTaskBuilderVoid6Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable6<A, B, C, D, E, F> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid6Arg2<A, B, C, D, E, F> withArguments(B b) {
            return new QTaskBuilderVoid6Arg2<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid6Arg3<A, B, C, D, E, F> withArguments(B b, C c) {
            return new QTaskBuilderVoid6Arg3<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public @NonNull QTaskBuilderVoid6Arg4<A, B, C, D, E, F> withArguments(B b, C c, D d) {
            return new QTaskBuilderVoid6Arg4<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid6Arg5<A, B, C, D, E, F> withArguments(B b, C c, D d, E e) {
            return new QTaskBuilderVoid6Arg5<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid6Arg6<A, B, C, D, E, F> withArguments(B b, C c, D d, E e, F f) {
            return new QTaskBuilderVoid6Arg6<A, B, C, D, E, F>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e, f);
        }

        public @NonNull QTaskBuilderVoid6Arg1<A, B, C, D, E, F> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid6Arg1<A, B, C, D, E, F> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid5Arg5<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final Runnable5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;
        private final E e;

        QTaskBuilderVoid5Arg5(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public @NonNull QTaskBuilderVoid5Arg5<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid5Arg5<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid5Arg5.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d, this.e);
        }

        private static native <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable5<A, B, C, D, E> var2, A var3, B var4, C var5, D var6, E var7);
    }

    public static final class QTaskBuilderVoid5Arg4<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final Runnable5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTaskBuilderVoid5Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(E e) {
            return new QTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, this.d, e);
        }

        public @NonNull QTaskBuilderVoid5Arg4<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid5Arg4<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid5Arg3<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final Runnable5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTaskBuilderVoid5Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(D d) {
            return new QTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public @NonNull QTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(D d, E e) {
            return new QTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d, e);
        }

        public @NonNull QTaskBuilderVoid5Arg3<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid5Arg3<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid5Arg2<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final Runnable5<A, B, C, D, E> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid5Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid5Arg3<A, B, C, D, E> withArguments(C c) {
            return new QTaskBuilderVoid5Arg3<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public @NonNull QTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(C c, D d) {
            return new QTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public @NonNull QTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(C c, D d, E e) {
            return new QTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid5Arg2<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid5Arg2<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid5Arg1<A, B, C, D, E>
    extends QTaskBuilder<Void> {
        private final Runnable5<A, B, C, D, E> runnable;
        private final A a;

        QTaskBuilderVoid5Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid5Arg2<A, B, C, D, E> withArguments(B b) {
            return new QTaskBuilderVoid5Arg2<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid5Arg3<A, B, C, D, E> withArguments(B b, C c) {
            return new QTaskBuilderVoid5Arg3<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public @NonNull QTaskBuilderVoid5Arg4<A, B, C, D, E> withArguments(B b, C c, D d) {
            return new QTaskBuilderVoid5Arg4<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid5Arg5<A, B, C, D, E> withArguments(B b, C c, D d, E e) {
            return new QTaskBuilderVoid5Arg5<A, B, C, D, E>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d, e);
        }

        public @NonNull QTaskBuilderVoid5Arg1<A, B, C, D, E> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid5Arg1<A, B, C, D, E> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid4Arg4<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final Runnable4<A, B, C, D> runnable;
        private final A a;
        private final B b;
        private final C c;
        private final D d;

        QTaskBuilderVoid4Arg4(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable4<A, B, C, D> runnable, A a, B b, C c, D d) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public @NonNull QTaskBuilderVoid4Arg4<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid4Arg4<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid4Arg4.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c, this.d);
        }

        private static native <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable4<A, B, C, D> var2, A var3, B var4, C var5, D var6);
    }

    public static final class QTaskBuilderVoid4Arg3<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final Runnable4<A, B, C, D> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTaskBuilderVoid4Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable4<A, B, C, D> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTaskBuilderVoid4Arg4<A, B, C, D> withArguments(D d) {
            return new QTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, this.c, d);
        }

        public @NonNull QTaskBuilderVoid4Arg3<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid4Arg3<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid4Arg2<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final Runnable4<A, B, C, D> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid4Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable4<A, B, C, D> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid4Arg3<A, B, C, D> withArguments(C c) {
            return new QTaskBuilderVoid4Arg3<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public @NonNull QTaskBuilderVoid4Arg4<A, B, C, D> withArguments(C c, D d) {
            return new QTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c, d);
        }

        public @NonNull QTaskBuilderVoid4Arg2<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid4Arg2<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTaskBuilderVoid4Arg1<A, B, C, D>
    extends QTaskBuilder<Void> {
        private final Runnable4<A, B, C, D> runnable;
        private final A a;

        QTaskBuilderVoid4Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable4<A, B, C, D> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid4Arg2<A, B, C, D> withArguments(B b) {
            return new QTaskBuilderVoid4Arg2<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid4Arg3<A, B, C, D> withArguments(B b, C c) {
            return new QTaskBuilderVoid4Arg3<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public @NonNull QTaskBuilderVoid4Arg4<A, B, C, D> withArguments(B b, C c, D d) {
            return new QTaskBuilderVoid4Arg4<A, B, C, D>(this.priority(), this.threadPool(), this.runnable, this.a, b, c, d);
        }

        public @NonNull QTaskBuilderVoid4Arg1<A, B, C, D> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid4Arg1<A, B, C, D> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid3Arg3<A, B, C>
    extends QTaskBuilder<Void> {
        private final Runnable3<A, B, C> runnable;
        private final A a;
        private final B b;
        private final C c;

        QTaskBuilderVoid3Arg3(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable3<A, B, C> runnable, A a, B b, C c) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public @NonNull QTaskBuilderVoid3Arg3<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid3Arg3<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid3Arg3.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b, this.c);
        }

        private static native <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable3<A, B, C> var2, A var3, B var4, C var5);
    }

    public static final class QTaskBuilderVoid3Arg2<A, B, C>
    extends QTaskBuilder<Void> {
        private final Runnable3<A, B, C> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid3Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable3<A, B, C> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid3Arg3<A, B, C> withArguments(C c) {
            return new QTaskBuilderVoid3Arg3<A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, this.b, c);
        }

        public @NonNull QTaskBuilderVoid3Arg2<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid3Arg2<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTaskBuilderVoid3Arg1<A, B, C>
    extends QTaskBuilder<Void> {
        private final Runnable3<A, B, C> runnable;
        private final A a;

        QTaskBuilderVoid3Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable3<A, B, C> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid3Arg2<A, B, C> withArguments(B b) {
            return new QTaskBuilderVoid3Arg2<A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid3Arg3<A, B, C> withArguments(B b, C c) {
            return new QTaskBuilderVoid3Arg3<A, B, C>(this.priority(), this.threadPool(), this.runnable, this.a, b, c);
        }

        public @NonNull QTaskBuilderVoid3Arg1<A, B, C> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid3Arg1<A, B, C> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static final class QTaskBuilderVoid2Arg2<A, B>
    extends QTaskBuilder<Void> {
        private final Runnable2<A, B> runnable;
        private final A a;
        private final B b;

        QTaskBuilderVoid2Arg2(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable2<A, B> runnable, A a, B b) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
            this.b = b;
        }

        public @NonNull QTaskBuilderVoid2Arg2<A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid2Arg2<A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid2Arg2.spawn(this.threadPool(), this.priority(), this.runnable, this.a, this.b);
        }

        private static native <A, B> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable2<A, B> var2, A var3, B var4);
    }

    public static class QTaskBuilderVoid2Arg1<A, B>
    extends QTaskBuilder<Void> {
        private final Runnable2<A, B> runnable;
        private final A a;

        QTaskBuilderVoid2Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable2<A, B> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        public @NonNull QTaskBuilderVoid2Arg2<A, B> withArguments(B b) {
            return new QTaskBuilderVoid2Arg2<A, B>(this.priority(), this.threadPool(), this.runnable, this.a, b);
        }

        public @NonNull QTaskBuilderVoid2Arg1<A, B> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        public @NonNull QTaskBuilderVoid2Arg1<A, B> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }
    }

    public static class QTaskBuilderVoid1Arg1<A>
    extends QTaskBuilder<Void> {
        private final Runnable1<A> runnable;
        private final A a;

        QTaskBuilderVoid1Arg1(int newPriority, QThreadPool threadPool, @StrictNonNull Runnable1<A> runnable, A a) {
            super(newPriority, threadPool);
            this.runnable = runnable;
            this.a = a;
        }

        @Override
        public @NonNull QTaskBuilderVoid1Arg1<A> withPriority(int newPriority) {
            super.withPriority(newPriority);
            return this;
        }

        @Override
        public @NonNull QTaskBuilderVoid1Arg1<A> onThreadPool(@Nullable QThreadPool newThreadPool) {
            super.onThreadPool(newThreadPool);
            return this;
        }

        @Override
        public @NonNull QFuture<@QtPrimitiveType Void> spawn() {
            return QTaskBuilderVoid1Arg1.spawn(this.threadPool(), this.priority(), this.runnable, this.a);
        }

        private static native <A> @NonNull QFuture<@QtPrimitiveType Void> spawn(@Nullable QThreadPool var0, int var1, Runnable1<A> var2, A var3);
    }

    public static abstract class QTypedTaskBuilder<T>
    extends QTaskBuilder<T> {
        QTypedTaskBuilder(int priority, QThreadPool threadPool) {
            super(priority, threadPool);
        }
    }

    public static abstract class QTaskBuilder<T> {
        private int priority;
        private QThreadPool threadPool;

        QTaskBuilder(int priority, QThreadPool threadPool) {
            this.priority = priority;
            this.threadPool = threadPool;
        }

        final int priority() {
            return this.priority;
        }

        final @Nullable QThreadPool threadPool() {
            return this.threadPool;
        }

        public @NonNull QFuture<T> spawn() {
            throw new RuntimeException("Unable to spawn due to missing arguments.");
        }

        public final void spawn(FutureResult result) {
            this.spawn();
        }

        public @NonNull QTaskBuilder<T> withPriority(int newPriority) {
            this.priority = newPriority;
            return this;
        }

        public @NonNull QTaskBuilder<T> onThreadPool(@Nullable QThreadPool newThreadPool) {
            this.threadPool = Objects.requireNonNull(newThreadPool);
            return this;
        }
    }

    public static enum ThreadFunctionResult implements QtEnumerator
    {
        ThrottleThread(0),
        ThreadFinished(1);

        private final int value;

        private ThreadFunctionResult(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static ThreadFunctionResult resolve(int value) {
            switch (value) {
                case 0: {
                    return ThrottleThread;
                }
                case 1: {
                    return ThreadFinished;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static enum FutureResult implements QtEnumerator
    {
        Ignore(0);

        private final int value;

        private FutureResult(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static FutureResult resolve(int value) {
            switch (value) {
                case 0: {
                    return Ignore;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }
}

