package io.qt.concurrent;

import io.qt.core.*;

/**
 * <p>High-level APIs that make it possible to write multi-threaded programs without using low-level threading primitives</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qtconcurrent.html">QtConcurrent</a></p>
 */
public final class QtConcurrent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtConcurrent() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtConcurrent."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qtconcurrent.html#ReduceOption-enum">QtConcurrent::ReduceOption</a></p>
     * 
     * @see ReduceOptions
     */
    public enum ReduceOption implements io.qt.QtFlagEnumerator {
        UnorderedReduce(1),
        OrderedReduce(2),
        SequentialReduce(4);

        private ReduceOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ReduceOptions asFlags() {
            return new ReduceOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ReduceOptions combined(ReduceOption e) {
            return new ReduceOptions(this, e);
        }

        /**
         * Creates a new {@link ReduceOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ReduceOptions flags(ReduceOption ... values) {
            return new ReduceOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ReduceOption resolve(int value) {
            switch (value) {
            case 1: return UnorderedReduce;
            case 2: return OrderedReduce;
            case 4: return SequentialReduce;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ReduceOption}
     */
    public static final class ReduceOptions extends io.qt.QFlags<ReduceOption> implements Comparable<ReduceOptions> {
        private static final long serialVersionUID = 0xbac37fef682db11eL;

        /**
         * Creates a new ReduceOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ReduceOptions(ReduceOption ... args){
            super(args);
        }

        /**
         * Creates a new ReduceOptions with given <code>value</code>.
         * @param value
         */
        public ReduceOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ReduceOptions
         */
        @Override
        public final ReduceOptions combined(ReduceOption e){
            return new ReduceOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ReduceOptions setFlag(ReduceOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ReduceOptions setFlag(ReduceOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ReduceOptions.
         * @return array of enum entries
         */
        @Override
        public final ReduceOption[] flags(){
            return super.flags(ReduceOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ReduceOptions clone(){
            return new ReduceOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ReduceOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QtConcurrent::ThreadFunctionResult</p>
     */
    public enum ThreadFunctionResult implements io.qt.QtEnumerator {
        ThrottleThread(0),
        ThreadFinished(1);

        private ThreadFunctionResult(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ThreadFunctionResult resolve(int value) {
            switch (value) {
            case 0: return ThrottleThread;
            case 1: return ThreadFinished;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt class QtConcurrent::MedianDouble</p>
     */
    public static class MedianDouble extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public MedianDouble(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(MedianDouble instance);
        
        @io.qt.QtUninvokable
        public final void addValue(double value){
            addValue_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        
        @io.qt.QtUninvokable
        private native void addValue_native_double(long __this__nativeId, double value);
        
        @io.qt.QtUninvokable
        public final boolean isMedianValid(){
            return isMedianValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isMedianValid_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final double median(){
            return median_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native double median_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void reset(){
            reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native void reset_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected MedianDouble(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * An implemetation of this interface is given one to QtConcurrent's map() methods.
     * The map() method of this interface is called for each object in a java.util.Collection.
     *
     */
    @FunctionalInterface
    public interface MapFunctor<T> {
    
        /**
         * This function is called for each item in the Collection. The function is then free to alter <code>object</code> as it see fit.
         */
        @io.qt.NativeAccess
        public void map(T object);
    }
    /**
     *  Calls function once for each item in sequence. The function is passed a reference to the item, so that any modifications done to the item will appear in sequence.
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<Void> map(java.util.Collection<T> sequence, MapFunctor<T> functor){
        java.util.Objects.requireNonNull(sequence);
        return _map(null, sequence, java.util.Objects.requireNonNull(functor));
    }
    
    @io.qt.QtUninvokable
    private static native <T> QFuture<Void> _map(QThreadPool threadPool, java.util.Collection<T> sequence, MapFunctor<T> functor);
    
    /**
     *  Calls function once for each item in sequence. The function is passed a reference to the item, so that any modifications done to the item will appear in sequence.
     */
    @io.qt.QtUninvokable
    public static <T> void blockingMap(java.util.Collection<T> sequence, MapFunctor<T> functor){
        java.util.Objects.requireNonNull(sequence);
        _blockingMap(null, sequence, java.util.Objects.requireNonNull(functor));
    }
    
    @io.qt.QtUninvokable
    private static native <T> void _blockingMap(QThreadPool threadPool, java.util.Collection<T> sequence, MapFunctor<T> functor);
    
    /**
     * Implement this interface to perform a mapped operation. An implementation of the interface is sendt
     * to ome of the mapped methods of QtConcurrent, which applies the MappedFunctor.map() method to all elements in a collection,
     * and returns the result.
     */
    @FunctionalInterface
    public interface MappedFunctor<U, T> {
    
        /**
         * This method is called for each object in a collection. It should returned a new altered
         * object.
         */
        @io.qt.NativeAccess
        public U map(T object);
    }
    
    /**
     * Calls function once for each item in sequence and returns a future with each mapped item as a result. You can QFutureIterator to iterate through the results.
     *
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> mapped(java.util.Collection<T> sequence, MappedFunctor<U, T> functor){
        java.util.Objects.requireNonNull(sequence);
        return _mapped(null, sequence, java.util.Objects.requireNonNull(functor));
    }
    
    @io.qt.QtUninvokable
    private static native <U, T> QFuture<U> _mapped(QThreadPool threadPool, java.util.Collection<T> sequence, MappedFunctor<U, T> functor);
    
    /**
     * Calls function once for each item in sequence and returns a future with each mapped item as a result. You can QFutureIterator to iterate through the results.
     */
    @io.qt.QtUninvokable
    public static <U, T> java.util.List<U> blockingMapped(java.util.Collection<T> sequence, MappedFunctor<U, T> functor){
        java.util.Objects.requireNonNull(sequence);
        return _blockingMapped(null, sequence, java.util.Objects.requireNonNull(functor));
    }
    
    @io.qt.QtUninvokable
    private static native <U, T> java.util.List<U> _blockingMapped(QThreadPool threadPool, java.util.Collection<T> sequence, MappedFunctor<U, T> functor);
    
    /**
     * Implement this interface in order to perform a reduce operation.
     * <p>
     * The reduce method will be called once per intermediate result (the result of the mapping of the data)
     * and the very first time the reduce() method is called for the particular data set, the result is set to
     * the returned value of the defaultResult() method.
     */
    @FunctionalInterface
    public interface ReducedFunctor<U, T> {
        @io.qt.NativeAccess
        public default U defaultResult() { return null; }
    
        /**
         *  Performs a reduce operation on <code>intermediate</code>. <code>result</code> is the result of the reduction.
         */
        @io.qt.NativeAccess
        public void reduce(U result, T intermediate);
    }
    
    /**
     * This is an overloaded method provided for convenience.
     * <p>
     * It is equivalent of mappedReduced(sequence, functor, reducedFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce)
     */
    @io.qt.QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor) {
        return mappedReduced(sequence, functor, reducedFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }
    
    
    /**
     * This is an overloaded method provided for convenience.
     * <p>
     * Note that while mapFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is determined by reduceOptions.
     *
     */
    @io.qt.QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor, ReduceOption ... options) {
        return mappedReduced(sequence, functor, reducedFunctor, new ReduceOptions(options));
    }
    
    /**
     * Calls mapFunction once for each item in sequence. The return value of each mapFunction is passed to reduceFunction.
     * <p>
     * Note that while mapFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is determined by reduceOptions.
     *
     */
    @io.qt.QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor, ReduceOptions options) {
        java.util.Objects.requireNonNull(sequence);
        return _mappedReduced(null, sequence, java.util.Objects.requireNonNull(functor), java.util.Objects.requireNonNull(reducedFunctor), options.value());
    }
    
    @io.qt.QtUninvokable
    private native static <U, V, T> QFuture<U> _mappedReduced(QThreadPool threadPool, java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor, int options);
    
    
    /**
     * This is an overloaded method provided for convenience.
     * <p>
     * It is equivalent of calling blockingMappedReduced(sequence, functor, reducedFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce)
     *
     */
    @io.qt.QtUninvokable
    public static <U, V, T> U blockingMappedReduced(java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor) {
        return blockingMappedReduced(sequence, functor, reducedFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }
    
    /**
     * Calls mapFunction once for each item in sequence. The return value of each mapFunction is passed to reduceFunction.
     * <p>
     * Note that while mapFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is determined by reduceOptions.
     * <p>
     * Note: This function will block until all items in the sequence have been processed.
     */
    @io.qt.QtUninvokable
    public static <U, V, T> U blockingMappedReduced(java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor, ReduceOption ... options) {
        return blockingMappedReduced(sequence, functor, reducedFunctor, new ReduceOptions(options));
    }
    
    /**
     * Calls mapFunction once for each item in sequence. The return value of each mapFunction is passed to reduceFunction.
     * <p>
     * Note that while mapFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is determined by reduceOptions.
     * <p>
     * Note: This function will block until all items in the sequence have been processed.
     */
    @io.qt.QtUninvokable
    public static <U, V, T> U blockingMappedReduced(java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor, ReduceOptions options) {
        return _blockingMappedReduced(null, java.util.Objects.requireNonNull(sequence), java.util.Objects.requireNonNull(functor), java.util.Objects.requireNonNull(reducedFunctor), options.value());
    }
    
    @io.qt.QtUninvokable
    private native static <U, V, T> U _blockingMappedReduced(QThreadPool threadPool, java.util.Collection<T> sequence, MappedFunctor<V, T> functor, ReducedFunctor<U, V> reducedFunctor, int options);
    
    /**
     * An implementation of this interface is given to one of QtConcurrent's filtered() methods.
     * The filter method if this interface is called for each item in a java.util.Collection.
     *
     */
    public interface FilteredFunctor<T> {
    
        /**
         *  This method is called for each item in a java.util.Collection. The items for which
         *  this method returns true are removed from the collection.
         */
        public boolean filter(T object);
    }
    
    /**
     * Calls filterFunctor's filter() method once for each item in sequence and returns a new Sequence of kept items. If filterFunction returns true, a copy of the item is put in the new Sequence. Otherwise, the item will not appear in the new Sequence.
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<Void> filter(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        return _filter(null, java.util.Objects.requireNonNull(sequence), filteredFunctor);
    }
    
    @io.qt.QtUninvokable
    private native static <T> QFuture<Void> _filter(QThreadPool threadPool, java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor);
    
    /**
     * Calls filterFunctor's filter() method once for each item in sequence and returns a new Sequence of kept items. If filterFunction returns true, a copy of the item is put in the new Sequence. Otherwise, the item will not appear in the new Sequence.
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<T> filtered(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        return _filtered(null, java.util.Objects.requireNonNull(sequence), java.util.Objects.requireNonNull(filteredFunctor));
    }
    
    @io.qt.QtUninvokable
    private native static <T> QFuture<T> _filtered(QThreadPool threadPool, java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor);
    
    /**
     * Calls filterFunctor's filter() method once for each item in sequence and returns a new Sequence of kept items. If filterFunction returns true, a copy of the item is put in the new Sequence. Otherwise, the item will not appear in the new Sequence.
     */
    @io.qt.QtUninvokable
    public static <T> java.util.List<T> blockingFiltered(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        return _blockingFiltered(null, java.util.Objects.requireNonNull(sequence), java.util.Objects.requireNonNull(filteredFunctor));
    }
    
    @io.qt.QtUninvokable
    private native static <T> java.util.List<T> _blockingFiltered(QThreadPool threadPool, java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor);
    
    /**
     * Calls filterFunction once for each item in sequence. If filterFunction returns true, the item is kept in sequence; otherwise, the item is removed from sequence.
     * Note: This function will block until all items in the sequence have been processed.
     */
    @io.qt.QtUninvokable
    public static <T> void blockingFilter(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        _blockingFilter(null, java.util.Objects.requireNonNull(sequence), java.util.Objects.requireNonNull(filteredFunctor));
    }
    
    @io.qt.QtUninvokable
    private native static <T> void _blockingFilter(QThreadPool threadPool, java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor);
    
    /**
     * This is an overloaded method provided for convenience. It is equivalent of calling filteredReduced(sequence, filteredFunctor, ReduceOption.UnorderedReduce, ReduceOption.Seq This is an overloaded method provided for convenience. It is equivalent of calling filteredReduced)
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor) {
        return filteredReduced(sequence, filteredFunctor, reducedFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }
    
    /**
     * Calls filterFunction once for each item in sequence. If filterFunction returns true for an item, that item is then passed to reduceFunction. In other words, the return value is the result of reduceFunction for each item where filterFunction returns true.
     * <p>
     * Note that while filterFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is undefined if reduceOptions is QtConcurrent::UnorderedReduce. If reduceOptions is QtConcurrent::OrderedReduce, reduceFunction is called in the order of the original sequence.
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor, ReduceOption ... options) {
        return filteredReduced(sequence, filteredFunctor, reducedFunctor, new ReduceOptions(options));
    }
    
    /**
     * Calls filterFunction once for each item in sequence. If filterFunction returns true for an item, that item is then passed to reduceFunction. In other words, the return value is the result of reduceFunction for each item where filterFunction returns true.
     * <p>
     * Note that while filterFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is undefined if reduceOptions is QtConcurrent::UnorderedReduce. If reduceOptions is QtConcurrent::OrderedReduce, reduceFunction is called in the order of the original sequence.
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor, ReduceOptions options) {
        return _filteredReduced(null, java.util.Objects.requireNonNull(sequence), java.util.Objects.requireNonNull(filteredFunctor), java.util.Objects.requireNonNull(reducedFunctor), options.value());
    }
    @io.qt.QtUninvokable
    private native static <U, T> QFuture<U> _filteredReduced(QThreadPool threadPool, java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor, int options);
    
    /**
     * This is an overloaded method provided for convenience. It is the equivalent of calling blockingFilteredReduced(sequence, filteredFunctor, reducedFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce)
     */
    @io.qt.QtUninvokable
    public static <U, T> U blockingFilteredReduced(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor) {
        return blockingFilteredReduced(sequence, filteredFunctor, reducedFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }
    
    /**
     * Calls filterFunction once for each item in sequence. If filterFunction returns true for an item, that item is then passed to reduceFunction. In other words, the return value is the result of reduceFunction for each item where filterFunction returns true.
     * <p>
     * Note that while filterFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is undefined if reduceOptions is QtConcurrent::UnorderedReduce. If reduceOptions is QtConcurrent::OrderedReduce, reduceFunction is called in the order of the original sequence.
     */
    @io.qt.QtUninvokable
    public static <U, T> U blockingFilteredReduced(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor, ReduceOption ... options) {
        return blockingFilteredReduced(sequence, filteredFunctor, reducedFunctor, new ReduceOptions(options));
    }
    
    /**
     * Calls filterFunction once for each item in sequence. If filterFunction returns true for an item, that item is then passed to reduceFunction. In other words, the return value is the result of reduceFunction for each item where filterFunction returns true.
     * <p>
     * Note that while filterFunction is called concurrently, only one thread at a time will call reduceFunction. The order in which reduceFunction is called is undefined if reduceOptions is QtConcurrent::UnorderedReduce. If reduceOptions is QtConcurrent::OrderedReduce, reduceFunction is called in the order of the original sequence.
     */
    @io.qt.QtUninvokable
    public static <U, T> U blockingFilteredReduced(java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor, ReduceOptions options) {
        return _blockingFilteredReduced(null, java.util.Objects.requireNonNull(sequence), java.util.Objects.requireNonNull(filteredFunctor), java.util.Objects.requireNonNull(reducedFunctor), options.value());
    }
    
    @io.qt.QtUninvokable
    private native static <U, T> U _blockingFilteredReduced(QThreadPool threadPool, java.util.Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReducedFunctor<U, T> reducedFunctor, int options);
    
    /**
     * Executes the Callable <code>callable</code> through the QtConcurrent framework. The returned QFuture object's result will be the
     * return value of <code>callable</code>.
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<T> run(java.util.concurrent.Callable<T> callable){
        return run0(null, java.util.Objects.requireNonNull(callable));
    }
    
    /**
     * Executes the Callable <code>callable</code> through the QtConcurrent framework. The thread is taken from the QThreadPool pool. 
     * The returned QFuture object's result will be the return value of <code>callable</code>.
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<T> run(QThreadPool threadPool, java.util.concurrent.Callable<T> callable){
        return run0(threadPool, java.util.Objects.requireNonNull(callable));
    }
    @io.qt.QtUninvokable
    private native static <T> QFuture<T> run0(QThreadPool threadPool, java.util.concurrent.Callable<T> callable);
    
    /**
     * Executes the Runnable <code>Void</code> using the QtConcurrent framework.
     */
    @io.qt.QtUninvokable
    public static QFuture<Void> run(Runnable runnable) {
        return runVoid0(null, java.util.Objects.requireNonNull(runnable));
    }
    
    /**
     * Executes the Runnable <code>Void</code> using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    @io.qt.QtUninvokable
    public static QFuture<Void> run(QThreadPool threadPool, Runnable runnable) {
        return runVoid0(threadPool, java.util.Objects.requireNonNull(runnable));
    }
    @io.qt.QtUninvokable
    private native static QFuture<Void> runVoid0(QThreadPool threadPool, Runnable runnable);
    
    @FunctionalInterface
    public interface Runnable1<A>{
        public void run(A a);
    }
    
    @FunctionalInterface
    public interface Runnable2<A,B>{
        public void run(A a, B b);
    }
    
    @FunctionalInterface
    public interface Runnable3<A,B,C>{
        public void run(A a, B b, C c);
    }
    
    @FunctionalInterface
    public interface Runnable4<A,B,C,D>{
        public void run(A a, B b, C c, D d);
    }
    
    @FunctionalInterface
    public interface Runnable5<A,B,C,D,E>{
        public void run(A a, B b, C c, D d, E e);
    }
    
    /**
     * Executes the Runnable using the QtConcurrent framework.
     */
    public static <A> QFuture<Void> run(Runnable1<A> runnable, A a) {
        return runVoid1(null, runnable, a);
    }
    /**
     * Executes the Runnable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <A> QFuture<Void> run(QThreadPool threadPool, Runnable1<A> runnable, A a) {
        return runVoid1(threadPool, java.util.Objects.requireNonNull(runnable), a);
    }
    private native static <A> QFuture<Void> runVoid1(QThreadPool threadPool, Runnable1<A> runnable, A a);
    
    /**
     * Executes the Runnable using the QtConcurrent framework.
     */
    public static <A,B> QFuture<Void> run(Runnable2<A,B> runnable, A a, B b) {
        return runVoid2(null, java.util.Objects.requireNonNull(runnable), a, b);
    }
    /**
     * Executes the Runnable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <A,B> QFuture<Void> run(QThreadPool threadPool, Runnable2<A,B> runnable, A a, B b) {
        return runVoid2(threadPool, java.util.Objects.requireNonNull(runnable), a, b);
    }
    private native static <A,B> QFuture<Void> runVoid2(QThreadPool threadPool, Runnable2<A,B> runnable, A a, B b);
    
    /**
     * Executes the Runnable using the QtConcurrent framework.
     */
    public static <A,B,C> QFuture<Void> run(Runnable3<A,B,C> runnable, A a, B b, C c) {
        return runVoid3(null, java.util.Objects.requireNonNull(runnable), a, b, c);
    }
    /**
     * Executes the Runnable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <A,B,C> QFuture<Void> run(QThreadPool threadPool, Runnable3<A,B,C> runnable, A a, B b, C c) {
        return runVoid3(threadPool, java.util.Objects.requireNonNull(runnable), a, b, c);
    }
    private native static <A,B,C> QFuture<Void> runVoid3(QThreadPool threadPool, Runnable3<A,B,C> runnable, A a, B b, C c);
    
    /**
     * Executes the Runnable using the QtConcurrent framework.
     */
    public static <A,B,C,D> QFuture<Void> run(Runnable4<A,B,C,D> runnable, A a, B b, C c, D d) {
        return runVoid4(null, java.util.Objects.requireNonNull(runnable), a, b, c, d);
    }
    /**
     * Executes the Runnable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <A,B,C,D> QFuture<Void> run(QThreadPool threadPool, Runnable4<A,B,C,D> runnable, A a, B b, C c, D d) {
        return runVoid4(threadPool, java.util.Objects.requireNonNull(runnable), a, b, c, d);
    }
    private native static <A,B,C,D> QFuture<Void> runVoid4(QThreadPool threadPool, Runnable4<A,B,C,D> runnable, A a, B b, C c, D d);
    
    /**
     * Executes the Runnable using the QtConcurrent framework.
     */
    public static <A,B,C,D,E> QFuture<Void> run(Runnable5<A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return runVoid5(null, java.util.Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    /**
     * Executes the Runnable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <A,B,C,D,E> QFuture<Void> run(QThreadPool threadPool, Runnable5<A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return runVoid5(threadPool, java.util.Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    private native static <A,B,C,D,E> QFuture<Void> runVoid5(QThreadPool threadPool, Runnable5<A,B,C,D,E> runnable, A a, B b, C c, D d, E e);
    
    
    
    @FunctionalInterface
    public interface Callable1<T,A>{
        public T call(A a);
    }
    
    @FunctionalInterface
    public interface Callable2<T,A,B>{
        public T call(A a, B b);
    }
    
    @FunctionalInterface
    public interface Callable3<T,A,B,C>{
        public T call(A a, B b, C c);
    }
    
    @FunctionalInterface
    public interface Callable4<T,A,B,C,D>{
        public T call(A a, B b, C c, D d);
    }
    
    @FunctionalInterface
    public interface Callable5<T,A,B,C,D,E>{
        public T call(A a, B b, C c, D d, E e);
    }
    
    /**
     * Executes the Callable using the QtConcurrent framework.
     */
    public static <T,A> QFuture<T> run(Callable1<T,A> runnable, A a) {
        return run1(null, java.util.Objects.requireNonNull(runnable), a);
    }
    /**
     * Executes the Callable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <T,A> QFuture<T> run(QThreadPool threadPool, Callable1<T,A> runnable, A a) {
        return run1(threadPool, java.util.Objects.requireNonNull(runnable), a);
    }
    private native static <T,A> QFuture<T> run1(QThreadPool threadPool, Callable1<T,A> runnable, A a);
    
    /**
     * Executes the Callable using the QtConcurrent framework.
     */
    public static <T,A,B> QFuture<T> run(Callable2<T,A,B> runnable, A a, B b) {
        return run2(null, java.util.Objects.requireNonNull(runnable), a, b);
    }
    /**
     * Executes the Callable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <T,A,B> QFuture<T> run(QThreadPool threadPool, Callable2<T,A,B> runnable, A a, B b) {
        return run2(threadPool, java.util.Objects.requireNonNull(runnable), a, b);
    }
    private native static <T,A,B> QFuture<T> run2(QThreadPool threadPool, Callable2<T,A,B> runnable, A a, B b);
    
    /**
     * Executes the Callable using the QtConcurrent framework.
     */
    public static <T,A,B,C> QFuture<T> run(Callable3<T,A,B,C> runnable, A a, B b, C c) {
        return run3(null, java.util.Objects.requireNonNull(runnable), a, b, c);
    }
    /**
     * Executes the Callable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <T,A,B,C> QFuture<T> run(QThreadPool threadPool, Callable3<T,A,B,C> runnable, A a, B b, C c) {
        return run3(threadPool, java.util.Objects.requireNonNull(runnable), a, b, c);
    }
    private native static <T,A,B,C> QFuture<T> run3(QThreadPool threadPool, Callable3<T,A,B,C> runnable, A a, B b, C c);
    
    /**
     * Executes the Callable using the QtConcurrent framework.
     */
    public static <T,A,B,C,D> QFuture<T> run(Callable4<T,A,B,C,D> runnable, A a, B b, C c, D d) {
        return run4(null, java.util.Objects.requireNonNull(runnable), a, b, c, d);
    }
    /**
     * Executes the Callable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <T,A,B,C,D> QFuture<T> run(QThreadPool threadPool, Callable4<T,A,B,C,D> runnable, A a, B b, C c, D d) {
        return run4(threadPool, java.util.Objects.requireNonNull(runnable), a, b, c, d);
    }
    private native static <T,A,B,C,D> QFuture<T> run4(QThreadPool threadPool, Callable4<T,A,B,C,D> runnable, A a, B b, C c, D d);
    
    /**
     * Executes the Callable using the QtConcurrent framework.
     */
    public static <T,A,B,C,D,E> QFuture<T> run(Callable5<T,A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return run5(null, java.util.Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    /**
     * Executes the Callable using the QtConcurrent framework. The thread is taken from the QThreadPool pool.
     */
    public static <T,A,B,C,D,E> QFuture<T> run(QThreadPool threadPool, Callable5<T,A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return run5(threadPool, java.util.Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    private native static <T,A,B,C,D,E> QFuture<T> run5(QThreadPool threadPool, Callable5<T,A,B,C,D,E> runnable, A a, B b, C c, D d, E e);
}
