/*
 * Decompiled with CFR 0.152.
 */
package io.qt.concurrent;

import io.qt.NonNull;
import io.qt.Nullable;
import io.qt.QFlags;
import io.qt.QNoSuchEnumValueException;
import io.qt.QtAbstractFlagEnumerator;
import io.qt.QtEnumerator;
import io.qt.QtFlagEnumerator;
import io.qt.QtObject;
import io.qt.QtPrimitiveType;
import io.qt.QtUninvokable;
import io.qt.StrictNonNull;
import io.qt.concurrent.QtJambi_LibraryUtilities;
import io.qt.core.QFuture;
import io.qt.core.QList;
import io.qt.core.QMetaType;
import io.qt.core.QThreadPool;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;

public final class QtConcurrent {
    private QtConcurrent() throws InstantiationError {
        throw new InstantiationError("Cannot instantiate namespace QtConcurrent.");
    }

    @QtUninvokable
    private static <U> U computeDefaultResult(ReduceFunctor<U, ?> functor) {
        int[] types = QtJambi_LibraryUtilities.internal.lambdaMetaTypes(ReduceFunctor.class, functor);
        if (types != null && types.length > 0) {
            return (U)new QMetaType(types[0]).create();
        }
        return null;
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<@QtPrimitiveType Void> map(@StrictNonNull Collection<T> sequence, MapFunctor<T> functor) {
        return QtConcurrent.startMap(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }

    @QtUninvokable
    public static <T> void blockingMap(@StrictNonNull Collection<T> sequence, MapFunctor<T> functor) {
        QFuture<@QtPrimitiveType Void> future = QtConcurrent.map(sequence, functor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> mapped(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        return QtConcurrent.startMapped(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> @NonNull QList<U> blockingMapped(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        QFuture<U> future = QtConcurrent.mapped(sequence, functor);
        return future.results();
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull QFuture<U> mappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<@QtPrimitiveType Void> filter(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.filter(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }

    @QtUninvokable
    public static <T> void blockingFilter(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        QFuture<@QtPrimitiveType Void> future = QtConcurrent.filter(sequence, filteredFunctor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<T> filtered(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.startFiltered(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor)).startAsynchronously();
    }

    @QtUninvokable
    public static <T> @NonNull QList<T> blockingFiltered(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        QFuture<T> future = QtConcurrent.filtered(sequence, filteredFunctor);
        return future.results();
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull QFuture<U> filteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor) {
        QFuture<U> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        QFuture<U> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        QFuture<U> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    private static native <T> @NonNull QFuture<@QtPrimitiveType Void> filter(long var0, Collection<T> var2, @StrictNonNull FilteredFunctor<T> var3);

    @QtUninvokable
    private static native <T> @NonNull ThreadEngineStarter<@QtPrimitiveType Void> startMap(long var0, Collection<T> var2, MapFunctor<T> var3);

    @QtUninvokable
    private static native <U, T> @NonNull ThreadEngineStarter<U> startMapped(long var0, Collection<T> var2, @StrictNonNull MappedFunctor<U, T> var3);

    @QtUninvokable
    private static native <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(long var0, Collection<T> var2, @StrictNonNull MappedFunctor<V, T> var3, @StrictNonNull ReduceFunctor<U, V> var4, U var5, int var6);

    @QtUninvokable
    private static native <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(long var0, Collection<T> var2, @StrictNonNull FilteredFunctor<T> var3, @StrictNonNull ReduceFunctor<U, T> var4, U var5, int var6);

    @QtUninvokable
    private static native <T> @NonNull ThreadEngineStarter<T> startFiltered(long var0, Collection<T> var2, @StrictNonNull FilteredFunctor<T> var3);

    @QtUninvokable
    public static <T> @NonNull QFuture<T> run(@StrictNonNull Callable<T> callable) {
        return QtConcurrent.run0(null, Objects.requireNonNull(callable));
    }

    @QtUninvokable
    public static <T> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable<T> callable) {
        return QtConcurrent.run0(threadPool, Objects.requireNonNull(callable));
    }

    @QtUninvokable
    private static native <T> @NonNull QFuture<T> run0(@Nullable QThreadPool var0, @StrictNonNull Callable<T> var1);

    @QtUninvokable
    public static @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable runnable) {
        return QtConcurrent.runVoid0(null, Objects.requireNonNull(runnable));
    }

    @QtUninvokable
    public static @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable runnable) {
        return QtConcurrent.runVoid0(threadPool, Objects.requireNonNull(runnable));
    }

    @QtUninvokable
    private static native @NonNull QFuture<@QtPrimitiveType Void> runVoid0(@Nullable QThreadPool var0, @StrictNonNull Runnable var1);

    @QtUninvokable
    public static <A> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable1<A> runnable, A a) {
        return QtConcurrent.runVoid1(null, runnable, a);
    }

    @QtUninvokable
    public static <A> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable1<A> runnable, A a) {
        return QtConcurrent.runVoid1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <A> @NonNull QFuture<@QtPrimitiveType Void> runVoid1(@Nullable QThreadPool var0, @StrictNonNull Runnable1<A> var1, A var2);

    @QtUninvokable
    public static <A, B> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable2<A, B> runnable, A a, B b) {
        return QtConcurrent.runVoid2(null, Objects.requireNonNull(runnable), a, b);
    }

    @QtUninvokable
    public static <A, B> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable2<A, B> runnable, A a, B b) {
        return QtConcurrent.runVoid2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <A, B> @NonNull QFuture<@QtPrimitiveType Void> runVoid2(@Nullable QThreadPool var0, @StrictNonNull Runnable2<A, B> var1, A var2, B var3);

    @QtUninvokable
    public static <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runVoid3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    @QtUninvokable
    public static <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runVoid3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <A, B, C> @NonNull QFuture<@QtPrimitiveType Void> runVoid3(@Nullable QThreadPool var0, @StrictNonNull Runnable3<A, B, C> var1, A var2, B var3, C var4);

    @QtUninvokable
    public static <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runVoid4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    @QtUninvokable
    public static <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runVoid4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <A, B, C, D> @NonNull QFuture<@QtPrimitiveType Void> runVoid4(@Nullable QThreadPool var0, @StrictNonNull Runnable4<A, B, C, D> var1, A var2, B var3, C var4, D var5);

    @QtUninvokable
    public static <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> run(@StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runVoid5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    @QtUninvokable
    public static <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> run(@Nullable QThreadPool threadPool, @StrictNonNull Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runVoid5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <A, B, C, D, E> @NonNull QFuture<@QtPrimitiveType Void> runVoid5(@Nullable QThreadPool var0, @StrictNonNull Runnable5<A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    @QtUninvokable
    public static <T, A> @NonNull QFuture<T> run(@StrictNonNull Callable1<T, A> runnable, A a) {
        return QtConcurrent.run1(null, Objects.requireNonNull(runnable), a);
    }

    @QtUninvokable
    public static <T, A> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable1<T, A> runnable, A a) {
        return QtConcurrent.run1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <T, A> @NonNull QFuture<T> run1(@Nullable QThreadPool var0, Callable1<T, A> var1, A var2);

    @QtUninvokable
    public static <T, A, B> @NonNull QFuture<T> run(@StrictNonNull Callable2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.run2(null, Objects.requireNonNull(runnable), a, b);
    }

    @QtUninvokable
    public static <T, A, B> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.run2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <T, A, B> @NonNull QFuture<T> run2(@Nullable QThreadPool var0, Callable2<T, A, B> var1, A var2, B var3);

    @QtUninvokable
    public static <T, A, B, C> @NonNull QFuture<T> run(@StrictNonNull Callable3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.run3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    @QtUninvokable
    public static <T, A, B, C> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.run3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <T, A, B, C> @NonNull QFuture<T> run3(@Nullable QThreadPool var0, Callable3<T, A, B, C> var1, A var2, B var3, C var4);

    @QtUninvokable
    public static <T, A, B, C, D> @NonNull QFuture<T> run(@StrictNonNull Callable4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.run4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    @QtUninvokable
    public static <T, A, B, C, D> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.run4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <T, A, B, C, D> @NonNull QFuture<T> run4(@Nullable QThreadPool var0, Callable4<T, A, B, C, D> var1, A var2, B var3, C var4, D var5);

    @QtUninvokable
    public static <T, A, B, C, D, E> @NonNull QFuture<T> run(@StrictNonNull Callable5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.run5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    @QtUninvokable
    public static <T, A, B, C, D, E> @NonNull QFuture<T> run(@Nullable QThreadPool threadPool, @StrictNonNull Callable5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.run5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <T, A, B, C, D, E> @NonNull QFuture<T> run5(@Nullable QThreadPool var0, Callable5<T, A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    @QtUninvokable
    public static <T> @NonNull ThreadEngineStarter<@QtPrimitiveType Void> startMap(@StrictNonNull Collection<T> sequence, MapFunctor<T> functor) {
        return QtConcurrent.startMap(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startMapped(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<U, T> functor) {
        return QtConcurrent.startMapped(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startMappedReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value());
    }

    @QtUninvokable
    public static <U, V, T> @NonNull ThreadEngineStarter<U> startMappedReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull MappedFunctor<V, T> functor, @StrictNonNull ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.startMappedReduced(sequence, functor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.startFilteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> @NonNull ThreadEngineStarter<U> startFilteredReduced(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor, @StrictNonNull ReduceFunctor<U, T> reduceFunctor, @NonNull ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value());
    }

    @QtUninvokable
    public static <T> @NonNull ThreadEngineStarter<T> startFiltered(@StrictNonNull Collection<T> sequence, @StrictNonNull FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.startFiltered(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }

    static {
        QtJambi_LibraryUtilities.initialize();
    }

    @FunctionalInterface
    public static interface ReduceFunctor<U, T>
    extends Serializable {
        public U reduce(U var1, T var2);
    }

    @FunctionalInterface
    public static interface MapFunctor<T> {
        public void map(T var1);
    }

    public static final class ThreadEngineStarter<T>
    extends QtObject {
        private ThreadEngineStarter(QtObject.QPrivateConstructor p) {
            super(p);
        }

        @QtUninvokable
        public final @NonNull QFuture<T> startAsynchronously() {
            QFuture<T> result = ThreadEngineStarter.startAsynchronously(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
            this.dispose();
            return result;
        }

        @QtUninvokable
        private static final native <T> @NonNull QFuture<T> startAsynchronously(long var0);
    }

    @FunctionalInterface
    public static interface MappedFunctor<U, T> {
        public U map(T var1);
    }

    public static enum ReduceOption implements QtFlagEnumerator
    {
        UnorderedReduce(1),
        OrderedReduce(2),
        SequentialReduce(4);

        private final int value;

        private ReduceOption(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public @NonNull ReduceOptions asFlags() {
            return new ReduceOptions(this.value);
        }

        public @NonNull ReduceOptions combined(@NonNull ReduceOption e) {
            return this.asFlags().setFlag(e, true);
        }

        public @NonNull ReduceOptions cleared(@NonNull ReduceOption e) {
            return this.asFlags().setFlag(e, false);
        }

        public static @NonNull ReduceOptions flags(ReduceOption ... values) {
            return new ReduceOptions(values);
        }

        public static @NonNull ReduceOption resolve(int value) {
            switch (value) {
                case 1: {
                    return UnorderedReduce;
                }
                case 2: {
                    return OrderedReduce;
                }
                case 4: {
                    return SequentialReduce;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static final class ReduceOptions
    extends QFlags<ReduceOption>
    implements Comparable<ReduceOptions> {
        private static final long serialVersionUID = -4989003295974641378L;

        public ReduceOptions(ReduceOption ... args) {
            super((QtAbstractFlagEnumerator[])args);
        }

        public ReduceOptions(int value) {
            super(value);
        }

        public final @NonNull ReduceOptions combined(@StrictNonNull ReduceOption e) {
            return new ReduceOptions(this.value() | e.value());
        }

        public final @NonNull ReduceOptions setFlag(@Nullable ReduceOption e) {
            return this.setFlag(e, true);
        }

        public final @NonNull ReduceOptions setFlag(@Nullable ReduceOption e, boolean on) {
            if (on) {
                this.setValue(this.value() | e.value());
            } else {
                this.setValue(this.value() & ~e.value());
            }
            return this;
        }

        public final @NonNull ReduceOption @NonNull [] flags() {
            return (ReduceOption[])super.flags((QtAbstractFlagEnumerator[])ReduceOption.values());
        }

        public final @NonNull ReduceOptions clone() {
            return new ReduceOptions(this.value());
        }

        @Override
        public final int compareTo(@StrictNonNull ReduceOptions other) {
            return Integer.compare(this.value(), other.value());
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static interface FilteredFunctor<T> {
        public boolean filter(T var1);
    }

    @FunctionalInterface
    public static interface Runnable1<A> {
        public void run(A var1);
    }

    @FunctionalInterface
    public static interface Runnable2<A, B> {
        public void run(A var1, B var2);
    }

    @FunctionalInterface
    public static interface Runnable3<A, B, C> {
        public void run(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface Runnable4<A, B, C, D> {
        public void run(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface Runnable5<A, B, C, D, E> {
        public void run(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface Callable1<T, A> {
        public T call(A var1);
    }

    @FunctionalInterface
    public static interface Callable2<T, A, B> {
        public T call(A var1, B var2);
    }

    @FunctionalInterface
    public static interface Callable3<T, A, B, C> {
        public T call(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface Callable4<T, A, B, C, D> {
        public T call(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface Callable5<T, A, B, C, D, E> {
        public T call(A var1, B var2, C var3, D var4, E var5);
    }

    public static class MedianDouble
    extends QtObject
    implements Cloneable {
        public MedianDouble() {
            super((QtObject.QPrivateConstructor)null);
            MedianDouble.initialize_native(this);
        }

        private static native void initialize_native(MedianDouble var0);

        @QtUninvokable
        public final void addValue(double value) {
            this.addValue_native_double(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), value);
        }

        @QtUninvokable
        private native void addValue_native_double(long var1, double var3);

        @QtUninvokable
        public final boolean isMedianValid() {
            return this.isMedianValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        @QtUninvokable
        private native boolean isMedianValid_native_constfct(long var1);

        @QtUninvokable
        public final double median() {
            return this.median_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        @QtUninvokable
        private native double median_native(long var1);

        @QtUninvokable
        public final void reset() {
            this.reset_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        @QtUninvokable
        private native void reset_native(long var1);

        protected MedianDouble(QtObject.QPrivateConstructor p) {
            super(p);
        }

        @QtUninvokable
        public MedianDouble clone() {
            return MedianDouble.clone_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        private static native MedianDouble clone_native(long var0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static enum ThreadFunctionResult implements QtEnumerator
    {
        ThrottleThread(0),
        ThreadFinished(1);

        private final int value;

        private ThreadFunctionResult(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static @NonNull ThreadFunctionResult resolve(int value) {
            switch (value) {
                case 0: {
                    return ThrottleThread;
                }
                case 1: {
                    return ThreadFinished;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }
}

