/*
 * Decompiled with CFR 0.152.
 */
package io.qt.concurrent;

import io.qt.QFlags;
import io.qt.QNoSuchEnumValueException;
import io.qt.QtAbstractFlagEnumerator;
import io.qt.QtEnumerator;
import io.qt.QtFlagEnumerator;
import io.qt.QtObject;
import io.qt.QtUninvokable;
import io.qt.concurrent.QtJambi_LibraryUtilities;
import io.qt.core.QFuture;
import io.qt.core.QList;
import io.qt.core.QMetaType;
import io.qt.core.QThreadPool;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;

public final class QtConcurrent {
    private QtConcurrent() throws InstantiationError {
        throw new InstantiationError("Cannot instantiate namespace QtConcurrent.");
    }

    @QtUninvokable
    private static <U> U computeDefaultResult(ReduceFunctor<U, ?> functor) {
        int[] types = QtJambi_LibraryUtilities.internal.lambdaMetaTypes(ReduceFunctor.class, functor);
        if (types != null && types.length > 0) {
            return (U)new QMetaType(types[0]).create();
        }
        return null;
    }

    @QtUninvokable
    public static <T> QFuture<Void> map(Collection<T> sequence, MapFunctor<T> functor) {
        return QtConcurrent.startMap(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }

    @QtUninvokable
    public static <T> void blockingMap(Collection<T> sequence, MapFunctor<T> functor) {
        QFuture<Void> future = QtConcurrent.map(sequence, functor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <U, T> QFuture<U> mapped(Collection<T> sequence, MappedFunctor<U, T> functor) {
        return QtConcurrent.startMapped(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> QList<U> blockingMapped(Collection<T> sequence, MappedFunctor<U, T> functor) {
        QFuture<U> future = QtConcurrent.mapped(sequence, functor);
        return future.results();
    }

    @QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOptions options) {
        return QtConcurrent.startMappedReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, V, T> U blockingMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOptions options) {
        QFuture<U> future = QtConcurrent.mappedReduced(sequence, functor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <T> QFuture<Void> filter(Collection<T> sequence, FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.filter(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }

    @QtUninvokable
    public static <T> void blockingFilter(Collection<T> sequence, FilteredFunctor<T> filteredFunctor) {
        QFuture<Void> future = QtConcurrent.filter(sequence, filteredFunctor);
        future.waitForFinished();
    }

    @QtUninvokable
    public static <T> QFuture<T> filtered(Collection<T> sequence, FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.startFiltered(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor)).startAsynchronously();
    }

    @QtUninvokable
    public static <T> QList<T> blockingFiltered(Collection<T> sequence, FilteredFunctor<T> filteredFunctor) {
        QFuture<T> future = QtConcurrent.filtered(sequence, filteredFunctor);
        return future.results();
    }

    @QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }

    @QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor) {
        QFuture<U> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        QFuture<U> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    public static <U, T> U blockingFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOptions options) {
        QFuture<U> future = QtConcurrent.filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return (U)future.result();
    }

    @QtUninvokable
    private static native <T> QFuture<Void> filter(long var0, Collection<T> var2, FilteredFunctor<T> var3);

    @QtUninvokable
    private static native <T> ThreadEngineStarter<Void> startMap(long var0, Collection<T> var2, MapFunctor<T> var3);

    @QtUninvokable
    private static native <U, T> ThreadEngineStarter<U> startMapped(long var0, Collection<T> var2, MappedFunctor<U, T> var3);

    @QtUninvokable
    private static native <U, V, T> ThreadEngineStarter<U> startMappedReduced(long var0, Collection<T> var2, MappedFunctor<V, T> var3, ReduceFunctor<U, V> var4, U var5, int var6);

    @QtUninvokable
    private static native <U, T> ThreadEngineStarter<U> startFilteredReduced(long var0, Collection<T> var2, FilteredFunctor<T> var3, ReduceFunctor<U, T> var4, U var5, int var6);

    @QtUninvokable
    private static native <T> ThreadEngineStarter<T> startFiltered(long var0, Collection<T> var2, FilteredFunctor<T> var3);

    @QtUninvokable
    public static <T> QFuture<T> run(Callable<T> callable) {
        return QtConcurrent.run0(null, Objects.requireNonNull(callable));
    }

    @QtUninvokable
    public static <T> QFuture<T> run(QThreadPool threadPool, Callable<T> callable) {
        return QtConcurrent.run0(threadPool, Objects.requireNonNull(callable));
    }

    @QtUninvokable
    private static native <T> QFuture<T> run0(QThreadPool var0, Callable<T> var1);

    @QtUninvokable
    public static QFuture<Void> run(Runnable runnable) {
        return QtConcurrent.runVoid0(null, Objects.requireNonNull(runnable));
    }

    @QtUninvokable
    public static QFuture<Void> run(QThreadPool threadPool, Runnable runnable) {
        return QtConcurrent.runVoid0(threadPool, Objects.requireNonNull(runnable));
    }

    @QtUninvokable
    private static native QFuture<Void> runVoid0(QThreadPool var0, Runnable var1);

    public static <A> QFuture<Void> run(Runnable1<A> runnable, A a) {
        return QtConcurrent.runVoid1(null, runnable, a);
    }

    public static <A> QFuture<Void> run(QThreadPool threadPool, Runnable1<A> runnable, A a) {
        return QtConcurrent.runVoid1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <A> QFuture<Void> runVoid1(QThreadPool var0, Runnable1<A> var1, A var2);

    public static <A, B> QFuture<Void> run(Runnable2<A, B> runnable, A a, B b) {
        return QtConcurrent.runVoid2(null, Objects.requireNonNull(runnable), a, b);
    }

    public static <A, B> QFuture<Void> run(QThreadPool threadPool, Runnable2<A, B> runnable, A a, B b) {
        return QtConcurrent.runVoid2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <A, B> QFuture<Void> runVoid2(QThreadPool var0, Runnable2<A, B> var1, A var2, B var3);

    public static <A, B, C> QFuture<Void> run(Runnable3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runVoid3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    public static <A, B, C> QFuture<Void> run(QThreadPool threadPool, Runnable3<A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.runVoid3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <A, B, C> QFuture<Void> runVoid3(QThreadPool var0, Runnable3<A, B, C> var1, A var2, B var3, C var4);

    public static <A, B, C, D> QFuture<Void> run(Runnable4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runVoid4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    public static <A, B, C, D> QFuture<Void> run(QThreadPool threadPool, Runnable4<A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.runVoid4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <A, B, C, D> QFuture<Void> runVoid4(QThreadPool var0, Runnable4<A, B, C, D> var1, A var2, B var3, C var4, D var5);

    public static <A, B, C, D, E> QFuture<Void> run(Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runVoid5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    public static <A, B, C, D, E> QFuture<Void> run(QThreadPool threadPool, Runnable5<A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.runVoid5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <A, B, C, D, E> QFuture<Void> runVoid5(QThreadPool var0, Runnable5<A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    public static <T, A> QFuture<T> run(Callable1<T, A> runnable, A a) {
        return QtConcurrent.run1(null, Objects.requireNonNull(runnable), a);
    }

    public static <T, A> QFuture<T> run(QThreadPool threadPool, Callable1<T, A> runnable, A a) {
        return QtConcurrent.run1(threadPool, Objects.requireNonNull(runnable), a);
    }

    private static native <T, A> QFuture<T> run1(QThreadPool var0, Callable1<T, A> var1, A var2);

    public static <T, A, B> QFuture<T> run(Callable2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.run2(null, Objects.requireNonNull(runnable), a, b);
    }

    public static <T, A, B> QFuture<T> run(QThreadPool threadPool, Callable2<T, A, B> runnable, A a, B b) {
        return QtConcurrent.run2(threadPool, Objects.requireNonNull(runnable), a, b);
    }

    private static native <T, A, B> QFuture<T> run2(QThreadPool var0, Callable2<T, A, B> var1, A var2, B var3);

    public static <T, A, B, C> QFuture<T> run(Callable3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.run3(null, Objects.requireNonNull(runnable), a, b, c);
    }

    public static <T, A, B, C> QFuture<T> run(QThreadPool threadPool, Callable3<T, A, B, C> runnable, A a, B b, C c) {
        return QtConcurrent.run3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }

    private static native <T, A, B, C> QFuture<T> run3(QThreadPool var0, Callable3<T, A, B, C> var1, A var2, B var3, C var4);

    public static <T, A, B, C, D> QFuture<T> run(Callable4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.run4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }

    public static <T, A, B, C, D> QFuture<T> run(QThreadPool threadPool, Callable4<T, A, B, C, D> runnable, A a, B b, C c, D d) {
        return QtConcurrent.run4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }

    private static native <T, A, B, C, D> QFuture<T> run4(QThreadPool var0, Callable4<T, A, B, C, D> var1, A var2, B var3, C var4, D var5);

    public static <T, A, B, C, D, E> QFuture<T> run(Callable5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.run5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    public static <T, A, B, C, D, E> QFuture<T> run(QThreadPool threadPool, Callable5<T, A, B, C, D, E> runnable, A a, B b, C c, D d, E e) {
        return QtConcurrent.run5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }

    private static native <T, A, B, C, D, E> QFuture<T> run5(QThreadPool var0, Callable5<T, A, B, C, D, E> var1, A var2, B var3, C var4, D var5, E var6);

    public static <T> ThreadEngineStarter<Void> startMap(Collection<T> sequence, MapFunctor<T> functor) {
        return QtConcurrent.startMap(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }

    @QtUninvokable
    public static <U, T> ThreadEngineStarter<U> startMapped(Collection<T> sequence, MappedFunctor<U, T> functor) {
        return QtConcurrent.startMapped(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }

    @QtUninvokable
    public static <U, V, T> ThreadEngineStarter<U> startMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOptions options) {
        return QtConcurrent.startMappedReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value());
    }

    @QtUninvokable
    public static <U, V, T> ThreadEngineStarter<U> startMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.startMappedReduced(sequence, functor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> ThreadEngineStarter<U> startFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return QtConcurrent.startFilteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }

    @QtUninvokable
    public static <U, T> ThreadEngineStarter<U> startFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOptions options) {
        return QtConcurrent.startFilteredReduced(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), QtConcurrent.computeDefaultResult(reduceFunctor), options.value());
    }

    @QtUninvokable
    public static <T> ThreadEngineStarter<T> startFiltered(Collection<T> sequence, FilteredFunctor<T> filteredFunctor) {
        return QtConcurrent.startFiltered(0L, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }

    static {
        QtJambi_LibraryUtilities.initialize();
    }

    @FunctionalInterface
    public static interface ReduceFunctor<U, T>
    extends Serializable {
        public U reduce(U var1, T var2);
    }

    @FunctionalInterface
    public static interface MapFunctor<T> {
        public void map(T var1);
    }

    public static final class ThreadEngineStarter<T>
    extends QtObject {
        private ThreadEngineStarter(QtObject.QPrivateConstructor p) {
            super(p);
        }

        public final QFuture<T> startAsynchronously() {
            QFuture<T> result = ThreadEngineStarter.startAsynchronously(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
            this.dispose();
            return result;
        }

        @QtUninvokable
        private static final native <T> QFuture<T> startAsynchronously(long var0);
    }

    @FunctionalInterface
    public static interface MappedFunctor<U, T> {
        public U map(T var1);
    }

    public static enum ReduceOption implements QtFlagEnumerator
    {
        UnorderedReduce(1),
        OrderedReduce(2),
        SequentialReduce(4);

        private final int value;

        private ReduceOption(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public ReduceOptions asFlags() {
            return new ReduceOptions(this.value);
        }

        public ReduceOptions combined(ReduceOption e) {
            return new ReduceOptions(this, e);
        }

        public static ReduceOptions flags(ReduceOption ... values) {
            return new ReduceOptions(values);
        }

        public static ReduceOption resolve(int value) {
            switch (value) {
                case 1: {
                    return UnorderedReduce;
                }
                case 2: {
                    return OrderedReduce;
                }
                case 4: {
                    return SequentialReduce;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static final class ReduceOptions
    extends QFlags<ReduceOption>
    implements Comparable<ReduceOptions> {
        private static final long serialVersionUID = -4989003295974641378L;

        public ReduceOptions(ReduceOption ... args) {
            super((QtAbstractFlagEnumerator[])args);
        }

        public ReduceOptions(int value) {
            super(value);
        }

        public final ReduceOptions combined(ReduceOption e) {
            return new ReduceOptions(this.value() | e.value());
        }

        public final ReduceOptions setFlag(ReduceOption e) {
            super.setFlag((QtAbstractFlagEnumerator)e);
            return this;
        }

        public final ReduceOptions setFlag(ReduceOption e, boolean on) {
            super.setFlag((QtAbstractFlagEnumerator)e, on);
            return this;
        }

        public final ReduceOption[] flags() {
            return (ReduceOption[])super.flags((QtAbstractFlagEnumerator[])ReduceOption.values());
        }

        public final ReduceOptions clone() {
            return new ReduceOptions(this.value());
        }

        @Override
        public final int compareTo(ReduceOptions other) {
            return Integer.compare(this.value(), other.value());
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static interface FilteredFunctor<T> {
        public boolean filter(T var1);
    }

    @FunctionalInterface
    public static interface Runnable1<A> {
        public void run(A var1);
    }

    @FunctionalInterface
    public static interface Runnable2<A, B> {
        public void run(A var1, B var2);
    }

    @FunctionalInterface
    public static interface Runnable3<A, B, C> {
        public void run(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface Runnable4<A, B, C, D> {
        public void run(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface Runnable5<A, B, C, D, E> {
        public void run(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface Callable1<T, A> {
        public T call(A var1);
    }

    @FunctionalInterface
    public static interface Callable2<T, A, B> {
        public T call(A var1, B var2);
    }

    @FunctionalInterface
    public static interface Callable3<T, A, B, C> {
        public T call(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface Callable4<T, A, B, C, D> {
        public T call(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface Callable5<T, A, B, C, D, E> {
        public T call(A var1, B var2, C var3, D var4, E var5);
    }

    public static class MedianDouble
    extends QtObject {
        public MedianDouble() {
            super((QtObject.QPrivateConstructor)null);
            MedianDouble.initialize_native(this);
        }

        private static native void initialize_native(MedianDouble var0);

        @QtUninvokable
        public final void addValue(double value) {
            this.addValue_native_double(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), value);
        }

        @QtUninvokable
        private native void addValue_native_double(long var1, double var3);

        @QtUninvokable
        public final boolean isMedianValid() {
            return this.isMedianValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        @QtUninvokable
        private native boolean isMedianValid_native_constfct(long var1);

        @QtUninvokable
        public final double median() {
            return this.median_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        @QtUninvokable
        private native double median_native(long var1);

        @QtUninvokable
        public final void reset() {
            this.reset_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
        }

        @QtUninvokable
        private native void reset_native(long var1);

        protected MedianDouble(QtObject.QPrivateConstructor p) {
            super(p);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }

    public static enum ThreadFunctionResult implements QtEnumerator
    {
        ThrottleThread(0),
        ThreadFinished(1);

        private final int value;

        private ThreadFunctionResult(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static ThreadFunctionResult resolve(int value) {
            switch (value) {
                case 0: {
                    return ThrottleThread;
                }
                case 1: {
                    return ThreadFinished;
                }
            }
            throw new QNoSuchEnumValueException(value);
        }

        static {
            QtJambi_LibraryUtilities.initialize();
        }
    }
}

