package io.qt.concurrent;

import io.qt.core.*;
import java.util.*;
import java.util.concurrent.*;

/**
 * <p>High-level APIs that make it possible to write multi-threaded programs without using low-level threading primitives</p>
 * <p>Java wrapper for Qt's namespace <a href="http://doc.qt.io/qt-5/qtconcurrent.html">QtConcurrent</a></p>
 */
public final class QtConcurrent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtConcurrent() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtConcurrent."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qtconcurrent.html#ReduceOption-enum">QtConcurrent::ReduceOption</a></p>
     * 
     * @see ReduceOptions
     */
    public enum ReduceOption implements io.qt.QtFlagEnumerator {
        UnorderedReduce(1),
        OrderedReduce(2),
        SequentialReduce(4);

        private ReduceOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ReduceOptions asFlags() {
            return new ReduceOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ReduceOptions combined(ReduceOption e) {
            return new ReduceOptions(this, e);
        }

        /**
         * Creates a new {@link ReduceOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ReduceOptions flags(ReduceOption ... values) {
            return new ReduceOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ReduceOption resolve(int value) {
            switch (value) {
            case 1: return UnorderedReduce;
            case 2: return OrderedReduce;
            case 4: return SequentialReduce;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ReduceOption}
     */
    public static final class ReduceOptions extends io.qt.QFlags<ReduceOption> implements Comparable<ReduceOptions> {
        private static final long serialVersionUID = 0xbac37fef682db11eL;

        /**
         * Creates a new ReduceOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ReduceOptions(ReduceOption ... args){
            super(args);
        }

        /**
         * Creates a new ReduceOptions with given <code>value</code>.
         * @param value
         */
        public ReduceOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ReduceOptions
         */
        @Override
        public final ReduceOptions combined(ReduceOption e){
            return new ReduceOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ReduceOptions setFlag(ReduceOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ReduceOptions setFlag(ReduceOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ReduceOptions.
         * @return array of enum entries
         */
        @Override
        public final ReduceOption[] flags(){
            return super.flags(ReduceOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ReduceOptions clone(){
            return new ReduceOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ReduceOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QtConcurrent::ThreadFunctionResult</p>
     */
    public enum ThreadFunctionResult implements io.qt.QtEnumerator {
        ThrottleThread(0),
        ThreadFinished(1);

        private ThreadFunctionResult(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ThreadFunctionResult resolve(int value) {
            switch (value) {
            case 0: return ThrottleThread;
            case 1: return ThreadFinished;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt class QtConcurrent::MedianDouble</p>
     */
    public static class MedianDouble extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public MedianDouble(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(MedianDouble instance);
        
        @io.qt.QtUninvokable
        public final void addValue(double value){
            addValue_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        
        @io.qt.QtUninvokable
        private native void addValue_native_double(long __this__nativeId, double value);
        
        @io.qt.QtUninvokable
        public final boolean isMedianValid(){
            return isMedianValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isMedianValid_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final double median(){
            return median_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native double median_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void reset(){
            reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native void reset_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected MedianDouble(QPrivateConstructor p) { super(p); } 
        
    }
    
    public static final class ThreadEngineStarter<T> extends io.qt.QtObject{
        private ThreadEngineStarter(QPrivateConstructor p){
            super(p);
        }
    
        public final QFuture<T> startAsynchronously(){
            QFuture<T> result = startAsynchronously(QtJambi_LibraryUtilities.internal.nativeId(this));
            dispose();
            return result;
        }
        
        @io.qt.QtUninvokable
        private static native final <T> QFuture<T> startAsynchronously(long nativeId);
    }
    
    /**
     * An implemetation of this interface is given one to QtConcurrent's map() methods.
     * The map() method of this interface is called for each object in a java.util.Collection.
     *
     */
    @FunctionalInterface
    public interface MapFunctor<T> {
    
        /**
         * This function is called for each item in the Collection. The function is then free to alter <code>object</code> as it see fit.
         */
        @io.qt.NativeAccess
        public void map(T object);
    }
    
    /**
     * Implement this interface to perform a mapped operation. An implementation of the interface is sendt
     * to ome of the mapped methods of QtConcurrent, which applies the MappedFunctor.map() method to all elements in a collection,
     * and returns the result.
     */
    @FunctionalInterface
    public interface MappedFunctor<U, T> {
    
        /**
         * This method is called for each object in a collection. It should returned a new altered
         * object.
         */
        @io.qt.NativeAccess
        public U map(T object);
    }
    
    /**
     * An implementation of this interface is given to one of QtConcurrent's filtered() methods.
     * The filter method if this interface is called for each item in a java.util.Collection.
     *
     */
    public interface FilteredFunctor<T> {
    
        /**
         *  This method is called for each item in a java.util.Collection. The items for which
         *  this method returns true are removed from the collection.
         */
        public boolean filter(T object);
    }
    
    /**
     * Implement this interface in order to perform a reduce operation.
     * <p>
     * The reduce method will be called once per intermediate result (the result of the mapping of the data)
     * and the very first time the reduce() method is called for the particular data set, the result is set to
     * the returned value of the defaultResult() method.
     */
    @FunctionalInterface
    public interface ReduceFunctor<U, T> extends java.io.Serializable{
        /**
         * Performs a reduce operation on <code>intermediate</code>.
         * Returns the result of the reduction.
         */
        @io.qt.NativeAccess
        public U reduce(U result, T intermediate);
    }
    
    @SuppressWarnings("unchecked")
    @io.qt.QtUninvokable
    private static <U> U computeDefaultResult(ReduceFunctor<U,?> functor) {
        int[] types = QtJambi_LibraryUtilities.internal.lambdaMetaTypes(ReduceFunctor.class, functor);
        if(types!=null && types.length>0) {
            return (U)new QMetaType(types[0]).create();
        }
        return null;
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#map">QtConcurrent::map(Sequence, MapFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<Void> map(Collection<T> sequence, MapFunctor<T> functor){
        return startMap(0, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingMap">QtConcurrent::blockingMap(Sequence, MapFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> void blockingMap(Collection<T> sequence, MapFunctor<T> functor){
        QFuture<Void> future = map(sequence, functor);
        future.waitForFinished();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#mapped">QtConcurrent::mapped(Sequence, MappedFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> mapped(Collection<T> sequence, MappedFunctor<U, T> functor){
        return startMapped(0, Objects.requireNonNull(sequence), Objects.requireNonNull(functor)).startAsynchronously();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingMapped">QtConcurrent::blockingMapped(Sequence, MappedFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> QList<U> blockingMapped(Collection<T> sequence, MappedFunctor<U, T> functor){
        QFuture<U> future = mapped(sequence, functor);
        return future.results();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#mappedReduced">QtConcurrent::mappedReduced(Sequence, MappedFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor) {
        return mappedReduced(sequence, functor, reduceFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#mappedReduced">QtConcurrent::mappedReduced(Sequence, MappedFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        return mappedReduced(sequence, functor, reduceFunctor, new ReduceOptions(options));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#mappedReduced">QtConcurrent::mappedReduced(Sequence, MappedFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, V, T> QFuture<U> mappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOptions options) {
           return startMappedReduced(0, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
     }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingMappedReduced">QtConcurrent::blockingMappedReduced(Sequence, MappedFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, V, T> U blockingMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor) {
        QFuture<U> future = mappedReduced(sequence, functor, reduceFunctor);
        return future.result();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingMappedReduced">QtConcurrent::blockingMappedReduced(Sequence, MappedFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, V, T> U blockingMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOption ... options) {
        QFuture<U> future = mappedReduced(sequence, functor, reduceFunctor, options);
        return future.result();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingMappedReduced">QtConcurrent::blockingMappedReduced(Sequence, MappedFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, V, T> U blockingMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOptions options) {
        QFuture<U> future = mappedReduced(sequence, functor, reduceFunctor, options);
        return future.result();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#filter">QtConcurrent::filter(Sequence, FilteredFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<Void> filter(Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        return filter(0, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingFilter">QtConcurrent::blockingFilter(Sequence, FilteredFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> void blockingFilter(Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        QFuture<Void> future = filter(sequence, filteredFunctor);
        future.waitForFinished();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#filtered">QtConcurrent::filtered(Sequence, FilteredFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<T> filtered(Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        return startFiltered(0, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor)).startAsynchronously();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingFiltered">QtConcurrent::blockingFiltered(Sequence, FilteredFunctor)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> QList<T> blockingFiltered(Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        QFuture<T> future = filtered(sequence, filteredFunctor);
        return future.results();
    }
        
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#filteredReduced">QtConcurrent::filteredReduced(Sequence, FilteredFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor) {
        return filteredReduced(sequence, filteredFunctor, reduceFunctor, ReduceOption.UnorderedReduce, ReduceOption.SequentialReduce);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#filteredReduced">QtConcurrent::filteredReduced(Sequence, FilteredFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return filteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#filteredReduced">QtConcurrent::filteredReduced(Sequence, FilteredFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> QFuture<U> filteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOptions options) {
        return startFilteredReduced(0, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), computeDefaultResult(reduceFunctor), options.value()).startAsynchronously();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingFilteredReduced">QtConcurrent::blockingFilteredReduced(Sequence, FilteredFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> U blockingFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor) {
        QFuture<U> future = filteredReduced(sequence, filteredFunctor, reduceFunctor);
        return future.result();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingFilteredReduced">QtConcurrent::blockingFilteredReduced(Sequence, FilteredFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> U blockingFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        QFuture<U> future = filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return future.result();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#blockingFilteredReduced">QtConcurrent::blockingFilteredReduced(Sequence, FilteredFunctor, ReduceFunctor, QtConcurrent::ReduceOptions)</a></p>
     */
    @io.qt.QtUninvokable
    public static <U, T> U blockingFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOptions options) {
        QFuture<U> future = filteredReduced(sequence, filteredFunctor, reduceFunctor, options);
        return future.result();
    }
    
    @io.qt.QtUninvokable
    private native static <T> QFuture<Void> filter(long threadPool, Collection<T> sequence, FilteredFunctor<T> filteredFunctor);
    
    @io.qt.QtUninvokable
    private native static <T> ThreadEngineStarter<Void> startMap(long threadPool, Collection<T> sequence, MapFunctor<T> functor);
    
    @io.qt.QtUninvokable
    private native static <U, T> ThreadEngineStarter<U> startMapped(long threadPool, Collection<T> sequence, MappedFunctor<U, T> functor);
    
    @io.qt.QtUninvokable
    private native static <U, V, T> ThreadEngineStarter<U> startMappedReduced(long threadPool, Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, U initialValue, int options);
    
    @io.qt.QtUninvokable
    private native static <U, T> ThreadEngineStarter<U> startFilteredReduced(long threadPool, Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, U initialValue, int options);
    
    @io.qt.QtUninvokable
    private native static <T> ThreadEngineStarter<T> startFiltered(long threadPool, Collection<T> sequence, FilteredFunctor<T> filteredFunctor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<T> run(Callable<T> callable){
        return run0(null, Objects.requireNonNull(callable));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    @io.qt.QtUninvokable
    public static <T> QFuture<T> run(QThreadPool threadPool, Callable<T> callable){
        return run0(threadPool, Objects.requireNonNull(callable));
    }
    @io.qt.QtUninvokable
    private native static <T> QFuture<T> run0(QThreadPool threadPool, Callable<T> callable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    @io.qt.QtUninvokable
    public static QFuture<Void> run(Runnable runnable) {
        return runVoid0(null, Objects.requireNonNull(runnable));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    @io.qt.QtUninvokable
    public static QFuture<Void> run(QThreadPool threadPool, Runnable runnable) {
        return runVoid0(threadPool, Objects.requireNonNull(runnable));
    }
    @io.qt.QtUninvokable
    private native static QFuture<Void> runVoid0(QThreadPool threadPool, Runnable runnable);
    
    @FunctionalInterface
    public interface Runnable1<A>{
        public void run(A a);
    }
    
    @FunctionalInterface
    public interface Runnable2<A,B>{
        public void run(A a, B b);
    }
    
    @FunctionalInterface
    public interface Runnable3<A,B,C>{
        public void run(A a, B b, C c);
    }
    
    @FunctionalInterface
    public interface Runnable4<A,B,C,D>{
        public void run(A a, B b, C c, D d);
    }
    
    @FunctionalInterface
    public interface Runnable5<A,B,C,D,E>{
        public void run(A a, B b, C c, D d, E e);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <A> QFuture<Void> run(Runnable1<A> runnable, A a) {
        return runVoid1(null, runnable, a);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <A> QFuture<Void> run(QThreadPool threadPool, Runnable1<A> runnable, A a) {
        return runVoid1(threadPool, Objects.requireNonNull(runnable), a);
    }
    private native static <A> QFuture<Void> runVoid1(QThreadPool threadPool, Runnable1<A> runnable, A a);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <A,B> QFuture<Void> run(Runnable2<A,B> runnable, A a, B b) {
        return runVoid2(null, Objects.requireNonNull(runnable), a, b);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <A,B> QFuture<Void> run(QThreadPool threadPool, Runnable2<A,B> runnable, A a, B b) {
        return runVoid2(threadPool, Objects.requireNonNull(runnable), a, b);
    }
    private native static <A,B> QFuture<Void> runVoid2(QThreadPool threadPool, Runnable2<A,B> runnable, A a, B b);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <A,B,C> QFuture<Void> run(Runnable3<A,B,C> runnable, A a, B b, C c) {
        return runVoid3(null, Objects.requireNonNull(runnable), a, b, c);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <A,B,C> QFuture<Void> run(QThreadPool threadPool, Runnable3<A,B,C> runnable, A a, B b, C c) {
        return runVoid3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }
    private native static <A,B,C> QFuture<Void> runVoid3(QThreadPool threadPool, Runnable3<A,B,C> runnable, A a, B b, C c);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <A,B,C,D> QFuture<Void> run(Runnable4<A,B,C,D> runnable, A a, B b, C c, D d) {
        return runVoid4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <A,B,C,D> QFuture<Void> run(QThreadPool threadPool, Runnable4<A,B,C,D> runnable, A a, B b, C c, D d) {
        return runVoid4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }
    private native static <A,B,C,D> QFuture<Void> runVoid4(QThreadPool threadPool, Runnable4<A,B,C,D> runnable, A a, B b, C c, D d);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <A,B,C,D,E> QFuture<Void> run(Runnable5<A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return runVoid5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <A,B,C,D,E> QFuture<Void> run(QThreadPool threadPool, Runnable5<A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return runVoid5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    private native static <A,B,C,D,E> QFuture<Void> runVoid5(QThreadPool threadPool, Runnable5<A,B,C,D,E> runnable, A a, B b, C c, D d, E e);
    
    
    
    @FunctionalInterface
    public interface Callable1<T,A>{
        public T call(A a);
    }
    
    @FunctionalInterface
    public interface Callable2<T,A,B>{
        public T call(A a, B b);
    }
    
    @FunctionalInterface
    public interface Callable3<T,A,B,C>{
        public T call(A a, B b, C c);
    }
    
    @FunctionalInterface
    public interface Callable4<T,A,B,C,D>{
        public T call(A a, B b, C c, D d);
    }
    
    @FunctionalInterface
    public interface Callable5<T,A,B,C,D,E>{
        public T call(A a, B b, C c, D d, E e);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <T,A> QFuture<T> run(Callable1<T,A> runnable, A a) {
        return run1(null, Objects.requireNonNull(runnable), a);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <T,A> QFuture<T> run(QThreadPool threadPool, Callable1<T,A> runnable, A a) {
        return run1(threadPool, Objects.requireNonNull(runnable), a);
    }
    private native static <T,A> QFuture<T> run1(QThreadPool threadPool, Callable1<T,A> runnable, A a);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <T,A,B> QFuture<T> run(Callable2<T,A,B> runnable, A a, B b) {
        return run2(null, Objects.requireNonNull(runnable), a, b);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <T,A,B> QFuture<T> run(QThreadPool threadPool, Callable2<T,A,B> runnable, A a, B b) {
        return run2(threadPool, Objects.requireNonNull(runnable), a, b);
    }
    private native static <T,A,B> QFuture<T> run2(QThreadPool threadPool, Callable2<T,A,B> runnable, A a, B b);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <T,A,B,C> QFuture<T> run(Callable3<T,A,B,C> runnable, A a, B b, C c) {
        return run3(null, Objects.requireNonNull(runnable), a, b, c);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <T,A,B,C> QFuture<T> run(QThreadPool threadPool, Callable3<T,A,B,C> runnable, A a, B b, C c) {
        return run3(threadPool, Objects.requireNonNull(runnable), a, b, c);
    }
    private native static <T,A,B,C> QFuture<T> run3(QThreadPool threadPool, Callable3<T,A,B,C> runnable, A a, B b, C c);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <T,A,B,C,D> QFuture<T> run(Callable4<T,A,B,C,D> runnable, A a, B b, C c, D d) {
        return run4(null, Objects.requireNonNull(runnable), a, b, c, d);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <T,A,B,C,D> QFuture<T> run(QThreadPool threadPool, Callable4<T,A,B,C,D> runnable, A a, B b, C c, D d) {
        return run4(threadPool, Objects.requireNonNull(runnable), a, b, c, d);
    }
    private native static <T,A,B,C,D> QFuture<T> run4(QThreadPool threadPool, Callable4<T,A,B,C,D> runnable, A a, B b, C c, D d);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(Function, ...)</a></p>
     */
    public static <T,A,B,C,D,E> QFuture<T> run(Callable5<T,A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return run5(null, Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtconcurrent.html#run">QtConcurrent::run(QThreadPool*, Function, ...)</a></p>
     */
    public static <T,A,B,C,D,E> QFuture<T> run(QThreadPool threadPool, Callable5<T,A,B,C,D,E> runnable, A a, B b, C c, D d, E e) {
        return run5(threadPool, Objects.requireNonNull(runnable), a, b, c, d, e);
    }
    private native static <T,A,B,C,D,E> QFuture<T> run5(QThreadPool threadPool, Callable5<T,A,B,C,D,E> runnable, A a, B b, C c, D d, E e);
    
    public static <T> ThreadEngineStarter<Void> startMap(Collection<T> sequence, MapFunctor<T> functor) {
        return startMap(0, Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }
    
    @io.qt.QtUninvokable
    public static <U, T> ThreadEngineStarter<U> startMapped(Collection<T> sequence, MappedFunctor<U, T> functor){
        return startMapped(0, Objects.requireNonNull(sequence), Objects.requireNonNull(functor));
    }
    
    @io.qt.QtUninvokable
    public static <U, V, T> ThreadEngineStarter<U> startMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOptions options) {
        return startMappedReduced(0, Objects.requireNonNull(sequence), Objects.requireNonNull(functor), Objects.requireNonNull(reduceFunctor), computeDefaultResult(reduceFunctor), options.value());
    }
    
    @io.qt.QtUninvokable
    public static <U, V, T> ThreadEngineStarter<U> startMappedReduced(Collection<T> sequence, MappedFunctor<V, T> functor, ReduceFunctor<U, V> reduceFunctor, ReduceOption... options) {
        return startMappedReduced(sequence, functor, reduceFunctor, new ReduceOptions(options));
    }
    
    @io.qt.QtUninvokable
    public static <U, T> ThreadEngineStarter<U> startFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOption ... options) {
        return startFilteredReduced(sequence, filteredFunctor, reduceFunctor, new ReduceOptions(options));
    }
    
    @io.qt.QtUninvokable
    public static <U, T> ThreadEngineStarter<U> startFilteredReduced(Collection<T> sequence, FilteredFunctor<T> filteredFunctor, ReduceFunctor<U, T> reduceFunctor, ReduceOptions options) {
        return startFilteredReduced(0, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor), Objects.requireNonNull(reduceFunctor), computeDefaultResult(reduceFunctor), options.value());
    }
    
    @io.qt.QtUninvokable
    public static <T> ThreadEngineStarter<T> startFiltered(Collection<T> sequence, FilteredFunctor<T> filteredFunctor){
        return startFiltered(0, Objects.requireNonNull(sequence), Objects.requireNonNull(filteredFunctor));
    }
}
