#include <QtCore/QtGlobal>
#include <QtBluetooth/qbluetoothserviceinfo.h>
#include <QtBluetooth/qbluetoothaddress.h>
#include <QtBluetooth/qbluetoothdeviceinfo.h>
#include <QtBluetooth/qbluetoothuuid.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qdebug.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiBluetooth/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QBluetoothServiceInfo(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QBluetoothServiceInfo")
    QBluetoothServiceInfo *_ptr = reinterpret_cast<QBluetoothServiceInfo *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QBluetoothServiceInfo()
void __qt_construct_QBluetoothServiceInfo_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothServiceInfo()")
    Q_UNUSED(__java_arguments)
    QBluetoothServiceInfo *__qt_this = new(__qtjambi_ptr) QBluetoothServiceInfo();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QBluetoothServiceInfo(QBluetoothServiceInfo)
void __qt_construct_QBluetoothServiceInfo_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothServiceInfo(QBluetoothServiceInfo)")
    jobject other0 = __java_arguments[0].l;
    const QBluetoothServiceInfo& __qt_other0 = qtjambi_cast<const QBluetoothServiceInfo& >(__jni_env, other0);
    QBluetoothServiceInfo *__qt_this = new(__qtjambi_ptr) QBluetoothServiceInfo(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QBluetoothServiceInfo
void __qt_destruct_QBluetoothServiceInfo(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QBluetoothServiceInfo")
    reinterpret_cast<QBluetoothServiceInfo*>(ptr)->~QBluetoothServiceInfo();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QBluetoothServiceInfo::QBluetoothServiceInfo()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_initialize_1native__Lio_qt_bluetooth_QBluetoothServiceInfo_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothServiceInfo::QBluetoothServiceInfo()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothServiceInfo_0, sizeof(QBluetoothServiceInfo), typeid(QBluetoothServiceInfo), false, &deleter_QBluetoothServiceInfo, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::QBluetoothServiceInfo(QBluetoothServiceInfo)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_initialize_1native__Lio_qt_bluetooth_QBluetoothServiceInfo_2Lio_qt_bluetooth_QBluetoothServiceInfo_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothServiceInfo::QBluetoothServiceInfo(QBluetoothServiceInfo)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothServiceInfo_1, sizeof(QBluetoothServiceInfo), typeid(QBluetoothServiceInfo), false, &deleter_QBluetoothServiceInfo, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::attribute(quint16)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_attribute_1native_1quint16_1constfct__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort attributeId0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::attribute(quint16)const", __qt_this)
        QVariant __qt_return_value = __qt_this->attribute(static_cast<quint16>(attributeId0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::attributes()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_attributes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::attributes()const", __qt_this)
        QList<quint16> __qt_return_value = __qt_this->attributes();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::contains(quint16)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_contains_1native_1quint16_1constfct__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort attributeId0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::contains(quint16)const", __qt_this)
        __java_return_value = __qt_this->contains(static_cast<quint16>(attributeId0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::device()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_device_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::device()const", __qt_this)
        QBluetoothDeviceInfo __qt_return_value = __qt_this->device();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::isComplete()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_isComplete_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::isComplete()const", __qt_this)
        __java_return_value = __qt_this->isComplete();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::isRegistered()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_isRegistered_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::isRegistered()const", __qt_this)
        __java_return_value = __qt_this->isRegistered();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::operator=(QBluetoothServiceInfo)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_assign_1native_1cref_1QBluetoothServiceInfo__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::operator=(QBluetoothServiceInfo)", __qt_this)
        const QBluetoothServiceInfo& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothServiceInfo>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::protocolDescriptor(QBluetoothUuid::ProtocolUuid)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_protocolDescriptor_1native_1QBluetoothUuid_1ProtocolUuid_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint protocol0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::protocolDescriptor(QBluetoothUuid::ProtocolUuid)const", __qt_this)
        QBluetoothUuid::ProtocolUuid __qt_protocol0 = qtjambi_cast<QBluetoothUuid::ProtocolUuid>(__jni_env, protocol0);
        QBluetoothServiceInfo::Sequence __qt_return_value = __qt_this->protocolDescriptor(QBluetoothUuid::ProtocolUuid(__qt_protocol0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::protocolServiceMultiplexer()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_protocolServiceMultiplexer_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::protocolServiceMultiplexer()const", __qt_this)
        __java_return_value = __qt_this->protocolServiceMultiplexer();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::registerService(QBluetoothAddress)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_registerService_1native_1cref_1QBluetoothAddress__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID localAdapter0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::registerService(QBluetoothAddress)", __qt_this)
        const QBluetoothAddress& __qt_localAdapter0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothAddress>(localAdapter0);
        __java_return_value = __qt_this->registerService(__qt_localAdapter0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::removeAttribute(quint16)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_removeAttribute_1native_1quint16__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort attributeId0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::removeAttribute(quint16)", __qt_this)
        __qt_this->removeAttribute(static_cast<quint16>(attributeId0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::serverChannel()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_serverChannel_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::serverChannel()const", __qt_this)
        __java_return_value = __qt_this->serverChannel();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::serviceAvailability()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_serviceAvailability_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::serviceAvailability()const", __qt_this)
        quint8 __qt_return_value = __qt_this->serviceAvailability();
        __java_return_value = jbyte(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::serviceClassUuids()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_serviceClassUuids_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::serviceClassUuids()const", __qt_this)
        QList<QBluetoothUuid> __qt_return_value = __qt_this->serviceClassUuids();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::serviceDescription()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_serviceDescription_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::serviceDescription()const", __qt_this)
        QString __qt_return_value = __qt_this->serviceDescription();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::serviceName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_serviceName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::serviceName()const", __qt_this)
        QString __qt_return_value = __qt_this->serviceName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::serviceProvider()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_serviceProvider_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::serviceProvider()const", __qt_this)
        QString __qt_return_value = __qt_this->serviceProvider();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::serviceUuid()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_serviceUuid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::serviceUuid()const", __qt_this)
        QBluetoothUuid __qt_return_value = __qt_this->serviceUuid();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::setAttribute(quint16,QBluetoothServiceInfo::Alternative)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setAttribute_1native_1quint16_1cref_1QBluetoothServiceInfo_1Alternative__JSJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort attributeId0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setAttribute(quint16,QBluetoothServiceInfo::Alternative)", __qt_this)
        const QBluetoothServiceInfo::Alternative& __qt_value1 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothServiceInfo::Alternative>(value1);
        __qt_this->setAttribute(static_cast<quint16>(attributeId0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setAttribute(quint16,QBluetoothServiceInfo::Sequence)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setAttribute_1native_1quint16_1cref_1QBluetoothServiceInfo_1Sequence__JSJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort attributeId0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setAttribute(quint16,QBluetoothServiceInfo::Sequence)", __qt_this)
        const QBluetoothServiceInfo::Sequence& __qt_value1 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothServiceInfo::Sequence>(value1);
        __qt_this->setAttribute(static_cast<quint16>(attributeId0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setAttribute(quint16,QBluetoothUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setAttribute_1native_1quint16_1cref_1QBluetoothUuid__JSJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort attributeId0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setAttribute(quint16,QBluetoothUuid)", __qt_this)
        const QBluetoothUuid& __qt_value1 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(value1);
        __qt_this->setAttribute(static_cast<quint16>(attributeId0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setAttribute(quint16,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setAttribute_1native_1quint16_1cref_1QVariant__JSLjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort attributeId0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setAttribute(quint16,QVariant)", __qt_this)
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->setAttribute(static_cast<quint16>(attributeId0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setDevice(QBluetoothDeviceInfo)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setDevice_1native_1cref_1QBluetoothDeviceInfo__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID info0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setDevice(QBluetoothDeviceInfo)", __qt_this)
        const QBluetoothDeviceInfo& __qt_info0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothDeviceInfo>(info0);
        __qt_this->setDevice(__qt_info0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setServiceAvailability(quint8)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setServiceAvailability_1native_1quint8__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte availability0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setServiceAvailability(quint8)", __qt_this)
        __qt_this->setServiceAvailability(static_cast<quint8>(availability0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setServiceDescription(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setServiceDescription_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring description0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setServiceDescription(QString)", __qt_this)
        QString  __qt_description0 = qtjambi_cast<QString>(__jni_env, description0);
        __qt_this->setServiceDescription(__qt_description0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setServiceName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setServiceName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setServiceName(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __qt_this->setServiceName(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setServiceProvider(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setServiceProvider_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring provider0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setServiceProvider(QString)", __qt_this)
        QString  __qt_provider0 = qtjambi_cast<QString>(__jni_env, provider0);
        __qt_this->setServiceProvider(__qt_provider0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::setServiceUuid(QBluetoothUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_setServiceUuid_1native_1cref_1QBluetoothUuid__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID uuid0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::setServiceUuid(QBluetoothUuid)", __qt_this)
        const QBluetoothUuid& __qt_uuid0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(uuid0);
        __qt_this->setServiceUuid(__qt_uuid0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothServiceInfo::socketProtocol()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_socketProtocol_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::socketProtocol()const", __qt_this)
        QBluetoothServiceInfo::Protocol __qt_return_value = __qt_this->socketProtocol();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothServiceInfo::unregisterService()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_unregisterService_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothServiceInfo::unregisterService()", __qt_this)
        __java_return_value = __qt_this->unregisterService();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothServiceInfo_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QBluetoothServiceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothServiceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QBluetoothServiceInfo(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QBluetoothServiceInfo>("QBluetoothServiceInfo", "io/qt/bluetooth/QBluetoothServiceInfo");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QBluetoothServiceInfo, {
        ConstructorInfo(&__qt_construct_QBluetoothServiceInfo_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QBluetoothServiceInfo_1, "Lio/qt/bluetooth/QBluetoothServiceInfo;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QBluetoothServiceInfo);
    registerMetaType<QBluetoothServiceInfo>("QBluetoothServiceInfo");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QBluetoothServiceInfo::AttributeId>("QBluetoothServiceInfo::AttributeId", "io/qt/bluetooth/QBluetoothServiceInfo$AttributeId");
    registerEnumTypeInfo<QBluetoothServiceInfo::Protocol>("QBluetoothServiceInfo::Protocol", "io/qt/bluetooth/QBluetoothServiceInfo$Protocol");
// END: enums and flags
}
