#include <QtCore/QtGlobal>
#include <QtBluetooth/qbluetoothdeviceinfo.h>
#include <QtCore/QVariant>
#include "utils_p.h"
#include <QtBluetooth/qbluetoothaddress.h>
#include <QtBluetooth/qbluetoothuuid.h>
#include <QtCore/QList>
#include <QtCore/qbytearray.h>
#include <QtCore/QMultiHash>

#include <QtJambi/QtJambiAPI>
#include <QtJambiBluetooth/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QBluetoothDeviceInfo(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QBluetoothDeviceInfo")
    QBluetoothDeviceInfo *_ptr = reinterpret_cast<QBluetoothDeviceInfo *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QBluetoothDeviceInfo()
void __qt_construct_QBluetoothDeviceInfo_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothDeviceInfo()")
    Q_UNUSED(__java_arguments)
    QBluetoothDeviceInfo *__qt_this = new(__qtjambi_ptr) QBluetoothDeviceInfo();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QBluetoothDeviceInfo(QBluetoothAddress,QString,quint32)
void __qt_construct_QBluetoothDeviceInfo_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothDeviceInfo(QBluetoothAddress,QString,quint32)")
    jobject address0 = __java_arguments[0].l;
    const QBluetoothAddress& __qt_address0 = qtjambi_cast<const QBluetoothAddress& >(__jni_env, address0);
    jstring name1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_name1 = qtjambi_cast<QString>(__jni_env, name1);
    jint classOfDevice2 = __java_arguments[2].i;
    Q_UNUSED(classOfDevice2)
    QBluetoothDeviceInfo *__qt_this = new(__qtjambi_ptr) QBluetoothDeviceInfo(__qt_address0, __qt_name1, static_cast<quint32>(classOfDevice2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QBluetoothDeviceInfo(QBluetoothDeviceInfo)
void __qt_construct_QBluetoothDeviceInfo_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothDeviceInfo(QBluetoothDeviceInfo)")
    jobject other0 = __java_arguments[0].l;
    const QBluetoothDeviceInfo& __qt_other0 = qtjambi_cast<const QBluetoothDeviceInfo& >(__jni_env, other0);
    QBluetoothDeviceInfo *__qt_this = new(__qtjambi_ptr) QBluetoothDeviceInfo(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QBluetoothDeviceInfo(QBluetoothUuid,QString,quint32)
void __qt_construct_QBluetoothDeviceInfo_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothDeviceInfo(QBluetoothUuid,QString,quint32)")
    jobject uuid0 = __java_arguments[0].l;
    const QBluetoothUuid& __qt_uuid0 = qtjambi_cast<const QBluetoothUuid& >(__jni_env, uuid0);
    jstring name1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_name1 = qtjambi_cast<QString>(__jni_env, name1);
    jint classOfDevice2 = __java_arguments[2].i;
    Q_UNUSED(classOfDevice2)
    QBluetoothDeviceInfo *__qt_this = new(__qtjambi_ptr) QBluetoothDeviceInfo(__qt_uuid0, __qt_name1, static_cast<quint32>(classOfDevice2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QBluetoothDeviceInfo
void __qt_destruct_QBluetoothDeviceInfo(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QBluetoothDeviceInfo")
    reinterpret_cast<QBluetoothDeviceInfo*>(ptr)->~QBluetoothDeviceInfo();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QBluetoothDeviceInfo::QBluetoothDeviceInfo()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_initialize_1native__Lio_qt_bluetooth_QBluetoothDeviceInfo_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothDeviceInfo::QBluetoothDeviceInfo()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothDeviceInfo_0, sizeof(QBluetoothDeviceInfo), typeid(QBluetoothDeviceInfo), false, &deleter_QBluetoothDeviceInfo, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::QBluetoothDeviceInfo(QBluetoothAddress,QString,quint32)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_initialize_1native__Lio_qt_bluetooth_QBluetoothDeviceInfo_2Lio_qt_bluetooth_QBluetoothAddress_2Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject address0,
 jstring name1,
 jint classOfDevice2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothDeviceInfo::QBluetoothDeviceInfo(QBluetoothAddress,QString,quint32)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = address0;
        arguments[1].l = name1;
        arguments[2].i = classOfDevice2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothDeviceInfo_1, sizeof(QBluetoothDeviceInfo), typeid(QBluetoothDeviceInfo), false, &deleter_QBluetoothDeviceInfo, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::QBluetoothDeviceInfo(QBluetoothDeviceInfo)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_initialize_1native__Lio_qt_bluetooth_QBluetoothDeviceInfo_2Lio_qt_bluetooth_QBluetoothDeviceInfo_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothDeviceInfo::QBluetoothDeviceInfo(QBluetoothDeviceInfo)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothDeviceInfo_2, sizeof(QBluetoothDeviceInfo), typeid(QBluetoothDeviceInfo), false, &deleter_QBluetoothDeviceInfo, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::QBluetoothDeviceInfo(QBluetoothUuid,QString,quint32)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_initialize_1native__Lio_qt_bluetooth_QBluetoothDeviceInfo_2Lio_qt_bluetooth_QBluetoothUuid_2Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject uuid0,
 jstring name1,
 jint classOfDevice2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothDeviceInfo::QBluetoothDeviceInfo(QBluetoothUuid,QString,quint32)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = uuid0;
        arguments[1].l = name1;
        arguments[2].i = classOfDevice2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothDeviceInfo_3, sizeof(QBluetoothDeviceInfo), typeid(QBluetoothDeviceInfo), false, &deleter_QBluetoothDeviceInfo, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::address()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_address_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::address()const", __qt_this)
        QBluetoothAddress __qt_return_value = __qt_this->address();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::coreConfigurations()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_coreConfigurations_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::coreConfigurations()const", __qt_this)
        QBluetoothDeviceInfo::CoreConfigurations __qt_return_value = __qt_this->coreConfigurations();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::deviceUuid()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_deviceUuid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::deviceUuid()const", __qt_this)
        QBluetoothUuid __qt_return_value = __qt_this->deviceUuid();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::isCached()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_isCached_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::isCached()const", __qt_this)
        __java_return_value = __qt_this->isCached();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::majorDeviceClass()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_majorDeviceClass_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::majorDeviceClass()const", __qt_this)
        QBluetoothDeviceInfo::MajorDeviceClass __qt_return_value = __qt_this->majorDeviceClass();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::manufacturerData()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_manufacturerData_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::manufacturerData()const", __qt_this)
        QMultiHash<quint16, QByteArray> __qt_return_value = __qt_this->manufacturerData();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::manufacturerData(quint16)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_manufacturerData_1native_1quint16_1constfct__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort manufacturerId0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::manufacturerData(quint16)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->manufacturerData(static_cast<quint16>(manufacturerId0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::manufacturerIds()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_manufacturerIds_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::manufacturerIds()const", __qt_this)
        QList<quint16> __qt_return_value = __qt_this->manufacturerIds();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::minorDeviceClass()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_minorDeviceClass_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::minorDeviceClass()const", __qt_this)
        quint8 __qt_return_value = __qt_this->minorDeviceClass();
        __java_return_value = jbyte(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::name()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_name_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::name()const", __qt_this)
        QString __qt_return_value = __qt_this->name();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::operator=(QBluetoothDeviceInfo)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_assign_1native_1cref_1QBluetoothDeviceInfo__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::operator=(QBluetoothDeviceInfo)", __qt_this)
        const QBluetoothDeviceInfo& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothDeviceInfo>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::operator==(QBluetoothDeviceInfo,QBluetoothDeviceInfo)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_operator_1equal_1native_1cref_1QBluetoothDeviceInfo__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID b1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::operator==(QBluetoothDeviceInfo,QBluetoothDeviceInfo)", __qt_this)
        const QBluetoothDeviceInfo& __qt_b1 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothDeviceInfo>(b1);
        __java_return_value = (*__qt_this) == __qt_b1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::rssi()const
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_rssi_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::rssi()const", __qt_this)
        qint16 __qt_return_value = __qt_this->rssi();
        __java_return_value = jshort(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::serviceClasses()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_serviceClasses_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::serviceClasses()const", __qt_this)
        QBluetoothDeviceInfo::ServiceClasses __qt_return_value = __qt_this->serviceClasses();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::serviceData()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_serviceData_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::serviceData()const", __qt_this)
        QMultiHash<QBluetoothUuid, QByteArray> __qt_return_value = __qt_this->serviceData();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::serviceData(QBluetoothUuid)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_serviceData_1native_1cref_1QBluetoothUuid_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID serviceId0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::serviceData(QBluetoothUuid)const", __qt_this)
        const QBluetoothUuid& __qt_serviceId0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(serviceId0);
        QByteArray __qt_return_value = __qt_this->serviceData(__qt_serviceId0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::serviceIds()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_serviceIds_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::serviceIds()const", __qt_this)
        QList<QBluetoothUuid> __qt_return_value = __qt_this->serviceIds();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::serviceUuids()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_serviceUuids_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::serviceUuids()const", __qt_this)
        QList<QBluetoothUuid> __qt_return_value = __qt_this->serviceUuids();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::setCached(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setCached_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean cached0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setCached(bool)", __qt_this)
        __qt_this->setCached(static_cast<bool>(cached0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::setCoreConfigurations(QBluetoothDeviceInfo::CoreConfigurations)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setCoreConfigurations_1native_1QBluetoothDeviceInfo_1CoreConfigurations__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint coreConfigs0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setCoreConfigurations(QBluetoothDeviceInfo::CoreConfigurations)", __qt_this)
        QBluetoothDeviceInfo::CoreConfigurations __qt_coreConfigs0 = qtjambi_cast<QBluetoothDeviceInfo::CoreConfigurations>(__jni_env, coreConfigs0);
        __qt_this->setCoreConfigurations(QBluetoothDeviceInfo::CoreConfigurations(__qt_coreConfigs0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::setDeviceUuid(QBluetoothUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setDeviceUuid_1native_1cref_1QBluetoothUuid__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID uuid0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setDeviceUuid(QBluetoothUuid)", __qt_this)
        const QBluetoothUuid& __qt_uuid0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(uuid0);
        __qt_this->setDeviceUuid(__qt_uuid0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::setManufacturerData(quint16,QByteArray)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setManufacturerData_1native_1quint16_1cref_1QByteArray__JSJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort manufacturerId0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setManufacturerData(quint16,QByteArray)", __qt_this)
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        __java_return_value = __qt_this->setManufacturerData(static_cast<quint16>(manufacturerId0), __qt_data1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::setName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setName(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __qt_this->setName(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::setRssi(qint16)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setRssi_1native_1qint16__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort signal0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setRssi(qint16)", __qt_this)
        __qt_this->setRssi(static_cast<qint16>(signal0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothDeviceInfo::setServiceData(QBluetoothUuid,QByteArray)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setServiceData_1native_1cref_1QBluetoothUuid_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID serviceId0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setServiceData(QBluetoothUuid,QByteArray)", __qt_this)
        const QBluetoothUuid& __qt_serviceId0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(serviceId0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        __java_return_value = __qt_this->setServiceData(__qt_serviceId0, __qt_data1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothDeviceInfo::setServiceUuids(QList<QBluetoothUuid>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_setServiceUuids_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject uuids0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothDeviceInfo::setServiceUuids(QList<QBluetoothUuid>)", __qt_this)
        const QList<QBluetoothUuid>&  __qt_uuids0 = qtjambi_cast<const QList<QBluetoothUuid>& >(__jni_env, __qtjambi_scope, uuids0);
        __qt_this->setServiceUuids(__qt_uuids0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothDeviceInfo_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QBluetoothDeviceInfo *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothDeviceInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QBluetoothDeviceInfo(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QBluetoothDeviceInfo>("QBluetoothDeviceInfo", "io/qt/bluetooth/QBluetoothDeviceInfo");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QBluetoothDeviceInfo, {
        ConstructorInfo(&__qt_construct_QBluetoothDeviceInfo_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QBluetoothDeviceInfo_1, "Lio/qt/bluetooth/QBluetoothAddress;Ljava/lang/String;I")
       ,ConstructorInfo(&__qt_construct_QBluetoothDeviceInfo_2, "Lio/qt/bluetooth/QBluetoothDeviceInfo;")
       ,ConstructorInfo(&__qt_construct_QBluetoothDeviceInfo_3, "Lio/qt/bluetooth/QBluetoothUuid;Ljava/lang/String;I")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QBluetoothDeviceInfo);
    registerMetaType<QBluetoothDeviceInfo>("QBluetoothDeviceInfo");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QBluetoothDeviceInfo::CoreConfiguration>("QBluetoothDeviceInfo::CoreConfiguration", "io/qt/bluetooth/QBluetoothDeviceInfo$CoreConfiguration", "QBluetoothDeviceInfo::CoreConfigurations", "QFlags<QBluetoothDeviceInfo::CoreConfiguration>", "io/qt/bluetooth/QBluetoothDeviceInfo$CoreConfigurations");
    registerEnumTypeInfo<QBluetoothDeviceInfo::Field>("QBluetoothDeviceInfo::Field", "io/qt/bluetooth/QBluetoothDeviceInfo$Field", "QBluetoothDeviceInfo::Fields", "QFlags<QBluetoothDeviceInfo::Field>", "io/qt/bluetooth/QBluetoothDeviceInfo$Fields");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MajorDeviceClass>("QBluetoothDeviceInfo::MajorDeviceClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MajorDeviceClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorAudioVideoClass>("QBluetoothDeviceInfo::MinorAudioVideoClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorAudioVideoClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorComputerClass>("QBluetoothDeviceInfo::MinorComputerClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorComputerClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorHealthClass>("QBluetoothDeviceInfo::MinorHealthClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorHealthClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorImagingClass>("QBluetoothDeviceInfo::MinorImagingClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorImagingClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorMiscellaneousClass>("QBluetoothDeviceInfo::MinorMiscellaneousClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorMiscellaneousClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorNetworkClass>("QBluetoothDeviceInfo::MinorNetworkClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorNetworkClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorPeripheralClass>("QBluetoothDeviceInfo::MinorPeripheralClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorPeripheralClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorPhoneClass>("QBluetoothDeviceInfo::MinorPhoneClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorPhoneClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorToyClass>("QBluetoothDeviceInfo::MinorToyClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorToyClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::MinorWearableClass>("QBluetoothDeviceInfo::MinorWearableClass", "io/qt/bluetooth/QBluetoothDeviceInfo$MinorWearableClass");
    registerEnumTypeInfo<QBluetoothDeviceInfo::ServiceClass>("QBluetoothDeviceInfo::ServiceClass", "io/qt/bluetooth/QBluetoothDeviceInfo$ServiceClass", "QBluetoothDeviceInfo::ServiceClasses", "QFlags<QBluetoothDeviceInfo::ServiceClass>", "io/qt/bluetooth/QBluetoothDeviceInfo$ServiceClasses");
// END: enums and flags
}
