#include <QtCore/QtGlobal>
#include <QtBluetooth/qbluetoothuuid.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qbytearrayview.h>
#include <QtCore/qdatastream.h>
#include <QtCore/qdebug.h>
#include <QtCore/quuid.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiBluetooth/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QBluetoothUuid(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QBluetoothUuid")
    QBluetoothUuid *_ptr = reinterpret_cast<QBluetoothUuid *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QBluetoothUuid()
void __qt_construct_QBluetoothUuid(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid()")
    Q_UNUSED(__java_arguments)
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(QBluetoothUuid)
void __qt_construct_QBluetoothUuid_cref_QBluetoothUuid(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(QBluetoothUuid)")
    jobject uuid0 = __java_arguments[0].l;
    const QBluetoothUuid& __qt_uuid0 = qtjambi_cast<const QBluetoothUuid& >(__jni_env, uuid0);
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(__qt_uuid0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(QBluetoothUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2Lio_qt_bluetooth_QBluetoothUuid_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(QBluetoothUuid)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_cref_QBluetoothUuid, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(QBluetoothUuid::CharacteristicType)
void __qt_construct_QBluetoothUuid_QBluetoothUuid_CharacteristicType(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(QBluetoothUuid::CharacteristicType)")
    jobject uuid0 = __java_arguments[0].l;
    QBluetoothUuid::CharacteristicType __qt_uuid0 = qtjambi_cast<QBluetoothUuid::CharacteristicType>(__jni_env, uuid0);
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(QBluetoothUuid::CharacteristicType(__qt_uuid0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::CharacteristicType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2Lio_qt_bluetooth_QBluetoothUuid_00024CharacteristicType_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::CharacteristicType)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_QBluetoothUuid_CharacteristicType, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(QBluetoothUuid::DescriptorType)
void __qt_construct_QBluetoothUuid_QBluetoothUuid_DescriptorType(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(QBluetoothUuid::DescriptorType)")
    jobject uuid0 = __java_arguments[0].l;
    QBluetoothUuid::DescriptorType __qt_uuid0 = qtjambi_cast<QBluetoothUuid::DescriptorType>(__jni_env, uuid0);
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(QBluetoothUuid::DescriptorType(__qt_uuid0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::DescriptorType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2Lio_qt_bluetooth_QBluetoothUuid_00024DescriptorType_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::DescriptorType)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_QBluetoothUuid_DescriptorType, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(QBluetoothUuid::ProtocolUuid)
void __qt_construct_QBluetoothUuid_QBluetoothUuid_ProtocolUuid(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(QBluetoothUuid::ProtocolUuid)")
    jobject uuid0 = __java_arguments[0].l;
    QBluetoothUuid::ProtocolUuid __qt_uuid0 = qtjambi_cast<QBluetoothUuid::ProtocolUuid>(__jni_env, uuid0);
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(QBluetoothUuid::ProtocolUuid(__qt_uuid0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::ProtocolUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2Lio_qt_bluetooth_QBluetoothUuid_00024ProtocolUuid_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::ProtocolUuid)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_QBluetoothUuid_ProtocolUuid, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(QBluetoothUuid::ServiceClassUuid)
void __qt_construct_QBluetoothUuid_QBluetoothUuid_ServiceClassUuid(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(QBluetoothUuid::ServiceClassUuid)")
    jobject uuid0 = __java_arguments[0].l;
    QBluetoothUuid::ServiceClassUuid __qt_uuid0 = qtjambi_cast<QBluetoothUuid::ServiceClassUuid>(__jni_env, uuid0);
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(QBluetoothUuid::ServiceClassUuid(__qt_uuid0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::ServiceClassUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2Lio_qt_bluetooth_QBluetoothUuid_00024ServiceClassUuid_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(QBluetoothUuid::ServiceClassUuid)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_QBluetoothUuid_ServiceClassUuid, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(QString)
void __qt_construct_QBluetoothUuid_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(QString)")
    jstring uuid0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_uuid0 = qtjambi_cast<QString>(__jni_env, uuid0);
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(__qt_uuid0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_cref_QString, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(QUuid)
void __qt_construct_QBluetoothUuid_cref_QUuid(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(QUuid)")
    jobject uuid0 = __java_arguments[0].l;
    const QUuid& __qt_uuid0 = qtjambi_cast<const QUuid& >(__jni_env, uuid0);
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(__qt_uuid0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(QUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2Lio_qt_core_QUuid_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(QUuid)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_cref_QUuid, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(quint128)
void __qt_construct_QBluetoothUuid_quint128(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(quint128)")
    jbyteArray uuid0 = static_cast<jbyteArray>(__java_arguments[0].l);
    quint128 __qt_uuid0;
    __jni_env->GetByteArrayRegion(jbyteArray(uuid0), 0, 16, *reinterpret_cast<jbyte **>(&__qt_uuid0));
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(__qt_uuid0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(quint128)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2_3B)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jbyteArray uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(quint128)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_quint128, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(quint16)
void __qt_construct_QBluetoothUuid_quint16(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(quint16)")
    jshort uuid0 = __java_arguments[0].s;
    Q_UNUSED(uuid0)
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(static_cast<quint16>(uuid0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(quint16)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2S)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jshort uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(quint16)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.s = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_quint16, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBluetoothUuid(quint32)
void __qt_construct_QBluetoothUuid_quint32(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBluetoothUuid(quint32)")
    jint uuid0 = __java_arguments[0].i;
    Q_UNUSED(uuid0)
    QBluetoothUuid *__qt_this = new(__qtjambi_ptr) QBluetoothUuid(static_cast<quint32>(uuid0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QBluetoothUuid::QBluetoothUuid(quint32)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_initialize_1native__Lio_qt_bluetooth_QBluetoothUuid_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::QBluetoothUuid(quint32)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.i = uuid0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBluetoothUuid_quint32, sizeof(QBluetoothUuid), typeid(QBluetoothUuid), false, &deleter_QBluetoothUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QBluetoothUuid
void __qt_destruct_QBluetoothUuid(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QBluetoothUuid")
    reinterpret_cast<QBluetoothUuid*>(ptr)->~QBluetoothUuid();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QBluetoothUuid::minimumSize()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_minimumSize_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::minimumSize()const", __qt_this)
        __java_return_value = __qt_this->minimumSize();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::operator<<(QDataStream&,QBluetoothUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::operator<<(QDataStream&,QBluetoothUuid)", __qt_this)
        QDataStream& __qt_s0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, s0);
        __qt_s0 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothUuid::operator=(QBluetoothUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_assign_1native_1cref_1QBluetoothUuid__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::operator=(QBluetoothUuid)", __qt_this)
        const QBluetoothUuid& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothUuid::operator==(QBluetoothUuid,QBluetoothUuid)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_equals_1native_1cref_1QBluetoothUuid__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID b1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::operator==(QBluetoothUuid,QBluetoothUuid)", __qt_this)
        const QBluetoothUuid& __qt_b1 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(b1);
        __java_return_value = (*__qt_this) == __qt_b1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::operator>>(QDataStream&,QBluetoothUuid&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::operator>>(QDataStream&,QBluetoothUuid&)", __qt_this)
        QDataStream& __qt_s0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, s0);
        __qt_s0 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBluetoothUuid::toUInt128()const
extern "C" Q_DECL_EXPORT jbyteArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_toBytes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyteArray __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::toUInt128()const", __qt_this)
        quint128 __qt_return_value = __qt_this->toUInt128();
        Int8PointerArray __qt_return_valueArray(__jni_env, reinterpret_cast<qint8*>(__qt_return_value.data), 16);
        __java_return_value = __jni_env->NewByteArray(16);
        __jni_env->SetByteArrayRegion(jbyteArray(__java_return_value), 0, 16, *reinterpret_cast<jbyte **>(&__qt_return_value));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::toUInt16(bool*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_toShort_1native_1bool_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::toUInt16(bool*)const", __qt_this)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        quint16 __qt_return_value = __qt_this->toUInt16(__qt_ok0);
        __java_return_value = ok ? QtJambiAPI::toJavaShortObject(__jni_env, __qt_return_value) : nullptr;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::toUInt32(bool*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_toInt_1native_1bool_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBluetoothUuid::toUInt32(bool*)const", __qt_this)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        quint32 __qt_return_value = __qt_this->toUInt32(__qt_ok0);
        __java_return_value = ok ? QtJambiAPI::toJavaIntegerObject(__jni_env, __qt_return_value) : nullptr;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::characteristicToString(QBluetoothUuid::CharacteristicType)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_characteristicToString_1native_1QBluetoothUuid_1CharacteristicType__I)
(JNIEnv *__jni_env,
 jclass,
 jint uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::characteristicToString(QBluetoothUuid::CharacteristicType)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothUuid::CharacteristicType __qt_uuid0 = qtjambi_cast<QBluetoothUuid::CharacteristicType>(__jni_env, uuid0);
        QString __qt_return_value = QBluetoothUuid::characteristicToString(QBluetoothUuid::CharacteristicType(__qt_uuid0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::descriptorToString(QBluetoothUuid::DescriptorType)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_descriptorToString_1native_1QBluetoothUuid_1DescriptorType__I)
(JNIEnv *__jni_env,
 jclass,
 jint uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::descriptorToString(QBluetoothUuid::DescriptorType)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothUuid::DescriptorType __qt_uuid0 = qtjambi_cast<QBluetoothUuid::DescriptorType>(__jni_env, uuid0);
        QString __qt_return_value = QBluetoothUuid::descriptorToString(QBluetoothUuid::DescriptorType(__qt_uuid0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::protocolToString(QBluetoothUuid::ProtocolUuid)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_protocolToString_1native_1QBluetoothUuid_1ProtocolUuid__I)
(JNIEnv *__jni_env,
 jclass,
 jint uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::protocolToString(QBluetoothUuid::ProtocolUuid)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothUuid::ProtocolUuid __qt_uuid0 = qtjambi_cast<QBluetoothUuid::ProtocolUuid>(__jni_env, uuid0);
        QString __qt_return_value = QBluetoothUuid::protocolToString(QBluetoothUuid::ProtocolUuid(__qt_uuid0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::serviceClassToString(QBluetoothUuid::ServiceClassUuid)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_serviceClassToString_1native_1QBluetoothUuid_1ServiceClassUuid__I)
(JNIEnv *__jni_env,
 jclass,
 jint uuid0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::serviceClassToString(QBluetoothUuid::ServiceClassUuid)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QBluetoothUuid::ServiceClassUuid __qt_uuid0 = qtjambi_cast<QBluetoothUuid::ServiceClassUuid>(__jni_env, uuid0);
        QString __qt_return_value = QBluetoothUuid::serviceClassToString(QBluetoothUuid::ServiceClassUuid(__qt_uuid0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBluetoothUuid::streamingOperator(QDebug,QBluetoothUuid)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_streamingOperator_1native_1QDebug_1cref_1QBluetoothUuid__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID debug0,
 QtJambiNativeID uuid1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBluetoothUuid::streamingOperator(QDebug,QBluetoothUuid)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug __qt_debug0 = QtJambiAPI::objectReferenceFromNativeId<QDebug>(__jni_env, debug0);
        const QBluetoothUuid& __qt_uuid1 = QtJambiAPI::valueReferenceFromNativeId<QBluetoothUuid>(uuid1);
        QDebug __qt_return_value = QBluetoothUuid::streamingOperator(__qt_debug0, __qt_uuid1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_bluetooth_QBluetoothUuid_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QBluetoothUuid *__qt_this = QtJambiAPI::objectFromNativeId<QBluetoothUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QBluetoothUuid(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QBluetoothUuid>("QBluetoothUuid", "io/qt/bluetooth/QBluetoothUuid");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QBluetoothUuid, {
        ConstructorInfo(&__qt_construct_QBluetoothUuid, nullptr)
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_cref_QBluetoothUuid, "Lio/qt/bluetooth/QBluetoothUuid;")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_QBluetoothUuid_CharacteristicType, "Lio/qt/bluetooth/QBluetoothUuid$CharacteristicType;")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_QBluetoothUuid_DescriptorType, "Lio/qt/bluetooth/QBluetoothUuid$DescriptorType;")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_QBluetoothUuid_ProtocolUuid, "Lio/qt/bluetooth/QBluetoothUuid$ProtocolUuid;")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_QBluetoothUuid_ServiceClassUuid, "Lio/qt/bluetooth/QBluetoothUuid$ServiceClassUuid;")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_cref_QString, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_cref_QUuid, "Lio/qt/core/QUuid;")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_quint128, "[B")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_quint16, "S")
       ,ConstructorInfo(&__qt_construct_QBluetoothUuid_quint32, "I")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QBluetoothUuid);
    registerMetaType<QBluetoothUuid>("QBluetoothUuid");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QBluetoothUuid::CharacteristicType>("QBluetoothUuid::CharacteristicType", "io/qt/bluetooth/QBluetoothUuid$CharacteristicType");
    registerEnumTypeInfo<QBluetoothUuid::DescriptorType>("QBluetoothUuid::DescriptorType", "io/qt/bluetooth/QBluetoothUuid$DescriptorType");
    registerEnumTypeInfo<QBluetoothUuid::ProtocolUuid>("QBluetoothUuid::ProtocolUuid", "io/qt/bluetooth/QBluetoothUuid$ProtocolUuid");
    registerEnumTypeInfo<QBluetoothUuid::ServiceClassUuid>("QBluetoothUuid::ServiceClassUuid", "io/qt/bluetooth/QBluetoothUuid$ServiceClassUuid");
// END: enums and flags
}
