package io.qt.activex;

import io.qt.*;


/**
 * <p>QWidget that wraps an ActiveX control</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaxwidget.html">QAxWidget</a></code></p>
 */
public class QAxWidget extends io.qt.activex.QAxBaseWidget
    implements io.qt.activex.QAxBase
{
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxwidget.html#QAxWidget-1">QAxWidget::<wbr/>QAxWidget(QString,<wbr/>QWidget*,<wbr/>Qt::WindowFlags)</a></code></p>
     */
    public QAxWidget(java.lang.@NonNull String c, io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowFlags f){
        super((QPrivateConstructor)null);
        initialize_native(this, c, parent, f);
    }
    
    private native static void initialize_native(QAxWidget instance, java.lang.String c, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxwidget.html#QAxWidget">QAxWidget::<wbr/>QAxWidget(QWidget*,<wbr/>Qt::WindowFlags)</a></code></p>
     */
    public QAxWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowFlags f){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, f);
    }
    
    private native static void initialize_native(QAxWidget instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#asVariant">QAxBase::<wbr/>asVariant()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object asVariant(){
        return asVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.Object asVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAxBase::<wbr/>axBaseMetaObject()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QMetaObject axBaseMetaObject(){
        return axBaseMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QMetaObject axBaseMetaObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAxBase::<wbr/>className()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@Nullable String className(){
        return className_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.String className_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#clear">QAxBase::<wbr/>clear()</a></code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code>QAxBase::<wbr/>connectNotify()</code></p>
     */
    @QtUninvokable
    protected final void connectNotify(){
        connectNotify_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void connectNotify_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxwidget.html#createHostWindow-1">QAxWidget::<wbr/>createHostWindow(bool,<wbr/>QByteArray)</a></code></p>
     */
    @QtUninvokable
    protected final boolean createHostWindow(boolean arg__1, io.qt.core.@NonNull QByteArray arg__2){
        return createHostWindow_native_bool_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @QtUninvokable
    private native boolean createHostWindow_native_bool_cref_QByteArray(long __this__nativeId, boolean arg__1, long arg__2);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#disableClassInfo">QAxBase::<wbr/>disableClassInfo()</a></code></p>
     */
    @QtUninvokable
    public final void disableClassInfo(){
        disableClassInfo_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void disableClassInfo_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#disableEventSink">QAxBase::<wbr/>disableEventSink()</a></code></p>
     */
    @QtUninvokable
    public final void disableEventSink(){
        disableEventSink_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void disableEventSink_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#disableMetaObject">QAxBase::<wbr/>disableMetaObject()</a></code></p>
     */
    @QtUninvokable
    public final void disableMetaObject(){
        disableMetaObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void disableMetaObject_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxwidget.html#doVerb">QAxWidget::<wbr/>doVerb(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean doVerb(java.lang.@NonNull String verb){
        return doVerb_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), verb);
    }
    
    @QtUninvokable
    private native boolean doVerb_native_cref_QString(long __this__nativeId, java.lang.String verb);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall-1">QAxBase::<wbr/>dynamicCall(const char*,<wbr/>QList&lt;QVariant&gt;&amp;)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.util.@NonNull Collection<? extends java.lang.Object> vars){
        return dynamicCall_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
    }
    
    private native static java.lang.Object dynamicCall_native_const_char_ptr_ref_QList(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars);
    
    /**
     * <p>See <code>QAxBase::<wbr/>dynamicCall(const char*,<wbr/>QList&lt;QVariant&gt;&amp;,<wbr/>uint)</code></p>
     */
    @QtUninvokable
    protected final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.util.@NonNull Collection<? extends java.lang.Object> vars, int flags){
        return dynamicCall_native_const_char_ptr_ref_QList_unsigned(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars, flags);
    }
    
    private native static java.lang.Object dynamicCall_native_const_char_ptr_ref_QList_unsigned(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars, int flags);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall">QAxBase::<wbr/>dynamicCall(const char*,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return dynamicCall_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    private native static java.lang.Object dynamicCall_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#generateDocumentation">QAxBase::<wbr/>generateDocumentation()</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String generateDocumentation(){
        return generateDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.String generateDocumentation_native(long __this__nativeId);
    
    /**
     * <p>See <code>QAxBase::<wbr/>indexOfVerb(QString)const</code></p>
     */
    @QtUninvokable
    protected final int indexOfVerb(java.lang.@NonNull String verb){
        return indexOfVerb_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), verb);
    }
    
    private native static int indexOfVerb_native_cref_QString_constfct(long __this__nativeId, java.lang.String verb);
    
    /**
     * <p>See <code>QAxBase::<wbr/>initializeFrom(QAxBase*)</code></p>
     */
    @QtUninvokable
    protected final void initializeFrom(io.qt.activex.@Nullable QAxBase that){
        initializeFrom_native_QAxBase_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(that));
    }
    
    private native static void initializeFrom_native_QAxBase_ptr(long __this__nativeId, long that);
    
    /**
     * <p>See <code>QAxBase::<wbr/>internalRelease()</code></p>
     */
    @QtUninvokable
    protected final void internalRelease(){
        internalRelease_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void internalRelease_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#isNull">QAxBase::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomnode.html#operator-lt-lt">operator&lt;&lt;(QDataStream&amp;)</a></code></p>
     */
    @QtUninvokable
    public void writeTo(io.qt.core.@StrictNonNull QDataStream s){
        java.util.Objects.requireNonNull(s, "Argument 's': null not expected.");
        writeTo_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(s));
    }
    
    private native static void writeTo_native_ref_QDataStream(long __this__nativeId, long s);
    
    /**
     * <p>See <code>operator&gt;&gt;(QDataStream&amp;)</code></p>
     */
    @QtUninvokable
    public void readFrom(io.qt.core.@StrictNonNull QDataStream s){
        java.util.Objects.requireNonNull(s, "Argument 's': null not expected.");
        readFrom_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(s));
    }
    
    private native static void readFrom_native_ref_QDataStream(long __this__nativeId, long s);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#propertyBag">QAxBase::<wbr/>propertyBag()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.Object> propertyBag(){
        return propertyBag_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QMap<java.lang.String, java.lang.Object> propertyBag_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAxBase::<wbr/>qObject()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QObject qObject(){
        return qObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QObject qObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#querySubObject-1">QAxBase::<wbr/>querySubObject(const char*,<wbr/>QList&lt;QVariant&gt;&amp;)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.util.@NonNull Collection<? extends java.lang.Object> vars){
        return querySubObject_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
    }
    
    private native static io.qt.activex.QAxObject querySubObject_native_const_char_ptr_ref_QList(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#querySubObject">QAxBase::<wbr/>querySubObject(const char*,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return querySubObject_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    private native static io.qt.activex.QAxObject querySubObject_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#setPropertyBag">QAxBase::<wbr/>setPropertyBag(QMap&lt;QString,<wbr/>QVariant&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setPropertyBag(java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> arg__1){
        setPropertyBag_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native static void setPropertyBag_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#verbs">QAxBase::<wbr/>verbs()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList verbs(){
        return verbs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QStringList verbs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#changeEvent">QWidget::<wbr/>changeEvent(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void changeEvent(io.qt.core.@Nullable QEvent e){
        changeEvent_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void changeEvent_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#classContext">QAxBase::<wbr/>classContext()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public int classContext(){
        return classContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int classContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#connectNotify">QObject::<wbr/>connectNotify(QMetaMethod)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void connectNotify(io.qt.core.@NonNull QMetaMethod signal){
        connectNotify_native_cref_QMetaMethod(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @QtUninvokable
    private native void connectNotify_native_cref_QMetaMethod(long __this__nativeId, long signal);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#control">QAxBase::<wbr/>control()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public java.lang.@NonNull String control(){
        return control_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.String control_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxwidget.html#createHostWindow">QAxWidget::<wbr/>createHostWindow(bool)</a></code></p>
     */
    @QtUninvokable
    protected boolean createHostWindow(boolean arg__1){
        return createHostWindow_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native boolean createHostWindow_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#minimumSizeHint-prop">QWidget::<wbr/>minimumSizeHint()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.core.@NonNull QSize minimumSizeHint(){
        return minimumSizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize minimumSizeHint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#propertyWritable">QAxBase::<wbr/>propertyWritable(const char*)const</a></code></p>
     */
    @QtUninvokable
    public boolean propertyWritable(java.lang.@Nullable String arg__1){
        return propertyWritable_native_const_char_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native static boolean propertyWritable_native_const_char_ptr_constfct(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#resetControl">QAxObjectInterface::<wbr/>resetControl()</a></code></p>
     */
    @QtUninvokable
    @Override
    public void resetControl(){
        resetControl_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void resetControl_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#resizeEvent">QWidget::<wbr/>resizeEvent(QResizeEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void resizeEvent(io.qt.gui.@Nullable QResizeEvent arg__1){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#setClassContext">QAxBase::<wbr/>setClassContext(ulong)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void setClassContext(int classContext){
        setClassContext_native_ulong(QtJambi_LibraryUtilities.internal.nativeId(this), classContext);
    }
    
    private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
    
    /**
     * <p>See <code>QAxBase::<wbr/>setControl(QString)</code></p>
     */
    @QtUninvokable
    @Override
    public boolean setControl(java.lang.@NonNull String arg__1){
        return setControl_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbase.html#setPropertyWritable">QAxBase::<wbr/>setPropertyWritable(const char*,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public void setPropertyWritable(java.lang.@Nullable String arg__1, boolean arg__2){
        setPropertyWritable_native_const_char_ptr_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, arg__2);
    }
    
    private native static void setPropertyWritable_native_const_char_ptr_bool(long __this__nativeId, java.lang.String arg__1, boolean arg__2);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#sizeHint-prop">QWidget::<wbr/>sizeHint()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.core.@NonNull QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxwidget.html#translateKeyEvent">QAxWidget::<wbr/>translateKeyEvent(int,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    protected boolean translateKeyEvent(int message, int keycode){
        return translateKeyEvent_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), message, keycode);
    }
    
    @QtUninvokable
    private native boolean translateKeyEvent_native_int_int_constfct(long __this__nativeId, int message, int keycode);
    
    /**
     * <p>See <code>QAxBase::<wbr/>argumentsToList(QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant)</code></p>
     */
    protected native static io.qt.core.@NonNull QList<java.lang.Object> argumentsToList(java.lang.Object var1, java.lang.Object var2, java.lang.Object var3, java.lang.Object var4, java.lang.Object var5, java.lang.Object var6, java.lang.Object var7, java.lang.Object var8);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAxWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAxWidget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(java.lang.String, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>f = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QAxWidget(java.lang.@NonNull String c, io.qt.widgets.@Nullable QWidget parent) {
        this(c, parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(java.lang.String, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>f = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QAxWidget(java.lang.@NonNull String c) {
        this(c, (io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(java.lang.String, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QAxWidget(java.lang.@NonNull String c, io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowType @NonNull... f) {
        this(c, parent, new io.qt.core.Qt.WindowFlags(f));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>f = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QAxWidget(io.qt.widgets.@Nullable QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>f = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QAxWidget() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QAxWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowType @NonNull... f) {
        this(parent, new io.qt.core.Qt.WindowFlags(f));
    }
    
    /**
     * <p>Overloaded function for {@link #createHostWindow(boolean, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    protected final boolean createHostWindow(boolean arg__1, byte @NonNull[] arg__2) {
        return createHostWindow(arg__1, new io.qt.core.QByteArray(arg__2));
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return dynamicCall(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return dynamicCall(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return dynamicCall(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return dynamicCall(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return dynamicCall(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2) {
        return dynamicCall(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name, java.lang.Object v1) {
        return dynamicCall(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.@Nullable String name) {
        return dynamicCall(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return querySubObject(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return querySubObject(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return querySubObject(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return querySubObject(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return querySubObject(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1, java.lang.Object v2) {
        return querySubObject(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name, java.lang.Object v1) {
        return querySubObject(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxObject querySubObject(java.lang.@Nullable String name) {
        return querySubObject(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
}
