package io.qt.activex;

import io.qt.*;


/**
 * <p>Bridge between application objects and script code</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html">QAxScriptManager</a></code></p>
 */
public class QAxScriptManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcObjects;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxScriptManager.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#error">QAxScriptManager::<wbr/>error(QAxScript*,<wbr/>int,<wbr/>QString,<wbr/>int,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal5<io.qt.activex.@Nullable QAxScript, java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String> error = new Signal5<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#QAxScriptManager">QAxScriptManager::<wbr/>QAxScriptManager(QObject*)</a></code></p>
     */
    public QAxScriptManager(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAxScriptManager instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#addObject">QAxScriptManager::<wbr/>addObject(QAxBase*)</a></code></p>
     */
    @QtUninvokable
    public final void addObject(io.qt.activex.@Nullable QAxBase object){
        addObject_native_QAxBase_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
        if (object != null) {
            if(__rcObjects==null)
                __rcObjects = QtJambi_LibraryUtilities.internal.newRCList();
            __rcObjects.add(object);
        }
    }
    
    @QtUninvokable
    private native void addObject_native_QAxBase_ptr(long __this__nativeId, long object);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#call-1">QAxScriptManager::<wbr/>call(QString,<wbr/>QList&lt;QVariant&gt;&amp;)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.util.@NonNull Collection<? extends java.lang.Object> arguments){
        return call_native_cref_QString_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), function, arguments);
    }
    
    @QtUninvokable
    private native java.lang.Object call_native_cref_QString_ref_QList(long __this__nativeId, java.lang.String function, java.util.Collection<? extends java.lang.Object> arguments);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#call">QAxScriptManager::<wbr/>call(QString,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return call_native_cref_QString_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), function, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    @QtUninvokable
    private native java.lang.Object call_native_cref_QString_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#functions">QAxScriptManager::<wbr/>functions(QAxScript::FunctionFlags)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList functions(io.qt.activex.QAxScript.@NonNull FunctionFlags arg__1){
        return functions_native_QAxScript_FunctionFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList functions_native_QAxScript_FunctionFlags_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#load-1">QAxScriptManager::<wbr/>load(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxScript load(java.lang.@NonNull String file, java.lang.@NonNull String name){
        return load_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), file, name);
    }
    
    @QtUninvokable
    private native io.qt.activex.QAxScript load_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String file, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#load">QAxScriptManager::<wbr/>load(QString,<wbr/>QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxScript load(java.lang.@NonNull String code, java.lang.@NonNull String name, java.lang.@NonNull String language){
        return load_native_cref_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), code, name, language);
    }
    
    @QtUninvokable
    private native io.qt.activex.QAxScript load_native_cref_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String code, java.lang.String name, java.lang.String language);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#script">QAxScriptManager::<wbr/>script(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxScript script(java.lang.@NonNull String name){
        return script_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.activex.QAxScript script_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#scriptNames">QAxScriptManager::<wbr/>scriptNames()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList scriptNames(){
        return scriptNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList scriptNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#registerEngine">QAxScriptManager::<wbr/>registerEngine(QString,<wbr/>QString,<wbr/>QString)</a></code></p>
     */
    public native static boolean registerEngine(java.lang.@NonNull String name, java.lang.@NonNull String extension, java.lang.@NonNull String code);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptmanager.html#scriptFileFilter">QAxScriptManager::<wbr/>scriptFileFilter()</a></code></p>
     */
    public native static java.lang.@NonNull String scriptFileFilter();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxScriptManager(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAxScriptManager(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAxScriptManager instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAxScriptManager(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAxScriptManager() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return call(function, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return call(function, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return call(function, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return call(function, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return call(function, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2) {
        return call(function, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1) {
        return call(function, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function) {
        return call(function, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #functions(io.qt.activex.QAxScript.FunctionFlags)}
     *  with <code>arg__1 = io.qt.activex.QAxScript.FunctionFlags.FunctionNames</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList functions() {
        return functions(io.qt.activex.QAxScript.FunctionFlags.FunctionNames);
    }
    
    /**
     * <p>Overloaded function for {@link #registerEngine(java.lang.String, java.lang.String, java.lang.String)}
     *  with <code>code = (String)null</code>.</p>
     */
    public static boolean registerEngine(java.lang.@NonNull String name, java.lang.@NonNull String extension) {
        return registerEngine(name, extension, (String)null);
    }
}
