package io.qt.activex;

import io.qt.*;


/**
 * <p>Wrapper around a script engine</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaxscriptengine.html">QAxScriptEngine</a></code></p>
 */
public class QAxScriptEngine extends io.qt.activex.QAxObject
{
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::State</a></code></p>
     */
    @QtUnlistedEnum
    public enum State implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::<wbr/>Uninitialized</a></code></p>
         */
        Uninitialized(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::<wbr/>Initialized</a></code></p>
         */
        Initialized(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::<wbr/>Started</a></code></p>
         */
        Started(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::<wbr/>Connected</a></code></p>
         */
        Connected(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::<wbr/>Disconnected</a></code></p>
         */
        Disconnected(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::<wbr/>Closed</a></code></p>
         */
        Closed(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull State resolve(int value) {
            switch (value) {
            case 0: return Uninitialized;
            case 5: return Initialized;
            case 1: return Started;
            case 2: return Connected;
            case 3: return Disconnected;
            case 4: return Closed;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#QAxScriptEngine">QAxScriptEngine::<wbr/>QAxScriptEngine(QString,<wbr/>QAxScript*)</a></code></p>
     */
    public QAxScriptEngine(java.lang.@NonNull String language, io.qt.activex.@Nullable QAxScript script){
        super((QPrivateConstructor)null);
        initialize_native(this, language, script);
    }
    
    private native static void initialize_native(QAxScriptEngine instance, java.lang.String language, io.qt.activex.QAxScript script);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#addItem">QAxScriptEngine::<wbr/>addItem(QString)</a></code></p>
     */
    @QtUninvokable
    public final void addItem(java.lang.@NonNull String name){
        addItem_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void addItem_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#hasIntrospection">QAxScriptEngine::<wbr/>hasIntrospection()const</a></code></p>
     */
    @QtUninvokable
    public final boolean hasIntrospection(){
        return hasIntrospection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasIntrospection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#isValid">QAxScriptEngine::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#scriptLanguage">QAxScriptEngine::<wbr/>scriptLanguage()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String scriptLanguage(){
        return scriptLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String scriptLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#setState">QAxScriptEngine::<wbr/>setState(QAxScriptEngine::State)</a></code></p>
     */
    @QtUninvokable
    public final void setState(io.qt.activex.QAxScriptEngine.@NonNull State st){
        setState_native_QAxScriptEngine_State(QtJambi_LibraryUtilities.internal.nativeId(this), st.value());
    }
    
    @QtUninvokable
    private native void setState_native_QAxScriptEngine_State(long __this__nativeId, int st);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscriptengine.html#state">QAxScriptEngine::<wbr/>state()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.activex.QAxScriptEngine.@NonNull State state(){
        return io.qt.activex.QAxScriptEngine.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxScriptEngine(QPrivateConstructor p) { super(p); } 
    
}
