package io.qt.activex;

import io.qt.*;


/**
 * <p>Wrapper around script code</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaxscript.html">QAxScript</a></code></p>
 */
public class QAxScript extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxScript.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaxscript.html#FunctionFlags-enum">QAxScript::FunctionFlags</a></code></p>
     */
    @QtUnlistedEnum
    public enum FunctionFlags implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscript.html#FunctionFlags-enum">QAxScript::<wbr/>FunctionNames</a></code></p>
         */
        FunctionNames(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaxscript.html#FunctionFlags-enum">QAxScript::<wbr/>FunctionSignatures</a></code></p>
         */
        FunctionSignatures(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FunctionFlags(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FunctionFlags resolve(int value) {
            switch (value) {
            case 0: return FunctionNames;
            case 1: return FunctionSignatures;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#entered">QAxScript::<wbr/>entered()</a></code></p>
     */
    public final @NonNull Signal0 entered = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#error">QAxScript::<wbr/>error(int,<wbr/>QString,<wbr/>int,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal4<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String> error = new Signal4<>();

    /**
     * <p>Wrapper class for overloaded signals:</p>
     * <ul>
     * <li><code>finished()</code></li>
     * <li><code>finished(const QVariant &amp; result)</code></li>
     * <li><code>finished(int code, const QString &amp; source, const QString &amp; description, const QString &amp; help)</code></li>
     * </ul>
     */
    public final class MultiSignal_finished extends MultiSignal{
        private MultiSignal_finished(){
            super();
        }

        /**
         * <p>Provides an overloaded parameterless signal.</p>
         * @return overloaded signal
         */
        public final Signal0 overload() throws QNoSuchSignalException{
            return (Signal0)super.overload();
        }

        /**
         * <p>Provides an overloaded signal by parameter type.</p>
         * <p>The only valid call is <code>finished.overload(java.lang.Object.class)</code></p>
         * <p>{@link QNoSuchSignalException} is thrown otherwise.</p>

         * @param <A> signal parameter type
         * @param type1 value of type A
         * @return overloaded signal
         * @throws QNoSuchSignalException if signal is not available
         */
        @QtAllowedTypeSet({java.lang.Object.class})
        public final <A> Signal1<A> overload(Class<A> type1) throws QNoSuchSignalException{
            return (Signal1<A>)super.overload(type1);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Slot1<A> slot, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Slot1<A> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Connectable1<A> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Connectable1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal1<A> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * <p>Provides an overloaded signal by parameter types.</p>
         * <p>The only valid call is <code>finished.overload(int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class)</code></p>
         * <p>{@link QNoSuchSignalException} is thrown otherwise.</p>

         * @param <A> signal parameter type
         * @param <B> signal parameter type
         * @param <C> signal parameter type
         * @param <D> signal parameter type
         * @param type1 value of type A
         * @param type2 value of type B
         * @param type3 value of type C
         * @param type4 value of type D
         * @return overloaded signal
         * @throws QNoSuchSignalException if signal is not available
         */
        @QtAllowedTypeSet({int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class})
        public final <A,B,C,D> Signal4<A,B,C,D> overload(Class<A> type1, Class<B> type2, Class<C> type3, Class<D> type4) throws QNoSuchSignalException{
            return (Signal4<A,B,C,D>)super.overload(type1, type2, type3, type4);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C,D> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Slot4<A,B,C,D> slot, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C,D> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Slot4<A,B,C,D> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C,D> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Connectable4<A,B,C,D> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C,D> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Connectable4<A,B,C,D> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C,D> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal4<A,B,C,D> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C,D> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal4<A,B,C,D> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.Slot3<A,B,C> slot, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C> boolean disconnect(io.qt.core.QMetaObject.Slot3<A,B,C> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal3<A,B,C> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal3<A,B,C> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.Slot2<A,B> slot, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B> boolean disconnect(io.qt.core.QMetaObject.Slot2<A,B> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal2<A,B> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal2<A,B> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#finished">QAxScript::<wbr/>finished()</a></code></p>
         * 
         */
        public final void emit() {
            ((Signal0)overload()).emit();
        }

        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#finished-1">QAxScript::<wbr/>finished(QVariant)</a></code></p>
         * 
         */
        public final void emit(java.lang.Object result) {
            ((Signal1<java.lang.Object>)overload(java.lang.Object.class)).emit(result);
        }

        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#finished-2">QAxScript::<wbr/>finished(int,<wbr/>QString,<wbr/>QString,<wbr/>QString)</a></code></p>
         * 
         */
        public final void emit(int code, java.lang.@NonNull String source, java.lang.@NonNull String description, java.lang.@NonNull String help) {
            ((Signal4<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String, java.lang.@NonNull String, java.lang.@NonNull String>)overload(int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class)).emit(code, source, description, help);
        }

    };


    /**
     * <p>Overloaded signals:</p>
     * <ul>
     * <li><code>finished()</code></li>
     * <li><code>finished(QVariant)</code></li>
     * <li><code>finished(int,<wbr/>QString,<wbr/>QString,<wbr/>QString)</code></li>
     * </ul>
     */
    public final @NonNull MultiSignal_finished finished = new MultiSignal_finished();


    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#stateChanged">QAxScript::<wbr/>stateChanged(int)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> stateChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#QAxScript">QAxScript::<wbr/>QAxScript(QString,<wbr/>QAxScriptManager*)</a></code></p>
     */
    public QAxScript(java.lang.@NonNull String name, io.qt.activex.@Nullable QAxScriptManager manager){
        super((QPrivateConstructor)null);
        initialize_native(this, name, manager);
    }
    
    private native static void initialize_native(QAxScript instance, java.lang.String name, io.qt.activex.QAxScriptManager manager);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#call-1">QAxScript::<wbr/>call(QString,<wbr/>QList&lt;QVariant&gt;&amp;)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.util.@NonNull Collection<? extends java.lang.Object> arguments){
        return call_native_cref_QString_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), function, arguments);
    }
    
    @QtUninvokable
    private native java.lang.Object call_native_cref_QString_ref_QList(long __this__nativeId, java.lang.String function, java.util.Collection<? extends java.lang.Object> arguments);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#call">QAxScript::<wbr/>call(QString,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant,<wbr/>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return call_native_cref_QString_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), function, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    @QtUninvokable
    private native java.lang.Object call_native_cref_QString_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#functions">QAxScript::<wbr/>functions(QAxScript::FunctionFlags)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList functions(io.qt.activex.QAxScript.@NonNull FunctionFlags arg__1){
        return functions_native_QAxScript_FunctionFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList functions_native_QAxScript_FunctionFlags_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#load">QAxScript::<wbr/>load(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean load(java.lang.@NonNull String code, java.lang.@NonNull String language){
        return load_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), code, language);
    }
    
    @QtUninvokable
    private native boolean load_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String code, java.lang.String language);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#scriptCode">QAxScript::<wbr/>scriptCode()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String scriptCode(){
        return scriptCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String scriptCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#scriptEngine">QAxScript::<wbr/>scriptEngine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.activex.@Nullable QAxScriptEngine scriptEngine(){
        return scriptEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.activex.QAxScriptEngine scriptEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxscript.html#scriptName">QAxScript::<wbr/>scriptName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String scriptName(){
        return scriptName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String scriptName_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxScript(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return call(function, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return call(function, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return call(function, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return call(function, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return call(function, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1, java.lang.Object v2) {
        return call(function, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function, java.lang.Object v1) {
        return call(function, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final java.lang.Object call(java.lang.@NonNull String function) {
        return call(function, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #functions(io.qt.activex.QAxScript.FunctionFlags)}
     *  with <code>arg__1 = io.qt.activex.QAxScript.FunctionFlags.FunctionNames</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList functions() {
        return functions(io.qt.activex.QAxScript.FunctionFlags.FunctionNames);
    }
    
    /**
     * <p>Overloaded function for {@link #load(java.lang.String, java.lang.String)}
     *  with <code>language = (String)null</code>.</p>
     */
    @QtUninvokable
    public final boolean load(java.lang.@NonNull String code) {
        return load(code, (String)null);
    }
}
