package io.qt.activex;

import io.qt.*;


/**
 * <p>Interface providing common properties of QAxObject and QAxWidget</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html">QAxObjectInterface</a></code></p>
 */
public interface QAxObjectInterface extends QtObjectInterface
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.activex.QAxObjectInterface}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.activex.QAxObjectInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QAxObjectInterface.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public int classContext(){
                return classContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int classContext_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public java.lang.@NonNull String control(){
                return control_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String control_native_constfct(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public void resetControl(){
                resetControl_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static void resetControl_native(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public void setClassContext(int classContext){
                setClassContext_native_ulong(QtJambi_LibraryUtilities.internal.nativeId(this), classContext);
            }
            private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
            
            
            @Override
            @QtUninvokable
            public boolean setControl(java.lang.@NonNull String c){
                return setControl_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), c);
            }
            private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String c);
            
        }
        
        
        /**
         * <p>See <code>QAxObjectInterface::<wbr/>QAxObjectInterface()</code></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QAxObjectInterface instance);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#classContext">QAxObjectInterface::<wbr/>classContext()const</a></code></p>
         */
        @QtUninvokable
        public abstract int classContext();
        
        private native static int classContext_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#control">QAxObjectInterface::<wbr/>control()const</a></code></p>
         */
        @QtUninvokable
        public abstract java.lang.@NonNull String control();
        
        private native static java.lang.String control_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#resetControl">QAxObjectInterface::<wbr/>resetControl()</a></code></p>
         */
        @QtUninvokable
        public abstract void resetControl();
        
        private native static void resetControl_native(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#setClassContext">QAxObjectInterface::<wbr/>setClassContext(ulong)</a></code></p>
         */
        @QtUninvokable
        public abstract void setClassContext(int classContext);
        
        private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#setControl">QAxObjectInterface::<wbr/>setControl(QString)</a></code></p>
         */
        @QtUninvokable
        public abstract boolean setControl(java.lang.@NonNull String c);
        
        private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String c);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#classContext">QAxObjectInterface::<wbr/>classContext()const</a></code></p>
     */
    @QtUninvokable
    public int classContext();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#control">QAxObjectInterface::<wbr/>control()const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String control();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#resetControl">QAxObjectInterface::<wbr/>resetControl()</a></code></p>
     */
    @QtUninvokable
    public void resetControl();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#setClassContext">QAxObjectInterface::<wbr/>setClassContext(ulong)</a></code></p>
     */
    @QtUninvokable
    public void setClassContext(int classContext);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#setControl">QAxObjectInterface::<wbr/>setControl(QString)</a></code></p>
     */
    @QtUninvokable
    public boolean setControl(java.lang.@NonNull String c);
    
}
