package io.qt.activex;

import io.qt.*;


/**
 * <p>Static properties and signals for QAxWidget</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaxbasewidget.html">QAxBaseWidget</a></code></p>
 */
public abstract class QAxBaseWidget extends io.qt.widgets.QWidget
    implements io.qt.activex.QAxObjectInterface
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxBaseWidget.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAxBaseWidget {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public int classContext(){
            return classContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native static int classContext_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public java.lang.@NonNull String control(){
            return control_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native static java.lang.String control_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void resetControl(){
            resetControl_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native static void resetControl_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void setClassContext(int classContext){
            setClassContext_native_ulong(QtJambi_LibraryUtilities.internal.nativeId(this), classContext);
        }
        private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
        
        
        @Override
        @QtUninvokable
        public boolean setControl(java.lang.@NonNull String c){
            return setControl_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), c);
        }
        private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String c);
        
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbasewidget.html#exception">QAxBaseWidget::<wbr/>exception(int,<wbr/>QString,<wbr/>QString,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal4<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String, java.lang.@NonNull String, java.lang.@NonNull String> exception = new Signal4<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbasewidget.html#propertyChanged">QAxBaseWidget::<wbr/>propertyChanged(QString)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> propertyChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxbasewidget.html#signal">QAxBaseWidget::<wbr/>signal(QString,<wbr/>int,<wbr/>void*)</a></code></p>
     */
    @SuppressWarnings({"unused"})
    private final @NonNull Signal3<java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Integer, @Nullable QNativePointer> signal = new Signal3<>();
    
    /**
     * <p>See <code>QAxBaseWidget::<wbr/>QAxBaseWidget(QWidget*,<wbr/>Qt::WindowFlags)</code></p>
     */
    protected QAxBaseWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowFlags f){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, f);
    }
    
    private native static void initialize_native(QAxBaseWidget instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#classContext">QAxObjectInterface::<wbr/>classContext()const</a></code></p>
     */
    @QtUninvokable
    public abstract int classContext();
    
    private native static int classContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#control">QAxObjectInterface::<wbr/>control()const</a></code></p>
     */
    @QtUninvokable
    public abstract java.lang.@NonNull String control();
    
    private native static java.lang.String control_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#resetControl">QAxObjectInterface::<wbr/>resetControl()</a></code></p>
     */
    @QtUninvokable
    public abstract void resetControl();
    
    private native static void resetControl_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#setClassContext">QAxObjectInterface::<wbr/>setClassContext(ulong)</a></code></p>
     */
    @QtUninvokable
    public abstract void setClassContext(int classContext);
    
    private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaxobjectinterface.html#setControl">QAxObjectInterface::<wbr/>setControl(QString)</a></code></p>
     */
    @QtUninvokable
    public abstract boolean setControl(java.lang.@NonNull String c);
    
    private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String c);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxBaseWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAxBaseWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAxBaseWidget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAxBaseWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>f = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    protected QAxBaseWidget(io.qt.widgets.@Nullable QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxBaseWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>f = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    protected QAxBaseWidget() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxBaseWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    protected QAxBaseWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowType @NonNull... f) {
        this(parent, new io.qt.core.Qt.WindowFlags(f));
    }
}
