package io.qt.activex;


/**
 * <p>QWidget that wraps an ActiveX control</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qaxwidget.html">QAxWidget</a></p>
 */
public class QAxWidget extends io.qt.activex.QAxBaseWidget
    implements io.qt.activex.QAxBase
{
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QAxWidget(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowType ... f){
        this(parent, new io.qt.core.Qt.WindowFlags(f));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>f = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QAxWidget(io.qt.widgets.QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>f = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QAxWidget() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxwidget.html#QAxWidget">QAxWidget::QAxWidget(QWidget*,Qt::WindowFlags)</a></p>
     */
    public QAxWidget(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, f);
    }
    
    private native static void initialize_native(QAxWidget instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f);
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(java.lang.String, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QAxWidget(java.lang.String c, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowType ... f){
        this(c, parent, new io.qt.core.Qt.WindowFlags(f));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(java.lang.String, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>f = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QAxWidget(java.lang.String c, io.qt.widgets.QWidget parent) {
        this(c, parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAxWidget(java.lang.String, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>f = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QAxWidget(java.lang.String c) {
        this(c, (io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxwidget.html#QAxWidget-1">QAxWidget::QAxWidget(QString,QWidget*,Qt::WindowFlags)</a></p>
     */
    public QAxWidget(java.lang.String c, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f){
        super((QPrivateConstructor)null);
        initialize_native(this, c, parent, f);
    }
    
    private native static void initialize_native(QAxWidget instance, java.lang.String c, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#asVariant">QAxBase::asVariant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object asVariant(){
        return asVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.Object asVariant_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QMetaObject axBaseMetaObject(){
        return axBaseMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QMetaObject axBaseMetaObject_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String className(){
        return className_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.String className_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#clear">QAxBase::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void clear_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final void connectNotify(){
        connectNotify_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void connectNotify_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxwidget.html#createHostWindow-1">QAxWidget::createHostWindow(bool,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean createHostWindow(boolean arg__1, io.qt.core.QByteArray arg__2){
        return createHostWindow_native_bool_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @io.qt.QtUninvokable
    private native boolean createHostWindow_native_bool_cref_QByteArray(long __this__nativeId, boolean arg__1, long arg__2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableClassInfo">QAxBase::disableClassInfo()</a></p>
     */
    @io.qt.QtUninvokable
    public final void disableClassInfo(){
        disableClassInfo_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void disableClassInfo_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableEventSink">QAxBase::disableEventSink()</a></p>
     */
    @io.qt.QtUninvokable
    public final void disableEventSink(){
        disableEventSink_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void disableEventSink_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableMetaObject">QAxBase::disableMetaObject()</a></p>
     */
    @io.qt.QtUninvokable
    public final void disableMetaObject(){
        disableMetaObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void disableMetaObject_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxwidget.html#doVerb">QAxWidget::doVerb(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean doVerb(java.lang.String verb){
        return doVerb_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), verb);
    }
    
    @io.qt.QtUninvokable
    private native boolean doVerb_native_cref_QString(long __this__nativeId, java.lang.String verb);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall-1">QAxBase::dynamicCall(const char*,QList&lt;QVariant&gt;&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars){
        return dynamicCall_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
    }
    
    private native static java.lang.Object dynamicCall_native_const_char_ptr_ref_QList(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars);
    
    @io.qt.QtUninvokable
    protected final java.lang.Object dynamicCall(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars, int flags){
        return dynamicCall_native_const_char_ptr_ref_QList_unsigned(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars, flags);
    }
    
    private native static java.lang.Object dynamicCall_native_const_char_ptr_ref_QList_unsigned(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars, int flags);
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return dynamicCall(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return dynamicCall(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return dynamicCall(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return dynamicCall(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return dynamicCall(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2) {
        return dynamicCall(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1) {
        return dynamicCall(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name) {
        return dynamicCall(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall">QAxBase::dynamicCall(const char*,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return dynamicCall_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    private native static java.lang.Object dynamicCall_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#generateDocumentation">QAxBase::generateDocumentation()</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String generateDocumentation(){
        return generateDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.String generateDocumentation_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final int indexOfVerb(java.lang.String verb){
        return indexOfVerb_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), verb);
    }
    
    private native static int indexOfVerb_native_cref_QString_constfct(long __this__nativeId, java.lang.String verb);
    
    @io.qt.QtUninvokable
    protected final void initializeFrom(io.qt.activex.QAxBase that){
        initializeFrom_native_QAxBase_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(that));
    }
    
    private native static void initializeFrom_native_QAxBase_ptr(long __this__nativeId, long that);
    
    @io.qt.QtUninvokable
    protected final void internalRelease(){
        internalRelease_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void internalRelease_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#isNull">QAxBase::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#propertyBag">QAxBase::propertyBag()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, java.lang.Object> propertyBag(){
        return propertyBag_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QMap<java.lang.String, java.lang.Object> propertyBag_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QObject qObject(){
        return qObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QObject qObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#querySubObject-1">QAxBase::querySubObject(const char*,QList&lt;QVariant&gt;&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars){
        return querySubObject_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
    }
    
    private native static io.qt.activex.QAxObject querySubObject_native_const_char_ptr_ref_QList(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars);
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return querySubObject(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return querySubObject(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return querySubObject(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return querySubObject(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return querySubObject(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2) {
        return querySubObject(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1) {
        return querySubObject(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name) {
        return querySubObject(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#querySubObject">QAxBase::querySubObject(const char*,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return querySubObject_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    private native static io.qt.activex.QAxObject querySubObject_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setPropertyBag">QAxBase::setPropertyBag(QMap&lt;QString,QVariant&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPropertyBag(java.util.Map<java.lang.String, ? extends java.lang.Object> arg__1){
        setPropertyBag_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native static void setPropertyBag_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#verbs">QAxBase::verbs()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList verbs(){
        return verbs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QStringList verbs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#changeEvent">QWidget::changeEvent(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void changeEvent(io.qt.core.QEvent e){
        changeEvent_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void changeEvent_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#classContext">QAxBase::classContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public int classContext(){
        return classContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int classContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#connectNotify">QObject::connectNotify(QMetaMethod)</a></p>
     */
    @io.qt.QtUninvokable
    protected void connectNotify(io.qt.core.QMetaMethod signal){
        connectNotify_native_cref_QMetaMethod(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @io.qt.QtUninvokable
    private native void connectNotify_native_cref_QMetaMethod(long __this__nativeId, long signal);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#control">QAxBase::control()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String control(){
        return control_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static java.lang.String control_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxwidget.html#createHostWindow">QAxWidget::createHostWindow(bool)</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean createHostWindow(boolean arg__1){
        return createHostWindow_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native boolean createHostWindow_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#minimumSizeHint-prop">QWidget::minimumSizeHint()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QSize minimumSizeHint(){
        return minimumSizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize minimumSizeHint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#propertyWritable">QAxBase::propertyWritable(const char*)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean propertyWritable(java.lang.String arg__1){
        return propertyWritable_native_const_char_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native static boolean propertyWritable_native_const_char_ptr_constfct(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#resetControl">QAxObjectInterface::resetControl()</a></p>
     */
    @io.qt.QtUninvokable
    public void resetControl(){
        resetControl_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void resetControl_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#resizeEvent">QWidget::resizeEvent(QResizeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeEvent(io.qt.gui.QResizeEvent arg__1){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setClassContext">QAxBase::setClassContext(ulong)</a></p>
     */
    @io.qt.QtUninvokable
    public void setClassContext(int classContext){
        setClassContext_native_ulong(QtJambi_LibraryUtilities.internal.nativeId(this), classContext);
    }
    
    private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
    
    @io.qt.QtUninvokable
    public boolean setControl(java.lang.String arg__1){
        return setControl_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setPropertyWritable">QAxBase::setPropertyWritable(const char*,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public void setPropertyWritable(java.lang.String arg__1, boolean arg__2){
        setPropertyWritable_native_const_char_ptr_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, arg__2);
    }
    
    private native static void setPropertyWritable_native_const_char_ptr_bool(long __this__nativeId, java.lang.String arg__1, boolean arg__2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#sizeHint-prop">QWidget::sizeHint()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxwidget.html#translateKeyEvent">QAxWidget::translateKeyEvent(int,int)const</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean translateKeyEvent(int message, int keycode){
        return translateKeyEvent_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), message, keycode);
    }
    
    @io.qt.QtUninvokable
    private native boolean translateKeyEvent_native_int_int_constfct(long __this__nativeId, int message, int keycode);
    
    protected native static io.qt.core.QList<java.lang.Object> argumentsToList(java.lang.Object var1, java.lang.Object var2, java.lang.Object var3, java.lang.Object var4, java.lang.Object var5, java.lang.Object var6, java.lang.Object var7, java.lang.Object var8);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAxWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAxWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAxWidget instance, QDeclarativeConstructor constructor);
    
}
