package io.qt.activex;


/**
 * <p>Wrapper around script code</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qaxscript.html">QAxScript</a></p>
 */
public class QAxScript extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxScript.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qaxscript.html#FunctionFlags-enum">QAxScript::FunctionFlags</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum FunctionFlags implements io.qt.QtEnumerator {
        FunctionNames(0),
        FunctionSignatures(1);

        private FunctionFlags(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FunctionFlags resolve(int value) {
            switch (value) {
            case 0: return FunctionNames;
            case 1: return FunctionSignatures;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#entered">QAxScript::entered()</a></p>
     */
    public final Signal0 entered = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#error">QAxScript::error(int,QString,int,QString)</a></p>
     */
    public final Signal4<@io.qt.QtPrimitiveType Integer, java.lang.String, @io.qt.QtPrimitiveType Integer, java.lang.String> error = new Signal4<>();

    /**
     * <p>Wrapper class for overloaded signals:</p>
     * <ul>
     * <li><code>finished()</code></li>
     * <li><code>finished(const QVariant &amp; result)</code></li>
     * <li><code>finished(int code, const QString &amp; source, const QString &amp; description, const QString &amp; help)</code></li>
     * </ul>
     */
    public final class MultiSignal_finished extends MultiSignal{
        private MultiSignal_finished(){
            super();
        }

        /**
         * <p>Provides an overloaded parameterless signal.</p>
         * @return overloaded signal
         */
        public final Signal0 overload() throws io.qt.QNoSuchSignalException{
            return (Signal0)super.overload();
        }

        /**
         * <p>Provides an overloaded signal by parameter type.</p>
         * <p>The only valid call is <code>finished.overload(java.lang.Object.class)</code></p>
         * <p>{@link io.qt.QNoSuchSignalException} is thrown otherwise.</p>

         * @param <A> signal parameter type
         * @param type1 value of type A
         * @return overloaded signal
         * @throws io.qt.QNoSuchSignalException if signal is not available
         */
        @io.qt.QtAllowedTypeSet({java.lang.Object.class})
        public final <A> Signal1<A> overload(Class<A> type1) throws io.qt.QNoSuchSignalException{
            return (Signal1<A>)super.overload(type1);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         * @throws io.qt.QUninvokableSlotException Raised if slot is annotated <code>&commat;QtUninvokable</code>.
         */
        public final <A> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Slot1<A> slot, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.Slot1<A> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Connectable1<A> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.Connectable1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal1<A> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * <p>Provides an overloaded signal by parameter types.</p>
         * <p>The only valid call is <code>finished.overload(int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class)</code></p>
         * <p>{@link io.qt.QNoSuchSignalException} is thrown otherwise.</p>

         * @param <A> signal parameter type
         * @param <B> signal parameter type
         * @param <C> signal parameter type
         * @param <D> signal parameter type
         * @param type1 value of type A
         * @param type2 value of type B
         * @param type3 value of type C
         * @param type4 value of type D
         * @return overloaded signal
         * @throws io.qt.QNoSuchSignalException if signal is not available
         */
        @io.qt.QtAllowedTypeSet({int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class})
        public final <A,B,C,D> Signal4<A,B,C,D> overload(Class<A> type1, Class<B> type2, Class<C> type3, Class<D> type4) throws io.qt.QNoSuchSignalException{
            return (Signal4<A,B,C,D>)super.overload(type1, type2, type3, type4);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         * @throws io.qt.QUninvokableSlotException Raised if slot is annotated <code>&commat;QtUninvokable</code>.
         */
        public final <A,B,C,D> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Slot4<A,B,C,D> slot, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C,D> boolean disconnect(io.qt.core.QMetaObject.Slot4<A,B,C,D> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C,D> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Connectable4<A,B,C,D> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C,D> boolean disconnect(io.qt.core.QMetaObject.Connectable4<A,B,C,D> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C,D> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal4<A,B,C,D> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C,D> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal4<A,B,C,D> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         * @throws io.qt.QUninvokableSlotException Raised if slot is annotated <code>&commat;QtUninvokable</code>.
         */
        public final <A,B,C> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Slot3<A,B,C> slot, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C> boolean disconnect(io.qt.core.QMetaObject.Slot3<A,B,C> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal3<A,B,C> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal3<A,B,C> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         * @throws io.qt.QUninvokableSlotException Raised if slot is annotated <code>&commat;QtUninvokable</code>.
         */
        public final <A,B> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Slot2<A,B> slot, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B> boolean disconnect(io.qt.core.QMetaObject.Slot2<A,B> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal2<A,B> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal2<A,B> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#finished">QAxScript::finished()</a></p>
         * 
         */
        public final void emit() {
            ((Signal0)overload()).emit();
        }

        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#finished-1">QAxScript::finished(QVariant)</a></p>
         * 
         */
        public final void emit(java.lang.Object result) {
            ((Signal1<java.lang.Object>)overload(java.lang.Object.class)).emit(result);
        }

        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#finished-2">QAxScript::finished(int,QString,QString,QString)</a></p>
         * 
         */
        public final void emit(int code, java.lang.String source, java.lang.String description, java.lang.String help) {
            ((Signal4<java.lang.Integer, java.lang.String, java.lang.String, java.lang.String>)overload(int.class, java.lang.String.class, java.lang.String.class, java.lang.String.class)).emit(code, source, description, help);
        }

    };


    /**
     * <p>Overloaded signals:</p>
     * <ul>
     * <li><code>finished()</code></li>
     * <li><code>finished(const QVariant & result)</code></li>
     * <li><code>finished(int code, const QString & source, const QString & description, const QString & help)</code></li>
     * </ul>
     */
    public final MultiSignal_finished finished = new MultiSignal_finished();


    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#stateChanged">QAxScript::stateChanged(int)</a></p>
     */
    public final Signal1<@io.qt.QtPrimitiveType Integer> stateChanged = new Signal1<>();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#QAxScript">QAxScript::QAxScript(QString,QAxScriptManager*)</a></p>
     */
    public QAxScript(java.lang.String name, io.qt.activex.QAxScriptManager manager){
        super((QPrivateConstructor)null);
        initialize_native(this, name, manager);
    }
    
    private native static void initialize_native(QAxScript instance, java.lang.String name, io.qt.activex.QAxScriptManager manager);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#call-1">QAxScript::call(QString,QList&lt;QVariant&gt;&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.util.Collection<? extends java.lang.Object> arguments){
        return call_native_cref_QString_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), function, arguments);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object call_native_cref_QString_ref_QList(long __this__nativeId, java.lang.String function, java.util.Collection<? extends java.lang.Object> arguments);
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return call(function, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return call(function, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return call(function, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return call(function, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return call(function, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1, java.lang.Object v2) {
        return call(function, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1) {
        return call(function, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #call(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function) {
        return call(function, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#call">QAxScript::call(QString,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object call(java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return call_native_cref_QString_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), function, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object call_native_cref_QString_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String function, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
    
    /**
     * <p>Overloaded function for {@link #functions(io.qt.activex.QAxScript.FunctionFlags)}
     *  with <code>arg__1 = io.qt.activex.QAxScript.FunctionFlags.FunctionNames</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList functions() {
        return functions(io.qt.activex.QAxScript.FunctionFlags.FunctionNames);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#functions">QAxScript::functions(QAxScript::FunctionFlags)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList functions(io.qt.activex.QAxScript.FunctionFlags arg__1){
        return functions_native_QAxScript_FunctionFlags_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList functions_native_QAxScript_FunctionFlags_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>Overloaded function for {@link #load(java.lang.String, java.lang.String)}
     *  with <code>language = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean load(java.lang.String code) {
        return load(code, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#load">QAxScript::load(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean load(java.lang.String code, java.lang.String language){
        return load_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), code, language);
    }
    
    @io.qt.QtUninvokable
    private native boolean load_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String code, java.lang.String language);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#scriptCode">QAxScript::scriptCode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String scriptCode(){
        return scriptCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String scriptCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#scriptEngine">QAxScript::scriptEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxScriptEngine scriptEngine(){
        return scriptEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.activex.QAxScriptEngine scriptEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscript.html#scriptName">QAxScript::scriptName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String scriptName(){
        return scriptName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String scriptName_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAxScript(QPrivateConstructor p) { super(p); } 
    
}
