package io.qt.activex;


/**
 * <p>Wrapper around a script engine</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qaxscriptengine.html">QAxScriptEngine</a></p>
 */
public class QAxScriptEngine extends io.qt.activex.QAxObject
{
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qaxscriptengine.html#State-enum">QAxScriptEngine::State</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum State implements io.qt.QtEnumerator {
        Uninitialized(0),
        Initialized(5),
        Started(1),
        Connected(2),
        Disconnected(3),
        Closed(4);

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static State resolve(int value) {
            switch (value) {
            case 0: return Uninitialized;
            case 5: return Initialized;
            case 1: return Started;
            case 2: return Connected;
            case 3: return Disconnected;
            case 4: return Closed;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscriptengine.html#QAxScriptEngine">QAxScriptEngine::QAxScriptEngine(QString,QAxScript*)</a></p>
     */
    public QAxScriptEngine(java.lang.String language, io.qt.activex.QAxScript script){
        super((QPrivateConstructor)null);
        initialize_native(this, language, script);
    }
    
    private native static void initialize_native(QAxScriptEngine instance, java.lang.String language, io.qt.activex.QAxScript script);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscriptengine.html#addItem">QAxScriptEngine::addItem(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addItem(java.lang.String name){
        addItem_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void addItem_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscriptengine.html#hasIntrospection">QAxScriptEngine::hasIntrospection()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasIntrospection(){
        return hasIntrospection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasIntrospection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscriptengine.html#isValid">QAxScriptEngine::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscriptengine.html#scriptLanguage">QAxScriptEngine::scriptLanguage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String scriptLanguage(){
        return scriptLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String scriptLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscriptengine.html#setState">QAxScriptEngine::setState(QAxScriptEngine::State)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setState(io.qt.activex.QAxScriptEngine.State st){
        setState_native_QAxScriptEngine_State(QtJambi_LibraryUtilities.internal.nativeId(this), st.value());
    }
    
    @io.qt.QtUninvokable
    private native void setState_native_QAxScriptEngine_State(long __this__nativeId, int st);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxscriptengine.html#state">QAxScriptEngine::state()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.activex.QAxScriptEngine.State state(){
        return io.qt.activex.QAxScriptEngine.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAxScriptEngine(QPrivateConstructor p) { super(p); } 
    
}
