package io.qt.activex;


/**
 * <p>Interface providing common properties of QAxObject and QAxWidget</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qaxobjectinterface.html">QAxObjectInterface</a></p>
 */
public interface QAxObjectInterface extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.activex.QAxObjectInterface}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.activex.QAxObjectInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QAxObjectInterface.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public int classContext(){
                return classContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int classContext_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public java.lang.String control(){
                return control_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static java.lang.String control_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public void resetControl(){
                resetControl_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static void resetControl_native(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public void setClassContext(int classContext){
                setClassContext_native_ulong(QtJambi_LibraryUtilities.internal.nativeId(this), classContext);
            }
            private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean setControl(java.lang.String c){
                return setControl_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), c);
            }
            private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String c);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QAxObjectInterface instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#classContext">QAxObjectInterface::classContext()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int classContext();
        
        private native static int classContext_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#control">QAxObjectInterface::control()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract java.lang.String control();
        
        private native static java.lang.String control_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#resetControl">QAxObjectInterface::resetControl()</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void resetControl();
        
        private native static void resetControl_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#setClassContext">QAxObjectInterface::setClassContext(ulong)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract void setClassContext(int classContext);
        
        private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#setControl">QAxObjectInterface::setControl(QString)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract boolean setControl(java.lang.String c);
        
        private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String c);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#classContext">QAxObjectInterface::classContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public int classContext();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#control">QAxObjectInterface::control()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String control();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#resetControl">QAxObjectInterface::resetControl()</a></p>
     */
    @io.qt.QtUninvokable
    public void resetControl();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#setClassContext">QAxObjectInterface::setClassContext(ulong)</a></p>
     */
    @io.qt.QtUninvokable
    public void setClassContext(int classContext);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxobjectinterface.html#setControl">QAxObjectInterface::setControl(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean setControl(java.lang.String c);
    
}
