package io.qt.activex;


/**
 * <p>Abstract class that provides an API to initialize and access a COM object</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qaxbase.html">QAxBase</a></p>
 * <p>Following functions are protected in the Qt interface, all implementations of this interface may implement these function:</p>
 * <br>
 * <code>
 * &commat;io.qt.QtUninvokable<br>
 * protected final void connectNotify(){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;QAxBase.MemberAccess.of(this).connectNotify();<br>
 * }<br>
 * <br>
 * &commat;io.qt.QtUninvokable<br>
 * protected final java.lang.Object dynamicCall(java.lang.String name, java.util.Collection&lt;? extends java.lang.Object&gt; vars, int flags){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return QAxBase.MemberAccess.of(this).dynamicCall(name, vars, flags);<br>
 * }<br>
 * <br>
 * &commat;io.qt.QtUninvokable<br>
 * protected final int indexOfVerb(java.lang.String verb){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return QAxBase.MemberAccess.of(this).indexOfVerb(verb);<br>
 * }<br>
 * <br>
 * &commat;io.qt.QtUninvokable<br>
 * protected final void initializeFrom(io.qt.activex.QAxBase that){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;QAxBase.MemberAccess.of(this).initializeFrom(that);<br>
 * }<br>
 * <br>
 * &commat;io.qt.QtUninvokable<br>
 * protected final void internalRelease(){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;QAxBase.MemberAccess.of(this).internalRelease();<br>
 * }<br>
 * <br>
 * protected static io.qt.core.QList&lt;java.lang.Object&gt; argumentsToList(java.lang.Object var1, java.lang.Object var2, java.lang.Object var3, java.lang.Object var4, java.lang.Object var5, java.lang.Object var6, java.lang.Object var7, java.lang.Object var8){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;return Impl.argumentsToList(var1, var2, var3, var4, var5, var6, var7, var8);<br>
 * }<br>
 * <br>
 * </code>
 */
public interface QAxBase extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.activex.QAxBase}</p>
     */
    public static class Impl extends io.qt.QtObject
        implements io.qt.activex.QAxBase
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#QAxBase">QAxBase::QAxBase()</a></p>
         */
        protected Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QAxBase instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#asVariant">QAxBase::asVariant()const</a></p>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object asVariant(){
            return asVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.Object asVariant_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final io.qt.core.QMetaObject axBaseMetaObject(){
            return axBaseMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.core.QMetaObject axBaseMetaObject_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#classContext">QAxBase::classContext()const</a></p>
         */
        @io.qt.QtUninvokable
        public final int classContext(){
            return classContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static int classContext_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final java.lang.String className(){
            return className_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.String className_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#clear">QAxBase::clear()</a></p>
         */
        @io.qt.QtUninvokable
        public final void clear(){
            clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void clear_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        protected final void connectNotify(){
            connectNotify_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void connectNotify_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#control">QAxBase::control()const</a></p>
         */
        @io.qt.QtUninvokable
        public final java.lang.String control(){
            return control_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.String control_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableClassInfo">QAxBase::disableClassInfo()</a></p>
         */
        @io.qt.QtUninvokable
        public final void disableClassInfo(){
            disableClassInfo_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void disableClassInfo_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableEventSink">QAxBase::disableEventSink()</a></p>
         */
        @io.qt.QtUninvokable
        public final void disableEventSink(){
            disableEventSink_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void disableEventSink_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableMetaObject">QAxBase::disableMetaObject()</a></p>
         */
        @io.qt.QtUninvokable
        public final void disableMetaObject(){
            disableMetaObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void disableMetaObject_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall-1">QAxBase::dynamicCall(const char*,QList&lt;QVariant&gt;&amp;)</a></p>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars){
            return dynamicCall_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
        }
        
        private native static java.lang.Object dynamicCall_native_const_char_ptr_ref_QList(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars);
        
        @io.qt.QtUninvokable
        protected final java.lang.Object dynamicCall(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars, int flags){
            return dynamicCall_native_const_char_ptr_ref_QList_unsigned(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars, flags);
        }
        
        private native static java.lang.Object dynamicCall_native_const_char_ptr_ref_QList_unsigned(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars, int flags);
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
         *  with <code>v8 = null</code>.</p>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
            return dynamicCall(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
            return dynamicCall(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
            return dynamicCall(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
            return dynamicCall(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
            return dynamicCall(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v3 = null</code></li>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2) {
            return dynamicCall(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v2 = null</code></li>
         * <li><code>v3 = null</code></li>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1) {
            return dynamicCall(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v1 = null</code></li>
         * <li><code>v2 = null</code></li>
         * <li><code>v3 = null</code></li>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name) {
            return dynamicCall(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall">QAxBase::dynamicCall(const char*,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant)</a></p>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
            return dynamicCall_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
        }
        
        private native static java.lang.Object dynamicCall_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#generateDocumentation">QAxBase::generateDocumentation()</a></p>
         */
        @io.qt.QtUninvokable
        public final java.lang.String generateDocumentation(){
            return generateDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.String generateDocumentation_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        protected final int indexOfVerb(java.lang.String verb){
            return indexOfVerb_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), verb);
        }
        
        private native static int indexOfVerb_native_cref_QString_constfct(long __this__nativeId, java.lang.String verb);
        
        @io.qt.QtUninvokable
        protected final void initializeFrom(io.qt.activex.QAxBase that){
            initializeFrom_native_QAxBase_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(that));
        }
        
        private native static void initializeFrom_native_QAxBase_ptr(long __this__nativeId, long that);
        
        @io.qt.QtUninvokable
        protected final void internalRelease(){
            internalRelease_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static void internalRelease_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#isNull">QAxBase::isNull()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isNull(){
            return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isNull_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#propertyBag">QAxBase::propertyBag()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QMap<java.lang.String, java.lang.Object> propertyBag(){
            return propertyBag_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.core.QMap<java.lang.String, java.lang.Object> propertyBag_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final io.qt.core.QObject qObject(){
            return qObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.core.QObject qObject_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#querySubObject-1">QAxBase::querySubObject(const char*,QList&lt;QVariant&gt;&amp;)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars){
            return querySubObject_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
        }
        
        private native static io.qt.activex.QAxObject querySubObject_native_const_char_ptr_ref_QList(long __this__nativeId, java.lang.String name, java.util.Collection<? extends java.lang.Object> vars);
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
         *  with <code>v8 = null</code>.</p>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
            return querySubObject(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
            return querySubObject(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
            return querySubObject(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
            return querySubObject(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
            return querySubObject(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v3 = null</code></li>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2) {
            return querySubObject(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v2 = null</code></li>
         * <li><code>v3 = null</code></li>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1) {
            return querySubObject(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
         * <p>with: </p><ul>
         * <li><code>v1 = null</code></li>
         * <li><code>v2 = null</code></li>
         * <li><code>v3 = null</code></li>
         * <li><code>v4 = null</code></li>
         * <li><code>v5 = null</code></li>
         * <li><code>v6 = null</code></li>
         * <li><code>v7 = null</code></li>
         * <li><code>v8 = null</code></li>
         * </ul>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name) {
            return querySubObject(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#querySubObject">QAxBase::querySubObject(const char*,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
            return querySubObject_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
        }
        
        private native static io.qt.activex.QAxObject querySubObject_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setClassContext">QAxBase::setClassContext(ulong)</a></p>
         */
        @io.qt.QtUninvokable
        public final void setClassContext(int classContext){
            setClassContext_native_ulong(QtJambi_LibraryUtilities.internal.nativeId(this), classContext);
        }
        
        private native static void setClassContext_native_ulong(long __this__nativeId, int classContext);
        
        @io.qt.QtUninvokable
        public final boolean setControl(java.lang.String arg__1){
            return setControl_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
        }
        
        private native static boolean setControl_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setPropertyBag">QAxBase::setPropertyBag(QMap&lt;QString,QVariant&gt;)</a></p>
         */
        @io.qt.QtUninvokable
        public final void setPropertyBag(java.util.Map<java.lang.String, ? extends java.lang.Object> arg__1){
            setPropertyBag_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
        }
        
        private native static void setPropertyBag_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> arg__1);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#verbs">QAxBase::verbs()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QStringList verbs(){
            return verbs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.core.QStringList verbs_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#propertyWritable">QAxBase::propertyWritable(const char*)const</a></p>
         */
        @io.qt.QtUninvokable
        public boolean propertyWritable(java.lang.String arg__1){
            return propertyWritable_native_const_char_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
        }
        
        private native static boolean propertyWritable_native_const_char_ptr_constfct(long __this__nativeId, java.lang.String arg__1);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setPropertyWritable">QAxBase::setPropertyWritable(const char*,bool)</a></p>
         */
        @io.qt.QtUninvokable
        public void setPropertyWritable(java.lang.String arg__1, boolean arg__2){
            setPropertyWritable_native_const_char_ptr_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, arg__2);
        }
        
        private native static void setPropertyWritable_native_const_char_ptr_bool(long __this__nativeId, java.lang.String arg__1, boolean arg__2);
        
        private native static io.qt.core.QList<java.lang.Object> argumentsToList(java.lang.Object var1, java.lang.Object var2, java.lang.Object var3, java.lang.Object var4, java.lang.Object var5, java.lang.Object var6, java.lang.Object var7, java.lang.Object var8);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#asVariant">QAxBase::asVariant()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object asVariant(){
        return Impl.asVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.core.QMetaObject axBaseMetaObject(){
        return Impl.axBaseMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#classContext">QAxBase::classContext()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default int classContext(){
        return Impl.classContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.String className(){
        return Impl.className_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#clear">QAxBase::clear()</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void clear(){
        Impl.clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#control">QAxBase::control()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.String control(){
        return Impl.control_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableClassInfo">QAxBase::disableClassInfo()</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void disableClassInfo(){
        Impl.disableClassInfo_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableEventSink">QAxBase::disableEventSink()</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void disableEventSink(){
        Impl.disableEventSink_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#disableMetaObject">QAxBase::disableMetaObject()</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void disableMetaObject(){
        Impl.disableMetaObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall-1">QAxBase::dynamicCall(const char*,QList&lt;QVariant&gt;&amp;)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars){
        return Impl.dynamicCall_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return dynamicCall(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return dynamicCall(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return dynamicCall(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return dynamicCall(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return dynamicCall(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2) {
        return dynamicCall(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1) {
        return dynamicCall(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #dynamicCall(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name) {
        return dynamicCall(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#dynamicCall">QAxBase::dynamicCall(const char*,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object dynamicCall(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return Impl.dynamicCall_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#generateDocumentation">QAxBase::generateDocumentation()</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.String generateDocumentation(){
        return Impl.generateDocumentation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#isNull">QAxBase::isNull()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean isNull(){
        return Impl.isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#propertyBag">QAxBase::propertyBag()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.core.QMap<java.lang.String, java.lang.Object> propertyBag(){
        return Impl.propertyBag_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.core.QObject qObject(){
        return Impl.qObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#querySubObject-1">QAxBase::querySubObject(const char*,QList&lt;QVariant&gt;&amp;)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars){
        return Impl.querySubObject_native_const_char_ptr_ref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, vars);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}
     *  with <code>v8 = null</code>.</p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7) {
        return querySubObject(name, v1, v2, v3, v4, v5, v6, v7, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6) {
        return querySubObject(name, v1, v2, v3, v4, v5, v6, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5) {
        return querySubObject(name, v1, v2, v3, v4, v5, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4) {
        return querySubObject(name, v1, v2, v3, v4, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3) {
        return querySubObject(name, v1, v2, v3, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2) {
        return querySubObject(name, v1, v2, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1) {
        return querySubObject(name, v1, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>Overloaded function for {@link #querySubObject(java.lang.String, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object, java.lang.Object)}</p>
     * <p>with: </p><ul>
     * <li><code>v1 = null</code></li>
     * <li><code>v2 = null</code></li>
     * <li><code>v3 = null</code></li>
     * <li><code>v4 = null</code></li>
     * <li><code>v5 = null</code></li>
     * <li><code>v6 = null</code></li>
     * <li><code>v7 = null</code></li>
     * <li><code>v8 = null</code></li>
     * </ul>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name) {
        return querySubObject(name, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#querySubObject">QAxBase::querySubObject(const char*,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant,QVariant)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.activex.QAxObject querySubObject(java.lang.String name, java.lang.Object v1, java.lang.Object v2, java.lang.Object v3, java.lang.Object v4, java.lang.Object v5, java.lang.Object v6, java.lang.Object v7, java.lang.Object v8){
        return Impl.querySubObject_native_const_char_ptr_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, v1, v2, v3, v4, v5, v6, v7, v8);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setClassContext">QAxBase::setClassContext(ulong)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void setClassContext(int classContext){
        Impl.setClassContext_native_ulong(QtJambi_LibraryUtilities.internal.nativeId(this), classContext);
    }
    
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean setControl(java.lang.String arg__1){
        return Impl.setControl_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setPropertyBag">QAxBase::setPropertyBag(QAxBase::PropertyBag)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void setPropertyBag(java.util.Map<java.lang.String, ? extends java.lang.Object> arg__1){
        Impl.setPropertyBag_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#verbs">QAxBase::verbs()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.core.QStringList verbs(){
        return Impl.verbs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#propertyWritable">QAxBase::propertyWritable(const char*)const</a></p>
     */
    @io.qt.QtUninvokable
    public default boolean propertyWritable(java.lang.String arg__1){
        return Impl.propertyWritable_native_const_char_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qaxbase.html#setPropertyWritable">QAxBase::setPropertyWritable(const char*,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public default void setPropertyWritable(java.lang.String arg__1, boolean arg__2){
        Impl.setPropertyWritable_native_const_char_ptr_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, arg__2);
    }
    
    public static class MemberAccess extends io.qt.MemberAccess<QAxBase> {
        private MemberAccess(QAxBase instance){
            super(instance);
        }
        
        @io.qt.QtUninvokable
        public final void connectNotify(){
            QAxBase instance = instance();
            QAxBase.Impl.connectNotify_native(QtJambi_LibraryUtilities.internal.nativeId(instance));
        }
        
        @io.qt.QtUninvokable
        public final java.lang.Object dynamicCall(java.lang.String name, java.util.Collection<? extends java.lang.Object> vars, int flags){
            QAxBase instance = instance();
            return QAxBase.Impl.dynamicCall_native_const_char_ptr_ref_QList_unsigned(QtJambi_LibraryUtilities.internal.nativeId(instance), name, vars, flags);
        }
        
        @io.qt.QtUninvokable
        public final int indexOfVerb(java.lang.String verb){
            QAxBase instance = instance();
            return QAxBase.Impl.indexOfVerb_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(instance), verb);
        }
        
        @io.qt.QtUninvokable
        public final void initializeFrom(io.qt.activex.QAxBase that){
            QAxBase instance = instance();
            QAxBase.Impl.initializeFrom_native_QAxBase_ptr(QtJambi_LibraryUtilities.internal.nativeId(instance), QtJambi_LibraryUtilities.internal.checkedNativeId(that));
        }
        
        @io.qt.QtUninvokable
        public final void internalRelease(){
            QAxBase instance = instance();
            QAxBase.Impl.internalRelease_native(QtJambi_LibraryUtilities.internal.nativeId(instance));
        }
        
        public static MemberAccess of(QAxBase instance){
            Class<?> callerClass = QtJambi_LibraryUtilities.internal.callerClassProvider().get();
            if(!QAxBase.class.isAssignableFrom(callerClass) || !callerClass.isInstance(instance))
                throw new RuntimeException("Access to restricted functions of class QAxBase is only granted from inside a user-implemented subclass.");
            return QtJambi_LibraryUtilities.internal.findMemberAccess(instance, QAxBase.class, MemberAccess.class);
        }
    }
}
