#include <QtJambi/MetaInfo>
#include <qaxobject.h>
#include <qaxwidget.h>
#include <QtJambi/RegistryAPI>

void initialize_meta_info_QAxBase();
void initialize_meta_info_QAxBaseObject();
void initialize_meta_info_QAxBaseWidget();
void initialize_meta_info_QAxObject();
void initialize_meta_info_QAxObjectInterface();
void initialize_meta_info_QAxScript();
void initialize_meta_info_QAxScriptEngine();
void initialize_meta_info_QAxScriptManager();
void initialize_meta_info_QAxSelect();
void initialize_meta_info_QAxWidget();

extern "C" Q_DECL_EXPORT jint JNICALL JNI_ONLOAD(JavaVM *, void *)
{
    QTJAMBI_LIBRARY_INITIALIZATION_METHOD_CALL("io.qt.activex")
    initialize_meta_info_QAxBase();
    initialize_meta_info_QAxBaseObject();
    initialize_meta_info_QAxBaseWidget();
    initialize_meta_info_QAxObject();
    initialize_meta_info_QAxObjectInterface();
    initialize_meta_info_QAxScript();
    initialize_meta_info_QAxScriptEngine();
    initialize_meta_info_QAxScriptManager();
    initialize_meta_info_QAxSelect();
    initialize_meta_info_QAxWidget();

    RegistryAPI::registerMetaType<HRESULT>("HRESULT");
    RegistryAPI::registerPrimitiveTypeInfo<HRESULT>("HRESULT", "int");
    return QTJAMBI_ONLOAD_RETURN;
}

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_activex_QtJambi_1LibraryUtilities_internalAccess)(JNIEnv *env, jclass cls){
    jobject result{0};
    QTJAMBI_TRY{
        result = MetaInfoAPI::internalAccess(env, cls);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(env);
    }QTJAMBI_TRY_END
    return result;
}

