package io.puresec;

import com.sun.jna.Native;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.lang.System;

public class FunctionShieldNative {

    public static native int functionshield_configure(String options);

    static {
        try {
            if(System.getenv("AWS_EXECUTION_ENV") != null){
                Files.copy(FunctionShield.class.getResourceAsStream("/lib/libfunctionshield.so"),
                           Paths.get("/tmp/libfunctionshield.so"),
                           StandardCopyOption.REPLACE_EXISTING
                           );
                Native.register("/tmp/libfunctionshield.so");
            }
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}
