package io.puresec;

import com.sun.jna.Native;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.lang.System;

public class FunctionShieldCore {

    public static native void functionshieldcore_configure(String options);

    static {
        try {
            if(System.getenv("AWS_EXECUTION_ENV") != null){
                Files.copy(FunctionShield.class.getResourceAsStream("/lib/libfunctionshieldcore.so"),
                           Paths.get("/tmp/libfunctionshieldcore.so"),
                           StandardCopyOption.REPLACE_EXISTING
                           );
                Native.register("/tmp/libfunctionshieldcore.so");
            }
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}
