/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class MetricSnapshot {
    private final MetricMetadata metadata;
    protected final List<? extends DataPointSnapshot> data;

    protected MetricSnapshot(MetricMetadata metadata, DataPointSnapshot ... data) {
        this(metadata, Arrays.asList(data));
    }

    protected MetricSnapshot(MetricMetadata metadata, Collection<? extends DataPointSnapshot> data) {
        this.metadata = metadata;
        if (data == null) {
            throw new NullPointerException();
        }
        ArrayList<? extends DataPointSnapshot> dataCopy = new ArrayList<DataPointSnapshot>(data);
        dataCopy.sort(Comparator.comparing(DataPointSnapshot::getLabels));
        this.data = Collections.unmodifiableList(dataCopy);
        this.validateLabels();
    }

    public MetricMetadata getMetadata() {
        return this.metadata;
    }

    public abstract List<? extends DataPointSnapshot> getData();

    protected void validateLabels() {
        for (int i = 0; i < this.data.size() - 1; ++i) {
            if (!this.data.get(i).getLabels().equals(this.data.get(i + 1).getLabels())) continue;
            throw new IllegalArgumentException("Duplicate labels in metric data: " + this.data.get(i).getLabels());
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String name;
        private String help;
        private Unit unit;

        public T withName(String name) {
            this.name = name;
            return this.self();
        }

        public T withHelp(String help) {
            this.help = help;
            return this.self();
        }

        public T withUnit(Unit unit) {
            this.unit = unit;
            return this.self();
        }

        protected MetricMetadata buildMetadata() {
            return new MetricMetadata(this.name, this.help, this.unit);
        }

        protected abstract T self();
    }
}

