/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.model.snapshots.Unit;
import java.util.regex.Pattern;

public final class MetricMetadata {
    private static final Pattern METRIC_NAME_RE = Pattern.compile("^[a-zA-Z_:][a-zA-Z0-9_:]+$");
    private static final String[] RESERVED_SUFFIXES = new String[]{"_total", "_created", "_bucket", "_info"};
    private final String name;
    private final String help;
    private final Unit unit;

    public MetricMetadata(String name) {
        this(name, null, null);
    }

    public MetricMetadata(String name, String help) {
        this(name, help, null);
    }

    public MetricMetadata(String name, String help, Unit unit) {
        this.name = name;
        this.help = help;
        this.unit = unit;
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public Unit getUnit() {
        return this.unit;
    }

    private void validate() {
        if (this.name == null) {
            throw new IllegalArgumentException("Missing required field: name is null");
        }
        if (!MetricMetadata.isValidMetricName(this.name)) {
            throw new IllegalArgumentException("'" + this.name + "': illegal metric name");
        }
    }

    public static boolean isValidMetricName(String name) {
        for (String reservedSuffix : RESERVED_SUFFIXES) {
            if (!name.endsWith(reservedSuffix)) continue;
            return false;
        }
        return METRIC_NAME_RE.matcher(name).matches();
    }

    public static String sanitizeMetricName(String metricName) {
        if (metricName.isEmpty()) {
            throw new IllegalArgumentException("Cannot convert an empty string into a valid metric name.");
        }
        int length = metricName.length();
        char[] sanitized = new char[length];
        for (int i = 0; i < length; ++i) {
            int ch = metricName.charAt(i);
            sanitized[i] = ch == 58 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || i > 0 && ch >= 48 && ch <= 57 ? ch : 95;
        }
        String sanitizedString = new String(sanitized);
        boolean modified = true;
        while (modified) {
            modified = false;
            for (String reservedSuffix : RESERVED_SUFFIXES) {
                if (sanitizedString.equals(reservedSuffix)) {
                    return reservedSuffix.substring(1);
                }
                if (!sanitizedString.endsWith(reservedSuffix)) continue;
                sanitizedString = sanitizedString.substring(0, sanitizedString.length() - reservedSuffix.length());
                modified = true;
            }
        }
        return sanitizedString;
    }
}

