/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.model.snapshots.Label;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class Labels
implements Comparable<Labels>,
Iterable<Label> {
    public static final Labels EMPTY = new Labels(new String[0], new String[0]);
    private static final Pattern LABEL_NAME_RE = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private final String[] names;
    private final String[] values;

    private Labels(String[] names, String[] values) {
        this.names = names;
        this.values = values;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.equals(EMPTY);
    }

    public static Labels of(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Key/value pairs must have an even length");
        }
        if (keyValuePairs.length == 0) {
            return EMPTY;
        }
        String[] names = new String[keyValuePairs.length / 2];
        String[] values = new String[keyValuePairs.length / 2];
        int i = 0;
        while (2 * i < keyValuePairs.length) {
            names[i] = keyValuePairs[2 * i];
            values[i] = keyValuePairs[2 * i + 1];
            ++i;
        }
        return Labels.of(names, values);
    }

    public static Labels of(List<String> names, List<String> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException("Names and values must have the same size.");
        }
        if (names.size() == 0) {
            return EMPTY;
        }
        String[] namesCopy = names.toArray(new String[0]);
        String[] valuesCopy = values.toArray(new String[0]);
        Labels.sortAndValidate(namesCopy, valuesCopy);
        return new Labels(namesCopy, valuesCopy);
    }

    public static Labels of(String[] names, String[] values) {
        if (names.length != values.length) {
            throw new IllegalArgumentException("Names and values must have the same length.");
        }
        if (names.length == 0) {
            return EMPTY;
        }
        String[] namesCopy = Arrays.copyOf(names, names.length);
        String[] valuesCopy = Arrays.copyOf(values, values.length);
        Labels.sortAndValidate(namesCopy, valuesCopy);
        return new Labels(namesCopy, valuesCopy);
    }

    public boolean contains(String labelName) {
        for (String name : this.names) {
            if (!name.equals(labelName)) continue;
            return true;
        }
        return false;
    }

    private static void sortAndValidate(String[] names, String[] values) {
        Labels.sort(names, values);
        Labels.validateNames(names);
    }

    private static void validateNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (!Labels.isValidLabelName(names[i])) {
                throw new IllegalArgumentException("'" + names[i] + "' is an illegal label name");
            }
            if (i <= 0 || !names[i - 1].equals(names[i])) continue;
            throw new IllegalArgumentException(names[i] + ": duplicate label name");
        }
    }

    private static void sort(String[] names, String[] values) {
        int n = names.length;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n - i - 1; ++j) {
                if (names[j].compareTo(names[j + 1]) <= 0) continue;
                Labels.swap(j, j + 1, names, values);
            }
        }
    }

    private static void swap(int i, int j, String[] names, String[] values) {
        String tmp = names[j];
        names[j] = names[i];
        names[i] = tmp;
        tmp = values[j];
        values[j] = values[i];
        values[i] = tmp;
    }

    public static boolean isValidLabelName(String name) {
        return LABEL_NAME_RE.matcher(name).matches() && !name.startsWith("__");
    }

    public static String sanitizeLabelName(String labelName) {
        String result = MetricMetadata.sanitizeMetricName(labelName);
        while (result.startsWith("__")) {
            result = result.substring(1);
        }
        return result;
    }

    @Override
    public Iterator<Label> iterator() {
        return this.asList().iterator();
    }

    public Stream<Label> stream() {
        return this.asList().stream();
    }

    public int size() {
        return this.names.length;
    }

    public String getName(int i) {
        return this.names[i];
    }

    public String getValue(int i) {
        return this.values[i];
    }

    public Labels merge(Labels other) {
        String[] names = new String[this.names.length + other.names.length];
        String[] values = new String[names.length];
        int thisPos = 0;
        int otherPos = 0;
        while (thisPos + otherPos < names.length) {
            if (thisPos >= this.names.length) {
                names[thisPos + otherPos] = other.names[otherPos];
                values[thisPos + otherPos] = other.values[otherPos];
                ++otherPos;
                continue;
            }
            if (otherPos >= other.names.length) {
                names[thisPos + otherPos] = this.names[thisPos];
                values[thisPos + otherPos] = this.values[thisPos];
                ++thisPos;
                continue;
            }
            if (this.names[thisPos].compareTo(other.names[otherPos]) < 0) {
                names[thisPos + otherPos] = this.names[thisPos];
                values[thisPos + otherPos] = this.values[thisPos];
                ++thisPos;
                continue;
            }
            if (this.names[thisPos].compareTo(other.names[otherPos]) > 0) {
                names[thisPos + otherPos] = other.names[otherPos];
                values[thisPos + otherPos] = other.values[otherPos];
                ++otherPos;
                continue;
            }
            throw new IllegalArgumentException("Duplicate label name: '" + this.names[thisPos] + "'.");
        }
        return new Labels(names, values);
    }

    public Labels add(String name, String value) {
        return this.merge(Labels.of(name, value));
    }

    public Labels merge(String[] names, String[] values) {
        if (this.equals(EMPTY)) {
            return Labels.of(names, values);
        }
        String[] mergedNames = new String[this.names.length + names.length];
        String[] mergedValues = new String[this.values.length + values.length];
        System.arraycopy(this.names, 0, mergedNames, 0, this.names.length);
        System.arraycopy(this.values, 0, mergedValues, 0, this.values.length);
        System.arraycopy(names, 0, mergedNames, this.names.length, names.length);
        System.arraycopy(values, 0, mergedValues, this.values.length, values.length);
        Labels.sortAndValidate(mergedNames, mergedValues);
        return new Labels(mergedNames, mergedValues);
    }

    public boolean hasSameNames(Labels other) {
        return Arrays.equals(this.names, other.names);
    }

    public boolean hasSameValues(Labels other) {
        return Arrays.equals(this.values, other.values);
    }

    @Override
    public int compareTo(Labels other) {
        int result = this.compare(this.names, other.names);
        if (result != 0) {
            return result;
        }
        return this.compare(this.values, other.values);
    }

    private int compare(String[] array1, String[] array2) {
        for (int i = 0; i < array1.length; ++i) {
            if (array2.length <= i) {
                return 1;
            }
            int result = array1[i].compareTo(array2[i]);
            if (result == 0) continue;
            return result;
        }
        if (array2.length > array1.length) {
            return -1;
        }
        return 0;
    }

    private List<Label> asList() {
        ArrayList<Label> result = new ArrayList<Label>(this.names.length);
        for (int i = 0; i < this.names.length; ++i) {
            result.add(new Label(this.names[i], this.values[i]));
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(this.names[i]);
            b.append("=\"");
            this.appendEscapedLabelValue(b, this.values[i]);
            b.append("\"");
        }
        b.append("}");
        return b.toString();
    }

    private void appendEscapedLabelValue(StringBuilder b, String value) {
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    b.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    b.append("\\n");
                    continue block5;
                }
                default: {
                    b.append(c);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Labels labels = (Labels)o;
        return Arrays.equals(this.names, labels.names) && Arrays.equals(this.values, labels.values);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.names);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String> names = new ArrayList<String>();
        private final List<String> values = new ArrayList<String>();

        private Builder() {
        }

        public Builder addLabel(String name, String value) {
            this.names.add(name);
            this.values.add(value);
            return this;
        }

        public Labels build() {
            return Labels.of(this.names, this.values);
        }
    }
}

