/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.registry;

import io.prometheus.metrics.model.registry.Collector;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;

public class PrometheusRegistry {
    public static final PrometheusRegistry defaultRegistry = new PrometheusRegistry();
    private final Set<String> names = ConcurrentHashMap.newKeySet();
    private final List<Collector> collectors = new CopyOnWriteArrayList<Collector>();
    private final List<MultiCollector> multiCollectors = new CopyOnWriteArrayList<MultiCollector>();

    public void register(Collector collector) {
        String name = collector.getName();
        if (!this.names.add(name)) {
            throw new IllegalStateException("Can't register " + name + " because that name is already registered.");
        }
        this.collectors.add(collector);
    }

    public void register(MultiCollector collector) {
        for (String name : collector.getNames()) {
            if (this.names.add(name)) continue;
            throw new IllegalStateException("Can't register " + name + " because that name is already registered.");
        }
        this.multiCollectors.add(collector);
    }

    public void unregister(Collector collector) {
        this.collectors.remove(collector);
        this.names.remove(collector.getName());
    }

    public void unregister(MultiCollector collector) {
        this.multiCollectors.remove(collector);
        for (String name : collector.getNames()) {
            this.names.remove(name);
        }
    }

    public MetricSnapshots scrape() {
        MetricSnapshots.Builder result = MetricSnapshots.newBuilder();
        for (Collector collector : this.collectors) {
            result.addMetricSnapshot(collector.collect());
        }
        for (MultiCollector multiCollector : this.multiCollectors) {
            for (MetricSnapshot snapshot : multiCollector.collect()) {
                result.addMetricSnapshot(snapshot);
            }
        }
        return result.build();
    }

    public MetricSnapshots scrape(Predicate<String> includedNames) {
        if (includedNames == null) {
            return this.scrape();
        }
        MetricSnapshots.Builder result = MetricSnapshots.newBuilder();
        for (Collector collector : this.collectors) {
            MetricSnapshot snapshot;
            String name = collector.getName();
            if (name != null && !includedNames.test(name) || (snapshot = collector.collect(includedNames)) == null) continue;
            result.addMetricSnapshot(snapshot);
        }
        for (MultiCollector multiCollector : this.multiCollectors) {
            List<String> names = multiCollector.getNames();
            boolean excluded = true;
            for (String name : names) {
                if (!includedNames.test(name)) continue;
                excluded = false;
                break;
            }
            if (excluded) continue;
            for (MetricSnapshot snapshot : multiCollector.collect(includedNames)) {
                if (snapshot == null) continue;
                result.addMetricSnapshot(snapshot);
            }
        }
        return result.build();
    }
}

