/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.logger.Logger;
import io.prometheus.jmx.logger.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameAttributeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectNameAttributeFilter.class);
    public static final String EXCLUDE_OBJECT_NAME_ATTRIBUTES = "excludeObjectNameAttributes";
    public static final String AUTO_EXCLUDE_OBJECT_NAME_ATTRIBUTES = "autoExcludeObjectNameAttributes";
    private final Map<ObjectName, Set<String>> excludeObjectNameAttributesMap = new ConcurrentHashMap<ObjectName, Set<String>>();
    private boolean autoExcludeObjectNameAttributes;

    private ObjectNameAttributeFilter() {
    }

    private ObjectNameAttributeFilter initialize(Map<String, Object> yamlConfig) throws MalformedObjectNameException {
        if (yamlConfig.containsKey(EXCLUDE_OBJECT_NAME_ATTRIBUTES)) {
            Map objectNameAttributeMap = (Map)yamlConfig.get(EXCLUDE_OBJECT_NAME_ATTRIBUTES);
            for (Map.Entry entry : objectNameAttributeMap.entrySet()) {
                ObjectName objectName = new ObjectName((String)entry.getKey());
                List attributeNames = (List)entry.getValue();
                Set attributeNameSet = this.excludeObjectNameAttributesMap.computeIfAbsent(objectName, o -> Collections.synchronizedSet(new HashSet()));
                attributeNameSet.addAll(attributeNames);
                for (String attribueName : attributeNames) {
                    attributeNameSet.add(attribueName);
                }
                this.excludeObjectNameAttributesMap.put(objectName, attributeNameSet);
            }
        }
        this.autoExcludeObjectNameAttributes = yamlConfig.containsKey(AUTO_EXCLUDE_OBJECT_NAME_ATTRIBUTES) ? (Boolean)yamlConfig.get(AUTO_EXCLUDE_OBJECT_NAME_ATTRIBUTES) : true;
        LOGGER.log(Level.FINE, "dynamicExclusion [%b]", this.autoExcludeObjectNameAttributes);
        return this;
    }

    public void add(ObjectName objectName, String attributeName) {
        if (this.autoExcludeObjectNameAttributes) {
            Set attribteNameSet = this.excludeObjectNameAttributesMap.computeIfAbsent(objectName, o -> Collections.synchronizedSet(new HashSet()));
            LOGGER.log(Level.FINE, "auto adding exclusion of object name [%s] attribute name [%s]", objectName.getCanonicalName(), attributeName);
            attribteNameSet.add(attributeName);
        }
    }

    public boolean exclude(ObjectName objectName, String attributeName) {
        Set<String> attributeNameSet;
        boolean result = false;
        if (this.excludeObjectNameAttributesMap.size() > 0 && (attributeNameSet = this.excludeObjectNameAttributesMap.get(objectName)) != null) {
            result = attributeNameSet.contains(attributeName);
        }
        return result;
    }

    public static ObjectNameAttributeFilter create(Map<String, Object> yamlConfig) {
        try {
            return new ObjectNameAttributeFilter().initialize(yamlConfig);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid configuration format for excludeObjectNameAttributes", e);
        }
    }
}

