/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.common.http.authenticator;

import com.sun.net.httpserver.BasicAuthenticator;
import io.prometheus.jmx.common.http.authenticator.Credentials;
import io.prometheus.jmx.common.http.authenticator.CredentialsCache;
import io.prometheus.jmx.common.http.authenticator.HexString;
import io.prometheus.jmx.common.util.Precondition;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2Authenticator
extends BasicAuthenticator {
    private static final int MAXIMUM_VALID_CACHE_SIZE_BYTES = 1000000;
    private static final int MAXIMUM_INVALID_CACHE_SIZE_BYTES = 10000000;
    private final String username;
    private final String passwordHash;
    private final String algorithm;
    private final String salt;
    private final int iterations;
    private final int keyLength;
    private final CredentialsCache validCredentialsCache;
    private final CredentialsCache invalidCredentialsCache;

    public PBKDF2Authenticator(String realm, String username, String passwordHash, String algorithm, String salt, int iterations, int keyLength) throws GeneralSecurityException {
        super(realm);
        Precondition.notNullOrEmpty(username);
        Precondition.notNullOrEmpty(passwordHash);
        Precondition.notNullOrEmpty(algorithm);
        Precondition.notNullOrEmpty(salt);
        Precondition.isGreaterThanOrEqualTo(iterations, 1);
        Precondition.isGreaterThanOrEqualTo(keyLength, 1);
        SecretKeyFactory.getInstance(algorithm);
        this.username = username;
        this.passwordHash = passwordHash.toLowerCase().replace(":", "");
        this.algorithm = algorithm;
        this.salt = salt;
        this.iterations = iterations;
        this.keyLength = keyLength;
        this.validCredentialsCache = new CredentialsCache(1000000);
        this.invalidCredentialsCache = new CredentialsCache(10000000);
    }

    @Override
    public boolean checkCredentials(String username, String password) {
        boolean isValid;
        if (username == null || password == null) {
            return false;
        }
        Credentials credentials = new Credentials(username, password);
        if (this.validCredentialsCache.contains(credentials)) {
            return true;
        }
        if (this.invalidCredentialsCache.contains(credentials)) {
            return false;
        }
        boolean bl = isValid = this.username.equals(username) && this.passwordHash.equals(PBKDF2Authenticator.generatePasswordHash(this.algorithm, this.salt, this.iterations, this.keyLength, password));
        if (isValid) {
            this.validCredentialsCache.add(credentials);
        } else {
            this.invalidCredentialsCache.add(credentials);
        }
        return isValid;
    }

    private static String generatePasswordHash(String algorithm, String salt, int iterations, int keyLength, String password) {
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray(), salt.getBytes(StandardCharsets.UTF_8), iterations, keyLength * 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
            byte[] secretKeyBytes = secretKeyFactory.generateSecret(pbeKeySpec).getEncoded();
            return HexString.toHex(secretKeyBytes);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

