/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.BuildInfoMetrics;
import io.prometheus.jmx.JmxCollector;
import io.prometheus.jmx.common.http.HTTPServerFactory;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.File;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class WebServer {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd | HH:mm:ss.SSS", Locale.getDefault());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int port;
        if (args.length < 2) {
            System.err.println("Usage: WebServer <[hostname:]port> <yaml configuration file>");
            System.exit(1);
        }
        String host = "0.0.0.0";
        int colonIndex = args[0].lastIndexOf(58);
        if (colonIndex < 0) {
            port = Integer.parseInt(args[0]);
        } else {
            port = Integer.parseInt(args[0].substring(colonIndex + 1));
            host = args[0].substring(0, colonIndex);
        }
        new BuildInfoMetrics().register(PrometheusRegistry.defaultRegistry);
        new JmxCollector(new File(args[1]), JmxCollector.Mode.STANDALONE).register(PrometheusRegistry.defaultRegistry);
        try (HTTPServer httpServer = null;){
            httpServer = new HTTPServerFactory().createHTTPServer(InetAddress.getByName(host), port, PrometheusRegistry.defaultRegistry, new File(args[1]));
            System.out.println(String.format("%s | %s | INFO | %s | %s", SIMPLE_DATE_FORMAT.format(new Date()), Thread.currentThread().getName(), WebServer.class.getName(), "Running"));
            Thread.currentThread().join();
        }
    }
}

