/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.jmx.JmxCollector;
import java.io.File;
import java.net.InetSocketAddress;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WebServer {
    public static void main(String[] args) throws Exception {
        InetSocketAddress socket;
        String[] hostnamePort;
        if (args.length < 2) {
            System.err.println("Usage: WebServer <[hostname:]port> <yaml configuration file>");
            System.exit(1);
        }
        if ((hostnamePort = args[0].split(":")).length == 2) {
            int port = Integer.parseInt(hostnamePort[1]);
            socket = new InetSocketAddress(hostnamePort[0], port);
        } else {
            int port = Integer.parseInt(hostnamePort[0]);
            socket = new InetSocketAddress(port);
        }
        JmxCollector jc = (JmxCollector)new JmxCollector(new File(args[1])).register();
        Server server = new Server(socket);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/metrics");
        server.start();
        server.join();
    }
}

